.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	D M O D A T A D K
.;
.; Purpose:	Dismount of data disk
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	14-JAN-85
.;
.; Version:	1.4	9-JUN-87
.;
.; Description:	
.;
.; Calls to:	BRO,	DEV,	DMO,	PIP,	PRI,	SET,	SRD
.;
.; Modified by:	Jan H. Belgraver	17-JAN-86	JB01	V1.1
.;		See subroutine	PRIDIR.
.;		Jan H. Belgraver	15-May-86	JB02	V1.2
.;		If DMRD disk don't print directory.
.;
.;		Jan H. Belgraver	5-JUN-86	JB03	V1.3
.;		1. Modifications to subroutine PRIDIR
.;		2. Disk volume labels may be 12 characters in length.
.;
.;		Jan H. Belgraver	9-JUN-87	JB04	V1.4
.;		Removed text with telephone numbers of DMRD in case there
.;		disk was to be dismounted; they are no longer guests here.
.;----------------------------------------------------------------------------
.;
.;

.enable	substitution
.disable lowercase
.enable decimal
.;
.IFF	<PRIVIL>	; Sorry, priviledged command; try console terminal
.IFF	<PRIVIL>	.EXIT
.;
	.enable	quiet					
	.SETF	DCL				
	.IF	<CLI> EQ "DCL"	.SETT	DCL	
.;	If current CLI is DCL reset to MCR	
	.IFT	DCL	SET TERMINAL/MCR	
.;
	DEV	DM1:		! Show volume label on console
.;
	.disable	quiet				
	.disable lowercase
	.ASKS	[1:12.]	VOLLBL	Enter volume label
.;
;	Check with the following users if diskpack can be removed.
	.enable	quiet					
	DEV	/LOG		! Show terminals loged in
	.disable	quiet				
.;
.;	We'll leave facility to skip printing directory listing if 
.;	volume-label starts with SS.
	.sets	TMPS	VOLLBL[1:2]
	.if	TMPS eq "SS"	.goto	10				! JB02
	.gosub	PRIDIR
.10:	.disable	quiet				
	.ask	[<FALSE>] OK	Continue
	.iff	OK	.goto	FINISH
.;
	.enable	quiet					
	.enable lowercase
	.SETS	MSG1	#Dismounting all users from data disk "'VOLLBL'"#
	BRO	TT1:	'MSG1'
	BRO	TT2:	'MSG1'
	BRO	TT3:	'MSG1'
	BRO	TT5:	'MSG1'	
	BRO	TT7:	'MSG1'
	BRO	TT10:	'MSG1'
	DMO	DM1:/DEV	! Dismount device
.FINISH:
	.enable	quiet				
	.;	If user CLI was DCL reset terminal.
	.IFT	DCL	SET /DCL=TI:
	.disable display
.EXIT

.;----------------------------------------------------------------------------
.;
.; CMD-Subr.:	P R I D I R
.;
.; Purpose:	Prepares a directory listing of all UFDs and spools 
.;		this file subsequently on the LA120.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	14-JAN-85
.;
.; Version:	V1.2	5-jun-86
.;
.; Modified by:	Jan H. Belgraver	17-JAN-86	JB01	V1.1
.;		1. Use of SRD V6.5, in use since OCT-85, /MI-switch in stead 
.;		of truncating old /FU directory lines.
.;		2. Use of /SM-switch for PIP-like summary.
.;		3. Header add-on by using /AP-switch.
.;
.;		Jan H. Belgraver	 5-JUN-86	JB02	V1.2
.;		Add LA120 leader and trailer records for printer control.
.;----------------------------------------------------------------------------
.;

.PRIDIR:
.sets	ESC	""							! JB02
.sets	PITCHN	"4w"		! 16.5 characters/inch pitch		  JB02
.sets	PITCHO	"4w"		! 16.5 characters/inch pitch		  JB02
.setn	LMN	9		! Left margin for this file		  JB02
.setn	LMO	4		! Default left margin			  JB02
	.enable	quiet

	.opena #0	DM1.DIR;1
	.data  #0 'ESC'['PITCHN''ESC'['LMN's
	.data #0	
	.data #0	Volume label 'VOLLBL'
	.data #0 	
	.close #0

	SRD	DM1.DIR;1=DM1:[*,*]/NA/WB/MI/SM/AP			! JB01

	.opena #0	DM1.DIR;1					! JB02
	.data  #0 'ESC'['PITCHO''ESC'['LMO's
	.close #0							! JB02

	PRI	TT4:/NOFL=DM1.DIR;1/DEL
	.return
