.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	D E V A T R
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	7-NOV-84
.;
.; Version:	1.1	23-Feb-87
.;
.; Purpose:	Demonstration command file to show contents of 
.;		DEVICE-CHARACTERISTICS words and DEVICE ATTRIBUTES in
.;		ICP Special String Symbol <EXSTRI>.
.;
.; Description:	<EXSTRI> is filled following an .TESTDEVICE directive.
.;		It contains the four device-characteristics words:
.;		U.CW1, U.CW2, U.CW3, resp. U.CW4 and one or more 
.;		device atttributes.
.;
.; Modified by:	Jan H. Belgraver	23-Feb-87	JB01	V1.1
.;		Show meaning of attributes returned
.;----------------------------------------------------------------------------
.;
.;

.enable	substitution
.if	P1 eq ""	.asks	P1	Enter Device
.;
.TESTDEVICE	'P1'
.SETS	STRING	<EXSTRI>
.PARSE	STRING	","	DEV CW1 CW2 CW3 CW4 DEVATR
.PARSE	DEVATR	","	D1 D2 D3 D4 D5 D6 D7 D8 D9 D10 D11 D12 D13 D14 D15
;
;	Device Characteristics Words (octal)
;
;	U.CW1	= 'CW1'
;	U.CW2	= 'CW2'
;	U.CW3	= 'CW3'
;	U.CW4	= 'CW4'
;
;	Device Attributes
;
;	'D1', 'D2', 'D3', 'D4', 'D5', 'D6', 'D7', 'D8', 'D9', 'D10'
;	'D11', 'D12', 'D13', 'D14', 'D15'
;
	.test	DEVATR	"NDS"						.;JB01
	.if	<STRLEN> gt 0	;	NSD: No Such Device
	.test	DEVATR	"LOD"						.;JB01
	.if	<STRLEN> gt 0	;	LOD: Driver loaded
	.test	DEVATR	"UNL"						.;JB01
	.if	<STRLEN> gt 0	;	UNL: Driver NOT loaded
	.test	DEVATR	"ONL"						.;JB01
	.if	<STRLEN> gt 0	;	ONL: Device on-line
	.test	DEVATR	"OFL"						.;JB01
	.if	<STRLEN> gt 0	;	OFL: Device off-line
	.test	DEVATR	"MTD"						.;JB01
	.if	<STRLEN> gt 0	;	MTD: Mounted mountable volume
	.test	DEVATR	"NMT"						.;JB01
	.if	<STRLEN> gt 0	;	NMT: NOT mounted, or NOT mountable
	.test	DEVATR	"FOR"						.;JB01
	.if	<STRLEN> gt 0	;	FOR: Foreign mounted mountable volume
	.test	DEVATR	"NFO"						.;JB01
	.if	<STRLEN> gt 0	;	NFO: NOT foreign mounted, or NOT mountable
	.test	DEVATR	"PUB"						.;JB01
	.if	<STRLEN> gt 0	;	PUB: Public device
	.test	DEVATR	"NPU"						.;JB01
	.if	<STRLEN> gt 0	;	NPU: NOT a public device
	.test	DEVATR	"ATT"						.;JB01
	.if	<STRLEN> gt 0	;	ATT: Device attached to other task
	.test	DEVATR	"ATU"						.;JB01
	.if	<STRLEN> gt 0	;	ATU: Device attached to this copy of AT.
	.test	DEVATR	"NAT"						.;JB01
	.if	<STRLEN> gt 0	;	NAT: Device NOT attached
	.test	DEVATR	"ALO"						.;JB01
	.if	<STRLEN> gt 0	;	ALO: Device allocated to another terminal
	.test	DEVATR	"ALU"						.;JB01
	.if	<STRLEN> gt 0	;	ALU: Device allocated to this terminal
	.test	DEVATR	"NAL"						.;JB01
	.if	<STRLEN> gt 0	;	NAL: Device NOT allocated
.EXIT
