.;----------------------------------------------------------------------------
.;
.; CMD-program:	B R U D T M
.;
.; Author:	Klaas H.N. Bos
.;
.; Date:	Summer 1981
.;
.; Version:	V1.16	17-Dec-86
.;
.; Note:	Don't forget to update the BIOREGAN Manual !
.;
.; Modified by:	Jan H. Belgraver	27-JAN-83	JB02
.; 		BRU command file is created in directory LB:[20,1].
.; 		This is in case the directory involved does not exist
.; 		on SY:. [20,1] has been chosen since it has
.; 		rwed-access for World.
.;
.; 		Jan H. Belgraver	23-FEB-83	JB03
.; 		Empty strings are not alowed.
.;
.; 		Jan H. Belgraver	28-FEB-83	JB04	
.; 		For compatibility with DCL.
.;
.; 		Jan H. Belgraver	25-MAY-83	JB05
.; 		If exit status reveals error, exit.
.;
.; 		Jan H. Belgraver	31-OCT-83	JB06	V1.6
.; 		Made device and filename question two separate ones.
.; 		Changed layout of some quetions.
.; 		Bell now rings once per 10 sec.
.; 		Making a directory listing is now the default answer.
.; 		A Form-feed is generated before printing a directory 
.; 		listing.
.;
.; 		Jan H. Belgraver	11-NOV-83	JB07	V1.7
.; 		Stringrange limits should be decimal.
.;
.; 		Jan H. Belgraver	27-aug-84	JB08	V1.8
.; 		Added incremental backup feature for files in 
.; 		particular UIC.
.;
.; 		Jan H. Belgraver	30-NOV-84	JB09	V1.9
.; 		1. Reset terminal properly if ^Z entered.
.; 		2. No lowercase allowed on certain questions.
.; 		3. Print current UIC and new warning.
.;
.; 		Jan H. Belgraver	11-FEB-85	JB10	V1.10
.; 		1. Fixed directory problem
.; 		2. Enabled continuation lines
.; 		3. Made "Display files copied" optional
.; 		4. Back to start in case of increm.backup to new tape.
.;
.; 		Jan H. Belgraver	11-MAR-85	JB11	V1.11
.; 		Allocate MM:
.;
.; 		Jan H. Belgraver	21-AUG-85	JB12	V1.12
.; 		Ask for Data_tape number. For proper experiment 
.; 		documentation only.
.;
.; 		Jan H. Belgraver	18-NOV-85	JB13	V1.13
.;		1. Renamed from DMTOMM.CMD into BRUDTM.CMD
.;		2. Chain to experiment data backup if [20,1] or [20,10]
.;
.; 		Jan H. Belgraver	24-FEB-86	JB14	V1.14
.;		1. Remove any spaces from input strings.
.;		2. Get datecheck routine from BIOREGAN.CLB; name was 
.;		changed into CHKDATE.
.;
.; 		Jan H. Belgraver	4-Dec-86	JB15	V1.15
.;		1. For use of RP06
.;		2. Create terminal-related BRU command file in LB:[20,20]
.;		since that directory has world write-access.
.;
.; 		Jan H. Belgraver	17-Dec-86	JB16	V1.16
.;		1. Chaining to BRUDBU.CMD optional
.;		2. [20,11] should be included as well
.;----------------------------------------------------------------------------

.enable	substitution
.enable decimal								! JB07
.enable	global								! JB08
.enable	control-z							! JB09
.setf	SURE
.sets	APP	""
.sets	DIS	""							! JB10
.sets	REV	""							! JB08
.enable	quiet								! JB04
	.setf	DCL							! JB04
	.if	<CLI> eq "DCL"	.sett	DCL				! JB04
.;	If current CLI is DCL reset to MCR				! JB04
	.ift	DCL	SET TERMINAL/MCR
	ALL	MM:		! Make it private			  JB11
.;
	.disable	quiet						! JB04
	.disable display						! JB09
;
;	Copying files from DISK to BRU-TAPE 
;
;	Current UIC = '<UIC>'
;
.START:									.;JB10
	.enable	display							! JB09
	.disable lowercase						! JB09
	.ask [<TRUE>]	BUFILE	Saving ACSO Experiment results	
	.ift	BUFILE .if <UIC> eq "[20,10]"	.chain	/LB:BRUDBU	! JB16
	.ift	BUFILE .if <UIC> eq "[20,11]"	.chain	/LB:BRUDBU	! JB16
	.disable display						! JB16
;
	.enable display							! JB16
	.ask [<TRUE>]	OK	Continue		
	.ift	<EOF>	.goto	FINISH					! JB09
	.iff	OK	.goto	FINISH					! JB09
.;
.;	Get terminal specs						! JB15
.;
	.testdevice TI:							! JB15
	.parse	<EXSTRI> ","	TIDEV	REST				! JB15
	.test	TIDEV				! Get stringlength	| JB15
	.sets	TIDEV	TIDEV[2:<STRLEN>-1]	! Remove : and 1st T	| JB15
.;
	.disable display						! JB15
;
	.enable display							! JB15
	.enable lowercase						! JB09
	.asks	[1:12]	OVL	Volume label		
	.ift	<EOF>	.goto	FINISH					! JB09
	.sets	OVL	"'OVL%C'"	! Remove any spaces		! JB14
.;
	.asks	[1:12]	BCS	Backup-set name		
	.ift	<EOF>	.goto	FINISH					! JB09
	.sets	BCS	"'BCS%C'"	! Remove any spaces		! JB14
.DEVICE:
	.disable	lowercase					! JB09
	.asks	[1:04]	INDEV	From DB:, DM: or DM1:	
	.ift	<EOF>	.goto	FINISH					! JB09
	.sets	INDEV	"'INDEV%C'"	! Remove any spaces		! JB14
	.sets	S	INDEV[1:1]					! JB15
	.if	S ne "D"	.goto	DEVICE				! JB15
	.sets	S	INDEV[2:2]					! JB15
	.if	S ne "B" .if S ne "M"	.goto	DEVICE			! JB15
	.sets	S	INDEV[<STRLEN>:<STRLEN>]
	.if	S NE ":"	.goto	DEVICE				! JB06
.;
	.ask	[<FALSE>]	INI	INITIALIZE tape		
	.ift	<EOF>	.goto	FINISH					! JB09
	.ift	INI	.ask	[<FALSE>]	SURE	Are   you   sure	
	.ift	<EOF>	.goto	FINISH					! JB09
	.iff	SURE	.setf	INI	
	.iff	INI	.sets	APP	"/APP"
.;
	.ask	[<TRUE>]	DIRLST	Directory listing	
	.ift	<EOF>	.goto	FINISH					! JB09
.;
	.ask	[<TRUE>]	FILLST	Copied files listing	
	.ift	<EOF>	.goto	FINISH					! JB10
	.ift	FILLST	.sets	DIS	"/DIS"				! JB10
.BUPMOD:								.;JB08
			;	Incremental backup [I], 
	.asks[1:1]	MODE	or   by   Filename [N]	
	.ift	<EOF>	.goto	FINISH					! JB09
	.if	MODE EQ "N"	.goto	FILNAM				! JB08
	.if	MODE NE "I"	.goto	BUPMOD				! JB08
	.ift	INI	; * WARNING *	No incremental backups to new tape
	.ift	INI	.goto	START					! JB10
	.enable	lowercase						! JB08
.;
	.asks[8:9]	$DATE	Previous Incr. backup date	
	.sets	$DATE	"'$DATE%C'"	! Remove any spaces		! JB14
	@/LB:CHKDATE '$DATE'						! JB14
	.sets	REV	"/REV:AFT:'$DATE'"				! JB08
.FILNAM:
	;	Filename(s) [<cr> = all files]
	;	            [Add ,- for continuation line]
	.setn	N	0						! JB10
.GETFIL:								.;JB10
	.inc	N							! JB10
	.asks	[0:60] TEMP
	.ift	<EOF>	.goto	FINISH					! JB09
	.sets	TEMP	"'TEMP%C'"	! Remove any spaces		! JB14
	.if	N gt 1	.goto	10					! JB10
	.parse	TEMP	"]"	DIR FLN					! JB10
	.test	FLN							! JB10
	.if	<STRLEN> eq 0	.sets	FLN	DIR			! JB10
	.if	<STRLEN> eq 0	.sets	TEMP	<UIC>+FLN		! JB10
	.sets	TEMP	INDEV+TEMP					! JB10
.10:	.sets	LINE'N'	TEMP						! JB10
	.test	TEMP
	.sets	TEMP	TEMP[<STRLEN>-1:<STRLEN>]			! JB10
	.if	TEMP ne ",-"	.goto	BLDCMD				! JB10
	.sets	INDEV	""						! JB10
	.goto	GETFIL							! JB10
.BLDCMD:
	.disable display						! JB15
;
;			* Working *
	.enable display							! JB15
        .open	LB:[20,20]BRUDTM'TIDEV'.CMD;1				! JB15
	.data 'APP'/REW/MOU'DIS'/DEN:1600/VER/OUT:'OVL'/BAC:'BCS''REV'
	.setn	NTOT	N
	.setn	N	0
.BLDSTR:								.;JB10
	.inc	N							! JB10
	.sets	TEMP	LINE'N'						! JB10
	.data 'TEMP'
	.if	N lt NTOT	.goto	BLDSTR				! JB10
	.data MM:
.CLOSE
	.enable	quiet
	PIP	TI:=LB:[20,20]BRUDTM'TIDEV'.CMD;1			! JB15
	BRU	@LB:[20,20]BRUDTM'TIDEV'				! JB15
	.if	<EXSTAT> gt 1	.goto	BRUEND				! JB09
	.iff	DIRLST	.goto	BRUEND					! JB09
	LAS	PA		! Top-Of-Form
	BRU	/REW/DIR/BAC:'BCS' MM:
.BRUEND:
	RUN	$REWIND/TASK=REWIND
	BEL 0
	PIP	LB:[20,20]BRUDTM'TIDEV'.CMD;*/DE			! JB15
.FINISH:
	.enable  quiet							! JB09
	DEA	MM:		! Make it available for other users	  JB11
	.disable display						! JB09
	.;	If user CLI was DCL reset terminal.			! JB04
	.ift	DCL	SET /DCL=TI:
.EXIT
