.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	R P T S U M
.;
.; Purpose:	Generating Summary Error Log listing.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	15-NOV-84
.;
.; Version:	1.4	2-SEP-86
.;
.; Description:	Switches used:
.; 		/Format:Brief
.; 		/Type:All
.; 		/Date:(Today, Yesterday, Previous:n days, or
.; 			start- to end date)
.; 		/Device:All
.; 		/Packet:*:*
.; 		/Width:wide
.; Calls to:	RPTDATE.CMD, P16L3.CMD, P16L9.CMD in BIOREGAN.CLB
.;
.; Globals:	Name	Type	Description
.; 		$RANGE	String	Date range as received from RPTDATE.CMD
.;		$PRSET	String	Printer setting escape-sequence filespec
.;
.; Modified by:	Jan H. Belgraver	21-DEC-84	JB01	1.1
.; 		Fetch RPTDATE.CMD from [5,104]
.;
.;		Jan H. Belgraver	17-JAN-86	JB02	V1.2
.;		Fetch RPTDATE.CMD from BIOREGAN.CLB
.;
.;		Jan H. Belgraver	18-Jun-86	JB03	V1.3
.;		1. Pre- and postfix RPT list file with escape-sequences for
.;		printer control.
.;		2. Selectively delete list files with SRD.
.;
.;		Jan H. Belgraver	2-SEP-86	JB04	V1.4
.;		Purge listfiles before selective delete.
.;----------------------------------------------------------------------------
.;

.enable	substitution
.enable	decimal
.enable	global
.enable	quiet
.disable	lowercase
.ifnins	RPT	INS $RPT/TASK=...RPT
.disable	quiet
;
; Generating Summary Error Log listing
;
.; Available Date Ranges: T = Today
.;                        Y = Yesterday
.;                        P = Previous n days
.;                        R = User defined start- to end date
.;
	@[5,104]/LB:RPTDATE	! Get date range in $RANGE		! JB02
;
;	B U S Y . . . .
;
	.enable	quiet
	RPT	RPTSUM.LST=/DATE:'$RANGE'
	SRD 	RPTSUM/NA/WB/NOLI

.;	Get printer set/reset escape-sequences in files.
	@[5,104]BIOREGAN/lb:P16L3					! JB03
	.sets	PREFIL	$PRSET						! JB03
	@[5,104]BIOREGAN/lb:P16L9					! JB03
	.sets	PSTFIL	$PRSET						! JB03
.;
	PIP	RPTSUM.LST='PREFIL'/RE/NV				! JB03
	PIP	RPTSUM.LST=RPTSUM.LST;-1/AP	! Append to prefix file	  JB03
	PIP	RPTSUM.LST='PSTFIL'/AP		! Append postfix file	  JB03
	PIP	RPTSUM.LST/PU/NM					! JB04
.;
	.if	<EXSTAT> eq 1	PRI RPTSUM.LST
.;
	SRD	RPTSUM.LST;*/SD/MI					! JB03
	PIP	'PREFIL';*,'PSTFIL';*/DE/NM				! JB03
.;
	REM	RPT
	.disable display
.exit
