.;----------------------------------------------------------------------------
.;
.; CMD-file:	C H K N U M 
.;
.; Purpose:	Checks ASCII numeral systax.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	11-NOV-85
.;
.; Version:	1.0
.;
.; Description:	Routine checks if ASCII characters in input string are in 
.;		range of numerals, i.e. octal 60 - 71. If an illegal character
.;		is found routine exits with an error message and exit status 2
.;
.; Call:	@CHKNUM Number
.;
.; Parameters:	Name	I/O	Type	Description
.;		P1	 I	String	ASCII number string
.;		$CNUMS	 O	Numeral	Error/Success status
.;				0	Success
.;				1	Input argument missing
.;				2	Syntax error in input argument
.; Calls to:	
.;
.; Modified by:	
.;
.;----------------------------------------------------------------------------
.;

.enable substitution
.enable	global
.setn	$CNUMS	0
.sett	DECIM
.setf	LCASE
.setf	SILENT
	.ifdisabled decimal	.setf		DECIM
	.enable		decimal
	.ifenabled lowercase	.sett		LCASE
	.disable	lowercase
	.ifenabled quiet	.sett		SILENT
	.disable	quiet
.;
	.test	P1
	.if <STRLEN> EQ 0	.goto	INPERR
	.setn	P	0
.LOOP:
	.inc	P
	.if P gt <STRLEN>	.goto	FINISH
	.sets	T	P1['P':'P']
	.if T ge "0"	.if T le "9"	.goto	LOOP
	.setn	$CNUMS	2
	; * W * -- Illegal character in string 'P1' at position 'P'.
	.goto	FINISH
.INPERR:
	.setn	$CNUMS	1
	; * W * -- Empty input argument
.FINISH:
	.iff	DECIM	.disable decimal
	.ift	LCASE	.enable lowercase
	.ift	SILENT	.disable quiet
	.exit
