/* ETH.C - Ethernet - Frame Transmit & Receive Example	
 * 
 * Language: DECUS-C
 *   Author: Juergen Pinkow
 *     Date: August '89
 *
 *    Notes: Commands - 'w' for transmitting a message
 * 		      - 'q' to quit
 *	     The destination node is identified by its 
 *	     node-number (Area.Node-Number), so don't
 *	     specify the area (1 used)	
 */

#include <cx.h>
#include <stdio.h>
#include <qiofun.h>
#include <qioret.h>
#include <qiottd.h>
#include "dlxdf.h"
#include "epmdf.h"
#include "chrdf.h"

#define  CHRLEN	 100     /* Maximum length of characteristics buffer */
#define  BUFLEN  1498    /* Length of user data buffer               */

#include "errchk.h"   /* Functions for error checking */
#include "ttio.h"     /* Functions for terminal-io */
#include "ethio.h"    /* Functions for ethernet-io */

/* Global variable definitions */

word rcvchr[CHRLEN],    /* Blank characteristics buffer for Receive and */
     sndchr[CHRLEN];    /* Transmit operation */

byte rcvbuf[BUFLEN],    /* Receive and Transmit buffers for User Data */
     sndbuf[BUFLEN]; 


char tibuf[80];   /* Buffer for formatted output to TI: */	
		  /* ( used by sprintf() ) */

                                        

/* 	*** Receive - AST ***
 *
 *	Whenever an Ethernet frame arrives, source address
 *	destination address, protocol type and user data
 *	will be printed on the TI:
 */

rcvast(r1,iosb)
  word r1,       /* This dummy variable is necessary, because DECUS-C */
       iosb[];   /* has a bug when handling the stack within AST's !! */ 
{
 byte *cp;  
 int    i;

 astset();

 if (iosb[0] == IE_ABO)
   {
   }
 else
 if (iosb[0] != IS_SUC)
     cmperr("RECAST: IO_XRC failed",0,iosb);
 else
   {
    chrerr("IO_XRC : Block CC_ADR failed",rcvchr[C_STAT]); 
 
    chrerr("IO_XRC : Block CC_DAD failed",rcvchr[C_STAT+7]); 

    chrerr("IO_XRC : Block CC_PRO failed",rcvchr[C_STAT+14]); 

    cp = &rcvchr[C_SAD];
    writes("Ethernet packet received\r\n\n");
    sprintf(tibuf,"     Source Address: %x-%x-%x-%x-%x-%x\r\n",cp[0],cp[1],cp[2],
                                                     cp[3],cp[4],cp[5]);
    writes(tibuf);
    cp = &rcvchr[C_DAD];
    sprintf(tibuf,"Destination Address: %x-%x-%x-%x-%x-%x\r\n",cp[0],cp[1],cp[2],
                                                     cp[3],cp[4],cp[5]); 
    writes(tibuf);
    cp = &rcvchr[C_PRO];
    sprintf(tibuf,"      Protocol Type: %x-%x\r\n",cp[0],cp[1]);   
    writes(tibuf);
    sprintf(tibuf,"   User Data Length: %d Bytes\r\n",iosb[1]);
    writes(tibuf);
    writes("   User Data       : ");
    for (i=0;i<iosb[1];i++)
       {
        if (rcvbuf[i] > 31 && rcvbuf[i] < 127)
            writec(rcvbuf[i]);
       }
    rcveth(rcvbuf,BUFLEN,rcvchr,rcvast); /* Receive next frame */
   }
 astx(1);
}
 


main()
{
 char cmd;

 word dstadr[3];

 int  dsw,
      nodnum;    /* Node Number */

 dsw = alunx(TILUN,"TI",0);
 cmperr("Assign terminal IO-lun to TI:",dsw,0);   


 opneth(ETHDEV,rcvchr);               /* Open Ethernet Port */
 rcveth(rcvbuf,BUFLEN,rcvchr,rcvast); /* Set up a pending receive */

 writes("\n\n\r") ;

 do {
     writes("\r\nPlease enter cmd : ") ;
     reads(&cmd,1) ; 
     if (cmd == 'w' || cmd == 'W') 
       {
        writes("\r\nRemote Node-Number : ");
        readi(&nodnum);

        dstadr[0] = 0x00AA;          /* Physical Ethernet Address  */
       	dstadr[1] = 0x0004;          /* AA-00-04-00-Node Number-04 */
       	dstadr[2] = 0x04*256+nodnum; /* (for DECnet nodes only)    */

        writes("\r\nMessage: ");
        reads(sndbuf,40);            /* Read up to 40 characters */
        sndeth(sndbuf,strlen(sndbuf),sndchr,dstadr,USRPRO);
       }
    } while (cmd != 'q' && cmd != 'Q') ;
 cloeth();
} 
 
