.;
.; MCEBLD.CMD -- Commandfile to build the MCE commandline editor
.;
.;
.;      Copyright (c) 1987,1988,1989
.;
.;      J.H. Hamakers,
.;      ABB Industrie b.v.
.;	Dept. AUT
.;      P.O.Box 113
.;	3000 AC  Rotterdam
.;	The Netherlands
.;      Phone : +31 - 10 - 4078631
.;
.;      All rights reserved
.;
.;      This software may be copied and distributed ONLY
.;      on a non profit basis and with the inclusion of
.;      the above copyright statement.
.;
.;
.;      >>>>> PLEASE CONTACT ME FOR PROBLEMS OR SUGGESTIONS <<<<<
.;
.;       +---------------------------------------------------+
.;       | See MCEREL.DOC for information about this release |
.;       +---------------------------------------------------+
.;
.;
.;
        .ENABLE SUBSTITUTION
        .DISABLE DISPLAY
.;
        .SETF  A$SV    ! Conditional for CRW/ASV  Erasmus university Rotterdam
        .IF P1 EQ "ASV" .SETT A$SV
.;
        .SETS IDNPRE	"04"		   ! Indent for MCEPRE
        .SETS VERS 	"V4.22a"           ! Version
        .SETS HLPUIC 	"[1,2]"            ! Helpfile UIC
        .SETS SYSUIC 	<LIBUIC>           ! Task uic
        .SETS INIUIC 	"[1,2]"            ! Change mce.mac to change uic
        .IFT A$SV .SETS INIUIC "[2,2]"  ! Change mce.mac to change uic
;
;       +---------------+
;       |   +-------+   |
;       |  /         \  |
;       | / D E C U S \ |   D E C U S  makes it work
;       | \   R S X   / |
;       |  \  S I G  /  |
;       |   +-------+   |
;       +---------------+
;
;MCEBLD.CMD -- Commandfile to build the MCE commandline editor 'VERS'
        .IF <CLI> = "DCL" .SETS CLI "MCR"
        .IF <CLI> = "MCR" .SETS CLI ""
        .IFDF CLI .GOTO 10$
        .DISABLE QUIET
;
;MCEBLD -- CLI '<CLI>' not supported
;
        .EXIT <SEVERE>
.10$:
        .SETF HLPNEW
        .SETF MU
	.SETF ID
        .SETF HLP
        .SETF COP
        .SETF INS
	.SETF OVSDEF
        .SETF STADEF
	.SETF EDTDEF
	.SETF PRMDEF
	.SETF RTMESS
	.SETF RTEXIT
        .SETF PRI
        .SETF TMO
        .SETN TMON 4.
	.SETS HLPCHR " ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	.SETN HLPNR 1.
	.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
        .IF P1 = "MAC"  .GOTO MAC
        .IF P1 = "LINK" .GOTO LINK
        .DISABLE QUIET
;
; This commandfile builds YOUR version of MCE. It prompts for several options
; to be build in MCE. It creates a conditional assembly definition file called
; MCEPRE.MAC, two command files MCEASM.CMD and MCETKB.CMD and optionaly a
; helpfile MCE.HLP. If you already have those files you can restart MCEBLD
; with "@MCEBLD MAC" to assemble and taskbuild or "@MCEBLD LINK" to taskbuild.
;
        .ASK Q MCEBLD -- Give <RETURN> to continue ..... 
;
;*****
;
; The standard CLI ( Command Line Interpreter) of RSX is MCR.
; When your system supports the use of other CLIs such as DCL than include
; multiple CLI support in MCE.
;
        .ASK CLS MCEBLD -- Want the multiple CLI support [ D:N ] ? 
;
;*****
;
; When init file support is included MCE reads initialisation files which
.IFF CLS	; can contain Command definitions Internal- and MCR- commands.
.IFT CLS	; can contain Command definitions Internal- and CLI- commands.
;
; Files are searched in this order:
;
        .IFF CLS .GOTO 20$
;    LB:'INIUIC'MCEINI.xxx, followed by SY:<cur_dir>MCEINI.xxx,
;
; where "xxx" is the name of the CLI defined for the terminal invoking MCE
; and "cur_dir" is the default directory at the startup of MCE.
        .GOTO 30$
.20$:
;    LB:'INIUIC'MCEINI.CMD, followed by SY:<cur_dir>MCEINI.CMD
;
; where "cur_dir" is the default directory at the startup of MCE.
.30$:
;
; This algorithm divides command-definitions into 2 groups:
; A system-wide set in LB:'INIUIC', followed by a users private set in SY:<uic>
;
        .ASK INI MCEBLD -- Want the MCEINI file support [ D:N ] ? 
;
;*****
;
; MCE allows definitions of compound commands.
; Using the ampersand (&) sign one can define an MCE command as a sequence
.IFF CLS	; of multiple MCR commands :
.IFT CLS	; of multiple CLI commands :
;
;               E.g.    +>STAT := TIM & PIP /LI & ACT /ALL ...etc.
;
; or directly:  E.g.    +>MAC @TASKASM & TKB @TASKTKB
;
        .ASK CMP MCEBLD -- Want the compound command definition support [ D:N ] ? 
;
;*****
;
; It is possible to include statusline support.
; The statusline shows the different settings and fifo parameters of MCE
; and can be switched on/off with MCE STATus on/off
; Line 24 is used for status information.
;
	.ASK STA MCEBLD -- Want Statusline/Statusmessage support [ D:N ] ? 
	.IFT STA .ASK STADEF MCEBLD -- Want Statusline ON by default         [ D:N ] ? 
;
;*****
;
; The startup and exit messages like :
;
.IFF CLS	;     "MCE -- MCR-Commandline-Editor 'VERS'"   and   "MCE -- Exit"
.IFT CLS	;     "MCE -- CLI-Commandline-Editor 'VERS'"   and   "MCE -- Exit"
;
; are optional.
;
        .ASK SIL MCEBLD -- Want Startup and exit messages [ D:N ] ? 
;
;*****
;
; When starting MCE via a remote terminal (RT:) problems may occur if the
; local system is VMS with its commandline editor enabled.
; MCE can detect if it was started via a remote terminal and can do
; 3 different things :
;
;	1. Give the folowing message:
;
;               MCE -- ** WARNING ** Started on a remote terminal (RT:)
;                      If your local system is VMS with its commandline editor
;                      enabled please type "MCE EXIT"
;
;	2. Give the folowing message and exit :
;
;               MCE -- Started on a remote terminalline (RT:) Exiting .....
;
;	3. Do nothing
;
;
        .ASKN [1.:3.:1.] O MCEBLD -- Which option [ D:1 ] : 
	.IF O = 1 .SETT RTMESS
	.IF O = 2 .SETT RTEXIT
;
;*****
;
; VT2xx and VT3xx support enables the use of keys <F11>, <F12> and <F13>
; as <ESC>, <BS> and <LF>.  The keys <HELP>, <DO> etc. can also be used
; and it is possible to define the functionkeys <F6> .. <F20> like :
;
;     "F6 := TIM"
;
; pushing <F6> gives the time of day then.
;
        .ASK VT2 MCEBLD -- Want the VT2xx, VT3xx support [ D:N ] ? 
;
;*****
;
; Also the keys of a TANDBERG TDV2230 terminal can be defined.
;
        .ASK TD2 MCEBLD -- Want the TANDBERG TDV2230 function key support [ D:N ] ? 
;
;*****
;
; Some edit functions can be performed on the VT1xx/VT2xx/VT3xx keypad,
; similar to KED and EDT.
; The Keypad-editing can be switched on/off with MCE KEYPad on/off
;
	.ASK EDT MCEBLD -- Want the EDT-Keypad support   [ D:N ] ? 
	.IFT EDT .ASK EDTDEF MCEBLD -- Want EDT-Keypad ON by default [ D:N ] ? 
;
;*****
;
; The MCE prompt can show if overstrike- or insert-mode is active by "+"
; and "-".
; Also it can display if keypad editing ( when selected ) is enabled
; when the statusline is off by ":"
;
;     eg.    "+:>"
;
; The Extended prompt can be switched on/off with MCE PROMpt on/off
;
	.ASK EXTNPR MCEBLD -- Want the extended prompt           [ D:N ] ? 
	.IFT EXTNPR .ASK PRMDEF MCEBLD -- Want Extended prompt ON by default [ D:N ] ? 
;
;*****
;
; Default overstrike- or insert-mode stayes active until it is changed by
; CTRL/A.  MCE can be build so that it sets one of the modes active by default
; when it prompts for a new command. This can be changed with the
; MCE INSErt on/off and MCE OVERstrike on/off commands.
;
            .ASK INSDEF MCEBLD -- Want MCE to set insert-mode back by default     [ D:N ] ? 
.IFF INSDEF .ASK OVSDEF MCEBLD -- Want MCE to set overstrike-mode back by default [ D:N ] ? 
;
;*****
;
; Default "old" commands ( retrieved from fifo and not edited ) are saved
; again in the FIFO. MCE can be build so that it does not save them again.
; This mode can be changed with the  MCE SVOLd on/off command.
;
;
 .ASK OLDDEF MCEBLD -- Want MCE to save "Old" Commands by default [ D:N ] ? 
;
;*****
;
; Default internal commands are saved in the FIFO. MCE can be build so that
; it does not save them.
; This mode can be changed with the  MCE SVINtern on/off command.
;
;
 .ASK INTDEF MCEBLD -- Want MCE to save Internal Commands by default [ D:N ] ? 
;
;*****
;
; When terminal time-out support is included the terminal is logged out
; after a given time-out time ( TT0: only exits MCE )
;
	.ASK TMO MCEBLD -- Want the terminal time-out support       [ D:N ] ? 
        .IFT TMO .ASKN [2.:120.:4.] TMON MCEBLD -- Enter number of time-out minutes [ 2..120  D:4 ] : 
;
;*****
;
; Only commandlines with a length greater than or equal to a given length
; are saved in the command FIFO.
; The value can be changed with the MCE CMSZ nn command.
;
        .ASKN [1.:10.:1.] MINCHR MCEBLD -- Enter minimum commandline length [ 1..10  D:1 ] : 
;
;*****
;
; Specify the default maximum number of commands which can be saved in the
; commandline Fifo.  The value can be changed with the MCE FISZ nn command.
; Note that the actual number of commands that can be saved depend on the
; size of the commands and the available MCE pool space.
; Information about MCE''s poolspace can be obtained by the MCE FREE command.
; More poolspace can be created by installing MCE with a larger increment.
; INS $MCE/INC=xxx
; A value of 2400 will be enough in most cases.
;
        .ASKN [1.:99.:22.] MAXFIF MCEBLD -- Enter maximum number of entries in FIFO [ 1..99  D:22. ] : 
        .IF <SYSTEM> NE 6 .GOTO 35$
;
;*****
;
        .ASK MU  MCEBLD -- Build MCE as a multi-user task   [ D:N ] ? 
        .ASK ID  MCEBLD -- Build MCE as an I & D Space task [ D:N ] ? 
.35$:
        .IF P1 <> "ALL" .GOTO 40$
        .SETT HLP
        .SETT COP
        .GOTO 50$
.40$:
;
;*****
;
; A helpfile MCE.HLP customized to your selections is created dynamicly if
; you answer "Y" to the following question.
	.IFF VT2 .GOTO 42$
; Note that if you donot build the helpfile now, you canot use the
; <NXT-SCREEN> and <PRV-SCREEN> keys to walk through the helpfile.
.42$:
;
        .ASK HLP MCEBLD -- Create helpfile on LB: [ D:N ] ? 
        .IFT A$SV  .OR	.IFF HLP   .GOTO 45$
        .ASKS [::HLPUIC] HLPUIC MCEBLD -- What is your helpfile UIC [ D:'HLPUIC' ] : 
;
;*****
;
; The helpfile can be created in two different versions.
;
; VERSION 1 :  You can access this one by typing HELP MCE [topic...] but
;              you have to include a reference like :
;                    1 MCE
;                    @MCE
;              in  MCR.HLP and DCL.HLP
;
; VERSION 2 :  You can access this one by typing HELP /MCE [topic...]
;              This version does not need any editing of MCR.HLP and DCL.HLP
;
        .ASK HLPNEW MCEBLD -- Do you want VERSION 2 [ D:N ] ? 
.45$:
;
;*****
;
        .ASK COP MCEBLD -- When ready and successfull copy MCE.TSK to LB: device [ D:N ] ? 
        .IFT COP .ASKS [::SYSUIC] SYSUIC MCEBLD -- What is your task UIC [ D:'SYSUIC' ] : 
        .IFT COP .ASK INS MCEBLD -- Install task [ D:N ] ? 
        .ASK PRI MCEBLD -- Print listing and map [ D:N ] ? 
.50$:
        .IFF HLP .GOTO 80$

;MCEBLD -- Creating helpfile LB:'HLPUIC'MCE.HLP .....
.;
	.IFF A$SV .IFT HLPNEW 	.SETN LEVEL 1
	.IFF A$SV .IFF HLPNEW 	.SETN LEVEL 2
	.IFT A$SV 		.SETN LEVEL 3
        .OPEN LB:'HLPUIC'MCE.HLP
			.DATA MCE 'VERS' - Commandline Editor options :
			.DATA
			.DATA - Support is included for the following options :
.IFT SIL    		.DATA   . Startup and exit messages
.IFT VT2    		.DATA   . VT2xx/VT3xx function keys
.IFT TD2		.DATA   . TDV2230 function keys
.IFT INI    		.DATA   . MCEINI files
.IFT CLS		.DATA   . Multiple CLI
.IFT EDT .IFF EDTDEF	.DATA   . EDT-Keypad editing - default OFF
.IFT EDT .IFT EDTDEF	.DATA   . EDT-Keypad editing - default ON
.IFT STA .IFT STADEF 	.DATA   . Statusline - default ON
.IFT STA .IFF STADEF 	.DATA   . Statusline - default OFF
.IFT OLDDEF 		.DATA   . Save "Old" commands default ON
.IFF OLDDEF 		.DATA   . Save "Old" commands default OFF
.IFT INTDEF 		.DATA   . Save Internal commands default ON
.IFF INTDEF 		.DATA   . Save Internal commands default OFF
.IFT INSDEF 		.DATA   . Auto Insertmode default ON
.IFT OVSDEF 		.DATA   . Auto Overstrikemode default ON
.IFT HLPNEW 		.DATA   . HELP /MCE
.IFT CMP  		.DATA   . Compound commandlines
.IFT TMO  		.DATA   . Terminal time-out ( 'TMON%D'. minutes )
.IFT EXTNPR .IFF PRMDEF	.DATA   . Extended prompt - default OFF
.IFT EXTNPR .IFT PRMDEF	.DATA   . Extended prompt - default ON
.IFT RTMESS		.DATA   . RT: detection ( Message )
.IFT RTEXIT		.DATA   . RT: detection ( Exit )
.IF MINCHR = 1		.DATA - Default all Commands are saved. ( CMSZ = 1 )
.IF MINCHR > 1		.DATA - Default only Commands which contain 'MINCHR%D' or more characters are saved.
			.DATA   To change this use the "MCE CMSZ n" Command ( see INTERNAL )
			.DATA - Default the savebuffer can contain up to 'MAXFIF%D' commandlines.
			.DATA   To change this value use the "MCE FISZ n" Command ( see INTERNAL )
			.DATA
.IFF EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.IFT EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; --KEYS1 ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#KEYS1
.DISABLE DATA
			.DATA 'LEVEL' KEYS1
.IFT EDT 		.DATA MCE 'VERS' - Commandline Editor Non-keypad editing and cursormovement commands
.IFF EDT 		.DATA MCE 'VERS' - Commandline Editor Editing and cursormovement commands :
			.DATA
			.DATA  <LEFT>      or <CTRL/D> - Move Cursor Left
			.DATA  <RIGHT>     or <CTRL/F> - Move Cursor Right
			.DATA  <BACKSPACE> or <CTRL/H> - Move Cursor to Begin of Line
			.DATA  <CTRL/E>                - Move Cursor to End of Line
			.DATA  <TAB>       or <CTRL/I> - Move one Word to the right or move from EOL to BOL
			.DATA  <DELETE>                - Delete Character Left of Cursor
			.DATA  <CTRL/V>                - Delete Character at Cursor
			.DATA  <LINEFEED>  or <CTRL/J> - Delete Word Left of Cursor
			.DATA  <CTRL/W>                - Delete Word Right at Cursor
			.DATA  <CTRL/U>                - Delete from Cursor to Begin of Line
			.DATA  <CTRL/K>                - Delete from Cursor to End of Line
			.DATA  <CTRL/C>                - Delete whole line
			.DATA  <CTRL/R>                - Rewrite Line
			.DATA  <CTRL/A>                - Switch between Overstrike and Insert mode
.IFT EXTNPR	 	.DATA                            Current mode is shown by first prompt character.
.IFT EXTNPR 		.DATA                                  "+" insert mode.    "-" overstrike mode.
			.DATA
.IFF EDT 		.DATA More help : KEYS2 COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.IFT EDT 		.DATA More help : KEYS2 COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; --KEYS2 ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#KEYS2
.DISABLE DATA
			.DATA 'LEVEL' KEYS2
.IFT EDT 		.DATA MCE 'VERS' - Commandline Editor Non-keypad keys :
.IFF EDT 		.DATA MCE 'VERS' - Commandline Editor keys :
			.DATA
			.DATA Save and execute :
			.DATA  <RETURN>    or <ENTER>    - Execute Command
.IFT VT2 		.DATA  <ESC><ESC>  or <DO>       - Execute Command without waiting
.IFF VT2 		.DATA  <ESC><ESC>                - Execute Command without waiting
			.DATA  <CTRL/X>                  - Execute Cmd and leave fifo pointer where it is
			.DATA  <CTRL/N>                  - Save Command without executing
			.DATA  <CTRL/T>                  - Enable output from other tasks: Detach for 10 sec.
.IFT EDT		.DATA Non-keypad Commandbuffer manipulation keys:
.IFF EDT		.DATA Commandbuffer manipulation keys :
			.DATA  <PF4>       or <ESC>S     - Display contents of Fifo
			.DATA  <UP>        or <CTRL/B>   - Retrieve previous Command
			.DATA  <DOWN>                    - Reverse of <UP> (next command)
.IFF VT2 		.DATA  <PF2>       or <ESC>Q     - Recall Command previously requested. (see RECALL)
.IFT VT2 		.DATA  <PF2> or <FIND> or <ESC>Q - Recall Command previously requested. (see RECALL)
			.DATA
.IFT EDT		.DATA Non-keypad Help keys:
.IFF EDT		.DATA Help keys:
.IFT VT2 		.DATA  <HELP> or <CTRL/?>        - Gives HELP about MCE
.IFF VT2 		.DATA  <CTRL/?>                  - Gives HELP about MCE
.IFT VT2 		.DATA  <PREV-SCR> / <NEXT-SCR>   - Gives Previous/Next HELP screen
			.DATA
.IFT EDT		.DATA Non-keypad Commandtranslation keys:
.IFF EDT		.DATA Commandtranslation keys:
			.DATA  <PF1>       or <ESC>P     - Translate Command without execution
			.DATA  <PF3>       or <ESC>R     - Show Command Translation Buffer
.IFF EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.IFT EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- COMMANDLINES  ------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#COMMANDLINES
.DISABLE DATA
			.DATA 'LEVEL' COMMANDLINES
			.DATA MCE 'VERS' - Commandline Editor Command Lines :
			.DATA
			.DATA  The maximum length of Commandlines is 78 characters.
			.DATA  If the Commandline starts with "MCE" an Internal Command is assumed, other
.IFF CLS		.DATA  commandlines are checked for translation and the result is spawned to MCR.
.IFT CLS		.DATA  commandlines are checked for translation and the result is spawned to the
.IFT CLS		.DATA  current commandline interpreter for the invoking terminal.
.IFF CLS		.DATA  Special action is performed with "BYE". ( See INTERNAL )
.IFT CLS		.DATA  Special action is performed with "BYE" and "LOG[out]". ( See INTERNAL )
.IFT CMP		.DATA  A commandline can consist of a single command or can contain more commands
.IFT CMP		.DATA  separated by " &". ( Note the space to let PIP /TD&/LI still work. )
.IFT CMP		.DATA  A command behind a "&" will only be processed when the former was successfull.
.IFT CMP		.DATA  A compound commandline may not contain Internal Commands and only the first
.IFT CMP		.DATA  command is checked for translation.
			.DATA
.IF MINCHR = 1		.DATA  Normally all commandlines are saved in the fifo buffer. This may be changed
.IF MINCHR = 1		.DATA  with the "MCE CMSZ nn" command. ( See INTERNAL )
.IF MINCHR > 1		.DATA  Normally all commandlines which contain 'MINCHR'. or more characters are saved
.IF MINCHR > 1		.DATA  in the fifo buffer. This may be changed with "MCE CMSZ nn" ( See INTERNAL )
			.DATA  When 'MAXFIF'. entries are present, or when no buffer space is available to hold
			.DATA  more entries, the new command is saved and the oldest disapears.
			.DATA  Retrieved commandlines from the fifo are only saved again if they are
			.DATA  edited or when the saving is enabled by "MCE SVOL ON". ( Save "OLD" commands )
			.DATA  Internal commands are saved when this is enabled by "MCE SVIN ON".
			.DATA  ( Save "INTERNAL commands )
.IFF EDT 		.DATA More help : KEYS  TRANS  FUNC  START  EXIT  INTERNAL  RECALL
.IFT EDT 		.DATA More help : KEYS  TRANS  FUNC  START  EXIT  INTERNAL  RECALL  KEYPAD
.; -- TRANS1  ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#TRANS1
.DISABLE DATA
			.DATA 'LEVEL' TRANS1
			.DATA MCE 'VERS' - Commandline Editor Command translations :
			.DATA
			.DATA  A Command may be defined by:
.IFF CMP		.DATA         +>CNAM := <TRANSLATION_OF_COMMAND>
.IFT CMP  		.DATA         +>CNAM := <TRANSL_OF_COMMAND> [ & <TRANSL_OF_COMMAND> [ & ... ] ]
			.DATA  where CNAM is the commandname which will be substituted by the
			.DATA  text at the right side of the ":=".
.IFT CMP		.DATA  A command behind  " &" will only be processed when the former was successfull.
			.DATA  NOTE: The ":=" must be prececed and followed by at least a single space.
			.DATA  e.g.:  +>HE := HELP PIP        ! 
			.DATA         +>HE                    ! Will request "HELP PIP"
.IFF EDT		.DATA  The <PF1> or <ESC>P key translates the command without execution.
.IFT EDT		.DATA  With Keypad disabled <PF1> or <ESC>P translates the command without execution.
			.DATA
			.DATA  If you enter a predefined command followed by additional text,
			.DATA  this additional text will normally be appended as a whole.
			.DATA  e.g.:  +>HE /RE                ! Will request "HELP PIP /RE
			.DATA  or:    +>HE /RE<PF1>           ! Will be translated and displayed
			.DATA  result +>HELP PIP /RE
			.DATA
			.DATA  You may delete a command translation entry by redefining it to null.
			.DATA  e.g.:  +>HE :=                 ! Delete above definition
			.DATA
.IFF EDT 		.DATA More help : KEYS COMMANDLINES TRANS2 FUNC START EXIT INTERNAL RECALL
.IFT EDT 		.DATA More help : KEYS COMMANDLINES TRANS2 FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- TRANS2  ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#TRANS2
.DISABLE DATA
			.DATA 'LEVEL' TRANS2
			.DATA MCE 'VERS' - Commandline Editor Command translations ( continued ) :
			.DATA
			.DATA  Abbreviate commands by seperating the optional part by "*"
			.DATA  e.g.:  +>HP*IP := HELP PIP
			.DATA  This command may now be requested with:
			.DATA         +>HP or HPI or HPIP  ect.
			.DATA
			.DATA  More sophisticated substitution is possible by the Parameter-Substitution,
			.DATA  similar to the indirect commandfile processor.
			.DATA  e.g.:  +>DIR*ECTORY := PIP ''P1''/LI
			.DATA         +>COP*Y := PIP ''P2''/NV/CD=''P1''
			.DATA         +>DIR                   ! Will be translated into "PIP /LI"
			.DATA         +>DIREC FIL             ! Will be translated into "PIP FIL/LI"
			.DATA         +>COPY A.CMD [200,200]  ! Will simulate DCL COPY command
.IFT INI 		.DATA  Note that Command Definitions may be performed from the commandfile
.IFT INI .IFF CLS 	.DATA         LB:'INIUIC'MCEINI.CMD  and  SY:[cur_dir]MCEINI.CMD.IFT
.IFT INI .IFT CLS 	.DATA         LB:'INIUIC'MCEINI.xxx  and  SY:[cur_dir]MCEINI.xxx
.IFT INI 		.DATA  which will always be read when MCE is started.
.IFT INI 		.DATA         [cur_dir] = the default directory at the startup of MCE.
.IFT INI .IFT CLS 	.DATA         xxx       = CLI name
.IFT INI 		.DATA  Files are read in order they are mentioned above.
			.DATA
.IFF EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.IFT EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- FUNC  ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#FUNC
.DISABLE DATA
			.DATA 'LEVEL' FUNC
			.DATA MCE 'VERS' - Commandline Editor Functionkeys :
			.DATA
			.DATA  You may request a command with function keys <PF1>, <PF2>, <PF3> or <PF4>
			.DATA  It is also possible to request commands with control keys. (e.g. <CTRL/G>)
.IFT VT2 		.DATA  On a VT2xx you can also define the function keys <F6> .. <F20> and <FIND>
.IFT VT2 		.DATA  <INSERT HERE> ect.
.IFT TD2 		.DATA  On a TDV2230 you can also define the function keys <F1> ... <F7>
			.DATA  Define the command translation as "''key'' := command".
			.DATA  e.g.   +>PF2 := TIM            ! Redefine <PF2> function key
			.DATA         <PF2>                   !  to display the current time
.IFT VT2 .OR .IFT TD2 	.DATA         +>F6 := ACT             ! Define F6 function key
.IFT VT2 .OR .IFT TD2 	.DATA         <F6>                    !  to display the active tasks
.IFT VT2 		.DATA  On a VT2XX the keys <FIND> ect. must be entered as F$a  where "a" is the
.IFT VT2 		.DATA  first char. of the key function.  e.g.  "F$P" for <PREV SCREEN>
			.DATA  Define a control key as follows :
			.DATA  e.g.   +>^G := SET /UIC        ! Define <CTRL/G> key
			.DATA         <CTRL/G>                !  to display the current UIC
			.DATA  Note that the following control-keys CANNOT be defined:
			.DATA  <CTRL/M> = <RETURN>,  <CTRL/O>,  <CTRL/Q>,  <CTRL/S>,  <CTRL/[> = <ESC>
			.DATA  Next to the rest of the Alphabetic characters the following keys can
			.DATA  be defined : <CTRL/\>,  <CTRL/]>,  <CTRL/^>,  <CTRL/?>
.IFF EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  START  EXIT  INTERNAL  RECALL
.IFT EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  START  EXIT  INTERNAL  RECALL  KEYPAD
.; -- START ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#START
.DISABLE DATA
			.DATA 'LEVEL' START
			.DATA MCE 'VERS' - Commandline Editor Startup
			.DATA
			.DATA  Invoke MCE with command "MCE" (at best in your LOGIN file by ".XQT MCE").
.IFF INI .GOTO 54$:
.IFT CLS		.DATA  A File of Command Definitions, CLI Commands and/or Internal commands will be 
.IFF CLS		.DATA  A File of Command Definitions, MCR Commands and/or Internal commands will be
			.DATA  executed at MCE start time. The file may be specified in the form 
			.DATA "MCE startup_file".
			.DATA  If no startup file is specified in the commandline (the normal case),
			.DATA  files are searched for are in this order:
.IFT CLS 		.DATA     LB:'INIUIC'MCEINI.xxx,        followed by
.IFT CLS 		.DATA     SY:[cur_dir]MCEINI.xxx,
.IFT CLS 		.DATA  Where "xxx" is the name of the CLI defined for the terminal invoking MCE
.IFT CLS 		.DATA  and [cur_dir] is the default directory at the startup of MCE.
.IFF CLS 		.DATA     LB:'INIUIC'MCEINI.CMD,        followed by
.IFF CLS 		.DATA     SY:[cur_dir]MCEINI.CMD,
.IFF CLS 		.DATA  [cur_dir] is the default directory at the startup of MCE.
			.DATA  This algorithm divides command-definitions into 2 groups:
			.DATA  A system-wide set in LB:'INIUIC', followed by a users private set in SY:<uic>.
			.DATA  Overriding the default file name in the commandline invoking MCE offers
			.DATA  the possibility to tailor an application specific command set.
.54$:
			.DATA
.IFF EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  FUNC  EXIT  INTERNAL  RECALL
.IFT EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  FUNC  EXIT  INTERNAL  RECALL  KEYPAD
.; -- EXIT ------------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#EXIT
.DISABLE DATA
			.DATA 'LEVEL' EXIT
			.DATA MCE 'VERS' - Commandline Editor Exit
			.DATA
			.DATA   To exit MCE operations, use the "MCE EXIT" internal command.
			.DATA   or <CTRL/Y>
			.DATA   More about internal commands see help MCE INTERNAL.
			.DATA
.IFF EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  FUNC  START  INTERNAL  RECALL
.IFT EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  FUNC  START  INTERNAL  RECALL  KEYPAD
.; -- INTERNAL -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#INTERNAL
.DISABLE DATA
			.DATA 'LEVEL' INTERNAL
			.DATA MCE 'VERS' - Commandline Editor Internal commands ( MCE xxxx )
.IFT INI 		.DATA    CHAI file: Chain from one INIT-file to another. (synonym for READ)
		        .DATA    CLEA     : Delete all commands in command Fifo
		        .DATA    CMSZ n   : Changes Minimal commandlinelength to be saved to "n"
		        .DATA    ECHO     : Commandlines are echoed on TI: ( usefull in INIT-files )
		        .DATA    EXIT     : MCE task exit (return to the normal command environment.)
		        .DATA    FISZ n   : Changes Fifosize to "n" ( if enough memory )
		        .DATA    FREE     : Display MCE Pool info (largest_block:Total_free_blocks:fragments)
			.DATA    INTE xx  : Auto Insert mode on/off       ( xx = on / off )
.IFT EDT 		.DATA    KEYP xx  : Set Keypad editing on/off     ( xx = on / off )
		        .DATA    LIST     : FIFO is a list       : UP- and DOWN-ARROW stop at the end
			.DATA    OVER xx  : Auto Overstrike mode on/off   ( xx = on / off )
.IFT EXTNPR		.DATA    PROM xx  : Extended prompt on/off        ( xx = on / off )
		        .DATA    PURG     : Delete all commands in translation table
.IFT INI 		.DATA    READ file: Read commands from specified file
.IFT INI 		.DATA    REPL file: Combines PURGe and READ.
.IFT STA 		.DATA    STAT xx  : Statusline on/off/show        ( xx = on / off / "blank" )
		        .DATA    SVIN xx  : Save internal commands on/off ( xx = on / off )
		        .DATA    SVOL xx  : Save "old" commands on/off    ( xx = on / off )
		        .DATA    RING     : FIFO is a ringbuffer : UP- and DOWN-ARROW roll through the FIFO
		        .DATA    VERS     : Show MCE Version
			.DATA   INTERNAL2 gives you explanation of internal commands.
.IFF EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL2 RECALL
.IFT EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL2 RECALL KEYPAD
.; -- INTERNAL2 -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#INTERNAL2
.DISABLE DATA
			.DATA 'LEVEL' INTERNAL2
			.DATA MCE 'VERS' - Commandline Editor Internal commands ( continued )
			.DATA
.IFF CLS		.DATA   Two command verbs are specially handled by MCE : "BYE" and "MCE".
.IFF CLS		.DATA   "BYE" is sent to MCR and MCE exits immediately.
.IFT CLS		.DATA   Three command verbs are specially handled by MCE: "BYE", "LOG[out]" and "MCE".
.IFT CLS		.DATA   "BYE" and when in DCL "LOG[out]" result in a spawn of "BYE" to MCR and MCE
.IFT CLS		.DATA   exits immediately.
			.DATA   Note that you may define any other string ( e.g. GOODBYE ) to result
.IFF CLS		.DATA   in BYE.
.IFT CLS		.DATA   in BYE or LOGOUT.
			.DATA   Commands starting with "MCE" are treated as internal commands and not passed
.IFF CLS		.DATA   to MCR. Following the verb "MCE " a 4 character action specifier defines
.IFT CLS		.DATA   to the CLI. Following the verb "MCE " a 4 character action specifier defines
			.DATA   the action wanted.
.IFF INI .GOTO 60$
			.DATA   The READ and REPLACE options, if no file is specified, follow the
.IFF CLS .GOTO 59$
			.DATA   the same file name convention as at startup: the files according
			.DATA   to the current CLI are read in, i.e. the command "MCE REPLace"
			.DATA   effects in a MCE restart (but the FIFO buffer is kept), usefull
			.DATA   after a SET TERMINAL new_cli command.
			.DATA   When a space is given as filename, only SY:[cur_dir]MCEINI.xxx is read.
			.DATA   [cur_dir] is the default directory at the moment of the command.
	.GOTO 60$
.59$:
			.DATA   the same file name convention as at startup: the INIT files
			.DATA   are read in, i.e. the command "MCE REPLace" effects in an MCE restart
			.DATA   (but the FIFO buffer is kept).
			.DATA   When a space is given as filename, only SY:[cur_dir]MCEINI.CMD is read.
			.DATA   [cur_dir] is the default directory at the moment of the command.
.60$:
			.DATA
.IFF EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL
.IFT EDT 		.DATA More help : KEYS COMMANDLINES TRANS FUNC START EXIT INTERNAL RECALL KEYPAD
.; -- RECALL -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#RECALL
.DISABLE DATA
			.DATA 'LEVEL' RECALL
			.DATA MCE 'VERS' - Commandline Editor Recall function
			.DATA
			.DATA  Recalling a command is done by entering the first part of a command
			.DATA  which was previously executed, termimated by the function key <PF2>,
.IFF VT2		.DATA  or by <ESC>Q.
.IFT VT2		.DATA  by <ESC>Q or by <FIND>.
			.DATA  This will find the last command already executed starting with the
			.DATA  string entered.  The command may be edited or executed by pressing
			.DATA  the return key. A second <PF2> keystroke searches further back in the
			.DATA  FIFO. When no string is entered, the last defined string is taken.
			.DATA  Note that the function key <PF2> may not have any superimposed
			.DATA  translation defined (by defining "PF2 := ...").  Example :
			.DATA     +>DIR X.DAT        ! Previously entered command
			.DATA     +>DMP X.DAT        !     "          "      "
			.DATA
			.DATA     +>D<PF2>           ! Will recall the last command starting with "D":
			.DATA     						+>DMP X.DAT
			.DATA     +><PF2>            ! Will recall the for last command:
			.DATA     						+>DIR X.DAT
			.DATA     +>DI<PF2>          ! Will recall the command:
			.DATA     						+>DIR X.DAT
			.DATA
.IFF EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  FUNC  START  EXIT  INTERNAL
.IFT EDT 		.DATA More help : KEYS  COMMANDLINES  TRANS  FUNC  START  EXIT  INTERNAL  KEYPAD
.IFF EDT .GOTO 70$
.; -- KEYPAD  -----------------------------------------------------------------------------------------------------------------
			.INC HLPNR
			.SETS MAXHLP HLPCHR[HLPNR:HLPNR]
			.DATA 'LEVEL' MCE'MAXHLP'
			.ENABLE DATA
#KEYPAD
.DISABLE DATA
			.DATA 'LEVEL' KEYPAD
			.DATA MCE 'VERS' - Commandline Editor EDT-Keypad and function keys :
			.DATA   +--------+-----------------+    +--------+--------+--------+--------+
			.DATA   |        |                 |    |\\\\\\\\|        |        |        |
			.DATA   |  HELP  |  EXECUTE NOWAIT |    |\\GOLD\\| KPHELP | RECALL | DELLIN |
			.DATA   |        |                 |    |\\\\\\\\|        |        |        |
			.DATA   +--------+--------+--------+    +--------+--------+--------+--------+
			.DATA   |        | INSERT | RE-    |    |        | SHOCMD | SHOFIF |        |
			.DATA   | RECALL |  HERE  |  MOVE  |    | TRANSL | ------ | ------ | DELWRD |
			.DATA   |        |        |        |    |        |\\VERS\\|\\FREE\\|        |
			.DATA   +--------+--------+--------+    +--------+--------+--------+--------+
			.DATA   |        |  PREV  |  NEXT  |    |        |        |  CUT   |        |
			.DATA   | SELECT |  HELP  |  HELP  |    |        |        | ------ | DELCHR |
			.DATA   |        |        |        |    |        |        |\PASTE\\|        |
			.DATA   +--------+--------+--------+    +--------+--------+--------+--------+
			.DATA            |        |             |        |  EOL   |        |        |
			.DATA            |    ^   |             |  WORD  | ------ |        |        |
			.DATA            |    |   |             |        |\DELLIN\|        |        |
			.DATA   +--------+--------+--------+    +--------+--------+--------+  ENTER |
			.DATA   |        |        |        |    |    BEGLINE      | SELECT |        |
			.DATA   |  <-    |    |   |   ->   |    | --------------- | ------ |        |
			.DATA   |        |    V   |        |    |\\\\CLRLINE\\\\\\|\RESET\\|        |
			.DATA   +--------+--------+--------+    +-----------------+--------+--------+
.70$:
        .close
        'cli' PIP LB:'HLPUIC'MCE.HLP/PU/NM
.80$:
;MCEBLD -- Creating configuration prefixfile MCEPRE.MAC .....
        .OPEN MCEPRE.MAC
        .data   .SBTTL MCE - Configuration prefixfile MCEPRE.MAC
        .data ;
        .data ; MCE Macro Prefixfile
        .data ; Created on '<date>' '<time>' by MCEBLD.CMD Version: 'VERS'
	.data ;
		.DATA IDNPRE   = 'IDNPRE'    ; Ident of MCEPRE.MAC
.IFT A$SV       .DATA A$SV     = 1     ; EUR - CRW/ASV support
.IFT CLS    	.DATA CLISUP   = 1     ; Multiple cli supp
.IFT CMP    	.DATA COMPND   = 1     ; Compound command (&) support
.IFT EDT    	.DATA EDT      = 1     ; EDT-Keypad support included
.IFT EDT .IFF EDTDEF 	.DATA EDTDEF   = 0     ; EDT-Keypad off by default
.IFT EDTDEF 	.DATA EDTDEF   = 1     ; EDT-Keypad on by default
.IFT EXTNPR 	.DATA EXTNPR   = 1     ; Extended prompt included
.IFT EXTNPR .IFF PRMDEF .DATA PRMDEF   = 0     ; Extended prompt off by default
.IFT EXTNPR .IFT PRMDEF .DATA PRMDEF   = 1     ; Extended prompt on by default
.IFT INI    	.DATA FILE     = 1     ; MCEINI file support included
.IFT HLPNEW 	.DATA HLPNEW   = 1     ; "HELP /" support
.IFF INSDEF 	.DATA INSDEF   = 0     ; Not return to insert-mode by default
.IFT INSDEF 	.DATA INSDEF   = 1     ; Return to insert-mode by default
.IFF INTDEF 	.DATA INTDEF   = 0     ; Not save internal commands by default
.IFT INTDEF 	.DATA INTDEF   = 1     ; Save internal commands by default
.IFF OLDDEF 	.DATA OLDDEF   = 0     ; Not save old commands by default
.IFT OLDDEF 	.DATA OLDDEF   = 1     ; Save old commands by default
.IFF OVSDEF 	.DATA OVSDEF   = 0     ; Not return to overstr.-mode by default
.IFT OVSDEF 	.DATA OVSDEF   = 1     ; Return to overstr.-mode by default
.IFT RTMESS	.DATA RTMESS   = 1     ; RT: detection ( Message )
.IFT RTEXIT	.DATA RTEXIT   = 1     ; RT: detection ( Exit )
.IFF SIL    	.DATA SILENT   = 1     ; No Startup and exit messages
.IFT STA    	.DATA STATUS   = 1     ; Statusline support
.IFT STA .IFF STADEF 	.DATA STADEF   = 0     ; Statusline off by default
.IFT STADEF 	.DATA STADEF   = 1     ; Statusline on by default
.IFT VT2    	.DATA VT2XX    = 1     ; VT2xx support included
.IFT TD2    	.DATA TDV2XX   = 1     ; TDV2230 support included
.IFT TMO   	.DATA TMOTIM   = 'TMON'.	 ; Time-out support 'TMON'. Minutes.
        .DATA MAXFIF   = 'MAXFIF'.	 ; Maximal number of entries in FIFO
	.DATA MAXHLP   = '''MAXHLP'	 ; Highest available Helppage
	.DATA MINCHR   = 'MINCHR'.	 ; Minimal cmd-line length to be saved
        .CLOSE
;MCEBLD -- Creating MAC-commandfile MCEASM.CMD .....
        .open MCEASM.CMD
        .data ;
        .data ; MCE Macro buildfile
        .data ; Created on '<date>' '<time>' by MCEBLD.CMD Version: 'VERS'
        .data ;
        .data MCE,MCE/CR/-SP=MCEPRE,MCE
        .CLOSE
;MCEBLD -- Creating TKB-commandfile MCETKB.CMD .....
        .OPEN MCETKB.CMD
        .SETS LIBR "Suplib=FCSFSL:SV"   ; Assume FCSFSL
        .TESTFILE LB:[1,1]FCSFSL.TSK
        .IF <FILERR> EQ 1 .GOTO LINK2
        .SETS LIBR "Libr=FCSRES:RO"     ; Assume FCSRES
        .TESTFILE LB:[1,1]FCSRES.TSK
        .IF <FILERR> EQ 1 .GOTO LINK2
        .SETS LIBR ";"
.LINK2:
.ENABLE DATA
;
; MCE Link buildfile
; Created on '<date>' '<time>' by MCEBLD.CMD Version: 'VERS'
;
.DISABLE DATA
.IFF MU .IFF ID .DATA MCE/CP,MCE/-SP=MCE
.IFT MU .IFF ID .DATA MCE/MU/CP,MCE/-SP=MCE
.IFF MU .IFT ID .DATA MCE/ID/CP,MCE/-SP=MCE
.IFT MU .IFT ID .DATA MCE/ID/MU/CP,MCE/-SP=MCE
.ENABLE DATA
;
; Virtual memory library .....
;
LB:[1,1]VMLIB/LB:INIDM:EXTSK
/
Units=2
Asg=TI:1
Asg=SY:2
Pri=150
Task=...MCE
'LIBR'
Exttsk=2400  ; May be extended to add more Poolspace
;
; Global definitions for 'older' RSX systems .....
;
;   Uncomment following line when TKB finds T.V2XX undefined ...
;
;Gbldef=T.V2xx:36
;
;   Uncomment following line when TKB finds SD.TI undefined ...
;
;Gbldef=SD.TI:6
;
/
.DISABLE DATA
        .CLOSE
    'cli' PIP MCEASM.CMD/PU/NM,MCEASM.CMD
.MAC:
;MCEBLD -- Assembling MCE .....
	.;
    'cli' MAC @MCEASM
        .IF <EXSTAT> NE <succes> .GOTO 200$
        .;
    'cli' PIP MCE.OBJ/PU/NM,MCE.LST
    'cli' PIP MCEPRE.MAC/PU/NM
.LINK:
;MCEBLD -- Building MCE .....
    'cli' PIP MCETKB.CMD/PU/NM
    'cli' TKB @MCETKB
        .IF <EXSTAT> NE 1 .GOTO 200$
.;
    'cli' PIP MCE.TSK/PU/NM,MCE.MAP
.;
        .IFF COP .GOTO 100$
    'cli' PIP LB:'SYSUIC'/NV/FO/CO=MCE.TSK
        .IFF INS .GOTO 100$
        .IFINS ...MCE           'cli' REM ...MCE
    'cli' INS LB:'SYSUIC'MCE
.;
.100$:
        .IFT PRI 'cli' PRI MCE/FLA=MCE.LST,MCE.MAP
;MCEBLD -- Procedure done
        .EXIT   <SUCCES>
.200$:
;
;MCEBLD -- Something wrong !!!
;
        .EXIT   <WARNIN>
