{$NOLIST}
{ ******* PASCAL-3 *************}

{
 These are general type declarations that are used in controlling
  terminal output.

FILE: LB:[22,320]VT100.TYP
AUTHOR: 24-Aug-83 Jim Bostwick 
History: This version created from GENTYP2.PAS 
        19-Oct-83 - Create an expanded CRT_attribute set that can
                    completely describe terminal output desires.

!!!!!!NOTE......

   CRT_attribute has been expanded to encompass the various 
   terminal control definitions that we used to have.  The first
   five scalers have stayed the same from PASCAL2, so that we
   should not need to change the current PUTSTR.  Since CRT_attribute
   is now a packed set (it was not in PASCAL2, we may need to
   modify PUTSTR to look for the revised set size.



Last Edit: PTH 19-Oct-83
}

{Old Pascal-2 definitions....}

{   ERASEWHAT = (REST,TOP,ALL,EOL,BOL,LIN);}
{   DBLTYP = (TOPHALF,BOTHALF,NORM,WIDE);}
{  CRT_Attribute = (Standard,Bold,Underline,Blink,Reverse);}
{  CRT_Attribute_set = SET OF CRT_Attribute ;}
{   DIRECTION = (UP,DOWN,RIGHT,LEFT);}


{*USER*
.hl 2 CRT output attributes
 The possible attributes that CRT output may have are set up as
scaler types and a set containing those scalers.  Thus we can use
set notation to describe the attributes that we want in effect when
we do terminal output.  VT100 terminals are the only terminals
that can implement all of these attributes, all other terminals can only
use "Standard" and "Ring_Bell".

.ls
.le "Standard" - Use the default attributes, overriding any others
specified in the set.  The default attributes mean normal video (white
on black), normal character intesity, normal character size, normal
screen size (80 char).
.le "Bold" - Use bold intesity for output.
.le "Underline" - Underline the output.
.le "Blink" - Blink the output on and off continuously.
.le "Reverse" - Use reverse video for the output.  That means that
if the screen background is black, the output will have a white background,
and if the screen background is white, the output will have a black
background.
.le "Double_upper" - Use upper half double high characters for output.
.le "Double_lower" - Use lower half double high characters for output.
.le "Double_wide" - Use double wide characters for output.
.le "Wide_screen" - Switch screen to 132 column format.
.le "Reverse_screen" - Switch sreen background to white.
.le "Ring_bell" - Ring terminal bell before output.
.le "Save_cursor" - Save cursor position before output, and restore
cursor position after output.
.els
}

{ Att_spare_x are used to fill out set to give it 16 elements which 
  will be one word.}

TYPE

  CRT_Attribute = (Standard, Bold, Underline, Blink, Reverse,
        Double_upper, Double_lower, Double_wide, Wide_screen, Reverse_screen,
        Ring_bell, Save_cursor, Att_spare_1, Att_spare_2, Att_spare_3, 
        Att_spare_4);

  CRT_Attribute_set = Packed set of CRT_Attribute ;

