program cinthx;
{$NOMAIN}
{$NOWALKBACK}

{
.stop

File		: DE:[22,310]CINTHX.PAS
Author		: Peter Stadick
Date		: Jun 6,1989
Edit History	:

       Last Edit: 6-JUN-1989 20:06:59 
}

procedure cinthx(bin:integer;
		 var asc:packed array [lo..hi:integer] of char;
                 pos:integer); external;
{
 Convert unsigned 16 bin value into 4 hex digits. 
 pos >  0: left justify output starting at pos.
 pos <= 0: right justify ending pos.
}

procedure cinthx;

type 
  digit_type = 0..17B;
  hex_digits_type = packed array [1..4] of digit_type;

var
  temp		: packed array [1..4] of char;
  i,j		: integer;
  hex_digits	: hex_digits_type;

begin
  { convert to hex }
  hex_digits := loophole(hex_digits_type,bin);
  
  for i := 1 to 4 do
  begin
    temp[i] := chr(hex_digits[5-i] + ord('0'));
    if temp[i] > '9' then
      temp[i] := chr(ord(temp[i]) + 7);
  end;

  if pos <= 0 then
    pos := abs(pos) - 3;

  for i := 1 to 4 do
  begin
    j := lo + (i - 1) + (pos - 1);
    if (j >= lo) and (j <= hi) then
      asc[j] := temp[i];
  end;
end;
