Program TSTCADTND;

{File: [22,311]TSTCADTND.PAS      Last edit: 9-JUN-1987 14:14:05 

 History:  8-Jun_87 Bob Thomas Created

}

{ Test routine to test CADTND Convert Ascii Date to Numeric Date
  P3UTIL library routine }

%INCLUDE LB:[22,320]GENERAL3.TYP;
%INCLUDE EX:[22,320]SASSIGN.EXT;
%INCLUDE LB:[22,320]CADTND.EXT;

type
  test_chr_type = packed array [1..3] of char;
  test_date_type = packed array [1..4] of dec_date;

const
  test_chr = test_chr_type('*','w','W');
  bad_date = test_date_type('00-jan-87','32-jan-87','29-feb-87','31-sep-87');
  good_date = test_date_type('01-jan-87','29-Feb-80','14-jUL-01','31-DEC-99');


Var
  I_date: int_date;
  Z_date: PACKED ARRAY [0..9] OF char;
  A_date: PACKED ARRAY [1..9] OF char;
  L_date:CH20;
  resp: char;
  i,j,check_total:integer;
  
Begin
writeln;
writeln('Begin test');

{test for type zero string}
writeln('Testing type zero string');
Sassign(Z_date,'18-jul-40');
cadtnd(Z_date,I_date);
check_total:=I_date.year + I_date.month + I_date.day;
if Check_total=0 then writeln ('FAILURE - Type zero string test  '
		  ,' I_date = ',I_date.year,I_date.month,I_date.day);

{test for valid Long string }
writeln('Testing Valid Long string');
Sassign(L_date,'18-jul-40');
cadtnd(L_date,I_date);
check_total:=I_date.year + I_date.month + I_date.day;
if Check_total=0 then writeln ('FAILURE - Long string test = ',L_date
		  ,' I_date = ',I_date.year,I_date.month,I_date.day);

{test for invalid Long string }
writeln('Testing Invalid Long string');
Sassign(L_date,'18-jul-40 ');
cadtnd(L_date,I_date);
check_total:=I_date.year + I_date.month + I_date.day;
if Check_total<>0 then writeln ('FAILURE - Long string test = ',L_date
		  ,' I_date = ',I_date.year,I_date.month,I_date.day);


{test for bad character}
writeln('Testing for bad characters ');
for i:=1 to 9 do begin
  for j:=1 to 3 do begin
    A_date:='18-jul-87';
    A_date[i]:=test_chr[j];
    cadtnd(A_date,I_date);
    check_total:=I_date.year + I_date.month + I_date.day;
    if check_total<>0 then writeln ('FAILURE - Bad chr test = ',A_date
		  ,' I_date = ',I_date.year,I_date.month,I_date.day);
end;{j loop}
end;{i loop}

{test a bad date}
writeln('Testing bad dates ');
for i:=1 to 4 do begin
  A_date:=bad_date[i];
  cadtnd(A_date,I_date);
  check_total:=I_date.year + I_date.month + I_date.day;
  if check_total<>0 then writeln ('FAILURE - Bad date test = ',A_date
		  ,' I_date = ',I_date.year,I_date.month,I_date.day);
end;{i loop}

{test a good date}
writeln('Testing good dates ');
for i:=1 to 4 do begin
  A_date:=good_date[i];
  cadtnd(A_date,I_date);
  check_total:=I_date.year + I_date.month + I_date.day;
  if Check_total=0 then writeln ('FAILURE - Good date test = ',A_date
		  ,' I_date = ',I_date.year,I_date.month,I_date.day);
end;{i loop}

repeat
  writeln;
  writeln('Free form testing ');
  write('Enter Ascii DEC style date in the form DD-MMM-YY> ');
  readln(A_date);
  writeln;
  writeln('Ascii date is ',A_date);
  writeln('Convert to numeric date....');
  writeln;
  cadtnd(A_date,I_date);
  writeln('Numeric date (YY:MM:DD) is ',I_date.year,':',I_date.month,':',I_date.day);
  writeln;
  write('Loop again (Y,N)> ');
  readln(resp);
  until (resp <> 'Y') and (resp <> 'y');
writeln;
writeln('End test');
writeln;
end.



