.; File: [22,311]RUNUETP.CMD      Last edit: 10-SEP-1989 13:55:10 
.;
.; History:  21-Apr-88.  Philip Hannay.  
.;           22-May-89.  Philip Hannay.  Added ability to run ALL tests,
.;             one test, or interactively pick and choose.
.;
.; This command file is the UETP (User Environment Test Program) for
.; the P3UTIL library.  It will run all test programs for the P3UTIL 
.; library routines.  They will be run in the order that will test
.; routines before they are used in subsequent tests.  Instructions will
.; be supplied where needed.
.;
.; Use BLDUETP.CMD to compile and build the test programs.  If testing is
.; successful, you can delete the task (TSK) images.
.;
.; Command file syntax is @RUNUETP <option>, where option can be "ALL"
.; for run all tests, or "TSTxxxxxx" to run a single test, or nothing,
.; which will interactively let you pick and choose which tests to run.
.;
.;

;
; RUNUETP.CMD command file - User Environment Test Program - tests various
; P3UTIL modules
;
.enable substitution
.sets clipre ""
.if <cli> ne "DCL" .sets clipre "DCL"
.;
.; look at parameter if any and set booleans
.;
.setf onejob
.sets onenam ""
.setf alljob
.setf askjob
.sett resp

.if p1 eq "" .goto noparm
.if p1 eq "ALL" .goto alparm

.; must be specific test
.sett onejob
.sets onenam p1
; UETP will be run for 'onenam'
;
.goto okay

.noparm:
.; no parameter, ask interactively
.sett askjob
; You will be asked if you want to run each UETP
;
.ask resp Ready to go
.iff resp .stop
;
.goto okay

.alparm:
.; all tests to be run
.sett alljob
; all UETPs will be run 
;
.goto okay

.okay:

.ift onejob .if onenam ne "TSTSTLO" .goto STLO
.ift askjob .ask resp run STLO UETP (TSTSTLO)
.ift askjob .iff resp .goto STLO
;
; STLO - STLO$ directive - wait for logical OR of event flags
;
; Test program will set and clear global event flags if given goahead.
; While running, do not use SCROLL/NOSCROLL as timing events occur.
;
run tststlo
;
.STLO:


.ift onejob .if onenam ne "TSTGTIM" .goto GTIM
.ift askjob .ask resp run GTIM UETP (TSTGTIM)
.ift askjob .iff resp .goto GTIM
;
; GTIM - GTIM$ directive - get current date/time
;
; Test program will get current date, time, ticks and ticks per second.
; While running, you may use SCROLL/NOSCROLL as desired.
;
run tstgtim
;
.GTIM:


.ift onejob .if onenam ne "TSTUNSLCT" .goto UNSLCT
.ift askjob .ask resp run UNSLCT UETP (TSTUNSLCT)
.ift askjob .iff resp .goto UNSLCT
;
; UNSLCT/TYPBUF - Unsolicted Input AST procedure and Typeahead Count procedure
;
; Test program will setup and accept unsolicted input on two terminals.
; It also will use TYPBUF to return the number of characters that are in
; the typeahead buffer of the active terminal.
; Uses STLO, CLEF,WAIT and RDEF routines.  Display can be SCROLLED/NOSCROLLED
; as desired.
;
run tstunslct
;
.UNSLCT:


.ift onejob .if onenam ne "TSTSLEN" .goto SLEN
.ift askjob .ask resp run SLEN UETP (TSTSLEN)
.ift askjob .iff resp .goto SLEN
;
; SLEN - return string length.
;
; Test program required no input, and the display can 
; be SCROLLED/NOSCROLLED as desired.
;
run tstslen
;
.SLEN:


.ift onejob .if onenam ne "TSTADATIM" .goto ADATIM
.ift askjob .ask resp run ADATIM UETP (TSTADATIM)
.ift askjob .iff resp .goto ADATIM
;
; ADATIM - get current date/time timestamp in various ascii formats
;
; Test program will get current date and time in various ascii formats 
; using type0 and type1 strings. 
; While running, you may use SCROLL/NOSCROLL as desired.
;
run tstadatim
;
.ADATIM:


.ift onejob .if onenam ne "TSTCINTAS" .goto CINTAS
.ift askjob .ask resp run CINTAS UETP (TSTCINTAS)
.ift askjob .iff resp .goto CINTAS
;
; CINTAS - convert integer to ascii
;
; Test program requires no input, and the display can 
; be SCROLLED/NOSCROLLED as desired.  Uses the string package 
; routines.
;
run tstCINTAS
;
.CINTAS:


.ift onejob .if onenam ne "TSTCPKTAS" .goto CPKTAS
.ift askjob .ask resp run CPKTAS UETP (TSTCPKTAS)
.ift askjob .iff resp .goto CPKTAS
;
; CPKTAS - convert packed decimal to ascii
;
; Test program requires no input, and the display can 
; be SCROLLED/NOSCROLLED as desired.  Uses the string package 
; routines.
;
run tstcpktas
;
.CPKTAS:


.ift onejob .if onenam ne "TSTCASTRE" .goto CASTRE
.ift askjob .ask resp run CASTRE UETP (TSTCASTRE)
.ift askjob .iff resp .goto CASTRE
;
; CASTRE - convert ascii to real number
;
; Test program runs a standard suite, then lets you enter strings as
; desired, press <RETURN> to skip string entry when asked.  The display
; can be SCROLLED/NOSCROLLED as desired.
;
run tstcastre
;
.CASTRE:


.ift onejob .if onenam ne "TSTCRETAS" .goto CRETAS
.ift askjob .ask resp run CRETAS UETP (TSTCRETAS)
.ift askjob .iff resp .goto CRETAS
;
; CRETAS - convert real number to ascii 
;
; Test program runs a standard suite, then lets you enter numbers as
; desired, press <RETURN> to skip string entry when asked.  The display
; can be SCROLLED/NOSCROLLED as desired.
;
run tstCRETAS
;
.CRETAS:


.ift onejob .if onenam ne "TSTCNCT" .goto CNCT
.ift askjob .ask resp run CNCT UETP (TSTCNCT)
.ift askjob .iff resp .goto CNCT
;
; CNCT - CNCT$ connect directive
;
; Test program requires no input.  Timing is critical, so do not
; stop display with SCROLL/NOSCROLL.  Uses CATR56 procedure.
;
.ifins run1 rem run1
.ifins run12 rem run12
.ifins run4 rem run4
;
; First run should connect and see exit status of 1
.xqt 'clipre'run run1/task:run1
.delay 2s
'clipre'run tstcnct/comm:"RUN1"
;
; Second run should connect and see exit status of 12
.xqt 'clipre'run run12/task:run12
.delay 2s
'clipre'run tstcnct/comm:"RUN12"
;
; Third run should connect and see exit status of 4 after run4 odd address trap
.xqt 'clipre'run run4/task:run4
.delay 2s
'clipre'run tstcnct/comm:"RUN4"
;
'clipre'ins run1/task:run1
; Fourth run should fail to connect, returning DSW of -7 (task not active)
'clipre'run tstcnct/comm:"RUN1"
rem run1
;
; Last run should fail to connect, returning DSW of -2 (task is a CLI/not ins)
'clipre'run tstcnct/comm:"RUN1"
;
.CNCT:


.ift onejob .if onenam ne "TSTSPAWN" .goto SPAWN
.ift askjob .ask resp run SPAWN UETP (TSTSPAWN)
.ift askjob .iff resp .goto SPAWN
;
; SPAWN - SPWN$ spawn directive
;
; Test program requires no input.  Timing is critical, so do not
; stop display with SCROLL/NOSCROLL.  Uses CATR56 procedure.
;
.ifnins run1 ins run1
.ifnins run12 ins run12
.ifnins run4 ins run4
;
; First spawn should see exit status of 1
'clipre'run tstspawn/comm:"RUN1"
;
; Second spawn should see exit status of 12
'clipre'run tstspawn/comm:"RUN12"
;
; Third spawn should see exit status of 4 after run4 odd address trap
'clipre'run tstspawn/comm:"RUN4"
;
rem run1
; Fourth run should fail to spawn, returning DSW of -2 (task installed)
'clipre'run tstspawn/comm:"RUN1"
;
; Fifth run should fail to spawn, returning DSW of -7 (task already active)
.xqt 'clipre'run run12
.delay 2s
'clipre'run tstspawn/comm:"RUN12"
;
.delay 12s
rem run12
rem run4
;
.SPAWN:


.ift onejob .if onenam ne "TSTRPOI" .goto RPOI
.ift askjob .ask resp run RPOI UETP (TSTRPOI)
.ift askjob .iff resp .goto RPOI
;
; RPOI - RPOI$ run and pass offspring info directive
;
; Test program requires no input.  Timing is critical, so do not
; stop display with SCROLL/NOSCROLL.  Uses CATR56 and SPAWN procedure.
;
.ifins rpoi1 rem rpoi1
.ifins rpoi2 rem rpoi2
.ifnins run1 ins run1
.ifnins run12 ins run12
.ifnins run4 ins run4
;
; TSTSPAWN should see RUN1 exit status of 1 after going through RPOI1 and 2
ins tstrpoi/task=rpoi1
ins tstrpoi/task=rpoi2
'clipre'run tstspawn/comm:"RPOI1  RPOI2  RUN1"
;
; TSTSPAWN should see RUN12 exit status of 12 after going through RPOI1 and 2
'clipre'run tstspawn/comm:"RPOI1  RPOI2  RUN12"
;
; TSTSPAWN should see RUN4 exit status of 4 after going through RPOI1 and 2
; Third spawn should see exit status of 4 after run4 odd address trap
'clipre'run tstspawn/comm:"RPOI1  RPOI2  RUN4"
;
rem run12
; Fourth run should see RPOI2 exit status of 1 after it fails to RPOI
; RUN12 which is not installed.  RPOI2 should show a DSW of -2 (task not 
; installed)
'clipre'run tstspawn/comm:"RPOI1  RPOI2  RUN12"
;
; Fifth run should see RPOI2 exit status of 1 after it fails to RPOI
; RUN11 which is already active.  RPOI2 should show a DSW of -7 (task 
; already active).
.xqt 'clipre'run run1
.delay 2s
'clipre'run tstspawn/comm:"RPOI1  RPOI2  RUN1"
;
.delay 12s
rem run1
rem run4
rem rpoi1
rem rpoi2
;
.RPOI:

;
;
; RUN OF P3UTIL UETP is complete.
;
;
