PROGRAM SSend;
{ Intertask send data for the String package.

Version: 3.2
File:[22,310]SSEND.PAS

Last edit: 23-JUN-1988 22:30:56 

History: 13-Apr-88.  Philip Hannay.  Created.
	 23-JUN-1988 21:59:24  - JMB PA3UTL upgrade.

}

{$NOMAIN}
{[A+,B+,L-,K+,R+] Pasmat Directive}

%include PAS$EXT:General.typ;

%include PAS$EXT:slen.ext;
%include PAS$EXT:svassign.ext;

%include PAS$EXT:vsda.ext;
%include PAS$EXT:catr56.ext;


procedure SSend(var dest: packed array [dlow..dhigh: integer] of char;
                var message: packed array [mlow..mhigh: integer] of char;
                var send_status: integer
  	);External;

{*USER*
 Send a MESSAGE to the task at DEST.  $DSW from variable send directive is
 returned in SEND_STATUS. }

Procedure SSend;

type
  Packet_allocation_block = record
    rad56_task: rad56;
    message: packed array [1..512] of char;  { not a type1 string however }
    end;    

var
  PAB: Packet_allocation_block;
  bufadr: address;
  PABpos, i, len: integer;
  task: ch6;

  begin {send string}
  len:= slen(message);
  for i:= 1 to len do pab.message[i]:= message[i];
  if len mod 2 <> 0 
    then begin
      { if odd length, pad with extra blank }
      len:= len+1;
      pab.message[len]:= ' ';
      end;
  { if less than 26 bytes, pad up to 26 with blanks for readability if
    received by RCVD. }
  if len < 26 then for i:= len + 1 to 26 do pab.message[i]:= ' ';
  bufadr:= loophole(address, ref(pab.message));
  svassign(task,dest);
  catr56(task,pab.rad56_task);
  { convert len to words }
  len:= len div 2;
  VSDA(PAB.rad56_task,bufadr,len,f0);
  send_status:= $DSW;
  end { send string } ;

