Program CASTBC;
{$nomain}

{ 
  Version
  File:[22,310]CASTBC.PAS
  Author: Jim Bostwick 18-Oct-83

  Last Edit: 23-JUN-1988 22:05:20 

  History: JBM 16-Nov-83 -- correct digit order
	 23-JUN-1988 21:55:27  - JMB PA3UTL upgrade.
           RAB 02-Aug-85 -- correct problem of empty ASCII string causing 
                            array subscript problems and enabled range 
                            checking on BCD array to prevent overflow.

}
{$Nolist}
{[a+,b+,l-,k+,r+] Pasmat }
 %INCLUDE 'PAS$EXT:General.typ';
 %INCLUDE 'PAS$EXT:BCD.TYP';
{$List }


{--------------- Convert ASCII array to BCD ---------------------}

Procedure CASTBC( asc: Packed array [lo..hi:integer] of char;
  		 Var B: packed array [LOBC..HIBC:integer] of BCD_Digit;
  		 VAR pos: Integer
  	);External;

{*USER*
 Convert ascii array to bcd. Pos = start position in ascii string.
Pos points to end of string, or terminating character on exit.
Conversion proceeds until a non-bcd character is encountered.
Leading spaces and tabs are skipped. The output string is leading
zero filled. 
}

Procedure CASTBC;

Var
  start, span, endpos: integer;
  limit, i: integer;

BEGIN
  if lo = 1 then limit := hi else limit := ord(asc[0]);

  { establish start position, endposition }	

  start := pos;
  if NOT(asc[pos] in ['0'..'9']) then  
      repeat
	start := start + 1
      until (start = limit) or (asc[start] in ['0'..'9']);
  endpos := start;
  while (endpos < limit) and (asc[endpos] in ['0'..'9'])
    do endpos := endpos + 1;
  pos := endpos;
  if (NOT(asc[endpos] in ['0'..'9'])) AND (endpos > lo)
    then endpos := endpos - 1;
 
  i := lobc;
  if endpos >= start then
      { fill bcd backwards from endpos }
    repeat
      b[i] := (ord(asc[endpos]) - ord('0'));
      endpos := endpos-1;
      i := i + 1;
    until (endpos < start) or (i > hibc);
  if i < hibc then for i := i to hibc do b[i] := 0
  END;
