PROGRAM CKDTAD;
{$nomain}
{$nowalkback}

{ File: [22,310]CKDTAD.PAS       Last Edit: 8-DEC-1988 16:14:21 

  History:  8-Dec-88.  Philip Hannay.  Created.
}


%include lb:[22,320]general3.typ;
%include ex:[22,320]d2clnk.ext;

Procedure CADTKD( var A_date:PACKED ARRAY[Lo..Hi:integer] OF char;
		                 { 9 char DEC style date DD-MMM-YY }
                  var K_date: clunk_type      { 64bit clunk date/time }
                ); external;


{*USER*

.hl 2 CADTKD - Convert Ascii Date/Time stamp to Clunk Date

The CADTKD routine will convert an ascii date/time stamp.  A variable length
string will be accepted in the format (DD-MMM-YYYYbHH:MM:SS).  It will
be converted to a 64bit CLUNK style date and returned in K_date.  The
string must be at least 9 characters (the date).  Beyond that, defaults 
will be supplied for hours, minutes and seconds if not supplied.  Those
defaults will be the value of zero (0 hours, 0 minutes, 0 seconds).

The first 20 characters of the string will be evaluated, and if more 
characters are in the string beyond the first 20, they will be ignored.
Thus the date/time stamp could be the first field in a longer string.

An invalid date or time will result in a clunk time of zero.  Remember,
you must check all four words of the 64bit clunk time to check for zero.
}

{*TECH*

Upper and lower case months will be accepted.

Years will be the four digit year.

The ascii date variable A_date will conform to either type 0 or type 1
Cargill/Pascal-2 string conventions depending on how it was specified in 
the calling routine.  

}

PROCEDURE CADTKD;

Var
 ascii_date: DEC_date;
 ascii_time: DEC_time;
 status: integer; 

Begin
len:= slen(
c2date(C_date,ascii_date,ascii_time,status);
sappend(A_date,ascii_date);
schconcat(A_date,' ');
sappend(A_date,ascii_time);
end;

