.; FILE:  LB:[11,44]BUILDLBR.CMD      LAST EDIT: 19-JUN-1989 15:30:48 
.;
.; HISTORY:  CREATED  21-SEP-82  PHIL HANNAY
.;
.;           MOVED TO LB:[11,44] FROM LB:[22,10]  11-JAN-83  PHIL HANNAY
.;
.;           Revised to use Pascal 2.1   19-Oct-83  Phil Hannay
.;
.;	     JMB 2-DEC-83 -- reference proper PASMAC for Pascal 2.1
.;
.;           Add recognition of FTN files  25-Sep-85  Phil Hannay
.;
.;           5-May-86.  Philip Hannay.  Changed input parameters.
.;           Listings are saved only when an error occurs.  There is no
.;           longer an option to spool listings, so parameters 2 and
.;           3 have been eliminated.  SRC files that generate a
.;           PAS file are assumed to be PA1 files and are built as such.
.;           OBJ files are always deleted after LBR input.  Also
.;           added an exit status to confirm that library built okay
.;           and opened the log file append so that others may use it too.
.;
.;           22-Sep-86.  Philip Hannay.  Added code to run under DCL.
.;
.;           19-Jan-87.  Glenn Wondra.  Revised to continue on compile
.;           warnings.
.;
.;           24-Jan-87.  Philip Hannay.  Modified extention tests to look
.;           for both upper and lower case types (PAS and pas).  It still
.;           will not accept mixed case (Pas).  
.;
.;           21-Jul-87.  Philip Hannay.  Added HELP function recognizing
.;           "?" and "/HE" as help requests
.;
.;           21-Aug-87.  Philip Hannay.  Added test for assembler command file
.;             srcfilename.ASM when doing a macro assembly.  If found, we use
.;             the ASM file to do the assembly.  Also updated to look
.;             for named default directory in <direct> rather than in <uic>
.;             if used is building in NAMED environment.  Added ONERR 
.;             processing to insure that log file is closed (and not locked),
.;             and CLI is restored on fatal indirect processing error.
.;
.;           16-Nov-87.  Philip Hannay.  Ignore lines beginning with "&" as
.;             comment lines.  These are used by PRINTSRC to signal additional
.;             files (usually include file) to print.
.;
.;           16-May-88.  Philip Hannay.  Changed PA3 default to ERROR from
.;             LIST to shorten LST file.  Did away with purge of source files
.;             including .ASM and .MOD files, leaving it up to the programmer
.;             to decide when to purge.
.;	
.;	     9-Nov-88. Bob Thomas. Modified to allow for appending a /DEBUG
.;	       switch to either the modfile name (resulting in all of the 
.;	       fortran modules being compiled with the /DE switch) or the   
.;	       individual file names in the mod file (resulting in just those
.;	       files with the /DEBUG switch being so compiled).
.;
.;           19-Jun-89.  Philip Hannay.  Added /DOUBLE switch to PA3
.;             (PASCAL 2.1) compiles as we now use double precision
.;             throughout the land.
.;
.; GENERIC LIBRARY BUILD PROCEDURE
.;
.ENABLE SUBSTITUTION
.;
.; See if help requested

.if p1 eq "?" .goto help
.if p1 eq "/HE" .goto help
.goto nohelp

.help:
;
; The BUILDLBR command file will compile/assemble specified modules, and 
; insert (replace) them into an existing library. Object modules are optionally 
; deleted following insertion. Listings are optionally generated in wide 
; or narrow format, and printed. If generated, listings are deleted following 
; printing.
;
; A modulator file name.MOD file is specified by the user and will contain 
; the library name where modules are inserted, and the module sources 
; (SRC, PAS, FTN, or MAC) to be inserted.  The syntax of the MOD file
; consists of a one line library name (without the .OLB), and a multiline
; list of module names (one per line) with the appropriate extenstion
; (like .PAS or .FTN).  Any line beginning with a ";" is a comment line.
; Any line consisting of just a <CR> is ignored.  A line beginning
; with a "%" is used by BUILDEXT.CMD for creating include files for
; Pascal, and ignored by BUILDLBR.  A line beginning with a "&" is used by
; PRINTSRC.CMD to indicate additional files to be printed (usually include
; files), and ignored by BUILDLBR.
;
; A sample MOD file
;    ;
;    ;  SAMPLE MOD FILE - comment line
;    ;  another comment line
;    ;  the next line is just a carriage return with not text, so its ignored
;    ;
;    ;  the following line is the library name (optional device, directory)
;    TB:[115,305]PHIL
;    ;  above line indicates we will deal with existing library 
;    ;  PHIL.OLB in TB:[115,305]
;    ;
;    ;  Now the sources to be compiled and replaced (put) in PHIL.OLB
;    ;
;    ; Main program
;    BIGJOB.PAS
;    ;
;    ; Subroutine to add two numbers
;    ADD.MAC
;    ;
;    ; Subroutine to open file, write results
;    FILWRT.FTN
;    ;
;    ; Subroutine to initialize variables
;    INIT.PAS
;    ;
;    ; end of MOD file
;
;
; There are three different ways of invoking BUILDLBR.  INTERACTIVE mode
; asks any needed questions before proceeding, SUPPRESSED INPUT mode
; uses parameters supplied at invocation to answer any questions, and
; REMOTE mode is the same as SUPPRESSED INPUT mode, but will notify another
; terminal with BROadcast of its progress.
;
; INTERACTIVE mode is for hands on operation.  It requires an operator
; present and limits your terminal access.
;
; SUPPRESSED INPUT mode allows another command file to supply anwers to
; BUILDLBR as it invokes it, thus eliminating the need for an operator
; to be present.  Your terminal access is still limited.
;
; REMOTE mode allows another command file to supply answers to BUILDLBR
; as it invokes it so an operator does not need to be present.  In addition,
; it lets you run the command file on another terminal (TT or VT - BATCH),
; with notifications to your terminal of errors or when the job is complete.
; This keeps you terminal free for other work.
;
; IN MORE DETAIL:
;
; SUPPRESSED INPUT MODE:
; This file may be called from another command file or buffer stuffer
; using the parameters to initialize certain variables.  This will
; eliminate the need to query the operator for this information.
; This is useful when this command file is called by another command
; file that will be take two hours doing other work before getting
; around to calling this one.  Thus the operator can take a nap and
; not have to wait around to answer the questions the variables 
; need initialization.
;
; REMOTE MODE:
; This file may be run from a different terminal, if you have 
; access to a buffer stuffer. When this is done, the command
; file does no interaction with its TI: (which you can't readily
; get at). Instead, BRO is used to notify the specified terminal
; of errors and completion. 
;
; For either mode, use the following command line.  Leave out <eti>
; for SUPPRESSED INPUT mode, and specify <eti> for REMOTE mode.
; The <modfil> parameter must be specified, while the others are
; optional, and default values will be used.  Note that there can be
; no ommissions between specified parameters, even if the default is
; desired for that parameter in between.  Ommissions can only occur
; when no further specified parameters follow.
;
; Invoke with commandline @BUILDLBR <modfil> <esw> <eti>.
;
; <modfil> = dev:[uic]modfilename  (p1) 
;    This is the .MOD (text) file name.  The device, uic and name of the file
;    is specified (normal file spec defaults apply).  Do not specify the
;    extention or version.  This command file will append the .MOD extention
;    and the latest version will be used.  The .MOD file will contain the name
;    of the library, into which insertion will occur, in the first line.
;    The library extention or version should not be specified, only
;    device, uic, and name, with normal file spec defaults valid.
;    The library name may have a /DEBUG switch appended to it. If it
;    does then all fortran modules will be compiled with the /DE switch.
;    The second line and onward will contain the names of the source
;    modules to be compiled (assembled) and inserted into the library.
;    The extention MUST be specifed.  Normal file spec defaults apply.
;    The individual source module names may also have the /DEBUG switch
;    appended, which results in the individual modules so designated
;    being compiled with the /DE switch (for Fortran modules only).
;
;    The modfile name itself can have a /DEBUG switch appended to it. If it 
;    does this also results in all the Fortran modules being compiled with 
;    the /DE switch. ( <modfile>/DEBUG )
;
; <esw> = error control switch   (P2)
;	Xn = terminate after n errors  (default and n=1)  Specify n
;            as a 1 or 2 digit number (thus 1 thru 99) with no
;            space between it and the letter X.  Execution will
;            continue until n errors have occurred.  If n is not
;            specified, or a non-numeric string used, n will
;            default to 1.
;            
;	C = continue on errors
;	any other letter = notify and pause (type UNS ...at. or
;	       UNS ATTxx at YOUR terminal to resume).
;
; <eti> = effective ti   (P3 - remote mode only) (no default as that
;          would mean suppress input mode and not remote mode)
;	TTx: = this required switch specifies the tt: to receive 
;	       nofitication of errors and completion.
;
;
;  A log file is maintained to allow you to go back and see what occurred
;  and when it occurred.  The log file will have the same name as the
;  MOD file (ie. modfilename.LOG).  It will contain starting and ending
;  times, and status of compilation and insertion into the library.  The
;  log file will be appended to if one already exists so that older build
;  info will be retained.
;
;  Files will be purged and deleted as possible to minimize storage
;  space needed.  No purges or deletes will be done, until a successful
;  operation occurs.  If a compile error or warning occurs, the files
;  resulting will be left behind (including the list file) allowing you
;  to diagnose the error more completely.
;
; This above HELP text is displayed in response to a "?" or "/HE" value
; used as the first parameter to BUILDLBR (ie. "@BUILDLBR ?").
;
.goto 990

.nohelp:

.; See if we are running in DCL
.;
.sets curcli <cli>
.if curcli ne "MCR" mcr set /cli=ti:mcr
.;

.setf badend
.; Badend will signal if an error occurred so that we can exit with the
.; appropriate error status, in case we are being called by another
.; indirect command file.
.;
.setf fatend
.; Fatend will signal if a fatal error (detected by .onerr) has occurred.
.;
.onerr 910
.; If a fatal indirect error detected, go to 910 for cleanup


.DISABLE QUIET
.SETS ESW ""
.SETS ETI ""
.SETF REMOTE
.SETF NOINPT
.SETF ERRX
.SETF ERRC
.SETF ERRP
.SETS ANUM "0123456789"
.SETN ERRNUM 0
.SETN ERRMAX 1
.;
.TEST P1
.IF <STRLEN> EQ 0 .GOTO NOREM
.SETS MODNAM P1
.; Invoked with parameters, may be remote, or suppressed input mode
.;
.; Determine the error option 'P2'
.SETS TST "X"
.SETS TST1 P2[1:1]
.IF TST1 NE TST .GOTO 1
.SETT ERRX
.TEST P2
.IF <STRLEN> LT 2 .GOTO 1
.IF <STRLEN> GT 3 .GOTO 1
.IF <STRLEN> EQ 3 .GOTO TWODGT
.;
.SETS TST1 P2[2:2]
.GOSUB NUMOUT
.IF COUNT NE 0 .DEC COUNT
.SETN ERRMAX COUNT
.IF ERRMAX LT 1 .SETN ERRMAX 1
.GOTO 1
.;
.TWODGT:
.SETS TST1 P2[2:2]
.GOSUB NUMOUT
.IF COUNT NE 0 .DEC COUNT
.SETN TCOUNT COUNT
.SETS TST1 P2[3:3]
.GOSUB NUMOUT
.IF COUNT NE 0 .DEC COUNT
.SETN ERRMAX TCOUNT*10.+COUNT
.IF ERRMAX LT 1 .SETN ERRMAX 1
.GOTO 1
.;
.;
.; SUBROUTINE NUMOUT:
.;
.NUMOUT:
.SETN COUNT 1
.LPNEXT:
.IF TST1 EQ ANUM[COUNT:COUNT] .RETURN
.INC COUNT
.IF COUNT LT 11 .GOTO LPNEXT
.SETN COUNT 0
.RETURN
.;
.; END SUBROUTINE
.;
.;
.1:
.SETS TST "C"
.IF P2 EQ TST .SETT ERRC
.SETS TST "P"
.IF P2 EQ TST .SETT ERRP
.IFF ERRC .IFF ERRP .SETT ERRX
.;
.; Determine effective TI: 'P3'
.TEST P3
.IF <STRLEN> NE 0 .GOTO SETRMT
.; just mod name supplied, not remote but suppressed input mode
.SETT NOINPT
.GOTO NOREM
.;
.SETRMT:
.ENABLE QUIET
.SETT REMOTE
.SETS ETI P3
.SETS TST "T"
.SETS TST1 ETI[1:1]
.IF TST NE TST1 .SETT FATEND
.IF TST NE TST1 .GOTO 900
.;We must have an EDI to work with.
.; now skip the interactive questions....
.GOTO START:
.;
.;
.NOREM:
;
; Library build begun '<DATE>' at '<TIME>'
;
;
.IFT NOINPT .GOTO START
;
;
; Interactive mode - no parameters supplied with @BUILDLBR
;
; Enter the name of the MOD file that contains the information needed to
; rebuild the library.  The mod file name.MOD will contain the name of
; the library to rebuild and the source modules to replace in that library.
; If an empty library file needs to be created, or the existing library
; file compressed before replaces, exit now (CTRL-Z) at this question
; and get the library file ready.
;
.ASKS MODNAM Enter name of MOD file (1 to 9 char, no .MOD)
;
;
.START:
.;
.; First we will parse the modname to identify any switches appended to it.
.Parse MODNAM "/" MODNAM SWITCH
.setf DEBUG1
.IF SWITCH EQ "DEBUG" .SETT DEBUG1
.IF SWITCH EQ "Debug" .SETT DEBUG1
.IF SWITCH EQ "debug" .SETT DEBUG1
.;
.; Common configuration completion.
.; if REMOTE, tell him we got this far
.IFT REMOTE BRO 'ETI' @BUILDLBR for 'MODNAM' begun at '<DATE>' '<TIME>'.
.; Open the module filespec list.
.TESTFILE 'MODNAM'.MOD
.IF <FILERR> EQ 1 .GOTO 8
.IFF REMOTE ; File 'MODNAM'.MOD could not be opened. 
.IFT REMOTE BRO 'ETI' File 'MODNAM'.MOD could not be opened. 
.SETT FATEND
.GOTO SHUTUP
.8:
.OPENR #3 'MODNAM'.MOD
.7:
.READ #3 LIBNAM
.;
.; Now we will parse the Libnam to identify any switches appended to it.
.Parse LIBNAM "/" LIBNAM SWITCH
.setf DEBUG2
.IF SWITCH EQ "DEBUG" .SETT DEBUG2
.IF SWITCH EQ "Debug" .SETT DEBUG2
.IF SWITCH EQ "debug" .SETT DEBUG2
.;
.IFT <EOF> .SETT FATEND
.IFT <EOF> .GOTO ABORT
.TEST LIBNAM
.IF <STRLEN> EQ 0 .GOTO 7
.SETS SIGN LIBNAM[1:1]
.IF SIGN EQ ";" .GOTO 7
.IF SIGN EQ "%" .GOTO 7
.IF SIGN EQ "&" .GOTO 7
.IF SIGN EQ " " .GOTO 7
.TESTFILE 'LIBNAM'.OLB
.IF <FILERR> EQ 1 .GOTO 9
.IFF REMOTE ; Library file 'LIBNAM' could not be found. 
.IFT REMOTE BRO 'ETI' Library file 'LIBNAM' could not be found.
.SETT FATEND
.GOTO ABORT
.9:
.; Open a log file
.OPENA #1 'MODNAM'.LOG
.DATA #1   'LIBNAM' library rebuild begun '<DATE>' '<TIME>'
.DATA #1   The following modules were inserted in 'MODNAM'.OLB:
.;
.; Get next filespec.
.10: 
.READ #3 FSPEC
.IFT <EOF> .GOTO FINISH
.11:
.TEST FSPEC
.IF <STRLEN> EQ 0 .GOTO 10
.SETS SIGN FSPEC[1:1]
.IF SIGN EQ ";" .GOTO 10
.IF SIGN EQ "%" .GOTO 10
.IF SIGN EQ "&" .GOTO 10
.IF SIGN EQ " " .GOTO 10
.;
.; Parse the filespec to see if a /DEBUG switch is appended
.PARSE FSPEC "/" FSPEC SWITCH
.SETF DEBUG3
.IF SWITCH EQ "DEBUG" .SETT DEBUG3
.IF SWITCH EQ "Debug" .SETT DEBUG3
.IF SWITCH EQ "debug" .SETT DEBUG3
.;
.; Parse filespec to determine extension.
.PARSE FSPEC ".;" FNAM EXT VER
.;
.; Check if there was a /DEBUG switch on either the MODFILE, LIBNAM or FSPEC
.SETF DEBUG
.IFT DEBUG1 .or .IFT DEBUG2 .or .IFT DEBUG3 .SETT DEBUG 
.;
.badext:
.;
.IFF REMOTE ;
.IFF REMOTE ;   ---------<<< 'FNAM' >>>----------
.IFF REMOTE ;
.IF EXT EQ "MAC" .GOTO DOMAC
.IF EXT EQ "mac" .GOTO DOMAC
.IF EXT EQ "SRC" .GOTO DOSLP
.IF EXT EQ "src" .GOTO DOSLP
.IF EXT EQ "PAS" .GOTO DOPAS
.IF EXT EQ "pas" .GOTO DOPAS
.IF EXT EQ "FTN" .GOTO DOFOR
.IF EXT EQ "ftn" .GOTO DOFOR
.DATA #1     <Illegal Filespec <'FSPEC'> -- skipped.>
.IFF REMOTE ;Illegal Filespec <'FSPEC'> -- skipped.
.IFT REMOTE BRO 'ETI' Illegal Filespec <'FSPEC'> -- skipped.
.GOTO 10
.;
.DOSLP:
.TESTFILE 'FSPEC'
.SETS CURJOB "SRC file search"
.IF <FILERR> NE 1 .GOTO FUBAR
.OPENR #2 'FSPEC'
.READ #2 OUTFIL
.SETS CURJOB "SRC output name"
.IFT <EOF> .GOTO FUBAR
.CLOSE #2
.PARSE OUTFIL "." TST TST1
.SETS EXT TST1[1:3]
.IF EXT EQ "PAS" .GOTO SLPGO
.IF EXT EQ "pas" .GOTO SLPGO
.IF EXT EQ "MAC" .GOTO SLPGO
.IF EXT EQ "mac" .GOTO SLPGO
.DATA #1     <Illegal Filespec in SLP file <'FSPEC'> -- skipped.>
.IFF REMOTE ;Illegal Filespec in SLP file <'FSPEC'> -- skipped.
.IFT REMOTE BRO 'ETI' Illegal Filespec in SLP file <'FSPEC'> -- skipped.
.;
.SLPGO:
SLP @'FSPEC'
.SETS CURJOB "SLP utility"
.IF <EXSTAT> NE 1 .GOTO FUBAR
.IF EXT EQ "PAS" .GOTO DOPA1
.IF EXT EQ "pas" .GOTO DOPA1
.IF EXT EQ "MAC" .GOTO DOMAC
.IF EXT EQ "mac" .GOTO DOMAC
.;
.DOPA1:
.SETS CURJOB "PA1 compiler"
PA1 'FNAM','FNAM'='FNAM'/S
.IF <EXSTAT> NE 1 .GOTO FUBAR
.SETS CURJOB "MAC assemblor"
PIP 'FNAM'.PAS;*,.LST;*/DE
MAC 'FNAM','FNAM'/-SP='FNAM'
.IF <EXSTAT> NE 1 .GOTO FUBAR
PIP 'FNAM'.MAC;*,.LST;*/DE
.GOTO PUTLIB
.;
.DOPAS:
PA3 'FNAM'/ERROR/NOWALKBACK/DOUBLE
.SETS CURJOB "PA3 compiler"
.IF <EXSTAT> NE 1 .GOTO FUBAR
PIP 'FNAM'.LST;*/DE
.GOTO PUTLIB
.;
.DOFOR:
.IFF DEBUG FOR 'FNAM','FNAM'/-SP='FNAM'
.IFT DEBUG FOR 'FNAM','FNAM'/-SP='FNAM'/DE
.SETS CURJOB "FOR compiler"
.IF <EXSTAT> EQ 0 .GOTO WARN
.IF <EXSTAT> NE 1 .GOTO FUBAR
PIP 'FNAM'.LST;*/DE
.GOTO PUTLIB

.DOMAC:
.;
.; Determine what device/ufd prefix to use.  Since we may need Pasmac from
.; the library to precede the marco source, we must explicitly state
.; the device and ufd.  The question is whether it has already been 
.; stated in the input file (FNAM) or whether we must create it here.
.SETS DUM1 ""
.SETS DUM2 ""
.SETS DUM3 ""
.SETS DUM4 ""
.SETS PREFIX ""
.PARSE FNAM "]" DUM1 DUM2
.PARSE FNAM ":" DUM3 DUM4
.IF DUM2 EQ "" .GOTO 30
.IF DUM4 EQ "" .SETS PREFIX "SY:"
.GOTO 31
.30:
.; The default UIC is either in <DIRECT> (named) or <UIC> (nonamed).
.; We must first check <DIRECT> and if null ([]), then use <UIC>.
.sets defuic <DIRECT>
.if defuic eq "[]" .sets defuic <UIC>
.if dum4 eq "" .sets prefix "SY:"+defuic
.if dum4 eq "" .goto 31
.sets fnam dum3+":"+defuic+dum4
.31:
.;
.; First off, see if a 'FNAM'.ASM file exists.  The ASM file will have
.; special macro assembly instructions if need be.
.TESTFILE 'FNAM'.ASM
.IF <FILERR> NE 1 .GOTO 33
MAC @'FNAM'.ASM
.SETS CURJOB "MAC assembler using 'FNAM'.ASM"
.IF <EXSTAT> NE 1 .GOTO FUBAR
PIP 'FNAM'.LST;*/DE/NM
.GOTO PUTLIB
.;
.33:
.; See if PASMAC macro defn file exists on system.  If so, precede the
.; MAC source with the PASMAC file.
.SETS PREFIL ""
.TESTFILE LB:[22,310]PASMAC.MAC
.IF <FILERR> NE 1 .GOTO 32
.SETS PREFIL "LB:[22,310]PASMAC,"
.32:
.;
MAC 'FNAM','FNAM'/-SP='PREFIL''PREFIX''FNAM'
.SETS CURJOB "MAC assembler"
.IF <EXSTAT> NE 1 .GOTO FUBAR
PIP 'FNAM'.LST;*/DE
.GOTO PUTLIB
.;
.WARN:
.; Warning encountered, log it and continue on.
.;
.DATA #1     <'FNAM'.'EXT';'VER' note  -- warning in 'CURJOB'>
.IFF REMOTE ; Warning -- <'FSPEC'> (in 'CURJOB') -- module still updated.
.IFT REMOTE BRO 'ETI'  Warning -- <'FSPEC'> (in 'CURJOB') -- module updated.
.GOTO PUTLIB
.;
.PUTLIB:
LBR 'LIBNAM'/RP='FNAM'
.SETS CURJOB "LBR insert"
.IF <EXSTAT> NE 1 .GOTO FUBAR
PIP 'FNAM'.OBJ;*/DE
.IF VER EQ "" .DATA #1     'FNAM'.'EXT'
.IF VER NE "" .DATA #1     'FNAM'.'EXT';'VER'
.GOTO 10
.;
.FUBAR:
.; Error encountered, set BADEND true to signal that we had some trouble.  We
.; continue on though.  If we are not in remote or no input mode, then we can
.; ask directly for what to do.
.;
.SETT BADEND
PIP 'FNAM'.OBJ;*/DE/NM
.DATA #1     <'FNAM'.'EXT';'VER' skipped -- error in 'CURJOB'>
.IFF REMOTE ; Error in <'FSPEC'> (in 'CURJOB') -- module not updated.
.IFT REMOTE BRO 'ETI'  Error in <'FSPEC'> (in 'CURJOB') -- module not updated.
.IFT REMOTE .GOTO 15
.IFT NOINPT .GOTO 15
.ASKS GOON Enter C to continue, P to pause, X to exit
.IF GOON EQ "C" .GOTO 10
.IF GOON EQ "P" .PAUSE
.IF GOON NE "X" .GOTO 10
.SETT FATEND
.GOTO FINISH
.;
.15:
.IFT ERRX .GOTO 16
.IFT ERRC .GOTO 10
.;ERRP MUST BE TRUE
.IFT REMOTE BRO 'ETI' PAUSING TYPE UNS ..XXXX TO CONTINUE
.PAUSE
.;
.16:
.INC ERRNUM
.IF ERRNUM LT ERRMAX .GOTO 10
;
; Exiting command file prematurely after 'ERRMAX' error(s).
;
.IFT REMOTE BRO 'ETI' EXITING AFTER 'ERRMAX' ERROR(S).
.DATA #1     <Exiting command file prematurely after 'ERRMAX' error(s).>
.SETT FATEND
.GOTO FINISH
.;
.FINISH:
.DATA #1   Finished library build '<DATE>' '<TIME>'
.DATA #1    
.CLOSE #1
.ABORT:
.CLOSE #3
.SHUTUP:
.IFF REMOTE ; Operation complete
.IFT REMOTE BRO 'ETI' @BUILDLBR for 'MODNAM' complete at '<DATE>' '<TIME>'.

.900:
.goto 950

.910:
.; fatal error trap - attempt to close log file if open (to prevent it
.; from being locked, and reset CLI
;
; Exiting abnormally - fatal indirect error - to see message, comment
; out ".onerr 910" line
;
.onerr 950
.sett fatend
.close
.goto 950

.950:
.; If BADEND is true, we had some sort of non-fatal error, we exit 
.; with a 2, indicating a partial failure (warning).  If we had a 
.; fatal error, FATEND will be true, and we will exit with a 4, 
.; indicating a fatal error.
.;
.; Set back CLI to starting CLI if it was not MCR
.;
.if curcli ne "MCR" set /cli=ti:'curcli'
.;
.ift fatend .exit 4
.ift badend .exit 2

.990:
.EXIT 1
