{ File: [22,320]SF.TYP      Last edit: 4-MAY-1989 16:59:43 

  Terminal characteristics type definitions for use with SF.GMC/SF.SMC
  QIOs.  

  History:
  
     4-May-89.  Philip Hannay.  Created.


*USER*

The SF.GMC (Special Function - Get Multiple Characteristics) and
the SF.SMC (Special Function - Set Multiple Characteristics) are
QIOs that can be used to query the system about the current
setup of a terminal driver port.

Each characteristics is assigned a one byte id code, and in most
cases, a one byte status/command.  An array of these two byte
structures (records) can referenced in the QIO, and the terminal
driver will fill in the current status for each id code (SF.GMC)
or will use the command value for each id code to set the
specified terminal characteristic (SF.SMC).

Some id codes can be used only in one type of call as it makes no
sense in the other call.  For example, TC_QDP, the lat queue depth
can only be retrieved (GMC) and not commanded (SMC).


}


Type

  { TERMINAL_CHARACTERISTIC_TYPE is the scaler types for all DEC
    defined symbols, where an underbar "_" replaces the period "."
    in the DEC name.  Two added names TC_NULL and TC_LAST represent
    types that we have added to allow us to reference the beginning
    and the end of the list (for array defs, FOR loops, etc).  Symbols
    that are not defined by DEC, are represented by place holders using
    the octal number as there name.   See section 2.4.15 in the Full
    Duplex Terminal Driver chapter of the I/O Drivers Reference Manual
    for more info.  Also, the SET command descriptions in the MCR or DCL
    manuals have more detailed descriptions of the characteristics. }

  Terminal_characteristic_type = (
 
    { symbol } { octal }   { short description }

    TC_NULL,   { 000   - not defined by DEC }
    TC_WID,    { 001   - BUF (WIDTH), 0-255 }
    TC_LPP,    { 002   - LINES (0-255) per page }
    TC_RSP,    { 003   - SPEED (receive), see speed codes }
    TC_XSP,    { 004   - SPEED (transmit), see speed codes }
    TC_005,    { 005   - unassigned by DEC }
    TC_ISL,    { 006   - MUX subline (0-15) (SF.GMC only) }
    TC_RAT,    { 007   - TYPEAHEAD, 0 = 1 char buffer, 1 = 31 char buffer }
    TC_TTP,    { 010   - TERM (0-177 reserver for Digital, 200-377 for user) }
    TC_011,    { 011   - unassigned by DEC }
    TC_SCP,    { 012   - CRT, 1 if true }
    TC_HFL,    { 013   - HFILL, 0-7 fill characters sent after CR }
    TC_VFL,    { 014   - VFILL (send 4 fill chars after LF, 1 if true }
    TC_015,    { 015   - unassigned by DEC }
    TC_016,    { 016   - unassigned by DEC }
    TC_HFF,    { 017   - FORMFEED, 1 if true }
    TC_020,    { 020   - unassigned by DEC }
    TC_HHT,    { 021   - HHT (TAB), 1 if true }
    TC_022,    { 022   - unassigned by DEC }
    TC_023,    { 023   - unassigned by DEC }
    TC_ACR,    { 024   - WRAP, 1 if true }
    TC_SMR,    { 025   - LOWER, 1 if true }
    TC_026,    { 026   - unassigned by DEC }
    TC_027,    { 027   - unassigned by DEC }
    TC_030,    { 030   - unassigned by DEC }
    TC_031,    { 031   - unassigned by DEC }
    TC_032,    { 032   - unassigned by DEC }
    TC_033,    { 033   - unassigned by DEC }
    TC_034,    { 034   - unassigned by DEC }
    TC_ESQ,    { 035   - ESCSEQ, 1 if true }
    TC_036,    { 036   - unassigned by DEC }
    TC_PAR,    { 037   - PARITY, 1 if true }
    TC_EPA,    { 040   - if PARITY (TC_PAR) on, 1 if even, 0 if odd }
    TC_DLU,    { 041   - REMOTE, 0 if local, 1 if remote, 2 if rem/autocall }
    TC_BLK,    { 042   - BLKMOD, 1 if true }
    TC_043,    { 043   - unassigned by DEC }
    TC_HLD,    { 044   - HOLD, 1 if true }
    TC_045,    { 045   - unassigned by DEC }
    TC_046,    { 046   - unassigned by DEC }
    TC_NEC,    { 047   - NOECHO, 1 if true }
    TC_SLV,    { 050   - SLAVE, 1 if true }
    TC_PRI,    { 051   - PRIV (SF.GMC only), 1 if true }
    TC_052,    { 052   - unassigned by DEC }
    TC_053,    { 053   - unassigned by DEC }
    TC_054,    { 054   - unassigned by DEC }
    TC_055,    { 055   - unassigned by DEC }
    TC_056,    { 056   - unassigned by DEC }
    TC_057,    { 057   - unassigned by DEC }
    TC_060,    { 060   - unassigned by DEC }
    TC_061,    { 061   - unassigned by DEC }
    TC_062,    { 062   - unassigned by DEC }
    TC_063,    { 063   - unassigned by DEC }
    TC_FDX,    { 064   - FDX, 1 if true }
    TC_BIN,    { 065   - PASSALL (RPA), 1 if true }
    TC_066,    { 066   - unassigned by DEC }
    TC_8BC,    { 067   - EBC (EIGHTBIT), 1 if true }
    TC_070,    { 070   - unassigned by DEC }
    TC_TBF,    { 071   - Get typeahead count (GMC), flush typeahead (SMC) }
    TC_CTS,    { 072   - get/set XON,XOFF status, 0 if XON, 1 if XOFF }
    TC_073,    { 073   - unassigned by DEC }
    TC_074,    { 074   - unassigned by DEC }
    TC_075,    { 075   - unassigned by DEC }
    TC_ASP,    { 076   - initial remote answer speed, see speed codes }
    TC_ABD,    { 077   - AUTOBAUD, 1 if true }
    TC_TBS,    { 100   - TYPEAHEAD (M+ I/D systems only) size, 0-255 }
    TC_TBM,    { 101   - SERIAL, 1 if true (typeahead mode, 0=task, 1=CLI) }
    TC_NBR,    { 102   - NOBRO, 1 if true }
    TC_ACD,    { 103   - current ACD number linked, 0 if none }
    TC_104,    { 104   - unassigned by DEC }
    TC_105,    { 105   - unassigned by DEC }
    TC_106,    { 106   - unassigned by DEC }
    TC_107,    { 107   - unassigned by DEC }
    TC_110,    { 110   - unassigned by DEC }
    TC_111,    { 111   - unassigned by DEC }
    TC_112,    { 112   - unassigned by DEC }
    TC_113,    { 113   - unassigned by DEC }
    TC_114,    { 114   - unassigned by DEC }
    TC_115,    { 115   - unassigned by DEC }
    TC_116,    { 116   - unassigned by DEC }
    TC_117,    { 117   - unassigned by DEC }
    TC_120,    { 120   - unassigned by DEC }
    TC_121,    { 121   - unassigned by DEC }
    TC_ANI,    { 122   - ANSI, 1 if true }
    TC_AVO,    { 123   - AVO (advanced video), 1 if true }
    TC_DEC,    { 124   - DEC, 1 if true }
    TC_EDT,    { 125   - EDIT, 1 if true }
    TC_RGS,    { 126   - REGIS, 1 if true }
    TC_127,    { 127   - unassigned by DEC }
    TC_TLC,    { 130   - CTRLC (CLI gets CTRL-C notice), 1 if true }
    TC_SFC,    { 131   - SOFT, 1 if true }
    TC_HSY,    { 132   - XOFFSET /HSYNC, 1 if flow control exerted }
    TC_133,    { 133   - unassigned by DEC }
    TC_134,    { 134   - unassigned by DEC }
    TC_135,    { 135   - unassigned by DEC }
    TC_136,    { 136   - unassigned by DEC }
    TC_137,    { 137   - unassigned by DEC }
    TC_OOB,    { 140   - Out of band char handling, flush typeahead, 1 if true }
    TC_ICS,    { 141   - Change in typeahead buffer, 1 if true }
    TC_SSC,    { 142   - Switch to terminal management mode, 1 if true }
    TC_TMM,    { 143   - In terminal management mode, 1 if true }
    TC_TSY,    { 144   - TTSYNC (process XON/XOFF), 1 if true }
    TC_MHU,    { 145   - Modem hangup AST, specifies address of AST }
    TC_PTH,    { 146   - PASTHRU, 1 if true }
    TC_PPT,    { 147   - PRINTERPORT, 1 if true }
    TC_SXL,    { 150   - Supports SIXEL graphics, 1 if true }
    TC_151,    { 151   - unassigned by DEC }
    TC_CLN,    { 152   - CHAR_LENGTH, 1 if 8, 0 if 7 }
    TC_QDP,    { 153   - LAT queue depth (SF.SMC only), 0 if connected, 1-255 }
    TC_MAP,    { 154   - LAT application terminal, 1 if true }
    TC_155,    { 155   - unassigned by DEC }
    TC_156,    { 156   - unassigned by DEC }
    TC_157,    { 157   - unassigned by DEC }
    TC_160,    { 160   - unassigned by DEC }
    TC_161,    { 161   - unassigned by DEC }
    TC_162,    { 162   - unassigned by DEC }
    TC_163,    { 163   - unassigned by DEC }
    TC_164,    { 164   - unassigned by DEC }
    TC_165,    { 165   - unassigned by DEC }
    TC_166,    { 166   - unassigned by DEC }
    TC_167,    { 167   - unassigned by DEC }
    TC_170,    { 170   - unassigned by DEC }
    TC_171,    { 171   - unassigned by DEC }
    TC_172,    { 172   - unassigned by DEC }
    TC_173,    { 173   - unassigned by DEC }
    TC_174,    { 174   - unassigned by DEC }
    TC_175,    { 175   - unassigned by DEC }
    TC_176,    { 176   - unassigned by DEC }
    TC_177,    { 177   - unassigned by DEC }
    TC_LAST    { 200   - AMI reserved - last element of scaler type }
    );

  { DEC_SPEED_TYPE type is the DEC baud rate codes used in the SPEED
    get/set commands.  The DEC defined symbol is used with an
    underbar "_" substituted for the period ".".}

  DEC_speed_type = (

  {sym name}  {octal}   { short description}

    S_NULL,   { 000   - AMI defined placeholder - also first scaler }
    S_0,      { 001   - disabled }
    S_50,     { 002   - 50 bps (baudot not supported) }
    S_75,     { 003   - 75 bps }
    S_004,    { 004   - unassigned by DEC }
    S_110,    { 005   - 110 bps }
    S_134,    { 006   - 134 bps }
    S_150,    { 007   - 150 bps }
    S_200,    { 010   - 200 bps }
    S_300,    { 011   - 300 bps }
    S_600,    { 012   - 600 bps }
    S_1200,   { 013   - 1200 bps }          
    S_1800,   { 014   - 1800 bps }          
    S_2000,   { 015   - 2000 bps }          
    S_2400,   { 016   - 2400 bps }          
    S_3600,   { 017   - 3600 bps }          
    S_4800,   { 020   - 4800 bps }          
    S_7200,   { 021   - 7200 bps }          
    S_9600,   { 022   - 9600 bps }          
    S_EXTA,   { 023   - DH11 external speed A }
    S_EXTB,   { 024   - DH11 external speed B }
    S_19_2,   { 025   - 19200 bps (not available on DZQ or DZV controllers }
    S_LAST    { 026   - AMI defined placeholder - last in list }
    );

  Terminal_characteristic_rec = packed record 
       id: terminal_characteristic_type;
       case terminal_characteristic_type of

         { all types not defined by DEC - second byte not defined }
      
    TC_NULL { 000 }, TC_005 { 005 }, TC_011 { 011 }, TC_015 { 015 }, 
    TC_016 { 016 }, TC_020 { 020 }, TC_022 { 022 }, TC_023 { 023 }, 
    TC_026 { 026 }, TC_027 { 027 }, TC_030 { 030 }, TC_031 { 031 }, 
    TC_032 { 032 }, TC_033 { 033 }, TC_034 { 034 }, TC_036 { 036 }, 
    TC_043 { 043 }, TC_045 { 045 }, TC_046 { 046 }, TC_052 { 052 }, 
    TC_053 { 053 }, TC_054 { 054 }, TC_055 { 055 }, TC_056 { 056 }, 
    TC_057 { 057 }, TC_060 { 060 }, TC_061 { 061 }, TC_062 { 062 }, 
    TC_063 { 063 }, TC_066 { 066 }, TC_070 { 070 }, TC_073 { 073 }, 
    TC_074 { 074 }, TC_075 { 075 }, TC_104 { 104 }, TC_105 { 105 }, 
    TC_106 { 106 }, TC_107 { 107 }, TC_110 { 110 }, TC_111 { 111 }, 
    TC_112 { 112 }, TC_113 { 113 }, TC_114 { 114 }, TC_115 { 115 }, 
    TC_116 { 116 }, TC_117 { 117 }, TC_120 { 120 }, TC_121 { 121 }, 
    TC_127 { 127 }, TC_133 { 133 }, TC_134 { 134 }, TC_135 { 135 }, 
    TC_136 { 136 }, TC_137 { 137 }, TC_151 { 151 }, TC_155 { 155 },
    TC_156 { 156 }, TC_157 { 157 }, TC_160 { 160 }, TC_161 { 161 },
    TC_162 { 162 }, TC_163 { 163 }, TC_164 { 164 }, TC_165 { 165 },
    TC_167 { 167 }, TC_170 { 170 }, TC_171 { 171 }, TC_172 { 172 },
    TC_173 { 173 }, TC_174 { 174 }, TC_175 { 175 }, TC_176 { 176 },
    TC_177 { 177 }, TC_LAST { 200 }
      : ();

  { The next variant type is all those characteristics that return
    true or false (BOOLEAN) in the second byte - watch out for
    those sneaky types that reference the negated form like 
    NOECHO - where TRUE (1) = NOECHO, and FALSE (0) = ECHO. }

    TC_SCP { 012 }, TC_VFL { 014 }, TC_HFF { 017 }, TC_HHT { 021 }, 
    TC_ACR { 024 }, TC_SMR { 025 }, TC_ESQ { 035 }, TC_PAR { 037 }, 
    TC_BLK { 042 }, TC_HLD { 044 }, TC_NEC { 047 }, TC_SLV { 050 }, 
    TC_PRI { 051 }, TC_FDX { 064 }, TC_BIN { 065 }, TC_8BC { 067 }, 
    TC_CTS { 072 }, TC_ABD { 077 }, TC_TBM { 101 }, TC_NBR { 102 },
    TC_ANI { 122 }, TC_AVO { 123 }, TC_DEC { 124 }, TC_EDT { 125 }, 
    TC_RGS { 126 }, TC_TLC { 130 }, TC_SFC { 131 }, TC_HSY { 132 }, 
    TC_ICS { 141 }, TC_TMM { 143 }, TC_TSY { 144 }, TC_PTH { 146 },
    TC_PPT { 147 }, TC_SXL { 150 }, TC_CLN { 152 }, TC_MAP { 154 }
      : (state: boolean);

  { The next set of characteristics are those that return byte unsigned
    integer values.  These have different meanings depending upon
    the type, but resolve into a "count".  For example, TC_WID, the
    number is the buffer width in bytes, or TC_HFL where the number
    is the number of fill characters to add to the output line after
    a CR, or TC_TTP where the number is a number assigned by DEC
    to describe the terminal type that is attached to the port like
    octal 21 for an LA100. }

    TC_WID { 001 }, TC_LPP { 002 }, TC_ISL { 006 }, TC_TTP { 010 },
    TC_HFL { 013 }, TC_TBF { 071 }, TC_TBS { 100 }, TC_ACD { 103 },
    TC_QDP { 153 }
      : (value: nbyte);

  { The next set of characteristics are those that return a baud rate.
    For our convenience, we defined the DEC baud rate type so that we do
    not have to translate numeric codes to baudrates. }

    TC_RSP { 003 }, TC_XSP { 004 }, TC_ASP { 076 }
      : (speed: DEC_speed_type);

  { And then a set of miscellaneous characteristics that do not fall
    into the above set.  They all still use the second byte for
    meaningfull information.  Its just that the interpretation is
    not very generic.  We use the NBYTE type for convenience in 
    accessing the value, but do not expect a continuous range of numbers. }

    TC_RAT { 007 }, TC_EPA { 040 }, TC_DLU { 041 }
      : (misc_value: nbyte);

  { And finally those characteristics that do not follow the two byte
    model.  After the id and status bytes, they have one or more words
    for additional information.  This upsets our nice variant record,
    as they exceed the two byte size.  For completeness, we place them
    here with null second bytes.  HOWEVER, IF YOU USE THESE CHARACTERISTICS,
    YOU MUST ONE OF THESE RECORDS, FOLLOWED BY THE NECCESSARY WORDS
    TO DEFINE THE ADDED DATA.  See the discussion of these guys
    in section 2.4.16.1 in the Full Duplex Terminal Driver chapter
    of the I/O Drivers Reference manual. }

    TC_OOB { 140 }, TC_SSC { 142 }, TC_MHU { 145 }
      : ()

    end;


          

