{ NOTICE OF COPYRIGHT AND OWNERSHIP OF SOFTWARE:

  Copyright (C) 1986, 1987, 1988 Oregon Software, Inc.
  All Rights Reserved.

  This program is the property of Oregon Software.  The program or
  parts of it may be copied and used only as provided under a signed
  license agreement with Oregon Software.  Any support purchased from 
  Oregon Software does not apply to user-modified programs.  All copies 
  of this program must display this notice and all copyright notices. 
  
  
  Release version: 2.1F  Level: 1
  Processor: PDP-11
  System: RSX-11

  Library definitions in Pascal

 Last modified by KIM on 17-Mar-1987 12:10:48
 Purpose:
Correct previous Update to 2.1F

}

{[l-,r+,b+]}
{
  RSX Pascal support library definitions.
}

TYPE

  word = 0..65535; { Unsigned 16 bit quantity }
  byte = 0..255; { Unsigned 8 bit quantity }

  file_id = ARRAY [1..3] OF word;

{
  Definitions for a filename block
}

{
  These bits describe the contents of the filename block.  They are
  found in the STAT field.
}

  fnb_status = (nb$ver, { Explicit version number }
                nb$typ, { Explicit type }
                nb$nam, { Explicit filename }
                nb$svr, { Wildcard version number }
                nb$stp, { Wildcard type }
                nb$snm, { Wildcard filename }
                nb$dir, { Explicit UIC }
                nb$dev, { Explicit device }
                nb$sd1, { Wildcard group in UIC }
                nb$sd2); { Wildcard owner in UIC }

  file_name_block =
    RECORD
      fid: file_id; { File ID }
      fnam: ARRAY [1..3] OF word; { File name (3 RAD50 words=9 chars) }
      ftyp: word; { RAD50 file type }
      fver: word; { Version number }
      stat: SET OF fnb_status; { FNB status bits }
      next: word; { Wildcard context }
      did: file_id; { File ID of directory }
      dvnm: PACKED ARRAY [1..2] OF char; { Device name }
      unit: word; { Device unit number }
    END;


{
  File descriptor block (FDB) definitions.  The FDB is defined by the RSX
  file control services (see appendix A of the I/O Operations Reference
  Manual.
}

CONST

{
  Record type field definitions found in RTYP
}

  r$fix = 1; { Fixed length records }
  r$var = 2; { Variable length records }
  r$seq = 3; { Sequenced records }

TYPE

{
  These bits describe the record in the RATT field of the FDB
}

  record_attributes = (fd$ftn, { Fortran carriage control }
                       fd$cr, { Normal LF-data-CR output format }
                       fd$xx1, { Not used }
                       fd$blk, { Records do not cross block boundaries }
                       fd$xx2, fd$xx3, fd$xx4, fd$xx5);

{
  These bits describe the way records are accessed.  RACC field in FDB
}

  record_access = (fd$rwm, { Read/Write mode }
                   fd$ran, { Random access mode }
                   fd$plc, { Locate mode }
                   fd$ins, { Insert mode }
                   fd$yy1, fd$yy2, fd$yy3, fd$yy4);

{
  Device characteristics in the RCTL field of the FDB
}

  device_characteristics = (fd$rec, { Record oriented device }
                            fd$ccl, { Carriage control device }
                            fd$tty, { Terminal device }
                            fd$dir, { Directory device }
                            fd$sdi, { Single directory device }
                            fd$sqd, { Sequential device }
                            fd$zz1, fd$zz2);


{
  Buffers described in URBD and NRBD in FDB
}

  file_buffer = PACKED ARRAY [1..512] OF char;

  file_buffer_pointer = ^file_buffer;

  buffer_descriptor =
    RECORD
      length: word;
      buffer: file_buffer_pointer;
    END;

  block_buffer_pointer = ^block_buffer;

  block_buffer =
    RECORD
      dummy1, dummy2: integer;
      vbn: ARRAY [1..2] OF word; { Virtual block number }
      bbfs: word; { Number of bytes read/written }
      nxbd: block_buffer_pointer; { Pointer to next block buffer }
    END;



{
  File access bits found in FACC in FDB
}

  file_access = (fa$rd, { Read only }
                 fa$wrt, { Write }
                 fa$ext, { Extend }
                 fa$cre, { Create }
                 fa$tmp, { Temporary file }
                 fa$shr, { Shared file }
                 fa$apd, { Append to file }
                 fa$xx1);

{
  Special device control bits in ACTL in FDB
}

  control_bits = (fa$yy1, { Not named }
                  fa$dlk, { Don't lock file }
                  fa$yy2, { Not named }
                  fa$rwd, { Rewind magtape on open/close }
                  fa$pos, { Position Magtape }
                  fa$yy3, { Not named }
                  fa$yy4, { Not named }
                  fa$enb); { Enable other control bits }


  fdb_pointer = ^fdb; { Pointer to an FDB }

  fdb = { File Descriptor Block }
    PACKED RECORD
      rtyp: byte; { Record type }
      ratt: SET OF record_attributes; { Record attributes }
      rsiz: word; { Record size }
      hibk: ARRAY [1..2] OF word; { Highest allocated block }
      efbk: ARRAY [1..2] OF word; { Highest used block }
      ffby: word; { First free byte in last block }
      racc: SET OF record_access; { How records are accessed }
      rctl: SET OF device_characteristics; { Description of device }
      urbd: buffer_descriptor; { User record buffer descriptor }
      nrbd: buffer_descriptor; { Next record buffer descriptor }
      nrec: word; { Address of next record }
      eobb: word; { End of block buffer }
      rcnm: ARRAY [1..2] OF word; { Record number }
      aloc: word; { Allocation quantity }
      lun: byte; { LUN for this file }
      facc: SET OF file_access; { File access bits }
      dspt: word; { Address of dataset descriptor }
      dfnb: word; { Address of default filename block }
      efn: byte; { Event flag }
      bkp1: byte; { Bookkeeping bits }
      err: - 127..127; { Error code }
      err1: - 127..127; { Error flag byte }
      mbct: byte; { Multiple buffer count }
      mbc1: byte; { Number of buffers in use }
      mbfg: byte; { Multiple buffer flags }
      bgbc: byte; { Big buffer block count? }
      vbsz: word; { Device buffer size }
      bbfs: word; { Block buffer size }
      vbn: ARRAY [1..2] OF word; { Virtual block number }
      bdb: block_buffer_pointer; { Block buffer descriptor }
      spdv: word; { Spool device }
      spun: byte; { Spool device unit number }
      xchr: byte; { ACP device characteristics }
      retp: byte; { Number of retrieval pointers }
      actl: SET OF control_bits; { Device control bits }
      seqn: word; { Record sequence number }
      fnb: file_name_block; { FNB for this file }
    END;


{
  File variable definitions.  The file variable is a structure created on
  the heap by RESET() or REWRITE().  It contains all the information
  necessary for I/O with record oriented devices.  The FDB is necessary
  for file operations.  These definitions match those in OPCOM.MAC which
  are used by the support library modules.
}

{
  File status bits in STAT in the file variable
}

  file_status = (rnd, { Random access file }
                 out, { Output operations legal }
                 inp, { Input operations legal }
                 ftn, { Fortran I/O for output }
                 txt, { Text file }
                 def, { Current character is defined }
                 feoln, { End of line found }
                 feof); { End of file found }

{
  File status bits in FLB2 in file variable
}

  file_status_two = (fs0, fs1, fs2, fs3, fs4, fs5, fs6, { Unused bits }
                     cup { Terminal independent cursor addressing }
                     );

  file_variable =
    PACKED RECORD
      ptr: word; { Pointer into file buffer }
      lun: byte; { Logical unit number for this file }
      stat: SET OF file_status; { Current file status }
      iov: word; { I/O vector address }
      buf: word; { Address of record buffer }
      siz: word; { Size of record buffer }
      fdb: fdb_pointer; { Address of FDB for this file }
      bend: word; { Pointer past end of record buffer }
      eflag: byte; { Error flag }
      nflag: byte; { NoIOerror flag byte }
      iosb: word; { Status of last I/O operation }
      len: word; { Length of data transferred by last operation }
      dev: PACKED ARRAY [1..2] OF char; { Device name }
      unit: word; { Unit number }
      tmod: byte; { Terminal I/O subfunction bits }
      flg2: SET OF file_status_two; { Extended file status bits }
    END;

{
  A file defined in the user's data area is simply a pointer to a
  file variable on the heap.
}

  user_file_variable = ^file_variable;

{
  The active file table contains the addresses of user file variables
}

  user_file = ^user_file_variable;



{
  Library work area definitions.  The library data area is found in a
  magical Psect called $$VEX1.  This section is known to the Task Builder,
  and the address of this section is part of the task's context.  The
  variable $VEXT contains the address of this section.  $VEXT is usually
  found at virtual address 56B, so programs which wish to reference the
  library work area can include a definition as shown below:

        vext origin 56B: library_data;
}

{
  Operating system identification found in SYS
}

  system_type = (rsx_11d, rsx_11m, rsx_11s, ias, rsts, vax, rsx_11m_plus,
		 rt_sj, rt_xm, pos);

{
  Description of blocks on the free list.  The library routines NEW() and
  DISPOSE() manipulate dynamic memory.
}
  free_pointer = ^free_block;

  free_block =
    RECORD
      next: free_pointer; { Pointer to next free block }
      length: word; { Size of this block in bytes }
    END;

{
  The orphan list is a list of single word blocks which are too small to
  place on the free list.
}

  orphan_pointer = ^orphan;

  orphan =
    RECORD
      next: orphan_pointer; { Pointer to next orphan }
    END;

{
  Table of active files.  Note that only the first few words of
  this table are actually allocated.  The field NLUN contains
  the number of possible entries in this table.  FLST points to
  this table.
}
  active_file_table = ARRAY [1..127] OF user_file;


{
  The Pascal library data area.  These fields are defined in the module
  opcom.mac
}
  library_data =
    RECORD
      usrpc: word; { Address of error in user's code }
      flst: ^active_file_table; { Start address of table of open files }
      flnd: word; { End address of table of open files }
      vfc: word; { Vertical format control character }
      vfcbk: word; { Vertical format control for break }
      efn: word; { Event flag used by library }
      iosb: word; { Address of last iosb block }
      iov: word; { Address of disk file I/O transfer vectors }
      iovf: word; { Address of record I/O transfer vectors }
      sysdv: PACKED ARRAY [1..2] OF char; { Name of system device }
      sysun: word; { System device unit number }
      ilun: word; { LUN for standard input file }
      olun: word; { LUN for standard output file }
      xin: user_file; { Address of current input file }
      out: user_file; { Address of current output file }
      sin: user_file_variable; { Address of standard input file variable }
      sout: user_file_variable; { Address of standard output file variable }
      hlo: word; { Address of low end of $$HEAP }
      hhi: word; { Address of high end of $$HEAP }
      llim: word; { Lower memory limit }
      hlim: word; { High memory limit }
      fill: word; { Garbage memory fill character }
      kore: word; { Low limit available to stack }
      free: free_pointer; { Free list head }
      free1: word; { Must be zero }
      orph: orphan_pointer; { Orphan list head }
      stak: word; { Initial size of stack }
      rsr6: word; { Initial location of stack }
      rsr5: word; { Pointer into global data area }
      sst: word; { Address of Pascal's SST vectors }
      fast: word; { Address of FPP AST routine }
      nlun: word; { Number of logical units available }
      exst: word; { Exit status }
      dbg: word; { Debugger termination address }
      efil: user_file; { Pointer to last file accessed }
      dynl: ^word; { Address of dynamic link }
      pmpc: word; { Error PC for PMA }
      pmdl: word; { Dynamic link for PMA }
      natt: word; { Don't attach to terminal }
      speoln: word; {Special "space" for EOLN}
      next: word; { Don't extend task for more memory }
      name: ARRAY [1..2] OF word; { Name of task (rad50) }
      par: ARRAY [1..2] OF word; { Task's partition (rad50) }
      dummy3, dummy4: word; { Unused }
      prio: word; { Task's priority }
      uic: word; { Task's UIC }
      luns: word; { LUN's used by this task }
      dummy5, dummy6: word; { Unused }
      sstv: word; { Address of task's SST vectors }
      sstl: word; { Length of task's SST vectors }
      mem: word; { Upper memory limit }
      sys: system_type; { System ID }
      puic: word; { Protection UIC }
      conf: word; { Library configuration word }
      oper: integer; { Error status from last open }
      lber: word; { Address of library error routine }
      uerr: word; { Address of user error routine }
      errn: word; { Error ID and class }
      erfl: word; { Address of file causing error }
      erst: word; { I/O status for file causing error }
      erpc: word; { Address in user code of error }
      vect: word; { Address of FCS vectors for cluster library }
    END;


{
  File storage region definitions
}

  file_storage_block =
    RECORD
      head1: word; { List head }
      head2: word; { List head }
      bfsr: word; { First address in $$FSR1 }
      efsr: word; { Last address in $$FSR1 }
      owui: word; { UIC of owner }
      fipr: word; { Default file protection word }
      dpb: ARRAY [1..12] OF word; { QIO DPB and scratch area }
      iost: word; { I/O status block }
      ioln: word; { Length (part of I/O status block) }
      dfdr: ARRAY [1..13] OF word; { Default directory info }
      dfbc: word; { Default multiple buffer count }
      dfui: word; { Default UIC }
      exds: PACKED ARRAY [1..80] OF char; { VAX default directory string }
    END;



{
  The fixed part of a task header
}

  task_header =
    PACKED RECORD
      csp: word; { Current stack pointer }
      hdln: word; { Header length }
      eflm: word; { Event flag mask }
      efad: word; { Event flag address }
      cuic: word; { Current UIC }
      duic: word; { Default UIC }
      ips: word; { Initial PS }
      ipc: word; { Initial PC }
      isp: word; { Initial stack pointer }
      odva: word; { ODT SST vector address }
      odvl: word; { ODT SST vector length }
      tkva: word; { Task SST vector address }
      tkvl: word; { Task SST vector length }
      pfva: word; { Power fail AST control block address }
      fpva: word; { FPP AST control block address }
      rcva: word; { Receive AST control block address }
      efsv: word; { Address of event flag context }
      fpsa: word; { Address of floating point context }
      wnd: word; { Pointer to number of window blocks }
      dsw: integer; { Directive status word }
      fcs: ^file_storage_block; { Address of FCS impure storage }
      fort: word; { Address of Fortran impure storage }
      ovly: word; { Address of overlay impure storage }
      vext: ^library_data; { Address of library work area }
      spri: byte; { Swapping priority }
      nml: byte; { Mailbox LUN }
      rrva: word; { Address of receive by reference AST control block }
      rsv1: word; { Reserved }
      rsv2: word; { Reserved }
      rsv3: word; { Reserved }
      gard: word; { Header guard word pointer }
      nlun: word; { Number of LUNs }
    END;
{
  Define task header (and thus most of the library data )
}

VAR
  header ORIGIN 0: task_header;


