Program MSSIZE;
 {$nowalkback}
 {$nomain}
 {[A-,B+,K+,L-,R+,T=3] PASMAT DIRECTIVES}


{ File: [MESSAGE]MSSIZE.PAS 
    Last Edit: 20-OCT-1989 01:39:08 

    History:
    	 20-OCT-1989 - JMB - Ripped out of MSGPACKET.PAS routine
    		MSGLEN and adapted for integrated Message_rec. 	
}

%include pas$ext:general.typ;
%include pas$ext:string.pkg;
%include pas$ext:message.typ;

%include pas$ext:vsda.ext;
%include pas$ext:vrcd.ext;
%include pas$ext:catr56.ext;
%include pas$ext:cr56ta.ext;


Function MsSize(var message: message_rec):integer;
  External;

{*USER*

Return the "valid" (used) length of the message in MESSAGE.  This is
the byte count of the message that is currently used.  This could be
the entire message (currently 206 byte max), or only part of the
message (will be at least 26 bytes).  The length of the message is
computed based on the MESSAGE_PACKET_TYPE ID field, and then on
string length or byte count fields within that message.  For this
reason, the message in MESSAGE must be filled in, complete and valid before
calling this routine, or an improper length may be calculated.

*ERROR CODES*

There are no errors.
However, any inconsistency found while calculating a message 
length will result
in a length of 206 being returned.  206 is the maximum length of any
message, and thus will guarantee that the message contents, regardless
of their format, will be considered valid.  Keep in mind that 206
is a valid message length for a number of messages.

}

{*WIZARD*

    This function is called internally by MSSEND (at least). The call
    site is hard-coded to call MSGLEN from within a MACRO routine. 

    	***** DO NOT CHANGE THE CALL SITE *****
    
}
    
    
Function MsSize;

{ Currently, the type MESSAGE_REC is a 236 byte variant record,
  with a fixed part containing routing and control information, plus
  2 bytes used for the ID, the second 4 bytes used for
  the SUB sub type subset, and the remaining 200 bytes used by the
  record variants. }

CONST
    hdr_size = 30; 	{ magic number for fixed part of record }
Var
  len: integer;

Begin
len:= 0;

case message.id of
  { for ease of insertion, items are ordered by size, with fixed length
    types first, and the variable length types at the end.  LEN is the
    length of the fixed and variant part of the record.  If not changed, 
    it will remain as zero.  A LEN of zero will be interpreted to be
    "unknown" and the maximum length possible will be substituted for LEN.}

  pk_orderly_abort,
  pk_wake_up_sender,
  pk_reserved9,
  pk_reserved10,
  pk_reserved11,
  pk_reserved12,
  pk_reserved13,
  pk_reserved14,
  pk_reserved15,
  pk_reserved16,
  pk_reserved17,
  pk_reserved18,
  pk_reserved19,
  pk_reserved20,
  pk_reserved21,
  pk_reserved22,
  pk_reserved23,
  pk_unknown: len:= 0;

  pk_synch: len:= 12;  

  pk_gate: len:= 16;

  pk_info_short,
  pk_identity: len:= 20;

  pk_control_symbol: len:= 26;

  pk_resource: len:= 30;

  pk_bin: len:= 40;

  pk_check_config,
  pk_report_status,
  pk_phil: len:= 60;

  pk_debug,
  pk_monitor,
  pk_view: len:= 62;

  pk_scale: len:= 182;

  pk_info_long,
  pk_send_as_is,
  pk_ACKed_transaction,
  pk_NAKed_transaction,
  pk_comment: len:= 1 + slen(message.linfo);
    { NOTE that we used MESSAGE.LINFO for all of this group as it
      overmaps the same type0 string in all }

  pk_record: len:= 2 + (message.record_len * 2);

  pk_control_alpha: len:= 7 + slen(message.alpha_value);

  pk_control_numeric: len:= 8 + (message.numeric_len * 2);

  pk_field_value: len:= 11 + slen(message.field_value);

  otherwise len:= 200;
  end; {case}

len := len + hdr_size; { add magic number for header part size }
    
if (len <= 0) or (len > size(message_rec))
  then mssize:= size(message_rec)
  else mssize:= len + hdr_size;
end;  { function mssize }

