{ GCCIINFO.PAS - define information record for use with the GCCI 
  library procedure.

 FILE: EX:[22,320]GCCI.TYP
 AUTHOR: Jim Bostwick 13-Sep-84
 History: JMB 13-Sep-84 -- clone from P2UTIL GCCIINFO.PAS
	  PJS 17-Feb-89 -- modified for M-Plus because the
		information buffer format has changed.

}

{*USER* 
  This record contains the various information items used with
  the GCCI directive. Only one field must be initialized prior
  to calling GCCI - the GCCI_NCP (no-command action) field.
  The other fields are returned by the GCCI procedure. 

  Many of the returned fields are not of much use to the majority
  of applications. However, everything known to the GCCI$ directive
  is defined in the record. 

NOTE: Prior definition of EX:[22,320]GENERAL3.TYP is assumed. Certain
  bits within the control fields are defined as constants in EX:[22,320]
  GCCI.CON.  No constants are defined in this file. 

}

TYPE
  GCCI_Info_rec = RECORD
    GCCI_Nocommand: Word;	{ No_Command action flags (NOTE 1) }
    GCCI_Device: CH2; 		{ Issuing terminal device - usually "TT" }
    GCCI_Unit: Integer;		{ Issuing terminal unit number }
    GCCI_CCL: Integer;		{ Length of original command (NOTE 2) }
    GCCI_Flags: Word;		{ Flags byte (NOTE 3) }
    GCCI_Term: Char;		{ Command line terminator character }
    { The remaining fields directly map the GCCI$ information buffer.
      This mapping MUST be maintained! }
    GCCI_CW2: Word;		{ U.CW2 of issuing terminal }
    GCCI_Parent: Rad56; 	{ Parent task name, if any (NOTE 4) }
    GCCI_POCB: Address;		{ Address of OCB, if any (NOTE 4) }
    GCCI_ProUICGroup: Integer;	{ Protection UIC group number (NOTE 5)}
    GCCI_ProUICMember: Integer; { Protection UIC Member number (NOTE 5) }
    GCCI_DefUFDGroup: Integer;	{ Default UFD Group number (NOTE 5) }
    GCCI_DefUFDMember: Integer;	{ Default UFD Member number (NOTE 5) }
    GCCI_CmdAddr: Address;	{ Address of original command (NOTE 6) }
  end;

{ NOTES:
    1.	This field specifies to the GCCI procedure the action to take
    	if no command line is available. The following bits are defined,
    	with the given meanings if set. Note that a zero value will
    	return with an empty command line, but without the 'NULL COMMAND
    	LINE' bit in GCCI_Flags set. 
    	GC.CCS (1)	If clear, this bit specifies return with carry
    	GC.CEX (1)	set to the GCCI$ directive.
    			This will return to Pascal with a DSW of -100(decimal)
    			which is locally defined as 'no command available'.
    			If SET, this bit forces the CLI task to exit if
    			no command line is available.

    	GC.CST (2)	If set, the CLI is forced to STOP if no command
    			is available. NOTE that if this is used, the
    			GCCI call will return DSW of 2 (IS.CLR) when
    			a command line becomes available, but the
    			command line will NOT be returned! When this
    			happens, the CLI should re-issue the GCCI
    			call to obtain the new command line. 

    	GC.CND (200)   	Do not deque command line. This bit may be
    		 	ORed with CG.CCS or GC.CST. If set, the
    			executive copies the command line from POOL
    			to the GCCI buffer, but does not eliminate
    			it from pool. The address of the original
    			command in pool is returned in field
    			GCCI_CmdAddr (see NOTE 5). It is then 
    			the CLIs responsibility to do something
    			with the original command, and eventually
    			eliminate it. 

    2. The length of the original command as typed in. With the
    	GCCI procedure, this is essentially meaningless, as the 
    	GCCI procedure is capable of accepting up to the maximum
    	length allowed by RSX. 

    3. The flags byte is returned as a word value to Pascal. The
    	following bits are defined by the GCCI$ directive:
    	GC.CNL = 1	a null command line was entered 
    			NOTE: This is NOT the same as 'no command available'!
    	GC.CTE = 2	prompt from a task exit (???)
    
    4. It is possible for an applications task to spawn a user CLI, just
    	as it is possible to spawn MCR (and for the same reasons). If
    	this is done, GCCI_Parent will contain the task name of the
    	parent (Spawning) task, and GCCI_OCB the address of the parent
    	OCB. These fields would then be used by the CLI in RPOIing
    	the requested task. The result would be as if the parent had
    	spawnned the task directly.

    5. The login and current UIC of the requesting task/terminal
    	are returned to pascal as integer group and member numbers.

    6. The address of the original command in system POOL, only if
    	the GC.CND bit is set in the GCCI_NCP control word. I 
    	can conceive of no use for this scheme, and do not recommend
    	it. It is included for completeness only.

}

