program qiowabtst;

%include lb:[22,320]general3.typ;
%include lb:[22,320]qio.typ;
%include lb:[22,320]alun.ext;
%include lb:[22,320]qio.ext;
%include de:[22,320]qioatt.ext;
%include de:[22,320]qiowab.ext;

var
  device	: integer;
  in_buff	: ch80;
  in_add	: address;
  in_len	: integer;
  out_buff	: ch10;
  out_add	: address;
  out_len	: integer;
  waiting	: ch10;
  more		: ch10;
  iosb		: io_status_block;

begin
  write('Enter device:');
  readln(device);
  alun(1,'TT',device);
  writeln('ALUN $dsw:',$dsw);

  qioatt(1,f2);
  writeln('ATTACH $dsw:',$dsw);

  in_add := loophole(address,ref(in_buff));
  in_len := 80;
  qio(read_noecho,1,f3,in_add,in_len,-1,iosb);
  writeln('QIO read no echo $dsw:',$dsw);

  write('Wait:');
  readln(waiting);

  out_add := loophole(address,ref(out_buff));
  out_len := 10;
  out_buff := 'TESTING123';
  qiowab(1,f4,out_add,out_len);
  writeln('QIOWAB $dsw:',$dsw);

  repeat
    write(in_buff,' More:');
    readln(more);
  until more[1] = 'N';
end.
