PROGRAM TSTGTSK;

{This program will test the GTSK P3UTIL routine.}

%include lb:[22,320]general3.typ;
%include lb:[22,320]gtsk.typ;
%include lb:[22,320]gtsk.ext;
%include lb:[22,320]cr56ta.ext;

Var
  name: ch6;
  Task_info: Task_info_rec;

Begin
Writeln ('Call the GTSK routine...');
GTSK (Task_info);
Writeln ('Returned from the GTSK routine.');
Writeln;
CR56TA (Task_info.Name, Name);
Writeln ('Task name is "',Name,'"');
CR56TA (Task_info.Partition, Name);
Writeln ('Partition name is "',Name,'"');
Writeln ('Null1 is ',Task_info.Null1:1,' and Null2 is ',
           Task_info.Null2:1);
Writeln ('Running priority is ',Task_info.Priority:1);
Writeln ('Default uic is group = ',ord (Task_info.Default_group):-1,
           ', member = ',ord (Task_info.Default_member):-1);
Writeln ('Number of luns is ',Task_info.Num_luns:1);
Writeln ('Null3 is ', Task_info.Null3:1,' and Null4 is ',
           Task_info.Null4:1);
Writeln ('SST table address is ', Task_info.SST_table_address:-1);
Writeln ('SST table size in words is ', Task_info.SST_table_size:1);
Writeln ('Window zero size in bytes is ', Task_info.Window0_size:1);
Write ('Operating system is ');
Case Task_info.Op_system of
  0: Writeln ('RSX11D');
  1: Writeln ('RSX11M');
  2: writeln ('RSX11S');
  3: writeln ('IAS');
  4: writeln ('RSTS');
  5: writeln ('VAX/VMS');
  6: writeln ('RSX11M+');
  otherwise writeln ('unknown, code = ',Task_info.Op_system:1);
  end;
Writeln ('Protection uic is group = ', ord (Task_info.Protect_group):-1,
           ', member = ', ord (Task_info.Protect_member):-1);
Writeln;
Writeln ('End of test');
Writeln;
End.
