Program SVAssign;

{ String Package Module

  Version: 3.2
  File:[22,310]SVAssign.PAS
  Author: Jim Bostwick 18-Mar-84

  Last Edit: 23-JUN-1988 22:32:58 

  History:
	 23-JUN-1988 21:59:52  - JMB PA3UTL upgrade.

        *** NOTE ***
  Part of this software is copyrighted by OMSI. Source distribution
to lisenced OMSI sites only.
}
 {$NOMAIN}
 {[A+,B+,K+,L-] Pasmat Directive }

%include PAS$EXT:slen.ext;

  procedure SVAssign(var T: packed array [Tlow..Thigh: Integer] of Char;
                    VAR S: packed array [Slow..Shigh: Integer] of Char);
    external;

{*IDENT* SVAssign -- assign one string to another (BOTH VAR PARAMETERS) }
{*USER*
        -- String Package Module --
 Assign string "S" to string "T". If SLn(S) > SLn(T), S is truncated
to the length of T. If T is greater, and T is a Type "1" string, T is
padded with nulls. 
.NOTE
 If the source string "S" is a Type "1" string, its length is determined
by the rightmost non-null character. 
.end note
.NOTE
 This routine duplicates SAssign in every way, EXCEPT that both "S" and "T"
are VAR parameters. This is a workaround of OMSI 2.1A restrictions on
passing conformant array parameters on to nested procedures. For example,
SAssign cannot be used to copy a VALUE string into another, because 
OMSI won't let you pass a value parameter on to another value parameter
("S" in SAssign). However, for some reason, OMSI WILL let you pass a
value parameter on to a VAR parameter. Hence, SVAssign can be used in 
this case. Conversely, you can't pass a quoted string or other string
constant to SVAssign, but you can to SAssign. Confusing? You BET! 
}


  procedure SVAssign;

    var
      SLn: Integer;
      I: Integer;


    begin {SVAssign}
      if Slow = 0 then SLn := ord(S[0]) else SLn := Slen (S);
      if SLn > Thigh then SLn := Thigh; {Truncate S to size of T}
      for I := 1 to SLn do T[I] := S[I];
      if Tlow = 0 then T[0] := Chr(SLn)
      else if (Tlow = 1) and (SLn < Thigh) then
        for I := SLn + 1 to Thigh do T[I] := chr(0);
    end {SVAssign} ;

