Program Slen;

{ Part of the String Package 


  Version: 3.2
  File:[22,310]SLEN.PAS
  Author: Jim Bostwick 30-Aug-83

  Last Edit:  23-JUN-1988 22:27:13 

  History: 
	 23-JUN-1988 21:58:56  - JMB PA3UTL upgrade.
	 15-Apr-88 PTH -- added code to validate type0 and type1 strings,
                            and if not valid, ignore and report error.
         23-Nov-83 PTH -- change back to null fill
         21-Nov-83 JMB -- convert to blank fill
  			-- return filled length of type "1" strings
  			-- s is now a var parameter

  	*** NOTE ***
 Part of this software is copyrighted by OMSI. Source distribution to 
lisenced OMSI Pascal sites only.

}
{$NOMAIN}
{[A+,B+,L-,K+,R+] Pasmat Directive }

%include PAS$EXT:General.typ;
%include PAS$EXT:error.ext;


function SLen(VAR s: packed array [slow..shigh: integer] of char
  	):integer
  	;External;

{*USER*

The SLEN function the length of string "S". If S is a type0 string,
the length is ORD(s[0]).  If S is a type1 string, then the length is
computed from the S[1] to the last non-null character in the S array.

An invalid string (neither type0 or type1) will be ignored, and the
length returned as zero.  In addition, a type0 string whose length
byte (byte 0) is greater than the upper subscript of the array, will
be considered invalid, ignored, and the length returned as zero.

To aid in debugging, a non-fatal error message
will be issued when an invalid string is encountered.  
For this reason, SLEN is a quick way to check that
an array is a type0 or type1 string.  Note that no validation status
is returned to the caller, but the error message to the terminal will
advise programmer of a program bug.

}

{*WIZZARD*

By definition, any array with a lower subsript of 1 will appear
as a valid type1 string regardless of content or length.  An array
with a lower subscript of 0 will appear as a valid type0 string
provided the length byte (byte 0) does not exceed the upper subscript,
or the upper subscript does not exceed 255.

This means uninitialized strings may appear as valid.
For this reason, strings should be initialized with 
a SCLEAR or SASSIGN to insure
that the string is correctly setup.

If this routine is called with an array that is not a valid type0 or type1
string, the ERROR routine will be called, emitting a warning message
on "output" with the following errors.

.lit

Error -1: Not type0 or type1 string, 
            param = lower subscript
Error -2: Type0 string len exceeds upper subscript, 
            param = upper subscript
Error -3: Type 0 string upper subscript greater
            than 255, param = upper subscript

.eli

}


Function SLen;

var i,err,param:integer;

  begin {Slen}
    err:= 0;
    if slow = 0 
      then begin
        {type0 string}
        i := ord(s[0]);
        if i > shigh 
          then err:= -2
          else if shigh > 255 then err:= -3;
        if err <> 0 
          then begin
            i:= 0;
            param:= shigh;
            end;
        end
      else 
        BEGIN 
        {must be type1 string, if not, ignore string, issue error
         and return len of zero}
        if slow = 1
          then begin
            {type0 string}
            i := shigh;
            while (i >= 1) and (s[i] = chr(0)) do i := i - 1;
            END
          else begin
            {error}
            err:= -1;
            i:= 0;
            param:= slow;
            end;
        end;
    if err <> 0 then error(err, warning_err, 
                            'SLEN - not valid type0/1 string', param);
    slen:= i;
  end {SLen} ;

