Program SEqual;
 {$NOMAIN [A+,B+,L-,K+] }

{
  Version: 3.2
  File:[22,310]SEQUAL.PAS
  Author: Jim Bostwick 31-Aug-83

  Last Edit:  23-JUN-1988 22:25:55 

  History: 
	 23-JUN-1988 21:58:45  - JMB PA3UTL upgrade.
  	 23-Nov-83 JMB -- convert back to null fill
	 21-Nov-83 JMB -- convert to blank fill

        ** NOTE **
 Part of this software is copyright by OMSI. Source distribution 
to licensed OMSI Pascal sites only.
}

{$nolist}
%INCLUDE 'PAS$EXT:slen.ext';
{$list}

  function SEqual(s1: packed array [s1low..s1high: integer] of char;
                  s2: packed array [s2low..s2high: integer] of char): boolean;
    external;

{*USER*
        -- String Package Module --

 Compare "s1" and "s2" for equality. Returns TRUE only if s1 and s2
have same length, and each character matches. Note that s1 and s2
may be of differing Types, and still return TRUE, so long as the 
'in use' length and content match. In use length of a Type "1" string
is the length to the last non-null character.
}


  function SEqual;

    var
      s1len, s2len: integer;
      eq: boolean;
      i: integer;


    begin {Sequal}
      s1len := slen(s1);
      s2len := slen(s2);
      if s1len <> s2len then Sequal := false
      else
        begin
        eq := true;
        for i := 1 to s1len do eq := eq and (s1[i] = s2[i]);
        Sequal := eq;
        end;
    end; {Sequal}
