Program Sadr;

{ Part of the String Package 


  Version: 3.2
  File:[22,310]SADR.PAS      
  Author: 14-Apr-88.  Philip Hannay.  

  Last edit: 23-JUN-1988 22:21:43 

  History: 
	 23-JUN-1988 21:58:12  - JMB PA3UTL upgrade.

}
{$NOMAIN}
{[A+,B+,L-,K+,R+] Pasmat Directive }

%include PAS$EXT:General.typ;

Function SAdr(var str: packed array [slow..shigh:integer] of char):address;
  external;

{*USER*

SADR returns the address of the first character in a string.  If the
array supplied is not a type0 or type1 string, an address of zero (0)
will be returned. 

Using SADR with SLEN allows you to get a buffer address and buffer len
value without knowning anything about a string.  The buffer address
and length can then be used in QIOs.

}

Function SAdr;

var
  adr: address;

begin
adr:= 0;
if (slow = 0) or (slow = 1)
  then begin
    adr:= loophole(address, ref(str));
    if slow = 0 then adr:= adr + 1;
    end;
sadr:= adr;
end;

