PROGRAM CNDTAD;
{$nomain}
{$nowalkback}

{ 
  File: [22,310]CNDTAD.PAS       

  Last Edit: 18-SEP-1989 15:53:42 

  History:  26-May-87.  Philip Hannay.  Created.
	 23-JUN-1988 21:56:10  - JMB PA3UTL upgrade.
             9-Jun_87.  Bob Thomas.     Expanded to allow for returning
			other than DEC_date type strings.
             Philip Hannay.  7-Sep-89.  Changed to clear string on conversion
              error, rather than force nulls.  No change for type1 strings,
              but type0 strings will be returned with zero length, rather
              than 9 nulls.
}


%include PAS$EXT:General.typ;
%include PAS$EXT:sclear.ext;
%include PAS$EXT:sassign.ext;
%include PAS$EXT:cintas.ext;

Procedure CNDTAD( I_date: Int_date;      { 3 integer date YY MM DD }
                  var A_date: Dec_date  { 9 char DEC style date DD-Mmm-YY }
                ); external;


{*USER*

.hl 2 CNDTAD - Convert Numeric Date To Ascii Date

The CNDTAD routine will convert a numeric (3 integer) date into a DEC
format ascii date (DD-MMM-YY).  It can also be used to validate a 
numeric date,
as the conversion will fail for invalid numeric dates.  The date string
A_DATE will be returned as zero length if an invalid integer date
is supplied.

The date string A_DATE must be a valid type0 or type1 string.  The date
will be "assigned" to the A_DATE string, so any previous contents of
the string will be overwritten.

}

{*WIZARD*

The MMM (month) portion of the ascii date will consist of a capitalized
first letter and a lower case second and third letter (ie. May, Feb).  This
conforms to the DEC practice in RSX and DTR.

Single digit days will be preceded with a zero (ie. 06-May-87).  DEC
date conversion routines suppress the zero and shift the date string left
one character, however the DTR date conversion routines
like the leading zero.  So we went with the
DTR convention.

The ascii date variable A_date will conform to either type0 or type1
Cargill/Pascal-2 string conventions depending on how it was specified in 
the calling routine.  If the date is valid, all 9 characters will be
non-null.  If the date is invalid, all 9 characters will be null.

}

PROCEDURE CNDTAD;

type
  month_table_type = packed array [1..12] of ch3;

const
  month_table = month_table_type ('Jan','Feb','Mar','Apr','May','Jun',
                                  'Jul','Aug','Sep','Oct','Nov','Dec');


Var
 Temp_date: DEC_date;
 valid: boolean;
 i: integer;

Begin
temp_date:= '  -   -  ';

{First validate I_date:  take into account leap years, including the
 year 2000, but not the centuries 2100 and beyond.}
valid:= true;
IF (i_date.year<0) OR (i_date.year>99) OR (I_date.day<1) then valid:= false;
if valid
  then begin
    CASE I_date.month OF
      1,3,5,7,8,10,12:
        begin
        IF I_date.day>31 then valid:= false;
        end;
      4,6,9,11:
        begin
        IF I_date.day>30 then valid:= false;
        end;
      2:begin
        IF (I_date.day>29) OR 
              ((I_date.day=29)AND(NOT(I_date.year MOD 4=0)))
          THEN valid:= false;
        END;
      otherwise valid:= false;
      end; {case}
    end;

{date valid if boolean VALID is true}

If valid
  then begin
    {convert the date to ascii}
    cintas(I_date.day,temp_date,-2);
    if temp_date[1] = ' ' then temp_date[1]:= '0';
    for i:= 1 to 3 do temp_date[i+3]:= month_table[I_date.month,i];
    cintas(I_date.year,temp_date,-9);
    if temp_date[8] = ' ' then temp_date[8]:= '0';
    end;

{transfer contents of temp_date to output var A_date.  If integer
 date was supplied, a null string will appear in A_date.}
if valid
  then Sassign(A_date,temp_date)
  else Sclear(A_date);
end;{if}
