PROGRAM CDATE;
{$nomain}
{$nowalkback}

{ 
  File: [22,310]CDATE.PAS       
  Author:   Bob Thomas  9-Jun-87.  

  Last Edit: 23-JUN-1988 22:11:08 

  History:
	 23-JUN-1988 21:55:58  - JMB PA3UTL upgrade.

}


%include PAS$EXT:General.typ;
%include PAS$EXT:sassign.ext;


Procedure CDATE(var In_date:PACKED ARRAY[LOin..HIin:integer]OF char;
		   { 9 char DEC style date DD-MMM-YY }
		 var Out_date:PACKED ARRAY[LOout..HIout:integer]OF char
		   { 7 char date  DDMMMYY}
                ); external;


{*USER*

.hl 2 CDATE - Compress date

The CDATE routine will convert a  DEC format ascii date (DD-MMM-YY) into 
a 7 character date string (DDMMMYY) by removing the hyphens. The 7 character 
Ascii date is often encountered in FMS data handling.

The input string can be any string type - only the first 9 characters are used.
They are moved, with the hyphens stripped out, to the first 7 characters
of the output string, which can also be of any type.
}

{*TECH*

This routine makes no validity checks of the incoming string and will ,in 
fact, remove the 3rd and 7th characters of any CH9 string returning a CH7
string. It will work with any type zero or type one strings as long as the 
effective string lengths are 9 chars for input and 7 chars for output.

}

PROCEDURE CDATE;

Var
 temp_date:ch7;
 i: integer;

Begin

  For i:=1 to 2 do Temp_date[i]:=In_date[i];
  For i:=3 to 5 do Temp_date[i]:=In_date[i+1];
  For i:=6 to 7 do Temp_date[i]:=In_date[i+2];
  sassign(Out_date,Temp_date);
End;

