/*	bits.c

Usage:

	int
	bit_on (bit_array, bit_number)
	int	bit_array[];	Array (field) of bit flags
	int	bit_number;	Number of bit to reference

	int
	bit_set (bit_array, bit_number)

	int
	bit_clr (bit_array, bit_number)

	int
	bit_flip (bit_array, bit_number)

Description:

These are bit manipulation routines in lieu of support for bit fields.

bit_on returns the value of WORD & BIT, where WORD is the word in the
bit array that contains the selected bit, and BIT is a bit mask with only
the selected bit set.  Thus the function returns TRUE if the selected bit
is set; FALSE otherwise.

bit_set operates identically to bit_on, and also sets the selected bit.
bit_clr operates identically to bit_on, and also clears the selected bit.
bit_flip operates identically to bit_on, and also reverses the selected bit.

>>> Note <<<  The bit_array must be word aligned (character arrays are
acceptable only if the array starts on a word boundary).

The bit numbering is left to right ordered:
	0 is MSB of the first word of the array,
	15 is the LSB of the first word of the array,
	16 is the MSB of the second word of the array,
	31 is the LSB of the second word of the array,
	etc.

******************************************************************************/

#include	<std.h>

/* >>> WARNING <<<  A 16 bit word size is assumed. */

#define	WORD	bit_array[bit_number / 16]
#define	BIT	(1 << (15 - (bit_number % 16)))


int
bit_on (bit_array, bit_number)
int	bit_array[];
int	bit_number;
{
return (WORD & BIT);
}


int
bit_set (bit_array, bit_number)
int	bit_array[];
int	bit_number;
{
FAST int	result;

result = WORD & BIT;
WORD = WORD | BIT;
return (result);
}


int
bit_clr (bit_array, bit_number)
int	bit_array[];
int	bit_number;
{
int	result;

result = WORD & BIT;
WORD = WORD & (~BIT);
return (result);
}


int
bit_flip (bit_array, bit_number)
int	bit_array[];
int	bit_number;
{
int	result;

result = WORD & BIT;
WORD = WORD ^ BIT;
return (result);
}
