/*
 *	+++ NAME +++
 *
 *	 CACOS   Complex double precision arc cosine
 *
 *	+++ INDEX +++
 *
 *	 CACOS
 *	 complex functions
 *	 machine independent routines
 *	 math libraries
 *
 *	+++ DESCRIPTION +++
 *
 *	Computes double precision complex arc cosine of
 *	a double precision complex argument.
 *	The result replaces the argument.
 *
 *	+++ USAGE +++
 *
 *	 cacos(z)
 *	 COMPLEX *z;
 *
 *	+++ REFERENCES +++
 *
 *
 *	+++ RESTRICTIONS +++
 *
 *
 *	+++ PROGRAMMER +++
 *
 *	 Fred Fish
 *	 Goodyear Aerospace Corp, Arizona Div.
 *	 (602) 932-7000 work
 *	 (602) 894-6881 home
 *
 *	+++ INTERNALS +++
 *
 *	Computes complex arc cosine of Z = x + j y from:
 *
 *	    CACOS(z) = -j * CLN(z + j * CSQRT(1-z*z))
 *
 *	---
 */

/*)LIBRARY
*/

#include <stdio.h>
#include "c:pmluse.h"
#include "pml.h"


cacos(z)
register COMPLEX *z;
{
    COMPLEX  temp;
    double swaptemp;

    temp.real = z->real;
    temp.imag = z->imag;
    cmult(&temp,&temp);
    temp.real = 1.0 - temp.real;
    temp.imag = -temp.imag;
    csqrt(&temp);
    swaptemp = temp.real;
    temp.real = -temp.imag;
    temp.imag = swaptemp;
    temp.real += z->real;
    temp.imag += z->imag;
    cln(&temp);
    z->real = temp.imag;
    z->imag = -temp.real;
}

