.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.;
.; MBUILD.CMD
.;
.; Command file to build whole DECUS-C on native RSX-11M/M+
.;
.; Volker C. Huck
.; 18-Oct-1988
.;
;
; Build Decus C on native RSX
;
; The default directory is [5,3]
;
.SETS SYSTYP "RSX-11M"
.IF <SYTYP> EQ "RSX-11M" .GOTO SYSOK
.IF <SYTYP> EQ "RSX-11M-PLUS" .GOTO SYSOK
.IF <SYTYP> EQ "MICRO-RSX" .GOTO SYSOK
;
;	You may not use SYSTEM '<SYTYP>' to build DECUS-C for
;	native RSX. If you want to build DECUS-C under
;	VAX-11 RSX, use VBUILD.COM instead.
;
.EXIT
;
.SYSOK:
.SETS MCR ""
.IF <CLI> EQ "MCR" .GOTO 90
.IF <CLI> EQ "DCL" .SETS MCR "MCR "
.IF <CLI> EQ "DCL" .GOTO 90
;
; This command file must be run under MCR.  Since "AT" will give
; confusing restart instructions (will be for '<CLI>'), MBUILD will
; now exit.  Type "@MBUILD" when you have changed CLI's to MCR.
;
.EXIT
.90:
;
; You must override the assignments in this file if you want the following
; logical devices to be assigned to other than SY:
;
;	SR:	Source and command files must be on this device.
;	LS:	Listings go to this device.
;	OB:	Objects go to this device.
;	MP:	Maps go to this device.
;	OU:	Task images go to this device.
;
.TRANSLATE SR
.IF <EXSTRI> EQ "" 'mcr'ASN SY:=SR:
.TRANSLATE LS
.IF <EXSTRI> EQ "" 'mcr'ASN NL:=LS:
.TRANSLATE OB
.IF <EXSTRI> EQ "" 'mcr'ASN SY:=OB:
.TRANSLATE MP
.IF <EXSTRI> EQ "" 'mcr'ASN SY:=MP:
.TRANSLATE OU
.IF <EXSTRI> EQ "" 'mcr'ASN SY:=OU:
;
.ASK OK Are the above assignments OK
.IFT OK .GOTO 100
;
; We will now pause so that you may change assignment(s)...
.PAUSE
.100:
;
.SETF EIS
.ASK OLD Is your processor an 11/04, 11/05, 11/10, or 11/20
.ASK FLT Should the floating-point default be (non-standard) single precsision
;
; If you answer yes to the next question, the resulting DECUS-C will not run
; on a non FPP machine.
;
.ASK FPP Should a Floating Point Processor (FPP) be used
.IFT OLD .GOTO 110
.ASK EIS Does your machine have EIS
.110:
;
; The Decus C character type table assumes that ASCII characters
; may range from 000 to 0377 (full 8-bits).  You can save 128. bytes
; by eliminating this part of the table.  (Decus C character type
; routines will be eventually extended to support extended ASCII
; tests.  These extensions have not yet been made.)
; The DEC Professional 3xx systems support the 8-bit character set.
;
.ASK XAS Restrict table to 7-bit ASCII
;
; You may build the DECUS C support library for use with either FCS-11
; or RMS-11.  Traditionally, this library uses FCS, which is somewhat
; smaller.  However, if you are building the library for P/OS use, or
; if you have DECnet and wish to use the RMS DECnet file I/O support,
; you may build the library for use with RMS.  If you do select RMS,
; the RMSMAC.MLB macro library must be in LB:[1,1] for the library
; to build.  NOTE: RMS specific modules may be identified by their
; "module ID" from a full listing of the library, or on the link map
; of a task built with the RMS version of the library.
;
.ASK RMS Build the RMS version of the library
.SETF $RMSUPD
.SETN FILES 0
.IFF RMS .GOTO RMS02
.TESTFILE LB:[1,1]C.OLB
.IF <FILERR> NE 1 .GOTO RMS01
;
; If you have already built the FCS version, you may generate an RMS
; version, which will be called CR.OLB, by assembling only the RMS
; specific modules and replacing them into a copy of the FCS version
; of C.OLB.  This procedure requires that LB:[1,1] contain the RMS macro
; library RMSMAC.MLB and the FCS version of the C library C.OLB.
;
.ASK $RMSUPD Generate an RMS library from the FCS library
.IFT $RMSUPD .GOTO RMS01
.RMS02:
;
; Building FCS version of library ...
;
; FCS requires static allocation of block buffers for record
; I/O. The code for this is in the C library. At this time, you
; must select the default number of block buffers which will be
; allocated to your C tasks. You need one buffer for each record
; oriented file open at any one time. You must specify at least 3
; as stdin, stdout and stderr each use one. If, at task build time,
; you wish to increase this allocation, you may use the TKB option
; "ACTFIL=n". This will extend the block buffer P-section for that
; particular task, so it can handle more simultaneous files.
;
.ASKN [3.:16.:4.] FILES How many block buffers
.GOTO FCS01
.RMS01:
;
; Building RMS version of library ...
.FCS01:
;
; Build RSX.MAC
;
.OPEN SR:[5,4]RSX.MAC
.ENABLE DATA
	.TITLE	RSX	RSX HEADER FILE
;
; Created by MBUILD.CMD on '<DATE>' at '<TIME>'
;
RSX	=	1		;Assemble for RSX
.DISABLE DATA
.IFT OLD .DATA C$$SXT	=	0		;No SXT, no EIS
.IFF EIS .DATA C$$EIS	=	0		;No EIS
.IFF FLT .DATA C$$FLT	=	0		;Double precision default
.IFT FLT .DATA C$$FLT	=	1		;Single precision default
.IFF FPP .DATA C$$FPP	=	0		;No FPP support
.IFT FPP .DATA C$$FPP	=	1		;FPP support default
.IFT XAS .DATA XASCII	=	0		;7-bit Ascii only
.IFT RMS .DATA RMSIO	=	1		;Assemble for RMS-11
.IFT $RMSUPD .DATA RMSIO	=	1		;Assemble for RMS-11
.IFF RMS .DATA N$$FIL	=	'FILES'.	;Default number of block buffers
.ENABLE DATA
VMS3.0	=	0		;Forget VMS release-specific code

C$PMTR	=	4		;Locally define C$PMTR and C$AUTO
C$AUTO	=	-6		;To minimize global symbol references

.IIF	NDF	L$$IST	.NLIST
.IIF	NDF	L$$IST	.DSABL	CRF
.IIF	NDF	C$$SXT	C$$SXT	=	1	; SXT default
.IIF	NDF	C$$EIS	C$$EIS	=	1	; EIS default
.IIF	NDF	C$$FPP	C$$FPP	=	0	; No FPP default
.IIF	NDF	XASCII	XASCII	=	1	; Allow extended Ascii
.IIF	NDF	RMSIO	RMSIO	=	0	; FCS default

.MACRO	CALL	ARG1,ARG2
.IF	B	ARG2
	  JSR	PC,ARG1
.IFF
	  JSR	ARG1,ARG2
.ENDC
.ENDM	CALL

.MACRO	CALLR	ARG1
	  JMP	ARG1
.ENDM	CALLR

.MACRO	RETURN	ARG1
.IF B	ARG1
	  RTS	PC
.IFF
	  RTS	ARG1
.ENDC
.ENDM	RETURN

;
; The null branch macro
;
.macro	.br	label
.iif	ndf	label	.error	label argument needed
.iif	ne	.-label	.error	label must be the next location
.endm	.br

;
; The .sob macro is like an sob but does not set condition codes correctly
; since it is a dec/bne when sob isn't available.
;

.IF EQ	C$$SXT
.MACRO	.SOB	ARG1,ARG2
	  DEC	ARG1
	  BNE	ARG2
.ENDM	.SOB
.IFF
.MACRO	.SOB	ARG1,ARG2
	  SOB	ARG1,ARG2
.ENDM	.SOB
.ENDC

;
; This macro defines the crash instruction
;
.MACRO	CRASH
.LIST
	  BPT
.NLIST
.ENDM	CRASH

;
; Check an assumption.  Use this macro as follows:
;
;	ASSUME	ARG1 COND ARG2
;
; An error will be signalled unless the condition is satisfied.
; COND may be one of:  EQ,NE,GT,GE,LT,LE,DF,NDF,B,NB,Z,NZ,G,L,
; but it may not be IDN or DIF.
;
.MACRO	ASSUME	ARG1,COND,ARG2
	.IF	COND	<ARG1>-<ARG2>
	.IFF
		.ERROR	;Invalid assumption (ARG1) COND (ARG2)
	.ENDC
.ENDM

	.ENABL	LC, GBL
	.NLIST	CND, BEX
.IIF	NDF	L$$IST	.ENABL	CRF
.IIF	NDF	L$$IST	.LIST

.DISABLE DATA
.CLOSE
;
; Now copying the HEADER Files to LB:[1,1]
;
; Include files
	PIP LB:[1,1]/NV=[5,3]*.h		
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
	.IFF	RMS	.GOTO	USRMAC
	.IFT	$RMSUPD	.GOTO	USRMAC
;
; Rename the standard FCS Header File to FCSSTDIO.H and make the RMS version
; the default.
;
	PIP LB:[1,1]FCSSTDIO.H/NV=LB:[1,1]STDIO.H/RE/NM
	PIP LB:[1,1]STDIO.H/NV=LB:[1,1]RMSTDIO.H/RE/NM
.USRMAC:
; User macro library
	PIP LB:[1,1]/NV=[5,3]cmacs.mac	
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
; Cleanup after ourselves
	PIP LB:[1,1]*.H/PU/NM,cmacs.mac	
;
; Compiler
	'mcr'SET /UIC=[5,4]
	@mmakcc.cmd		
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
; Assembler
	@mmakas.cmd		
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
; Run-time library
	'mcr'SET /UIC=[5,16]
	@mmaklb.cmd		
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
;
; Now install the new compiler and assembler
;
	.IFINS	...XCC	'mcr'REM ...XCC
	.IFINS	...XAS	'mcr'REM ...XAS
	'mcr'INS	OU:[5,4]CC/CKP=YES/TASK=...XCC
	'mcr'INS	OU:[5,4]AS/CKP=YES/TASK=...XAS
	.IFNINS ...XCC	.GOTO ERROR
	.IFNINS	...XAS	.GOTO ERROR
;
; Locate us into tools
	'mcr'set /uic=[5,26]			
; Compile the tools
	@mtool.cmd   			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
;
; Now, locate us into lex
	'mcr'set /uic=[5,12]			
; Compile lex library
	@mlexl.cmd			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
; And compile lex itself
	@mlex.cmd 			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
;
; Back to command
	'mcr'set /uic=[5,3]			
; Documentation proper
	@mgtdoc.cmd			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
;
; Now, do the useful library
	'mcr'set /uic=[5,27]			
; Compile the library
	@mmkcu.cmd			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
; And the documentation
	@muldoc.cmd			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
;
; RSX interface library
	'mcr'set /uic=[5,24]			
; Do it.
	@mxmak.cmd			
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
;
; DECnet library extensions CN.OLB
	'mcr'set /uic=[5,10]
;
	@mbldnet
	.IF <EXSTAT> NE <SUCCES> .GOTO ERROR
; Home again
	'mcr'set /uic=[5,3]			
;
; Compiler and library are built
;
.EXIT
;
.ERROR:
;
; An error has occured. Please correct and retry.
;
.EXIT
