/*	swap_bytes

The count bytes beginning at the word aligned address
are order swapped within each word of the buffer.

>>> NOTE <<< This routine should be modfied in the intermediate
source assembly code to significantly optimize its performance.
This should take advantage of loop control and byte swap instructions
when they are available.  On the DEC PDP family of CPUs use:

	ASR	R0	; R0 is the counter
	BEQ	DONE
SWAP:	SWAB	(R1)+	; R1 is the address pointer
	SOB	R0,SWAP
DONE:
*/

swap_bytes (address, count)
register char	*address;
register int	count;
{
register char	temp;

count >> 1;
while (count--)
    {
    temp = *address;
    *address++ = *(address + 1);
    *address++ = temp;
    }
}

