/*	file_extension

Usage:

    char *
    file_extension (filename, extenstion)

    char	*filename;
    char	*extension;

Description:

The extension string replaces the current extension string (following a
'.' character in the string) if one exists.  If there is no extension
on the filename string, a '.' is added at the end followed by the extension.

The filename string must have sufficient space for the addition of the
extension if not a replacement, a '.' character if needed, and the trailing
null as appropriate.

The function returns the filename pointer.
No filename syntax checking is done.

******************************************************************************/

#include	<std.h>


STRING
file_extension (filename, extension)

STRING	filename;
STRING	extension;
{
FAST STRING	character;

for (character = filename; *character && (*character != '.'); character++);
*character ? character++ : (*character++ = '.');
while (*character++ = *extension++);
return (filename);
}
