/*
 * Unit Control Block (UCB)
 *
 * General purpose style UCB.  Add stuff to this at your
 * driver's convenience & use the sizeof() to get the UCB
 * length.
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Include EXEDF.H for various symbolics
 *
 * Bob Denny
 * 19-Oct-82
 */
struct ucb     {
               struct dcb *u_dcb;      /* Backpointer to DCB */
               struct ucb *u_red;      /* Redirect UCB pointer */
               byte        u_ctl;      /* Control flags */
               byte        u_sts;      /* Status flags byte 1 */
               byte        u_unit;     /* Unit number */
               byte        u_st2;      /* Status flags byte 2 */
               word        u_cw1;      /* Characteristics word 1 */
               word        u_cw2;      /* Characteristics word 2 */
               word        u_cw3;      /* Characteristics word 3 */
               word        u_cw4;      /* Characteristics word 4 */
               struct scb *u_scb;      /* SCB address */
               struct tcb *u_tcb;      /* TCB of attached task */
               word        u_buf[2];   /* Buffer address descriptor */
               word        u_cnt;      /* Byte count of transfer */
               struct tcb *u_acp;      /* TCB of attached ACP task */
               address     u_vcb;      /* Address of VCB */
               };
