/*
 *			t i m e . h
 */

#ifdef	DOCUMENTATION

title	time	Define time buffer structure for localtime()
index		Define time buffer structure for localtime()

synopsis

	#include <time.h>
	   ...
	extern struct tm *localtime();

description

	This header file defines the structure of the time buffer used by
	the standard library localtime() function.  It is defined
	as follows:
	.s.nf
	struct tm {
	  int	tm_sec;		/* Seconds		*/
	  int	tm_min;		/* Minutes		*/
	  int	tm_hour;	/* Hours		*/
	  int	tm_mday;	/* Day in month		*/
	  int	tm_mon;		/* Month		*/
	  int	tm_year;	/* Year			*/
	  int	tm_wday;	/* Weekday		*/
	  int	tm_yday;	/* Days since Jan 1	*/
	  int	tm_isdst;	/* Daylight Savings = 1	*/
	};        	
	.s
	extern struct tm *localtime();
	.s.f
bugs

	Unix V7 changed the tm_isday to tm_isdst.  Thanks guys.

#endif

/*
 * )EDITLEVEL=01
 * Edit history
 * 0.0 16-Feb-82 MM	Newly invented
 */

struct tm {
	int	tm_sec;		/* Seconds			*/
	int	tm_min;		/* Minutes			*/
	int	tm_hour;	/* Hours			*/
	int	tm_mday;	/* Day in month			*/
	int	tm_mon;		/* Month			*/
	int	tm_year;	/* Year				*/
	int	tm_wday;	/* Weekday			*/
	int	tm_yday;	/* Days since Jan 1		*/
	int	tm_isdst;	/* 1 if Daylight Savings Time	*/
};        	

extern struct tm *localtime();
