/*
 *				c s c o p y . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	cscopy		Copy a Cset
index			Copy a cset

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 int
	 cscopy(cs);
	 CSET *cs;

description

	cscopy() returns a cset whose members are exactly the same as the
	members of cs; however, the copy is independent of cs, and changes
	to cs will not affect it.

	cscopy() returns NULL if it can't obtain space for the new cset.

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=12
 * Edit history
 * 0.0 16-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif
#define NULL	0
#define TRUE	1
#define FALSE	0

CSET *
cscopy(cs)
register CSET *cs;
{	CSET *newcs;
	register int i;
	register int flip;

	if ((newcs = cset("")) != NULL)
	{	if ((int)cs & 1)		/* A complemented cset	*/
		{	cs = cscomp(cs);	/* Get base cset	*/
			flip = TRUE;		/* Flip everything	*/
		}
		else
			flip = FALSE;		/* Leave things alone	*/

		for (i = 0; i < cssize; i++)	/* Scan the set		*/
			if (((cs->table[i] & cs->mask) != 0) ^ flip)
				newcs->table[i] |= newcs->mask;
	}
	return(newcs);
}
