/*)LIBRARY
*/

#include	<rsts.h>
 
 
rserror(errno)
/*
 * Fatal error exit.
 *
 * Print the RSTS error message on the keyboard, remove the current job
 * from the receiver table (just in case), close all channels, and exit. 
 */
{
	rs_err("?Fatal error: ", errno, "\r\n");
	rsexit();
}


rs_err(leadin, errno, trailer)
char	*leadin;		/* Leading message			*/
char	errno;			/* the RSTS error number		*/
char	*trailer;		/* Trailing message			*/
/*
 * Print error message "leadin <error text for errno> trailer"
 */
{
	char	outbuffer[30];

	clrfqx();
	firqb.fqfun = UU_ERR;
	firqb.fqfil = errno;
	rstsys(_UUO);
	strcpy(outbuffer, &firqb.fqfil);
	forcenl();
	print(leadin);
	print(outbuffer);
	print(trailer);
}
 
