/*
 * MFRAME - Read menu frame
 */

#ifdef DOCUMENTATION

title    p$mframe    Read Menu Frame
index                Read Menu Frame

synopsis

	 char *frame;    /* Frame ID string */
	 char *gblact;   /* Global action string buffer addr */
	 int maxlen;     /* Size of global action buffer */
	 int *stat;      /* Returned 2-word status */

	 p$mframe(frame, gblact, maxlen, stat)

description

	The p$mframe directive reads the specified menu frame into the static
	menu buffer.  The menu definition file must be open before calling
	P$MFRAME.

author

	 Bob Denny

#endif

extern mframe();

p$mframe(frame, gblact, maxlen, stat)
char *frame;                            /* Frame ID string */
char *gblact;                           /* Global action string buffer addr */
int maxlen;                             /* Size of global action buffer */
int *stat;                              /* Returned 2-word status */
   {
   int flen;
   int size;

   flen = strlen(frame);
   call(mframe, 6, stat, frame, &flen, gblact, &maxlen, &size);
   gblact[size] = '\0';
   return(stat[0]);
   }
