-h- asm.cmd	Wed Jul 28 11:08:29 1982	ASM.CMD;1
rmsput=lb:supmac/ml,lb:rmsmac/ml,[1,6]rmsput
-h- info.txt	Wed Jul 28 11:08:29 1982	INFO.TXT;1
 
RMSFTN
	A FORTRAN CALLABLE RUN-TIME INTERFACE TO THE RMS-11K
	'INDEXED SEQUENTIAL ACCESS METHOD' FILE/RECORD
	MANAGEMENT SYSTEM IS AVAILABLE FOR PROGRAMS CODED IN
	FORTRAN IV, FORTRAN IV PLUS, AND SUPERMAC V46. THE AC-
	COMPANYING DOCUMENT DESCRIBES THE INTERFACE IN DETAIL.
	INCLUDED FUNCTIONS ARE: OPEN, CLOSE, CONNECT, DISCONNECT,
	GET, PUT, FIND, UPDATE, DELETE, AND REWIND. ONLY THE
	INDEXED ORGANIZATION IS SUPPORTED. THE ACCESS METHODS
	SUPPORTED ARE: SEQUENTIAL, RFA (RECORD'S FILE ADDRESS),
	AND INDEXED. NOTE!!!!   SUPERMAC V46 IS REQUIRED FOR
	SOURCE ASSEMBLY.
	SYSTEM(S) RSX-11M VER 3.0 OR LATER WITH RMS-11K IS REQUIRED.
	DOCUMENTATION IS PROVIDED BY THE FILE RMSFTN.TXT
 
 
		A.P. GAUGHAN, JR.
		BRIDGEPORT-TEXTRON
		PRECISION RD.
		HORSHAM, PA.  19044
-h- rms.ext	Wed Jul 28 11:08:29 1982	RMS.EXT;1
		RMFFLU	- RMS Flush an I/O Buffer
		RMSCLO	- RMS Close a file
		RMSCON	- RMS Connect a Record Access Stream
		RMSDEL	- RMS Delete a Record
		RMSDIS	- RMS Disconnect a Record Access Stream
		RMSFND	- RMS Find a Record
		RMSFRE	- RMS Free a locked Bucket
		RMSGET	- RMS Get a Record
		RMSKEY	- RMS Specify Key of Reference
		RMSOPE	- RMS Open a file
		RMSPUT	- RMS Put a Record
		RMSRAC	- RMS Specify Record Access mode
		RMSRWD	- RMS Rewind the file
		RMSUPD	- RMS Update a Record
-h- rmsclo.mac	Wed Jul 28 11:08:29 1982	RMSCLO.MAC;1
	.TITLE	RMSCLO
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSCLO			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE: $RLCB			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSCLO (LUN,ISTAT)					   O
;N		CALLG RMSCLO <#LUN,#ISTAT>				   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	FABOF$,FAB$BT,RABOF$,RAB$BT,$DISCONNECT,$CLOSE
	.MCALL	SMACIT
	;
	;
	;
	FABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	FAB$BT	DFIN$L			;DEFINE FAB BIT PATTERNS LOCALLY
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	ISTAT=4
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSCLO,GLOBAL
	;
	;
	;
	IFB (R5) NE #2			;TWO ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R0 := @LUN(R5)		;PICK UP LUN
	LET R0 := R0 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R0) EQ #0		;FILE OPEN ON LUN?
	  LET @ISTAT(R5) := #XX$OPN	;SAY NO FILE OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R0) NE #0		;RECORD STREAM STILL CONNECTED?
	  LET R2 := $$$RAB(R0)		;IF SO, PICK UP RAB ADDRESS
	  $DISCONNECT	R2		;DISCONNECT THE RECORD ACCESS STREAM
	  LET $$$RAB(R0) := #0		;ZERO THE TABLE ENTRY
	  PUSH R0			;SAVE TABLE INDEX
	  $CALL $RLCB <#$$$RMS,#RB$BLN,R2>	;RELEASE THE RAB
	  POP R0			;RESTORE TABLE INDEX
	END
	;
	;
	;
	LET R2 := $$$FAB(R0)		;PICK UP FAB ADDRESS
	$CLOSE	R2			;CLOSE THE FILE
	LET @ISTAT(R5) := O$STS(R2)	;SET STATUS
	LET $$$FAB(R0) := #0		;ZERO THE TABLE ENTRY
	$CALL $RLCB <#$$$RMS,#FB$BLN,R2>	;RELEASE THE FAB
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmscon.mac	Wed Jul 28 11:08:29 1982	RMSCON.MAC;1
	.TITLE	RMSCON
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSCON			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE: $RQCB, $RLCB, $ZECB	   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSCON (LUN,KEYNUM,MODE,RECBUF,RECSIZ,ISTAT)	   O
;N	CALLG RMSCON <#LUN,#KEYNUM,#MODE,#RECBUF,#RECSIZ,#ISTAT>	   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	$CONNECT
	.MCALL	RABOF$,RAB$BT
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	KEYNUM=4
	MODE=6
	RECBUF=10
	RECSIZ=12
	ISTAT=14
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSCON,GLOBAL
	;
	;
	;
	IFB (R5) NE #6			;SIX ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;STATUS BLOCK SPECIFIED?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) NE #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM ALREADY CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	IF RECBUF(R5) EQ #NULARG OR RECSIZ(R5) EQ #NULARG;NULL BUFFER ARGUMENTS?
	  LET @ISTAT(R5) := #XX$NOP	;SAY NO OPERATION POSSSIBLE
	  $RETURN			;RETURN TO CALLER
	END
	IF KEYNUM(R5) NE #NULARG	;KEY OF REFERENCE SPECIFIED?
	  LET R0 := $$$FAB(R2)		;YES, GET FAB POINTER
	  IFB @KEYNUM(R5) HIS O$CTX(R0)	;LEGAL KEY NUMBER?
	    LET @ISTAT(R5) := #XX$KEY	;NOPE, SAY ILLEGAL KEY NUMBER
	    $RETURN			;RETURN TO CALLER
	  END
	END
	IF MODE(R5) NE #NULARG AND @MODE(R5) HI #RB$RFA	;ILLEGAL ACCESS MODE?
	  LET @ISTAT(R5) := #XX$RAC	;YES, SET ILLEGAL ACCESS MODE
	  $RETURN			;RETURN TO CALLER
	END
	PUSH R2				;SAVE LUN INDEX
	;
	;
	;
	$CALL $RQCB <#$$$RMS,#RB$BLN>	;ALLOCATE A RAB
	ON.ERROR			;ALLOCATION ERROR -
	  LET @ISTAT(R5) := #XX$ALL	;SAY ALLLOCATION ERROR
	  POP R2			;RESTORE STACK
	  $RETURN			;RETURN TO CALLER
	END
	$CALL $ZECB <R0,#RB$BLN>	;ZERO RAB BLOCK
	LET O$BID(R0) :B= #RB$BID	;SET RAB IDENTIFIER
	LET O$BLN(R0) :B= #RB$BLN	;SET SIZE OF RAB
	IF MODE(R5) EQ #NULARG		;ACCESS MODE SPECIFIED?
	  LET O$RAC(R0) :B= #RB$KEY	;NOPE, SET KEYED ACCESS BY DEFAULT
	ELSE
	  LET O$RAC(R0) :B= @MODE(R5)	;YES, SET ACCESS MODE
	END
	IF KEYNUM(R5) NE #NULARG	;KEY OF REFERENCE SPECIFIED?
	  LET O$KRF(R0) :B= @KEYNUM(R5)	;YES, OVERRIDE PRIMARY KEY DEFAULT
	END
	LET O$USZ(R0) := @RECSIZ(R5)	;SET USER RECORD AREA SIZE
	LET O$UBF(R0) := RECBUF(R5)	;SET USER RECORD AREA ADDR
	LET O$RSZ(R0) := @RECSIZ(R5)	;SET RECORD BUFFER SIZE
	LET O$RBF(R0) := RECBUF(R5)	;SET RECORD AREA ADDR
	LET O$MBF(R0) :B= #2		;SET MULTI-BUFFER COUNT
	POP R2				;RESTORE LUN INDEX
	LET O$FAB(R0) := $$$FAB(R2)	;SET FAB ADDRESS
	$CONNECT	R0		;CONNECT A RECORD ACCESS STREAM
	IF O$STS(R0) NE #SU$SUC		;CONNECT SUCCESSFUL?
	  LET @ISTAT(R5) := O$STS(R0)	;SET FAILURE CODE
	  $CALL $RLCB <#$$$RMS,#RB$BLN,R0>	;RELEASE THE RAB
	  $RETURN			;RETURN TO CALLER
	END
	LET $$$RAB(R2) := R0		;INSERT RAB ADDRESS INTO TABLE
	LET @ISTAT(R5) := #SU$SUC	;SET SUCCESS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsdel.mac	Wed Jul 28 11:08:29 1982	RMSDEL.MAC;1
	.TITLE	RMSDEL
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSDEL			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSDEL (LUN,ISTAT)					   O
;N		CALLG RMSDEL <#LUN,#ISTAT>				   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$DELETE
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	ISTAT=4
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSDEL,GLOBAL
	;
	;
	;
	IFB (R5) NE #2			;TWO ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	$DELETE	R0			;DELETE THE RECORD
	LET @ISTAT(R5) := O$STS(R0)	;RETURN STATUS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsdfn.mac	Wed Jul 28 11:08:29 1982	RMSDFN.MAC;1
	.PAGE
	.TITLE	RMSDFN
	.IDENT	/01.01/						;JAN18APG
	.NLIST	BEX						;**-1
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: DEFINE DATA AREAS FOR RMS-FTN INTERFACE		   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: SEE LISTING		   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CONFIGURATION DEPENDENT PARAMETERS VIA COMMAND PREFIX FILE O
;N									   N
;!	OUTPUTS:							   !
;!									   !
;H	HOUSEKEEPING: ADD SUPPORT FOR APPROX MATCH APG JAN 18-19 1979	   H
;O									   O
;R									   R
;S	NOTES: SUPPORTS INDEXED ORGANIZATION ONLY			   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	ORG$,POOL$B,FABOF$,RABOF$,XABOF$
	;
	;
	;
	FABOF$	RMS$L
	RABOF$	RMS$L
	XABOF$	RMS$L
	;
	;
	;
	;GLOBAL DEFINITIONS
	;
	;
	;
	SP$BLN	==	32.		;SIZE OF A FILESPEC BLOCK
	XX$LUN	==	-1		;NO LUN SPECIFIED
	XX$OPN	==	-2		;FILE ALREADY OPENED/CLOSED
	XX$ALL	==	-3		;INTERNAL ALLOCATION ERROR
	XX$STM	==	-4		;STREAM ALREADY CONNECTED/DISCONNECTED
	XX$KEY	==	-5		;ILLEGAL KEY NUMBER FOR THIS FILE
	XX$NOP	==	-6		;NO OPERATION POSSIBLE
	XX$RFA	==	-7		;ILLEGAL PUT OPERATION (RFA MODE)
	XX$RAC	==	-8.		;ILLEGAL RECORD ACCESS MODE
	XX$FAC	==	-9.		;ILLEGAL FILE ACCESS RIGHTS REQUESTED
	XX$ROP	==	-10.		;ILLEGAL RECORD		;JAN18APG
					;PROCESSING REQUESTED	;JAN18APG
	;
	NOPEN = 4
	NCHGES = 1
	BIGKEY = 24
	NKEYS = 1
	MAXLUN = 10
	;
	;
	ORG$	IDX,<FIN,GET,PUT,UPD,DEL>
	POOL$B
	P$BDB	<4*NOPEN>
	P$FAB	NOPEN
	P$RABX	NOPEN,BIGKEY,NCHGES
	P$IDX	NKEYS
	P$BUF	<<<512.*2>*NOPEN>>
	POOL$E
	;
	;
	;
	.PSECT	$$$RMS
$$$RMS::
	.WORD	..FREE
	.WORD	0
..FREE:
	.WORD	0
$$$SIZ=	<<<FB$BLN+10>+<RB$BLN+10>>*NOPEN>
	.WORD	$$$SIZ
	.BLKB	$$$SIZ
	;
	;
	;
	.PSECT	$$$FAB
$$$FAB::
	.BLKW	<MAXLUN+1>		;ACCOUNT FOR LUN '0'
	;
	;
	;
	.PSECT	$$$RAB
$$$RAB::
	.BLKW	<MAXLUN+1>		;ACCOUNT FOR LUN '0'
	;
	;
	;
	.PSECT	$$$SYS
DEFALT::
	.ASCII	/SY0:/
DEFSIZ==<.-DEFALT>
	;
	;
	;
	.PSECT
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsdis.mac	Wed Jul 28 11:08:29 1982	RMSDIS.MAC;1
	.TITLE	RMSDIS
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSDIS			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE: $RLCB			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSDIS (LUN,ISTAT)					   O
;N		CALLG RMSDIS <#LUN,#ISTAT>				   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$DISCONNECT
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	ISTAT=4
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSDIS,GLOBAL
	;
	;
	;
	IFB (R5) NE #2			;TWO ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R0 := @LUN(R5)		;PICK UP LUN
	LET R0 := R0 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$RAB(R0) EQ #0		;RECORD STREAM CONNECTED?
	  LET @ISTAT(R5) := #XX$STM		;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R2 := $$$RAB(R0)		;PICK UP RAB ADDRESS
	$DISCONNECT	R2		;DISCONNECT THE RECORD ACCESS STREAM
	LET @ISTAT(R5) := O$STS(R2)	;SET STATUS
	LET $$$RAB(R0) := #0		;ZERO THE TABLE ENTRY
	$CALL $RLCB <#$$$RMS,#RB$BLN,R2>	;RELEASE THE RAB
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsfls.mac	Wed Jul 28 11:08:29 1982	RMSFLS.MAC;1
	.TITLE	RMSFLS
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSFLS			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSFLS (LUN,ISTAT)					   O
;N		CALLG RMSFLS <#LUN,#ISTAT>				   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$FLUSH
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	ISTAT=4
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSFLS,GLOBAL
	;
	;
	;
	IFB (R5) NE #2			;TWO ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	$FLUSH	R0			;FLUSH THE BUFFERS
	LET @ISTAT(R5) := O$STS(R0)	;RETURN STATUS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsfnd.mac	Wed Jul 28 11:08:29 1982	RMSFND.MAC;1
	.TITLE	RMSFND
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSFND			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSFND (LUN,IRFA,ISTAT)				   O
;N		CALLG RMSFND <#LUN,#IRFA,#ISTAT>			   N
;!	OUTPUTS: ISTAT, IRFA(CONDITIONALLY)				   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$FIND
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	IRFA=4
	ISTAT=6
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSFND,GLOBAL
	;
	;
	;
	IFB (R5) NE #3			;THREE ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	IFB O$RAC(R0) EQ #RB$RFA	;RFA MODE?
	  IF IRFA(R5) EQ #NULARG	;NULL ARGUMENT?
	    LET @ISTAT(R5) := #XX$NOP	;SAY NO OPERATION POSSIBLE
	    $RETURN			;RETURN TO CALLER
	  END
	  LET R1 := IRFA(R5)		;PICK UP RFA POINTER
	  LET O$RFA(R0) := (R1)+	;STUFF
	  LET O$RFA+2(R0) := (R1)+	;THE
	  LET O$RFA+4(R0) := (R1)	;RFA
	END
	$FIND	R0			;FIND THE RECORD
	LET @ISTAT(R5) := O$STS(R0)	;SET STATUS
	IF O$STS(R0) EQ #SU$SUC		;SUCCESS??
	  IF IRFA(R5) NE #NULARG	;PLACE TO PUT RFA?
	    LET R1 := IRFA(R5)		;PICK UP RFA POINTER TO RETURN
	    LET (R1)+ := O$RFA(R0)	;RETURN
	    LET (R1)+ := O$RFA+2(R0)	;THE
	    LET (R1) := O$RFA+4(R0)	;RFA
	  END
	END
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsfre.mac	Wed Jul 28 11:08:29 1982	RMSFRE.MAC;1
	.TITLE	RMSFRE
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSFRE			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSFRE (LUN,ISTAT)					   O
;N		CALLG RMSFRE <#LUN,#ISTAT>				   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$FREE
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	ISTAT=4
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSFRE,GLOBAL
	;
	;
	;
	IFB (R5) NE #2			;TWO ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	$FREE	R0			;FREE THE BUCKET
	LET @ISTAT(R5) := O$STS(R0)	;RETURN STATUS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsftn.asm	Wed Jul 28 11:08:29 1982	RMSFTN.ASM;1
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
MAC RMSOPE,LS:RMSOPE=[1,1]RMSMAC/ML,'$MYUIC'RMSOPE
MAC RMSCLO,LS:RMSCLO=[1,1]RMSMAC/ML,'$MYUIC'RMSCLO
MAC RMSCON,LS:RMSCON=[1,1]RMSMAC/ML,'$MYUIC'RMSCON
MAC RMSDIS,LS:RMSDIS=[1,1]RMSMAC/ML,'$MYUIC'RMSDIS
MAC RMSGET,LS:RMSGET=[1,1]RMSMAC/ML,'$MYUIC'RMSGET
MAC RMSPUT,LS:RMSPUT=[1,1]RMSMAC/ML,'$MYUIC'RMSPUT
MAC RMSFND,LS:RMSFND=[1,1]RMSMAC/ML,'$MYUIC'RMSFND
MAC RMSUPD,LS:RMSUPD=[1,1]RMSMAC/ML,'$MYUIC'RMSUPD
MAC RMSDEL,LS:RMSDEL=[1,1]RMSMAC/ML,'$MYUIC'RMSDEL
MAC RMSRWD,LS:RMSRWD=[1,1]RMSMAC/ML,'$MYUIC'RMSRWD
MAC RMSRAC,LS:RMSRAC=[1,1]RMSMAC/ML,'$MYUIC'RMSRAC
MAC RMSKEY,LS:RMSKEY=[1,1]RMSMAC/ML,'$MYUIC'RMSKEY
MAC RMSFRE,LS:RMSFRE=[1,1]RMSMAC/ML,'$MYUIC'RMSFRE
MAC RMSFLS,LS:RMSFLS=[1,1]RMSMAC/ML,'$MYUIC'RMSFLS
MAC ZECB,LS:ZECB=ZECB
-h- rmsftn.cmd	Wed Jul 28 11:08:29 1982	RMSFTN.CMD;1
.ENABLE SUBSTITUTION
.ENABLE DATA
.SETS SEMI ";"
.SETS MYUIC <UIC>
PIP RMSDFN.OBJ;*/DE
.ASKS OPEN SUPPLY THE NUMBER OF RMS FILES TO BE OPEN SIMULTANEOUSLY
.ASKS KEYS SUPPLY THE TOTAL NUMBER OF DEFINED KEYS ACROSS THESE FILES
.ASKS LRGKEY SUPPLY THE SIZE IN BYTES OF THE LARGEST KEY ACROSS THESE FILES
.ASKS CHGES SUPPLY THE TOTAL NUMBER OF CHANGEABLE KEYS ACROSS THESE FILES
.ASKS HILUN SUPPLY THE MAXIMUM LUN ASSIGNED FOR THE TARGET TASK
.OPEN RMSPRE.MAC
'SEMI'     *****     CONFIGURATION DEPENDENT DEFINITIONS     *****
'SEMI'
'SEMI'
'SEMI'
'SEMI'
NOPEN	==	'OPEN'
NKEYS	==	'KEYS'
BIGKEY	==	'LRGKEY'
NCHGES	==	'CHGES'
MAXLUN	==	'HILUN'
$$$LST	==	0
'SEMI'
'SEMI'
'SEMI'
'SEMI'
'SEMI'     *****     END OF CONFIGURATION DEPENDENT DEFINITIONS     *****
.CLOSE
;
;
;
;
;
MAC RMSDFN,RMSDFN=[1,1]RMSMAC/ML,'MYUIC'RMSPRE,[1,10]RMSDFN
PIP /FO/NV=[1,10]RMSFTN.OLB;1
LBR RMSFTN/RP=RMSDFN
PIP RMSDFN.OBJ;*/DE
;
;!!!<DONE>!!!
-h- rmsftn.mak	Wed Jul 28 11:08:29 1982	RMSFTN.MAK;1
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.SETS $MYUIC <UIC>
.ASK LIST DO YOU WANT THE LISTINGS
.ASK INDEX DO YOU WANT THE LIBRARY INDICES
.IFT LIST ASN SY:=LS:
.IFF LIST ASN NL:=LS:
.IFT INDEX ASN SY:=IX:
.IFF INDEX ASN NL:=IX:
PIP *.OLB;*/DE,*.OBJ;*,*.LST;*,*.COB;*
@RMSFTN.ASM
PIP RMSFTN.COB=*.OBJ
PIP *.OBJ;*/DE
LBR RMSFTN/CR:30.:64.:64.:OBJ,IX:RMSFTN.LST/LE/FU=RMSFTN.COB
PIP *.COB;*/DE
ASN =LS:
ASN =IX:
;!!!<DONE>!!!
-h- rmsftn.txt	Wed Jul 28 11:08:29 1982	RMSFTN.TXT;1
	THIS DOCUMENT DESCRIBES THE USER INTERFACE TO THE 'RMSFTN' RUN-TIME SYS-
TEM. IT IS PRESUMED THAT THE PROSPECTIVE USER IS WELL ACQUAINTED WITH RMS CON-
CEPTS AS WELL AS THE RMS-MACRO INTERFACE AS DESCRIBED IN THE RMS-11 MACRO PRO-
GRAMMER'S REFERENCE MANUAL. THE 'RMSFTN' RUN-TIME SYSTEM IS WRITTEN IN SUPERMAC.
THE CALLS ARE VANILLA FLAVORED FORTRAN WITH ALL ARGUMENTS BEING PASSED AS
PARAMETERS IN THE CALL LIST. THE 'RMSFTN' RUN-TIME SYSTEM SUPPORTS ONLY THE RMS
INDEXED FILE ORGANIZATION AND ALL OPERATIONS ARE SYNCHRONOUS. ALTHOUGH RMS SUP-
PORTS MULTIPLE ACCESS STREAMS TO A SINGLE FILE, THIS VERSION OF THE 'RMSFTN' IN-
TERFACE SUPPORTS ONLY A SINGLE RECORD ACCESS STREAM PER FILE. THIS ARISES BE-
CAUSE OF THE ASSOCIATION OF A RECORD ACCESS STREAM WITH A LUN AND THE INTERNAL
ASSOCIATION OF A RECORD ACCESS BLOCK WITH A FILE ACCESS BLOCK. IN ORDER FOR THE
USER TO IMPLEMENT THE CALLS LISTED BELOW HE SHOULD KNOW IN ADVANCE THE NUMBER
OF INDEXED-SEQUENTIAL FILES THAT HIS (FORTRAN) TASK WILL ACCESS AS WELL AS THE
IMPORTANT CHARACTERISTICS OF THESE FILES. ONCE THIS INFORMATION IS IN HAND HE
SHOULD THEN CREATE A TAILORED VERSION OF RMSFTN.OLB FOR HIS TASK BY COPYING
THE INTERACTIVE COMMAND FILE RMSFTN.CMD FROM MM:[311,6] TO HIS DIRECTORY AND THEN
INVOKING IT: >@RMSFTN . THIS COMMAND FILE WILL PROMPT THE USER FOR THE FILE
CHARACTERISTICS NECESSARY TO TAILOR THE RUN-TIME LIBRARY. THE FILE RELATED
QUESTIONS ARE AS FOLLOWS:
 
 
	1) SUPPLY THE NUMBER OF RMS FILES TO BE OPEN SIMULTANEOUSLY
	2) SUPPLY THE TOTAL NUMBER OF DEFINED KEYS ACROSS THESE FILES
	3) SUPPLY THE SIZE IN BYTES OF THE LARGEST KEY ACROSS THESE FILES
	4) SUPPLY THE TOTAL NUMBER OF CHANGEABLE KEYS ACROSS THESE FILES
	5) SUPPLY THE MAXIMUM LUN ASSIGNED FOR THE TARGET TASK
THE FORTRAN CALLS TO THE 'RMSFTN' RUN-TIME SYSTEM ARE AS FOLLOWS:
 
CALL RMSOPE(LUN,FILSPC,IFAC,ISHR,ISTAT)		OPEN THE SPECIFIED FILE
CALL RMSCLO(LUN,ISTAT)				CLOSE THE FILE - ANY CONNECTED
						RECORD ACCESS STREAM WILL BE
						AUTOMATICALLY DISCONNECTED
						PRIOR TO CLOSING THE FILE
CALL RMSCON(LUN,KEYNUM,MODE,RECBUF,RECSIZ,ISTAT)
						CONNECT A RECORD ACCESS STREAM
CALL RMSDIS(LUN,ISTAT)				DISCONNECT RECORD ACCESS STREAM
CALL RMSGET(LUN,IRFA,ISTAT)			GET A RECORD
CALL RMSPUT(LUN,IRFA,ISTAT)			PUT A RECORD
CALL RMSFND(LUN,IRFA,ISTAT)			FIND A RECORD
CALL RMSUPD(LUN,IRFA,ISTAT)			UPDATE A RECORD
CALL RMSDEL(LUN,ISTAT)				DELETE A RECORD
CALL RMSRWD(LUN,ISTAT)				REWIND THE FILE
CALL RMSRAC(LUN,MODE,ISTAT)			SPECIFY RMS ACCESS MODE
CALL RMSKEY(LUN,KEYNUM,KEYBUF,KEYSIZ,IROP,ISTAT)
						SPECIFY RMS KEY OF REFERENCE/
						SPECIFY RMS KEY BUFFER & SIZE/
						SPECIFY APPROXIMATE MATCH
CALL RMSFRE(LUN,ISTAT)				FREE A LOCKED BUCKET
CALL RMSFLS(LUN,ISTAT)				FLUSH AN I/O BUFFER
 
 
 
 
THE SUPERMAC* CALLS TO THE 'RMSFTN' RUN-TIME SYSTEM ARE AS FOLLOWS:
 
CALLG RMSOPE <#LUN,#FILSPC,#IFAC,#ISHR,#ISTAT>	OPEN THE SPECIFIED FILE
CALLG RMSCLO <#LUN,#ISTAT>			CLOSE THE FILE - ANY CONNECTED
						RECORD ACCESS STREAM WILL BE
						AUTOMATICALLY DISCONNECTED
						PRIOR TO CLOSING THE FILE
CALLG RMSCON <#LUN,#KEYNUM,#MODE,#RECBUF,#RECSIZ,#ISTAT>
						CONNECT A RECORD ACCESS STREAM
CALLG RMSDIS <#LUN,#ISTAT>			DISCONNECT RECORD ACCESS STREAM
CALLG RMSGET <#LUN,#IRFA,#ISTAT>		GET A RECORD
CALLG RMSPUT <#LUN,#IRFA,#ISTAT>		PUT A RECORD
CALLG RMSFND <#LUN,#IRFA,#ISTAT>		FIND A RECORD
CALLG RMSUPD <#LUN,#IRFA,#ISTAT>		UPDATE A RECORD
CALLG RMSDEL <#LUN,#ISTAT>			DELETE A RECORD
CALLG RMSRWD <#LUN,#ISTAT>			REWIND THE FILE
CALLG RMSRAC <#LUN,#MODE,#ISTAT>		SPECIFY RMS ACCESS MODE
CALLG RMSKEY <#LUN,#KEYNUM,#KEYBUF,#KEYSIZ,#IROP,#ISTAT>
						SPECIFY RMS KEY OF REFERENCE/
						SPECIFY RMS KEY BUFFER & SIZE/
						SPECIFY APPROXIMATE MATCH
CALLG RMSFRE <#LUN,#ISTAT>			FREE A LOCKED BUCKET
CALLG RMSFLS <#LUN,#ISTAT>			FLUSH AN I/O BUFFER
 
 
 
 
 
* SUPERMAC V46 OR HIGHER IS REQUIRED
VARIABLE DEFINITIONS ARE AS FOLLOWS:
 
 
LUN	INTEGER*2 VARIABLE SPECIFYING THE LOGICAL UNIT NUMBER - MUST BE SUPPLIED
	FOR ALL CALLS.
 
FILSPC	BYTE ARRAY(MAX = 30.) CONTAINING THE FILESPEC AND TERMINATED BY A NULL
	BYTE. MUST BE SUPPLIED.
 
IFAC	INTEGER*2 VARIABLE SPECIFYING THE FILE ACCESS RIGHTS DESIRED
	IFAC = 0	READ ONLY ACCESS (GET AND FIND)
	     = 1	EXTEND ACCESS (GET, FIND, AND PUT)
	     = 2	MODIFY ACCESS (GET, FIND, AND UPDATE)
	     = 3	WRITE ACCESS (GET, FIND, PUT, UPDATE, AND DELETE)
	IF THE ARGUMENT IS NULL, THEN THE RESULT IS THE SAME AS IFAC = 0.
 
ISHR	INTEGER*2 VARIABLE SPECIFYING THE SHARED ACCESS FLAG.
	ISHR = 0	NO SHARED ACCESS DESIRED
	     = 1	SHARED ACCESS DESIRED
	IF THE ARGUMENT IS NULL, THEN THE RESULT IS THE SAME AS ISHR = 0.
 
ISTAT	INTEGER*2 VARIABLE FOR STATUS RETURNS - MUST BE SUPPLIED FOR ALL CALLS.
	POSSIBLE STATUS RETURNS ARE:
		1) -1 NO LUN SPECIFIED
		2) -2 FILE ALREADY OPENED/CLOSED
		3) -3 INTERNAL ALLOCATION ERROR - PROBABLY TO MANY FILES OPEN
		4) -4 ACCESS STREAM ALREADY CONNECTED/DISCONNECTED
		5) -5 ILLEGAL KEY NUMBER FOR THIS FILE
		6) -6 NO OPERATION POSSIBLE - NULL ARGUMENT OUT OF CONTEXT
		7) -7 PUT OPERATION IN RFA MODE (IS ILLEGAL)
		8) -8 ILLEGAL RECORD ACCESS MODE (PROBABLY BAD MODE PARAMETER)
		9) -9 ILLEGAL (UNRECOGNIZED) FILE ACCESS RIGHTS REQUESTED
		10) -10 ILLEGAL RECORD PROCESSING OPTION REQUESTED
		11) ALL POSSIBLE RMS STATUS RETURNS (APPENDIX A, RMS-11 MACRO
		   PROGRAMMER'S REFERENCE MANUAL)
 
RECBUF	BYTE ARRAY TO SERVE AS THE RMS RECORD BUFFER. MUST BE SUPPLIED.
 
RECSIZ	INTEGER*2 VARIABLE SPECIFYING THE SIZE (IN BYTES) OF RECBUF. MUST
	BE SUPPLIED.
 
IRFA	INTEGER*2 ARRAY DIMENSIONED @ 3 TO EITHER SUPPLY OR RECEIVE THE
	RECORD'S FILE ADDRESS DEPENDING ON CONTEXT. IN CERTAIN CONTEXTS
	THIS ARGUMENT MAY BE NULL: KEYED ACCESS OPERATIONS (MODE = 1).
 
MODE	INTEGER*2 VARIABLE SPECIFYING THE RECORD ACCESS MODE:
	0 = SEQUENTIAL; 1 = RANDOM(KEY); 2 = RFA.
	IF THE ARGUMENT IS NULL IN THE CALL TO 'RMSCON', THE DEFAULT
	IS RANDOM(KEY) ACCESS. THE ARGUMENT MUST BE SUPPLIED IN THE
	CALL TO 'RMSRAC'.
 
KEYNUM	INTEGER*2 VARIABLE SPECIFYING THE KEY NUMBER OF REFERENCE, E.G. -
	0 = PRIMARY; 1 = 1ST ALTERNATE; ETC.ETC.
	IF THIS ARGUMENT IS NULL IN THE CALL TO 'RMSCON', THE KEY OF REFERENCE
	WILL BE THE PRIMARY KEY BY DEFAULT.
	IF THIS ARGUMENT IS NULL IN THE CALL TO 'RMSKEY', THE KEY OF REFERENCE
	WILL BE UNCHANGED.
 
KEYBUF	BYTE ARRAY TO SERVE AS THE KEY BUFFER - MAY BE EQUIVALENCED IN
	RECBUF. MUST BE SUPPLIED.
 
KEYSIZ	INTEGER*2 VARIABLE SPECIFYING THE SIZE (IN BYTES) OF KEYBUF. MUST
	BE SUPPLIED.
IROP	INTEGER*2 VARIABLE SPECIFYING THE MATCH FACILITY DESIRED. IF THIS
	ARGUMENT IS NULL, THEN THE MATCH OPTION WILL BE UNCHANGED.
	IROP = 0	EXACT MATCH (DEFAULT)
	     = 1	APPROXIMATE MATCH, .GT.
	     = 2	APPROXIMATE MATCH, .GE.
 
 
 
 
IN THOSE SITUATIONS WHERE NO STATUS RETURN IS POSSIBLE (INCORRECTLY FORMATTED
CALL) THE 'RMSFTN' RUN-TIME SYSTEM WILL TAKE AN INTERNAL SST FAULT VIA A TRAP
OR EMT INSTRUCTION.
IN ORDER TO LINK THE 'RMSFTN' RUN-TIME SYSTEM TO YOUR TASK IT IS NECESSARY
TO HAVE A TAILORED RMSFTN.OLB IN YOUR DIRECTORY AS DESCRIBED ABOVIRED. IF THIS
	ARGUMENT IS NULL, THEN THE MATCH OPTION WILL BE UNCHANGED.
	IROP = 0	EXACT MATCH (DEFAULT)
	     = 1	APPROXIMATE MATCH, .GT.
	     = 2	APPROXIMATE MATCH, .GE.
 
 
 
 
IN THOSE SITUATIONS WHERE NO STATUS RETURN IS POSSIBLE (INCORRECTLY FORMATTED
CALL) THE 'RMSFTN' RUN-TIME SYSTEM WILL TAKE AN INTERNAL SST FAULT VIA A TRAP
OR EMT INSTRUCTION.
IN ORDER TO LINK THE 'RMSFTN' RUN-TIME SYSTEM TO YOUR TASK IT IS NECESSARY
TO HAVE A TAILORED RMSFTN.OLB IN YOUR DIRECTORY AS DESCRIBED ABOVE AND TO
INCLUDE A REFERENCE TO THIS LIBRARY IN YOUR TASKBUILD COMMAND FILE. IN ORDER
TO FACILITATE THE PROCESS OF TASKBUILDING YOUR TASK, SEVERAL PROTOTYPE TASK-
BUILD COMMAND FILES ARE AVAILABLE. MYPROG.NOV IS A PROTOTYPE TASKBUILD COM-
MAND FILE WHICH YOU MAY COPY INTO YOUR UIC FROM MM:[311,6] AND EDIT ACCORD-
ING TO THE INSTRUCTIONS CONTAINED IN THE FILE. THIS COMMAND FILE WILL BUILD
YOUR TASK WITH AN UNOVERLAID RMS RUN-TIME SYSTEM WHICH WILL BE VERY FAST
BUT SOMEWHAT WASTEFUL OF CORE. SUCH A TASK IS LIMITED TO APPROXIMATELY 18K
WORDS BECAUSE THE RMS RUN-TIME SYSTEM AND THE FCS CORE RESIDENT LIBRARY
TAKE APPROXIMATELY 14K. MYPROG.BLD IS A PROTOTYPE TASKBUILD COMMAND FILE
WHICH YOU MAY COPY FROM MM:[311,6] AND EDIT ACCORDING TO THE INSTRUCTIONS CON-
TAINED IN THE FILE. THIS COMMAND FILE WILL BUILD YOUR TASK WITH AN OVER-
LAID RMS RUN-TIME SYSTEM WHICH IS 6K IN SIZE AND SOMEWHAT SLOWER IN EXECU-
TION. IN ORDER TO UTILIZE THIS COMMAND FILE IT IS NECESSARY TO COPY
MYPROG.ODL AND RMS11M.ODL FROM MM:[311,6] INTO YOUR DIRECTORY AND TO EDIT MYPROG.
ODL ACCORDING TO THE INSTRUCTIONS CONTAINED IN THE FILE. TASKS WHICH USE
THIS TASKBUILD COMMAND FILE ARE LIMITED TO APPROXIMATELY 22K AGAIN BECAUSE 
OF THE SIZE OF THE RMS RUN-TIME SYSTEM AND THE FCS CORE RESIDENT LIBRARY.
 
 
				APG 6/5/78
-h- rmsget.mac	Wed Jul 28 11:08:29 1982	RMSGET.MAC;1
	.TITLE	RMSGET
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSGET			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSGET (LUN,IRFA,ISTAT)				   O
;N		CALLG RMSGET <#LUN,#IRFA,#ISTAT>			   N
;!	OUTPUTS: ISTAT, IRFA(CONDITIONALLY)				   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$GET
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	IRFA=4
	ISTAT=6
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSGET,GLOBAL
	;
	;
	;
	IFB (R5) NE #3			;THREE ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	IFB O$RAC(R0) EQ #RB$RFA	;RFA MODE?
	  IF IRFA(R5) EQ #NULARG	;NULL ARGUMENT?
	    LET @ISTAT(R5) := #XX$NOP	;SAY NO OPERATION POSSIBLE
	    $RETURN			;RETURN TO CALLER
	  END
	  LET R1 := IRFA(R5)		;PICK UP RFA POINTER
	  LET O$RFA(R0) := (R1)+	;STUFF
	  LET O$RFA+2(R0) := (R1)+	;THE
	  LET O$RFA+4(R0) := (R1)	;RFA
	END
	$GET	R0			;GET THE RECORD
	LET @ISTAT(R5) := O$STS(R0)	;SET STATUS
	IF O$STS(R0) EQ #SU$SUC		;SUCCESS??
	  IF IRFA(R5) NE #NULARG	;PLACE TO PUT RFA?
	    LET R1 := IRFA(R5)		;PICK UP RFA POINTER TO RETURN
	    LET (R1)+ := O$RFA(R0)	;RETURN
	    LET (R1)+ := O$RFA+2(R0)	;THE
	    LET (R1) := O$RFA+4(R0)	;RFA
	  END
	ELSE
	  LET O$RBF(R0) := O$UBF(R0)	;RESTORE RECORD BUFFER ADDRESS
	  LET O$RSZ(R0) := O$USZ(R0)	;RESTORE RECORD BUFFER SIZE
	END
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmskey.mac	Wed Jul 28 11:08:29 1982	RMSKEY.MAC;1
	.TITLE	RMSKEY
	.IDENT	/01.01/						;JAN18APG
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSKEY			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSKEY (LUN,KEYNUM,KEYBUF,KEYSIZ,IROP,ISTAT)	   O
;N		CALLG RMSKEY <#LUN,#KEYNUM,#KEYBUF,#KEYSIZ,#IROP,#ISTAT>   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES: ADD APPROX MATCH FACILITY APG JAN 18-19 1979		   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	FABOF$,FAB$BT,RABOF$,RAB$BT
	.MCALL	SMACIT
	;
	;
	;
	FABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	FAB$BT	DFIN$L			;DEFINE FAB BIT PATTERNS LOCALLY
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	KEYNUM=4
	KEYBUF=6
	KEYSIZ=10
	IROP=12							;JAN18APG
	ISTAT=14						;JAN18APG
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSKEY,GLOBAL
	;
	;
	;
	IFB (R5) NE #6			;SIX ARGUMENTS???	;JAN18APG
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	IF KEYBUF(R5) EQ #NULARG OR KEYSIZ(R5) EQ #NULARG;NULL BUFFER ARG(S)?
	  LET @ISTAT(R5) := #XX$NOP	;SAY NO OPERATION POSSIBLE
	  $RETURN			;RETURN TO CALLER
	END
	IF KEYNUM(R5) NE #NULARG	;KEY OF REFERENCE SPECIFIED?
	  LET R0 := $$$FAB(R2)		;YES, SET FAB ADDRESS
	  IFB @KEYNUM(R5) HIS O$CTX(R0)	;LEGAL KEY NUMBER?
	    LET @ISTAT(R5) := #XX$KEY	;NOPE, SAY ILLEGAL KEY NUMBER
	    $RETURN			;RETURN TO CALLER
	  END
	END
	IF IROP(R5) NE #NULARG		;RECORD OPTS SPECIFIED?	;JAN18APG
	  IF @IROP(R5) HI #2		;YUP, OPTION IN RANGE?	;JAN18APG
	    LET @ISTAT(R5) := #XX$ROP	;NOPE, SAY BAD OPTION	;JAN18APG
	    $RETURN			;RETURN TO CALLER	;JAN18APG
	  END							;JAN18APG
	END							;JAN18APG
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	IF KEYNUM(R5) NE #NULARG	;KEY OF REFERENCE SPECIFIED?
	  LET O$KRF(R0) :B= @KEYNUM(R5)	;YES, SET KEY OF REFERENCE
	END
	LET O$KBF(R0) := KEYBUF(R5)	;SET KEY BUFFER ADDRESS
	LET O$KSZ(R0) :B= @KEYSIZ(R5)	;SET KEY SIZE
	IF IROP(R5) NE #NULARG		;RECORD OPTS SPECIFIED?	;JAN19APG
	  LET O$ROP(R0) := O$ROP(R0) OFF.BY #<RB$KGT!RB$KGE>	;JAN19APG
					;CLEAN OUT DIRTY BITS	;JAN19APG
	  CASE @IROP(R5)		;SELECT NEW BITS	;JAN19APG
	    EXACT			;EXACT MATCH		;JAN19APG
	    .GT.			;APPROX., .GT.		;JAN19APG
	    .GE.			;APPROX., .GE.		;JAN19APG
	  END							;JAN19APG
	END							;JAN19APG
	LET @ISTAT(R5) := #SU$SUC	;SET SUCCESS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;CASED ROUTINES						;JAN19APG
	;							;JAN19APG
	;							;JAN19APG
	;							;JAN19APG
	ENTRYPOINT	.GE.,LOCAL				;JAN19APG
	LET O$ROP(R0) := O$ROP(R0) SET.BY #RB$KGE ;SET .GE.	;JAN19APG
	$RETURN				;RETURN TO CALLER	;JAN19APG
	ENTRYPOINT	.GT.,LOCAL				;JAN19APG
	LET O$ROP(R0) := O$ROP(R0) SET.BY #RB$KGT ;SET .GT.	;JAN19APG
	ENTRYPOINT	EXACT,LOCAL				;JAN19APG
	$RETURN				;RETURN TO CALLER	;JAN19APG
	;							;JAN19APG
	;							;JAN19APG
	;							;JAN19APG
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsope.mac	Wed Jul 28 11:08:29 1982	RMSOPE.MAC;1
	.TITLE	RMSOPE
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSOPE			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE: $RQCB, $RLCB, $ZECB	   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSOPE (LUN,FILSPC,IFAC,ISHR,ISTAT)		   O
;N		CALLG RMSOPE <#LUN,#FILSPC,#IFAC,#ISHR,#ISTAT>		   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	$OPEN,$INITIF
	.MCALL	FABOF$,FAB$BT,XABOF$,XAB$BT
	.MCALL	SMACIT
	;
	;
	;
	FABOF$	RMS$L			;DEFINE FAB OFFSETS LOCALLY
	FAB$BT	DFIN$L			;DEFINE FAB BIT PATTERNS LOCALLY
	XABOF$	RMS$L			;DEFINE XAB OFFSETS LOCALLY
	XAB$BT	DFIN$L			;DEFINE XAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	FILSPC=4
	IFAC=6
	ISHR=10
	ISTAT=12
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSOPE,GLOBAL
	;
	;
	;
	IFB (R5) NE #5			;FIVE ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;STATUS BLOCK SPECIFIED?
	  EMT				;IF NOT QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) NE #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY ALREADY OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF FILSPC(R5) EQ #NULARG	;NULL ARGUMENT?
	  LET @ISTAT(R5) := #XX$NOP	;SAY NO OPERATION POSSIBLE
	  $RETURN			;RETURN TO CALLER
	END
	PUSH R2				;SAVE LUN INDEX
	;
	;
	;
	$CALL $RQCB <#$$$RMS,#FB$BLN>	;ALLOCATE A FAB
	ON.ERROR			;ALLOCATION ERROR -
	  LET @ISTAT(R5) := #XX$ALL	;SAY ALLLOCATION ERROR
	  POP TOP			;RESTORE STACK
	  $RETURN			;RETURN TO CALLER
	END
	PUSH R0				;SAVE FAB POINTER
	$CALL $ZECB <R0,#FB$BLN>	;ZERO FAB BLOCK
	LET O$BID(R0) :B= #FB$BID	;SET FAB IDENTIFIER
	LET O$BLN(R0) :B= #FB$BLN	;SET SIZE OF FAB
	IF IFAC(R5) EQ #NULARG		;DEFAULT FILE ACCESS REQUESTED?
	  LET O$FAC(R0) :B= #FB$GET	;IF SO, SET READ ONLY
	ELSE
	  IF @IFAC(R5) HI #3		;CASE SELECTOR IN RANGE?
	    $CALL $RLCB <#$$$RMS,#FB$BLN,(SP)+>	;IF NOT, RELEASE THE FAB
	    LET @ISTAT(R5) := #XX$FAC		;SAY UNRECOGNIZED FILE ACCESS
	    POP TOP				;RESTORE STACK
	    $RETURN				;RETURN TO CALLER
	  ELSE
	    CASE @IFAC(R5)
	      READONLY			;GET AND FIND ACCESS
	      EXTEND			;GET, FIND, AND PUT ACCESS
	      MODIFY			;GET, FIND, AND UPDATE ACCESS
	      WRITE			;GET, FIND, PUT, UPDATE, AND DELETE
	    END
	  END
	END
	IF ISHR(R5) NE #NULARG		;SHARED ACCESS OPTION SPECIFIED?
	  IF @ISHR(R5) EQ #1		;SHARED ACCESS REQUESTED?
	    LET O$SHR(R0) :B= #FB$WRI	;SET SHARED ACCESS
	  END
	END
	LET O$DNA(R0) := #DEFALT	;SET ADDR OF DEFALT NAME STRING
	LET O$DNS(R0) :B= #DEFSIZ	;AND ITS SIZE
	LET O$LCH(R0) :B= @LUN(R5)	;SET LUN
	;
	;
	;
	$CALL $RQCB <#$$$RMS,#SP$BLN>	;ALLOCATE A SPECIFICATION BLOCK
	ON.ERROR			;ALLOCATION ERROR -
	  $CALL $RLCB <#$$$RMS,#FB$BLN,(SP)+>	;RELEASE THE FAB
	  LET @ISTAT(R5) := #XX$ALL	;SAY ALLOCATION ERROR
	  POP TOP			;RESTORE STACK
	  $RETURN			;RETURN TO CALLER
	END
	$CALL $ZECB <R0,#SP$BLN>	;ZERO THE SPECIFICATION BLOCK
	PUSH R0				;SAVE THE SPEC BLOCK PTR
	LET R2 := FILSPC(R5)		;PICK UP SPEC STRING POINTER
	FOR.ABS R1 := #1 TO #SP$BLN	;INITIALIZE LOOP
	  LET (R0)+ :B= (R2)+		;TRANSFER FILESPEC TO SPEC BLOCK
	  IFB (R2) EQ #0 THEN LEAVE LOOP;DONE ON NULL BYTE
	END
	LET R0 := 2(SP)			;RESTORE FAB ADDRESS
	LET O$FNA(R0) := (SP)		;INSERT SPEC BLOCK ADDRESS IN FAB
	LET O$FNS(R0) :B= R1		;  "     "     "     SIZE   "  "
	;
	;
	;
	$CALL $RQCB <#$$$RMS,#XB$SML>	;ALLOCATE A SUMMARY XAB
	ON.ERROR			;ALLOCATION ERROR -
	  $CALL $RLCB <#$$$RMS,#SP$BLN,(SP)+>	;RELEASE THE SPEC BLOCK
	  $CALL $RLCB <#$$$RMS,#FB$BLN,(SP)+>	;RELEASE THE FAB
	  LET @ISTAT(R5) := #XX$ALL	;SAY ALLOCATION ERROR
	  POP TOP			;RESTORE STACK
	  $RETURN			;RETURN TO CALLER
	END
	$CALL $ZECB <R0,#XB$SML>	;ZERO THE SUMMARY XAB
	LET O$COD(R0) :B= #XB$SUM	;SET XAB IDENTIFIER
	LET R2 := 2(SP)			;RESTORE FAB ADDRESS
	LET O$XAB(R2) := R0		;INSERT XAB ADDRESS IN FAB
	;
	;
	;
	$INITIF				;CONDITIONALLY INITIALIZE RMS
	$OPEN	R2			;OPEN THE FILE
	;
	;
	;
	LET O$FNA(R2) := #0		;ZERO THE SPEC BLK PTR FOR CLEANLINESS
	$CALL $RLCB <#$$$RMS,#SP$BLN,(SP)+>	;RELEASE THE SPEC BLOCK
	LET R0 := (SP)			;RESTORE THE FAB ADDRESS
	LET R2 := O$XAB(R0)		;RESTORE SUMMARY XAB POINTER
	LET O$CTX(R0) :B= O$NOK(R2)	;INSERT # KEYS IN CONTEXT AREA
	LET O$XAB(R0) := #0		;ZERO THE POINTER FOR CLEANLINESS
	$CALL $RLCB <#$$$RMS,#XB$SML,R2>	;RELEASE THE SUMMARY XAB
	POP R2,R0			;RESTORE FAB POINTER AND LUN INDEX
	IF O$STS(R2) NE #SU$SUC		;OPEN SUCCESSFUL?
	  LET @ISTAT(R5) := O$STS(R2)	;SET FAILURE CODE
	  $CALL $RLCB <#$$$RMS,#FB$BLN,R2>	;RELEASE THE FAB
	  $RETURN			;RETURN TO CALLER
	END
	LET $$$FAB(R0) := R2		;INSERT FAB ADDRESS INTO TABLE
	LET @ISTAT(R5) := #SU$SUC	;SET SUCCESS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;CASED ROUTINES
	;
	;
	;
	ENTRYPOINT WRITE
	  LET O$FAC(R0) :B= O$FAC(R0) SET.BY #<FB$DEL!FB$UPD>
	ENTRYPOINT EXTEND
	  LET O$FAC(R0) :B= O$FAC(R0) SET.BY #FB$PUT
	ENTRYPOINT READONLY
	  LET O$FAC(R0) :B= O$FAC(R0) SET.BY #FB$GET
	$RETURN
	ENTRYPOINT MODIFY
	  LET O$FAC(R0) :B= O$FAC(R0) SET.BY #<FB$GET!FB$UPD>
	$RETURN
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsput.mac	Wed Jul 28 11:08:29 1982	RMSPUT.MAC;1
	.TITLE	RMSPUT
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSPUT			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSPUT (LUN,IRFA,ISTAT)				   O
;N		CALLG RMSPUT <#LUN,#IRFA,#ISTAT>			   N
;!	OUTPUTS: ISTAT, IRFA(CONDITIONALLY)				   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$PUT
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	IRFA=4
	ISTAT=6
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSPUT,GLOBAL
	;
	;
	;
	IFB (R5) NE #3			;THREE ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	IFB O$RAC(R0) EQ #RB$RFA	;RFA MODE?
	  LET @ISTAT(R5) := #XX$RFA	;SAY ILLEGAL PUT ATTEMPTED (RFA MODE)
	  $RETURN			;RETURN TO CALLER
	END
	$PUT	R0			;PUT THE RECORD
	LET @ISTAT(R5) := O$STS(R0)	;SET STATUS
	IF O$STS(R0) GE #SU$SUC		;SUCCESS??
	  IF IRFA(R5) NE #NULARG	;PLACE TO PUT RFA?
	    LET R1 := IRFA(R5)		;PICK UP RFA POINTER TO RETURN
	    LET (R1)+ := O$RFA(R0)	;RETURN
	    LET (R1)+ := O$RFA+2(R0)	;THE
	    LET (R1) := O$RFA+4(R0)	;RFA
	  END
	END
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
 LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	IFB O$RAC(R0) EQ #RB$RFA	;RFA MODE?
	  LET @ISTAT(R5) := #XX$RFA	;SAY ILLEGAL PUT ATTEMPTED (RFA MODE)
	  $RETURN			;RETURN TO CALLER
	END
	$PUT	R0			;PUT THE RECORD
	LET @ISTAT(R5) := O$STS(R0)	;SET STATUS
	IF O$STS(R0) GE #SU$SUC		;SUCCESS??
	  IF IRFA(R5) NE #NULARG	;PLACE TO PUT RFA?
	    LET R1 := IRFA(R5)		;PICK UP RFA POINTER TO RETURN
	    LET (R1)+ := O$RFA(R0)	;RETURN
	    LET (R1)+ := O$RFA+2(R0)	;THE
	    LET (R1) := O$RFA+4(R0)	;RFA
	  END
	END
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsrac.mac	Wed Jul 28 11:08:29 1982	RMSRAC.MAC;1
	.TITLE	RMSRAC
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSRAC			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSRAC (LUN,MODE,ISTAT)				   O
;N		CALLG RMSRAC <#LUN,#MODE,#ISTAT>			   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	MODE=4
	ISTAT=6
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSRAC,GLOBAL
	;
	;
	;
	IFB (R5) NE #3			;THREE ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	IF MODE(R5) EQ #NULARG		;ACCESS MODE SPECIFIED?
	  LET @ISTAT(R5) := #XX$NOP	;SAY NO OPERATION POSSIBLE
	  $RETURN
	END
	IF @MODE(R5) HI #RB$RFA		;LEGAL ACCESS MODE??
	  LET @ISTAT(R5) := #XX$RAC	;SET ILLEGAL ACCESS MODE
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	LET O$RAC(R0) :B= @MODE(R5)	;SET ACCESS MODE
	LET @ISTAT(R5) := #SU$SUC	;SET SUCCESS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsrwd.mac	Wed Jul 28 11:08:29 1982	RMSRWD.MAC;1
	.TITLE	RMSRWD
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSRWD			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSRWD (LUN,ISTAT)					   O
;N		CALLG RMSRWD <#LUN,#ISTAT>				   N
;!	OUTPUTS: ISTAT							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$REWIND
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	ISTAT=4
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSRWD,GLOBAL
	;
	;
	;
	IFB (R5) NE #2			;TWO ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	$REWIND	R0			;ISSUE A REWIND
	LET @ISTAT(R5) := O$STS(R0)	;RETURN STATUS
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- rmsupd.mac	Wed Jul 28 11:08:29 1982	RMSUPD.MAC;1
	.TITLE	RMSUPD
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: A FORTRAN COMPATIBLE RMS INTERFACE			   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: RMSUPD			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CALL RMSUPD (LUN,IRFA,ISTAT)				   O
;N		CALLG RMSUPD <#LUN,#IRFA,#ISTAT>			   N
;!	OUTPUTS: ISTAT, IRFA(CONDITIONALLY)				   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES:								   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	RABOF$,RAB$BT,$UPDATE
	.MCALL	SMACIT
	;
	;
	;
	RABOF$	RMS$L			;DEFINE OFFSETS LOCALLY
	RAB$BT	DFIN$L			;DEFINE RAB BIT PATTERNS LOCALLY
	SMACIT				;DEFINE SUPERMAC
	;
	;
	;
	;DEFINE FORTRAN COMPATIBLE PARAMETER BLOCK
	;
	;
	;
	LUN=2
	IRFA=4
	ISTAT=6
	NULARG=-1
	;
	;
	;
	PROCEDURE	RMSUPD,GLOBAL
	;
	;
	;
	IFB (R5) NE #3			;THREE ARGUMENTS???
	  TRAP				;IF NOT, QUIT HERE
	END
	IF ISTAT(R5) EQ #NULARG		;NO STATUS BLOCK?
	  EMT				;IF NOT, QUIT HERE
	END
	;
	;
	;
	IF LUN(R5) EQ #NULARG		;LUN SPECIFIED?
	  LET @ISTAT(R5) := #XX$LUN	;IF NOT, SAY LUN NOT SPECIFIED
	  $RETURN			;RETURN TO CALLER
	END
	LET R2 := @LUN(R5)		;PICK UP LUN
	LET R2 := R2 L.SHIFT 1		;CONVERT TO WORD INDEX
	IF $$$FAB(R2) EQ #0		;FILE ALREADY OPEN???
	  LET @ISTAT(R5) := #XX$OPN	;SAY FILE NOT OPEN
	  $RETURN			;RETURN TO CALLER
	END
	IF $$$RAB(R2) EQ #0		;RECORD STREAM ALREADY CONNECTED?
	  LET @ISTAT(R5) := #XX$STM	;SAY STREAM NOT CONNECTED
	  $RETURN			;RETURN TO CALLER
	END
	;
	;
	;
	LET R0 := $$$RAB(R2)		;PICK UP RAB ADDRESS
	$UPDATE	R0			;UPDATE THE RECORD
	LET @ISTAT(R5) := O$STS(R0)	;SET STATUS
	IF O$STS(R0) GE #SU$SUC		;SUCCESS??
	  IF IRFA(R5) NE #NULARG	;PLACE TO PUT RFA?
	    LET R1 := IRFA(R5)		;PICK UP RFA POINTER TO RETURN
	    LET (R1)+ := O$RFA(R0)	;RETURN
	    LET (R1)+ := O$RFA+2(R0)	;THE
	    LET (R1) := O$RFA+4(R0)	;RFA
	  END
	END
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
-h- supmac.mac	Wed Jul 28 11:08:29 1982	SUPMAC.MAC;1
;
; ALTERED:
; EDWIN H. MARISON  11 MAY 76  15:39
; ARTHUR P. GAUGHAN, JR. 9-FEB-1978
; ARTHUR P. GAUGHAN, JR. 28-JUL-1978
; ARTHUR P. GAUGHAN, JR. 28-AUG-1978
; RICHARD L. MICHAUD 2-NOV-78 (ADD NVS,NVC,RVS,RVC .MCALL TO SMCALL)
; ARTHUR P. GAUGHAN, JR. 5-DEC-78
;STRUCTURED PROGRAMMING MACROS
;
;	** SUPMAC **
;
;;;;;	V0047
;
.MACRO	SMACIT
	.MCALL	SMCALL
	$SUPMC=47
	$DIDDO=0
	$EF$=0
	$L$=0
	$T=0
	$L=0
	$R=-1
	IIII=-1
	$.$.$.=0
	SMCALL			; DEFINE SUPMAC
.ENDM
;
.MACRO	SMCALL
	.MCALL	..PUSH,..POP,..GET,..TAG,..BRAN,.EMIT,.EMITL,.EMITR
	.MCALL	.IFOPR,.IS,.GENBR,.OPADD,.OPSUB,ENTRYPOINT,PROBE,PROBEB
	.MCALL	RNE,REQ,RLT,RGE,RGT,RLE,RPL,RMI,RHI,RLOS,RHIS,RLO,RCS,RCC
	.MCALL	RVC,RVS
	.MCALL	NNE,NEQ,NLT,NGE,NGT,NLE,NPL,NMI,NHI,NLOS,NHIS,NLO,NCS,NCC
	.MCALL	NVC,NVS
	.MCALL	IF,.OR,.LEAVE,.GOTO,$SET$K$,OR,AND,DO,THEN,ELSE
	.MCALL	WHILE,CASE,CASEB,FOR,TO,DOWNTO,FOR.ABS,REPEAT,UNTIL,THRU
	.MCALL	END,BEGIN,$$END,LEAVE,JUMPTO,GOTO,PUSH,POP,$CALL,$RETURN
	.MCALL	LET,.SIMPLE,.ARITH,BRJ,SOB,PROCEDURE,CALLG,PUSHB,POPB
	.MCALL	ORB,ANDB,IFB,UNTILB,WHILEB,ON.ERROR,ON.NOERROR,FI
	.MACRO	SMCALL
	.ENDM
.ENDM	SMCALL
;
;
.MACRO	..PUSH	AA1,AA2
	IIII=IIII+1
	.IRP	TT,\IIII
		TYPS'TT = AA1
		LBLS'TT = AA2
	.ENDM
.ENDM
.MACRO	..POP	AA1,AA2
	.IF LT IIII
	.LIST
	.ERROR  ;STACK UNDERFLOW;
	$Y$=IIII
	.NLIST
	.MEXIT
	.IFF
	.IRP	TT,\IIII
		AA1 = TYPS'TT
		AA2 = LBLS'TT
	.ENDM
	.ENDC
	IIII=IIII-1
.ENDM
;
.MACRO	..GET	PPP,AA1,AA2
	.IRP	TT,\PPP
		AA1=TYPS'TT
		AA2=LBLS'TT
	.ENDM
.ENDM	..GET
;
.MACRO	..TAG	TG,WH
.EMITL	<WH''TG':>
.ENDM
;
.MACRO	..BRAN	BRA,TG,WH
.EMIT	<BRA WH''TG>
.ENDM
;
.MACRO	SOB	A,B
	.EMIT	<DEC	A>
	..BRAN	BEQ,\$.$.$.,T
	.EMIT	<BRJ	B>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
;
.MACRO	BRJ	TARGET
.IF	DF	TARGET
.IF	GT	.-TARGET-376
JMP	TARGET
.IFF
.IF	GE	.-TARGET
BR	TARGET
.IFF
JMP	TARGET
.ENDC
.ENDC
.IFF
JMP	TARGET
.ENDC
.ENDM	BRJ
;
.MACRO	.EMIT	VAL
$E$=1
	.IIF	DF	LST$$	.LIST MEB
								VAL
	.IIF	DF	LST$$	.NLIST MEB
.ENDM
;
.MACRO	.EMITL	VAL
	.IIF	DF	LST$$	.LIST
							VAL
	.IIF	DF	LST$$	.NLIST
.ENDM
;
.MACRO	.EMITR	S1,S2
	.EMIT	<S1>
	.IIF	GT	S2-1	.EMITR	<S1>,\S2-1
.ENDM
.MACRO	.IFOPR	OPRA,RELA,TTG
	.EMIT	OPRA
	.IF	GT	$R
		.IIF	EQ	$L$	N'RELA	L'TTG
		.IIF	EQ	$L$-1	N'RELA	B'TTG
		.IIF	EQ	$L$-2	N'RELA	E'TTG
		.IIF	EQ	$L$-3	N'RELA	TTG
	.IFF
		.IIF	EQ	$L$	R'RELA	L'TTG
		.IIF	EQ	$L$-1	R'RELA	B'TTG
		.IIF	EQ	$L$-2	R'RELA	E'TTG
		.IIF	EQ	$L$-3	R'RELA	TTG
	.ENDC
	..PUSH	0,$T
	$I$=1
.ENDM
.MACRO	.IS	Q1,Q2,QB,QT
	.IIF	DIF	<RESULT>,<Q1>,.ERROR ; IF SYNTAX ERROR Q1 IS;
	.IIF	IDN	<RESULT>,<Q1>,.IFOPR <<.=.>>,Q2,QT
.ENDM
;
.MACRO	.GENBR	A1,B1,C1,D1,E1

$I$=0
.IIF	IDN	<SET.IN>	<B1>	.IFOPR <<BIT'D1 A1,C1>>,NE,E1
.IIF	IDN	<OFF.IN>	<B1>	.IFOPR <<BIT'D1 A1,C1>>,EQ,E1
.IIF	IDN	<#0>		<C1>	.IFOPR <<TST'D1 A1>>,B1,E1
.IIF	IDN	<#0>		<A1>	.IFOPR <<TST'D1 C1>>,B1,E1
.IIF	IDN	<IS>		<B1>	.IS A1,C1,D1,E1
.IIF	EQ	$I$			.IFOPR <<CMP'D1 A1,C1>>,B1,E1
.ENDM




.MACRO	.OPADD	V1,V2,V3
	.IIF	IDN	<V2>	<#1>	.EMIT	<INC'V3 V1>
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<V2>	<CARRY>	.EMIT	<ADC'V3 V1>
	.IIF	NE	$E$		.MEXIT

	.EMIT	<ADD'V3 V2,V1>
.ENDM
;
;
.MACRO	.OPSUB	V1,V2,V3
	.IIF	IDN	<V2>	<#1>	.EMIT	<DEC'V3 V1>
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<V2>	<CARRY>	.EMIT	<SBC'V3 V1>
	.IIF	NE	$E$		.MEXIT

	.EMIT	<SUB'V3 V2,V1>
.ENDM
.MACRO	NNE	LOC
	..BRAN	BEQ,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NEQ	LOC
	..BRAN	BNE,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NLT	LOC
	..BRAN	BGE,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NGE	LOC
	..BRAN	BLT,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NGT	LOC
	..BRAN	BLE,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NLE	LOC
	..BRAN	BGT,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NPL	LOC
	..BRAN	BMI,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NMI	LOC
	..BRAN	BPL,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NHI	LOC
	..BRAN	BLOS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NLOS	LOC
	..BRAN	BHI,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NHIS	LOC
	..BRAN	BLO,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NLO	LOC
	..BRAN	BHIS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NCS	LOC
	..BRAN	BCC,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NCC	LOC
	..BRAN	BCS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NVC	LOC
	..BRAN	BVS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	NVS	LOC
	..BRAN	BVC,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RNE	LOC
	..BRAN	BNE,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	REQ	LOC
	..BRAN	BEQ,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RLT	LOC
	..BRAN	BLT,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RGE	LOC
	..BRAN	BGE,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RGT	LOC
	..BRAN	BGT,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RLE	LOC
	..BRAN	BLE,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RPL	LOC
	..BRAN	BPL,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RMI	LOC
	..BRAN	BMI,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RHI	LOC
	..BRAN	BHI,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RLOS	LOC
	..BRAN	BLOS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RHIS	LOC
	..BRAN	BHIS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RLO	LOC
	..BRAN	BLO,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RCS	LOC
	..BRAN	BCS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RCC	LOC
	..BRAN	BCC,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RVC	LOC
	..BRAN	BVC,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM
.MACRO	RVS	LOC
	..BRAN	BVS,\$.$.$.,T
	.EMIT	<BRJ	LOC>
	..TAG	\$.$.$.,T
	$.$.$.=$.$.$.+1
.ENDM

.MACRO	IF	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,BB
	.IIF	B	<A>	.MEXIT
$O$=0
$I$=0
	.IF	IDN	<LEAVE> <D>
	.IIF	NB	<EE>	.LEAVE	A,BE,C,BB,EE
	.ENDC
	.IIF	NE	$I$		.MEXIT
	.IF	IDN	<GOTO>	<D>
	.IIF	NB	<EE>	.GOTO	A,BE,C,BB,EE
	.ENDC
	.IIF	NE	$I$		.MEXIT
	.IIF	IDN	<D>	<OR>	.OR	A,BE,C,BB
	.IIF	IDN	<D>	<ORB>	.OR	A,BE,C,BB
	.IF EQ	$O$
		.IIF EQ $L$-1	.GENBR A,BE,C,BB,\$T2
		.IIF NE $L$-1	.GENBR A,BE,C,BB,\$T
	.ENDC
$T=$T+1
	.IIF	B	<D>,.MEXIT
;
	D	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	.IIF	LE	$DIDDO	.MEXIT
..POP	$$T,$$T
..TAG	\$$T,L
$DIDDO=$DIDDO-1
.ENDM
.MACRO	.OR	OA,OB,OC,OD
	$R=-$R
	$O$=1
	$SV$=$L$
	$L$=0
 .IIF NE $L$-1   	.GENBR	OA,OB,OC,OD,\$T
 .IIF EQ $L$-1   	.GENBR	OA,OB,OC,OD,\$T2
	$L$=$SV$
	$R=-$R
.ENDM
;
;
;
.MACRO	.LEAVE	LA,LB,LC,LD,LE
	$L$=2
	.IIF	IDN	<LE>	<LOOP>	$SET$K$	IIII
	.IIF	DIF	<LE>	<LOOP>	$K$=LE
	$R=-$R
	.GENBR	LA,LB,LC,LD,\$K$
	..POP	$$TT,$$TT
	$R=-$R
	$L$=0
.ENDM
;
;
.MACRO	.GOTO	GA,GB,GC,GD,GEE
	$R=-$R
	$L$=3
	.GENBR	GA,GB,GC,GD,GEE
	..POP	$$TT,$$TT
	$R=-$R
	$L$=0
.ENDM
;
;
.MACRO	$SET$K$	BBB
	$K$L=-1
	$K$=-1
	.IF	LT	BBB
		.ERROR	; NO LOOP BLOCK;
		.MEXIT
	.ENDC
	..GET	BBB,$K$T,$K$L
	$XXX$ = 0
	.IIF	EQ	$K$T-1	$XXX$ = 1 	;WHILE
	.IIF	EQ	$K$T-2	$XXX$ = 1 	;FOR
	.IIF	EQ	$K$T-5	$XXX$ = 1 	;REPEAT
	.IIF	EQ	$K$T-6	$XXX$ = 1 	;THRU
	.IIF	EQ	$XXX$	$SET$K$	BBB-1
	$K$=$K$L
.ENDM	$SET$K$
.MACRO	OR	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,BB
	.IIF	B	<EE>	.MEXIT
	.IIF	IDN	<H>	<OR>	..POP	$T1,$T
	.IIF	IDN	<H>	<ORB>	..POP	$T1,$T
	IF'BB	EE,F,G,H
	.IF	DIF	<H>	<OR>
	.IF	DIF	<H>	<ORB>
	..POP	$$TT,$$TT
	..POP	$$T,$$T
	$$S=0
	.IIF	IDN	<H>,<AND>,$$S=1
	.IIF	IDN	<H>,<ANDB>,$$S=1
	.IIF	IDN	<H>,<GOTO>,$$S=2
	.IIF	IDN	<H>,<LEAVE>,$$S=2
	.IF	NE	$$S
		.IF	EQ,$$S-1
			..PUSH	0,$$TT
			..TAG	\$$T,L
			.ERROR	; AND (ANDB) SEEN AFTER AN OR (ORB);
			.MEXIT
		.ENDC
		..TAG	\$$T,L
		THEN	H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	.IFF
	..TAG	\$$T,L
	.IIF	B	<H>	..PUSH	0,$$TT
	.IIF	B	<H>	.MEXIT
	H	I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	.ENDC
	.IF	LE	$DIDDO
	..PUSH 0,$$TT
	.IFF
	..TAG	\$$TT,L
	$DIDDO=0
	.ENDC
	.MEXIT
	.ENDC
	.ENDC
	H	I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
.ENDM
;
;
.MACRO	AND	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,BB
	.IIF	B	<EE>	.MEXIT
	$$S=0
	.IIF	IDN	<ORB>,<H>,$$S=1
	.IIF	IDN	<OR>,<H>,$$S=1
	.IF	GT	$$S
	..POP	$$T,$$T
	IF'BB	EE,F,G,H
	..TAG	\$$T,L
	H	I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	.IFF
	..POP	$T,$T
	IF'BB	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	$$S=0
	.IIF	IDN	<H>,<LEAVE>,$$S=1
	.IIF	IDN	<H>,<GOTO>,$$S=1
	.IF	NE	$$S
	..TAG	\$T,L
	$T=$T+1
	.ENDC
	.ENDC
.ENDM
;
;
.MACRO	DO	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	.IIF	B	<EE>,.MEXIT
		LET EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	$DIDDO=$DIDDO+1
.ENDM
;
;
.MACRO	THEN EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	.IIF	B	<EE>	.MEXIT
	EE F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	$DIDDO=$DIDDO+1
.ENDM
.MACRO	ELSE
	..POP	$T1,$T2
	.IF	NE	$T1
	.ERROR		; $T1 ELSE SEEN IN OTHER THAN IF BLOCK;
	..PUSH	$T1,$T2
	.MEXIT
	.ENDC
	..BRAN	BRJ,\$T,L
	..TAG	\$T2,L
	..PUSH	$T1,$T
	$T=$T+1
.ENDM
.MACRO	WHILE A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,BB
	$DIDDO=-1
	..TAG	\$L,B
 IF A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,BB
	.IF	EQ	$DIDDO
		..BRAN	BRJ,\$L,B
		..POP	$$T,$$T
		..TAG	\$$T,L
	.IFF
		..PUSH	1,$L
	.ENDC
	$DIDDO=0
	$L=$L+1
.ENDM
.MACRO	CASE	A,BBB,C
	.IIF	DIF	<A>	<TOP>	.EMIT	<MOV	A,-(SP)>
	.EMIT	<ASL	(SP)>
	.IRP	TT,\$T
	.EMIT	<CALL	L'TT>
	.ENDM
	..PUSH	4,$T
	$T=$T+1
.ENDM	CASE
;
.MACRO	CASEB	A,BBB,C
	.IIF	DIF	<A>	<TOP>	.EMIT	<MOVB	A,-(SP)>
	.EMIT	<CLRB	1(SP)>
	.EMIT	<ASLB	(SP)>
	.IRP	TT,\$T
	.EMIT	<CALL	L'TT>
	.ENDM
	..PUSH	4,$T
	$T=$T+1
.ENDM	CASEB

.MACRO	FOR	A,BBB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,MG
 .IIF DIF <F>,<BY>,FOR A,BBB,C,D,EE,BY,#1,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,MG
 .IIF DIF <F>,<BY>,.MEXIT
;
	.SIMPLE	A,BBB,C
	..TAG	\$L,B
	.IF B <H>
		..PUSH	2,$L
		.IRP	TT,\<$L>
			.MACRO	$.$'TT
				D	A,EE,G,TT,MG
			.ENDM
		.ENDM
	.IFF
		$SDO=$DIDDO
		H I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
		D A,EE,G,\$L
		.IIF GT $DIDDO-$SDO $DIDDO=$DIDDO-1
	.ENDC
	$L=$L+1
.ENDM


.MACRO	TO	A1,A2,A3,A4,MG
	$E$=0
	.OPADD	A1,A3
	.EMIT	<CMP A1,A2>
	.IF	IDN	<MG>	<ABS>
	.EMIT	<BHIS E'A4>
	.IFF
	.EMIT	<BGE E'A4>
	.ENDC
	.EMIT	<BRJ	B'A4>
	.EMITL	<E'A4:>
.ENDM



.MACRO	DOWNTO	A1,A2,A3,A4,MG
	$E$=0
	.OPSUB	A1,A3
	.EMIT	<CMP A1,A2>
	.IF	IDN	<MG>	<ABS>
	.EMIT	<BLOS E'A4>
	.IFF
	.EMIT	<BLE E'A4>
	.ENDC
	.EMIT	<BRJ	B'A4>
	.EMITL	<E'A4:>
.ENDM

.MACRO	FOR.ABS	A,BBB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
	FOR	A,BBB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,ABS
.ENDM	FOR.ABS
.MACRO	REPEAT	A,BB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
	..TAG	\$L,B
	..PUSH	5,$L
	$L=$L+1
	.IIF	B	<A>	.MEXIT
	.IF	IDN	<A>	<UNTILB>	
	UNTILB BB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
	.MEXIT
	.ENDC
	.IF	IDN	<A>	<UNTIL>	
	UNTIL BB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
	.MEXIT
	.ENDC
	LET A,BB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
.ENDM



.MACRO	UNTIL  A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,BB
	$L$=1
	..POP	$T1,$T2
	.IF	NE	$T1-5
	.ERROR	; UNTIL SEEN IN OTHER THAN REPEAT BLOCK;
	.MEXIT
	.ENDC
	IF A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,BB
	..POP	$$T,$$T
	..TAG	\$T2,E
	$L$=0
.ENDM


.MACRO	THRU	A,BB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V
	.NTYPE	A3,A
	.IF	NE	A3&70
	.ERROR	; A MUST BE A REGISTER;
	.MEXIT
	.ENDC
	.IIF	NB	<BB>,LET A,BB,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V
	..TAG	\$L,B
	..PUSH	6,$L
	.IRP	TT,\$L
	.MACRO	$.$'TT
	.EMIT	<SOB A,B'TT>
	.ENDM
	.ENDM
	$L=$L+1
.ENDM
.MACRO	END   COMM
	..POP	$T1,$T2
	.IF	EQ	$T1
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - IF;
	..TAG	\$T2,L			;-0- 	IF
	.MEXIT
	.ENDC
;
	.IF	EQ	$T1-3
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - BEGIN;
	..TAG	\$T2,E			;-3-	BEGIN/END
	.MEXIT
	.ENDC
;
	.IF	EQ	$T1-5
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - REPEAT;
	..BRAN  BRJ,\$T2,B		;-5-	REPEAT
	..TAG	\$T2,E		
	.MEXIT
	.ENDC
;
	.IF	EQ	$T1-1			;-1-	WHILE
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - WHILE;
		..BRAN	BRJ,\$T2,B
		..POP	$$T,$$T
		..TAG	\$$T,L
		..TAG	\$T2,E
		.MEXIT
	.ENDC
;
	.IF	EQ	$T1-2			;-2-	FOR
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - FOR;
		.IRP	TT,<\$T2>
			$.$'TT
		.ENDM
	.MEXIT
	.ENDC
;
	.IF	EQ	$T1-4			;-4-	CASE
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - CASE;
		..TAG	\$T2,L
		.EMIT	<ADD (SP)+,@SP>
		.EMIT	<MOV @(SP)+,-(SP)>
		.EMIT	<CALL	@(SP)+>
		.MEXIT
	.ENDC
;
	.IF	EQ	$T1-6			; -6- THRU
	.IIF	EQ	$EF$-1	.PRINT	; MISSING END - THRU;
	.IRP	TT,\$T2
	$.$'TT
	..TAG	\$T2,E
	.ENDM
	.MEXIT
	.ENDC
;
	.ERROR		; $T STRANGE SUPER-MAC STACK VALUE;
.ENDM
;
.MACRO	BEGIN	BNAME
	.IIF NB	<BNAME>		BNAME=$L
	..PUSH	3,$L
	..TAG	\$L,B
	$L=$L+1
.ENDM

.MACRO	$$END
	.IF	GE	IIII
		$EF$=1
		END
		$EF$=0
		$$END
	.ENDC
.ENDM
.MACRO	LEAVE AAAA,A,BB,C,D,EE,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U
	.IIF	B	<AAAA>	.MEXIT
	.IIF	IDN	<AAAA>,<LOOP>,$SET$K$	IIII
	.IIF	DIF	<AAAA>,<LOOP>,$K$=AAAA
	.IRP	QQ,\$K$
	.EMIT	<BRJ E'QQ>
	.ENDM
.ENDM
;
;
.MACRO	JUMPTO	AAAA,A,B,C,D,E,F,H,G,I,J,K,L,M,N,O,P,Q,R,S,T,U
.EMIT	<BRJ AAAA>
.ENDM
;
.MACRO	GOTO	BBBB,A,BB,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U
	.IIF	B	<BBBB>	.MEXIT
.EMIT	<BRJ BBBB>
.ENDM
;
.MACRO	PUSH	P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,Q1,Q2,Q3,Q4,Q5,Q6,Q7,Q8,Q9,Q10,Q11,Q22
	.IF	NB	P0
	.EMIT	<MOV	P0,-(SP)>
	PUSH	P1,P2,P3,P4,P5,P6,P7,P8,P9
	.ENDC
.ENDM	PUSH
;
.MACRO	POP	P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,Q0,Q1,Q2,Q3,Q4,Q5,Q6,Q7,Q8,Q9,Q22
	.IF	NB	P0
		.IF	IDN	<P0>	<TOP>
			.EMIT	<MOV	(SP),(SP)+>
		.IFF
			.EMIT	<MOV	(SP)+,P0>
		.ENDC
	POP	P1,P2,P3,P4,P5,P6,P7,P8,P9
	.ENDC
.ENDM	POP
;
.MACRO	PUSHB	P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,Q1,Q2,Q3,Q4,Q5,Q6,Q7,Q8,Q9,Q10,Q11,Q22
	.IF	NB	P0
	.EMIT	<MOVB	P0,-(SP)>
	.EMIT	<CLRB	1(SP)>
	PUSHB	P1,P2,P3,P4,P5,P6,P7,P8,P9
	.ENDC
.ENDM	PUSHB
;
.MACRO	POPB	P0,P1,P2,P3,P4,P5,P6,P7,P8,P9,Q0,Q1,Q2,Q3,Q4,Q5,Q6,Q7,Q8,Q9,Q22
	.IF	NB	P0
	.EMIT	<MOVB	(SP)+,P0>
	POPB	P1,P2,P3,P4,P5,P6,P7,P8,P9
	.ENDC
.ENDM	POPB
.MACRO	$CALL	NAME,ARGS,WHERE,TYPE,A,BB,C,D,E,F,G,H,I,J,K,LL,M,N,O,P,Q,RR,S
; NOTE: **** WHERE AND TYPE NOT IMPLEMENTED ****
	.IIF	B	<ARGS>	.EMIT	<CALL	NAME>
	.IIF	B	<ARGS>	.MEXIT
	.IF	NB	WHERE
	.ERROR	; WHERE .... ARG'S MUST BE WITHIN <>;
	.MEXIT
	.ENDC
.$T=0
.MACRO	$GENM	BBT,BBP
	.IIF	GT	BBP-5	.ERROR	; 6 ARG MAX (R0-R5);
	.IIF	GT	BBP-5	.MEXIT
	.IIF	DIF	<BBT> <R'BBP>	.EMIT	<MOV BBT,R'BBP>
.ENDM
	.IRP	T,<ARGS>
	.IIF	NB	<T>	$GENM	T,\.$T
	.$T=.$T+1
	.ENDM
	.EMIT	<CALL	NAME>
.ENDM
 
 
 
 
 
.MACRO	CALLG	ENTRY,ARGS,CHECK
	.IF	B	ENTRY
		.ERROR	;.... PROCEDURE NAME NOT SPECIFIED ....
		.MEXIT
	.ENDC
	.IF	NB	CHECK
		.ERROR	; CHECK .... ARGUMENTS MUST BE WITHIN <> ....
		.MEXIT
	.ENDC
	.IF	B	<ARGS>
		.EMIT	<CLR	-(SP)>
		.EMIT	<MOV	R5,-(SP)>
		.EMIT	<MOV	SP,R5>
		.EMIT	<TST	(R5)+>
		.EMIT	<CALL	ENTRY>
		.EMIT	<MOV	(SP)+,R5>
		.EMIT	<TST	(SP)+>
		.MEXIT
	.ENDC
	.$ARGS=0
	.$SIZE=0
	.IRP	X,<ARGS>
		.$ARGS=.$ARGS+1
		.$SIZE=.$SIZE+2
	.ENDM
	.IIF	GT	.$ARGS-16	.ERROR	;.... 16 ARGS MAX ....
	.EMIT	<SUB	#.$SIZE,SP>
	.EMIT	<MOV	#.$ARGS,-(SP)>
	.EMIT	<MOV	R5,-(SP)>
	.EMIT	<MOV	SP,R5>
	.EMIT	<CMP	(R5)+,(R5)+>
	.IRP	X,<ARGS>
		.IIF	B	<X>	.EMIT	<MOV	#-1,(R5)+>
		.IIF	NB	<X>	.EMIT	<MOV	X,(R5)+>
	.ENDM
	.EMIT	<MOV	SP,R5>
	.EMIT	<TST	(R5)+>
	.EMIT	<CALL	ENTRY>
	.EMIT	<MOV	(SP)+,R5>
	.EMIT	<ASL	(SP)>
	.EMIT	<ADD	(SP)+,SP>
.ENDM
.MACRO	$RETURN	STA,REG,A,BE,C,D,E,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE
	.IF	NB	STA
	.IF	DIF	<WITH>,<STA>
	.IF	DIF	<ERROR>,<STA>
	.IF	DIF	<NOERROR>,<STA>
		.IF IDN <WORD>,<A>
		.EMIT	<MOV STA,-(SP)>
		.EMIT	<ROL (SP)+>
		.IFF
		.EMIT	<MOVB STA,-(SP)>
		.EMIT	<ROLB (SP)+>
		.ENDC
	.IFF
		.EMIT	<CLC>
	.ENDC
	.IFF
		.EMIT	<SEC>
	.ENDC
	.ENDC
	.ENDC
	.IIF	B	<REG>	.EMIT	<RETURN>
	.IIF	NB	<REG>	.EMIT	<RTS REG>
.ENDM

.MACRO	LET	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V
	.SIMPLE	A,BE,C,D,EE
	.IIF	B		<D>	.MEXIT
	.IIF	B		<EE>	.MEXIT
	.IIF	B		<F>	.MEXIT
	.IIF	IDN	<!>	<D>	LET EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V
	.IIF	IDN	<!>	<D>	.MEXIT
	.IIF	IDN	<!>	<EE>	LET F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V
	.IIF	IDN	<!>	<EE>	.MEXIT
	.IIF	IDN	<!>	<F>	LET G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V
	.IIF	IDN	<!>	<F>	.MEXIT
	.IF	LT	$Y$
		LET A,BE,A,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V
		.MEXIT
	.ENDC
		LET  A,BE,A,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V
.ENDM

.MACRO	.SIMPLE	X1,X2,X3,X4,X5,X6
	.IF	DIF	<X2>	<:=>
	.IF	DIF	<X2>	<:W=>
	.IF	DIF	<X2>	<:==>
	.IF	DIF	<X2>	<:B=>
	.ERROR	; X2 NOT A LEGAL ASSIGNMENT OPERATOR;
	.MEXIT
	.ENDC
	.ENDC
	.SIMPLE	X1,:=,X3,X4,X5,B
	.MEXIT
	.ENDC
	.ENDC

	.IIF	IDN	<X1>	<PUSH>	.SIMPLE	-(SP),X2,X3,X4,X5,X6
	.IIF	IDN	<X1>	<PUSH>	.MEXIT
	.IIF	IDN	<X1>	<TOP>	.SIMPLE	@SP,X2,X3,X4,X5,X6
	.IIF	IDN	<X1>	<TOP>	.MEXIT
$Y$=0
$Z$=0
	.IIF	IDN	<CARRY> <X1>	$Z$=-1
	.IIF	IDN	<C.BIT>	<X1>	$Z$=-1
	.IIF	IDN	<V.BIT>	<X1>	$Z$=-2
	.IIF	IDN	<OFF>	<X3>	$Y$=7
	.IIF	IDN	<FALSE>	<X3>	$Y$=7
	.IIF	IDN	<CLEARED> <X3>	$Y$=7
	.IIF	IDN	<0>	<X3>	$Y$=7
	.IIF	IDN	<#0>	<X3>	$Y$=7
	.IIF	IDN	<ON>	<X3>	$Y$=4
	.IIF	IDN	<SET>	<X3>	$Y$=4
	.IIF	IDN	<TRUE>	<X3>	$Y$=4
	.IF	LT	$Z$
	.IIF	EQ	$Z$+$Y$-6	.EMIT	<CLC>
 	.IIF	EQ	$Z$+$Y$-5	.EMIT	<CLV>
 	.IIF	EQ	$Z$+$Y$-3	.EMIT	<SEC>
 	.IIF	EQ	$Z$+$Y$-2	.EMIT	<SEV>
 	.MEXIT
	.ENDC
;
	.IIF	IDN	<NOT>	<X3>	$Y$=-1
	.IIF	IDN	<->	<X3>	$Y$=-2
	.IIF	IDN	<POP>	<X3>	$Y$=5
	.IIF	IDN	<TOP>	<X3>	$Y$=6
	.IIF	IDN	<PUSH>	<X3>	$Y$=10
  .IF	DIF	<X1> <X3>
	.IIF	EQ	$Y$-7		.EMIT	<CLR'X6 X1>
	.IF	DIF	<@SP>,<X1>
	.IIF	EQ	$Y$-6		.EMIT	<MOV'X6 @SP,X1>
	.ENDC
	.IIF	EQ	$Y$-5		.EMIT	<MOV'X6 (SP)+,X1>
	.IIF	EQ	$Y$-4		.EMIT	<MOV'X6 #-1,X1>
	.IIF	EQ	$Y$		.EMIT	<MOV'X6 X3,X1>
  .ENDC
  .IF	DIF	<X1> <X4>
	.IIF	LT	$Y$		.EMIT	<MOV'X6 X4,X1>
  .ENDC
	.IIF	IDN	<+1>	<X4>	$Y$=-5
	.IIF	IDN	<-1>	<X4>	$Y$=-6
	.IF	LT	$Y$
		.IIF	EQ	$Y$+1	.EMIT	<COM'X6 X1>
		.IIF	EQ	$Y$+2	.EMIT	<NEG'X6 X1>
		.IIF	EQ	$Y$+3	.EMIT	<TST'X6 X1>
		.IIF	EQ	$Y$+4	.EMIT	<SWAB X1>
		.IIF	EQ	$Y$+5	.EMIT	<INC'X6 X1>
		.IIF	EQ	$Y$+6	.EMIT	<DEC'X6 X1>
		.MEXIT
	.ENDC
;
	.IIF	B	<X4>		.MEXIT
	.IIF	IDN	<X4>	<!>	.MEXIT
	.IIF	IDN	<X4>	<IS>	.MEXIT
$E$=0
	.IIF	IDN	<X5>	<TOP>	.ARITH	X1,@SP,X6,X4
	.IIF	IDN	<X5>	<POP>	.ARITH	X1,(SP)+,X6,X4
	.IIF	EQ	$E$		.ARITH	X1,X5,X6,X4
.ENDM
;
.MACRO	.ARITH	Y1,Y2,Y3,Y4
	.IIF	IDN	<Y1>	<-(SP)>	.ARITH	@SP,Y2,Y3,Y4
	.IIF	IDN	<Y1>	<-(SP)>	.MEXIT
	.IIF	IDN	<+>	<Y4>	.OPADD	Y1,Y2,Y3
	.IIF	IDN	<->	<Y4>	.OPSUB	Y1,Y2,Y3
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<NAND>	<Y4>	.EMIT	<BIC'Y3 Y2,Y1>
	.IIF	IDN	<OFF.BY> <Y4>	.EMIT	<BIC'Y3 Y2,Y1>
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<SET.BY> <Y4>	.EMIT	<BIS'Y3 Y2,Y1>
	.IIF	IDN	<OR>	<Y4>	.EMIT	<BIS'Y3 Y2,Y1>
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<L.SHIFT> <Y4>	.EMITR	<ASL'Y3 Y1>,Y2
	.IIF	IDN	<R.SHIFT> <Y4>	.EMITR	<ASR'Y3 Y1>,Y2
	.IIF	IDN	<L.ROTATE> <Y4>	.EMITR	<ROL'Y3 Y1>,Y2
	.IIF	IDN	<R.ROTATE> <Y4>	.EMITR	<ROR'Y3 Y1>,Y2
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<*>	<Y4>	.EMIT	<MUL Y2,Y1>
	.IIF	IDN	</>	<Y4>	.EMIT	<DIV Y2,Y1>
	.IIF	IDN	<SHIFT>	<Y4>	.EMIT	<ASH Y2,Y1>
	.IIF	IDN 	<C.SHIFT> <Y4>	.EMIT	<ASHC Y2,Y1>
	.IIF	NE	$E$		.MEXIT
	.IIF	IDN	<XOR>	<Y4>	.EMIT	<XOR Y2,Y1>
	.IIF	EQ	$E$		.ERROR	; Y4 NOT A LEGAL OPERATOR;
.ENDM
;
;
;


.MACRO	ORB	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	OR	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,B
.ENDM
;
.MACRO	ANDB	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	AND	EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,B
.ENDM
;
.MACRO	IFB	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	IF	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,B
.ENDM
;
;
.MACRO	UNTILB A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
	UNTIL	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,B
.ENDM
;
.MACRO	WHILEB A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z
	WHILE	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,B
.ENDM
;
.MACRO	ON.NOERROR	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S
	IF RESULT IS,CC,A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S
.ENDM
;
.MACRO	ON.ERROR	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S
	IF RESULT IS,CS,A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S
.ENDM
.MACRO	FI	COMM
	END	<COMM>
.ENDM
;
;
.MACRO	PROCEDURE	ENTRY,TYPE,SAVE
	.IF	B	ENTRY
	.ERROR	;.... PROCEDURE NAME NOT SPECIFIED ....
	.MEXIT
	.ENDC
	.IF	B	TYPE
	.EMITL	<ENTRY:>
	.IFF
		.IF	IDN	<TYPE>	<GLOBAL>
		.EMITL	<ENTRY::>
		.IFF
			.IF	IDN	<TYPE>	<LOCAL>
			.EMITL	<ENTRY:>
			.IFF
			.EMITL	<ENTRY::>
			.PRINT	;.... UNRECOGNIZED TYPE KEYWORD - DEFAULT TO GLOBAL ....
			.ENDC
		.ENDC
	.ENDC
	.IF	B	SAVE
	.MEXIT
	.IFF
		.IF	IDN	<SAVE>	<SAVREG>
		.EMIT	<CALL	$SAVAL>
		.IFF
		.PRINT	;.... UNRECOGNIZED SAVE KEYWORD - REGISTERS NOT SAVED ....
		.ENDC
	.ENDC
.ENDM	PROCEDURE
;
.MACRO	ENTRYPOINT	ENTRY,TYPE
	.IF	B	ENTRY
	.ERROR	;.... ENTRY POINT NAME NOT SPECIFIED ....
	.MEXIT
	.ENDC
	.IF	B	TYPE
	.EMITL	<ENTRY:>
	.IFF
		.IF	IDN	<TYPE>	<GLOBAL>
		.EMITL	<ENTRY::>
		.IFF
			.IF	IDN	<TYPE>	<LOCAL>
			.EMITL	<ENTRY:>
			.IFF
			.EMITL	<ENTRY::>
			.PRINT	;.... UNRECOGNIZED TYPE KEYWORD - DEFAULT TO GLOBAL ....
			.ENDC
		.ENDC
	.ENDC
.ENDM	ENTRYPOINT
.MACRO	PROBE	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,BYTE
	.IF	NB	BE
		.ERROR	;.....'PROBE' ACCEPTS ONLY ONE ARGUMENT.....
		.MEXIT
	.ENDC
	.IF	NB	C
		.ERROR	;.....'PROBE' ACCEPTS ONLY ONE ARGUMENT.....
		.MEXIT
	.ENDC
	.IF	NB	D
		.ERROR	;.....'PROBE' ACCEPTS ONLY ONE ARGUMENT.....
		.MEXIT
	.ENDC
	.IF	NB	EE
		.ERROR	;.....'PROBE' ACCEPTS ONLY ONE ARGUMENT.....
		.MEXIT
	.ENDC
	.IF	B	BYTE
		.EMIT	<TST	A>
	.IFF
		.IF	IDN	<B>	<BYTE>
			.EMIT	<TSTB	A>
		.IFF
			.ERROR	;.....'PROBE' ACCEPTS ONLY ONE ARGUMENT.....
		.ENDC
	.ENDC
.ENDM	PROBE
.MACRO	PROBEB	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z
	PROBE	A,BE,C,D,EE,F,G,H,I,J,K,LL,M,N,O,P,Q,R,S,TE,U,V,W,X,Y,Z,B
.ENDM	PROBEB
-h- zecb.mac	Wed Jul 28 11:08:29 1982	ZECB.MAC;1
	.TITLE	ZECB
	.IDENT	/01.00/
	.PSECT	RMSFTN
	;
	;
	;
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
;B									   B
;R	PURPOSE: ZERO A CORE BLOCK					   R
;I									   I
;D									   D
;G	AUTHOR: ARTHUR P. GAUGHAN, JR.					   G
;E									   E
;P	DATE: 5/31/78							   P
;O									   O
;R	GLOBAL SYMBOLS DEFINED IN THIS MODULE: $ZECB			   R
;T									   T
;!	GLOBAL SYMBOLS REFERENCED IN THIS MODULE:			   !
;T									   T
;E									   E
;X									   X
;T									   T
;R									   R
;O	INPUTS: CORE BLOCK ADDRESS IN R0, BYTE COUNT IN R1		   O
;N									   N
;!	OUTPUTS:							   !
;!									   !
;H	HOUSEKEEPING:							   H
;O									   O
;R									   R
;S	NOTES: BLOCK ADDRESS (R0) PRESERVED ACROSS CALL			   S
;H									   H
;A									   A
;M									   M
;BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON BRIDGEPORT-TEXTRON
	;
	;
	;
	.MCALL	SMACIT
	;
	;
	;
	SMACIT
	;
	;
	;
	PROCEDURE	$ZECB,GLOBAL
	;
	;
	;
	PUSH R0				;SAVE BUFFER POINTER
	FOR.ABS R2 := #1 TO R1		;INITIALIZE LOOP
	  LET (R0)+ :B= #0		;ZERO A BYTE
	END
	POP R0				;RESTORE BUFFER POINTER
	$RETURN				;RETURN TO CALLER
	;
	;
	;
	;///////////////////////////////////////////////////////////////////////
	.END
