.; DECtape II operations.
.;   Adapted from Ira A Caplan, "The Multi-tasker", V15 No7 pp44-54 (Feb 1982).
.;
	.GOSUB INIT
	;
	; If copying in RT-11 format, it is assumed that file types determine
	; copy mode. Answer ctrl/Z to next question to exit if not.
	;
	.IF P1 = "0" .OR .IF P1 = "1" .SETN UNIT 'P1'
	.IFNDF UNIT .ASKN [0:1:0] UNIT DECtape unit
.2:	.ASKS [::"Files-11"] P1 Files-11 (RSX) or RT-11
	.SETS P1 P1[1:1]
	.IF P1 = R .SETT RT11
	.IF P1 = F .SETF RT11
	.IFNDF RT11 .GOTO 2
.; Get volume name (Foreign if RT11) and allocate tape.
	.SETS NAME "/FOREIGN"
	.IFF RT11 .ASKS [1:9.] NAME Volume name
	'MCR'ALL DD'UNIT':
	.IF <EXSTAT> <> 1 .EXIT 2
	MOU DD'UNIT':'NAME'
	.IF <EXSTAT> <> 1 .EXIT 2
	;
	; Start operations entry.
	;
.10:	.ASK NUTAPE Creating new tape
	.SETN OPNO 1.
	.GOSUB OPRGET
.20:	.GOSUB OPRSHO
	.GOSUB VERIFY
	.IFF SOPOK .GOTO 20
	.IFF AOPOK .GOTO 10
	;
	; End operations entry.
	;
	.ASK DIREC Do you want a DECtape directory listing
	;
	; Start operations at '<TIME>'.
	;
	.ASK LOGOFF All further operations are automatic. Log off when finished
	.IF MCR <> "" MCR SET /CLI=TI:MCR
	.IFF NUTAPE .GOTO 40
	BAD DD'UNIT':/LI
	.IFT RT11 .GOTO 25
	INI DD'UNIT':'NAME'
	DMO DD'UNIT':
	MOU DD'UNIT':'NAME'
	.GOTO 40
.25:	FLX DD'UNIT':/RT/ZE
.40:	.IFF RT11 UFD DD'UNIT':'<UIC>'
	.SETN OPNO 1.
.50:	.IFNDF $OP'OPNO' .GOTO ALLDUN
	.GOSUB XEQ
	.INC OPNO
	.GOTO 50
.ALLDUN: .IFF DIREC .GOTO 57
	.IFT RT11 FLX DIR.LST=DD'UNIT':/RT/DI
	.IFF RT11 PIP DIR.LST=DD'UNIT':*.*;*/LI
.57:	DMO DD'UNIT':
	DEA DD'UNIT':
	.IFT DIREC PRI DIR.LST
	;
	; Operation finished at '<TIME>'.
	.IFF LOGOFF ;
	.IFT LOGOFF BYE
	.IFF LOGOFF .AND .IF MCR <> "" SET /CLI=TI:'CLI'
	.ENABLE QUIET
	.EXIT
.;
.; Get list of required operations.
.OPRGET: 
	.IFT NUTAPE ; Enter files to add to tape, blank line to end.
	.SETS OPER A
	.IFT NUTAPE .GOTO 71
	.ENABLE ESCAPE
.72:	; Mode	Action
	;  A	Add file(s) to tape
	;  D	Delete file(s) from existing tape
	;  R	Replace file(s) with latest version
	;  T	Transfer file(s) to SY:'<UIC>'
	;  N	No more operations
.75:
	.IFT NUTAPE .GOTO 71
	.ASKS OPER Enter operation [A/D/R/T/N], escape for options
	.IFT <ESCAPE> .GOTO 72
	.SETS OPER OPER[1:1]
.90:	.IF OPER <> N .AND .IF OPER <> "" .GOTO 70
	.DISABLE ESCAPE
	.RETURN
.70:	.IF OPER = A .OR .IF OPER = D .OR .IF OPER = R .OR .IF OPER = T .GOTO 71
	; Invalid operation.
	.GOTO 75
.71:	.ASKS FILE Enter file name
	.IFT NUTAPE .AND .IF FILE = "" .RETURN
.; Do a .TESTFILE to make sure FILE exists, unless wildcards given.
	.TEST FILE
	.SETN LEN <STRLEN>
.711:
	.SETS CHAR FILE[LEN:LEN]
	.IF CHAR = "*" .OR .IF CHAR = "%" .GOTO 74
	.DEC LEN
	.IF LEN <> 0 .GOTO 711
	.TESTFILE 'FILE'
	.IF <FILERR> = 1 .GOTO 74
	Error #'<FILERR>'/IND! with '<FILSPC>':
	.GOTO 75
.74:	.SETS $OP'OPNO' OPER
	.SETS $FI'OPNO' FILE
	.INC OPNO
	.GOTO 75
.;
.; Show operation.
.OPRSHO:
	.ENABLE LOWERCASE
	;
	.IFT NUTAPE ; Creating new tape 'NAME'
	.SETN OPNO 1.
	.SETN NUM 0.
.115:
	.IFNDF $OP'OPNO' .GOTO SHODUN
	.SETS FILE $FI'OPNO'
	.SETS OPER $OP'OPNO'
	.INC OPNO
	.INC NUM
	.IF OPER = A .SETS OPSHO "Add"
	.IF OPER = D .SETS OPSHO "Delete"
	.IF OPER = R .SETS OPSHO "Replace"
	.IF OPER = T .SETS OPSHO "Transfer"
; 'NUM'.	'OPSHO' 'FILE'
	.GOTO 115
.SHODUN:
	;
	.DISABLE LOWERCASE
	.RETURN
.;
.; Verify required operations.
.VERIFY:
	.SETT AOPOK
	.SETT SOPOK
	.ENABLE ESCAPE
.130:
	; Type return when all entries correct, escape to change all.
	.ASKN [1.:'OPNO'-1:1] OPFIX Number of entry to change
	.DISABLE ESCAPE
	.IFT <DEFAUL> .GOTO FIXDUN
	.IFF <ESCAPE> .GOTO 140
	  .SETF AOPOK
	  .; The only global symbols are $OPn and $FIn. ERASing GLOBAL therefore
	  .; clears the table.
	  .ERASE GLOBAL
	  .GOTO FIXDUN
.140:	.SETF SOPOK
	.SETS NUOP "A"
	.IFT NUTAPE .GOTO 141
	.ASKS NUOP Enter operation [A/D/R/T]
	.IF OPER = A .OR .IF OPER = D .OR .IF OPER = R .OR .IF OPER = T .GOTO 141
	; Invalid operation.
	.GOTO 140
.141:	.ASKS NUFIL Enter file
	.SETS $OP'OPFIX' NUOP
	.SETS $FI'OPFIX' NUFIL
	.GOTO 130
.FIXDUN:
	.RETURN
.;
.; Execute commands.
.XEQ:	.SETS FILE $FI'OPNO'
	.SETS OPER $OP'OPNO'
	.IF OPER <> A .GOTO XEQD
.XEQA:
	  .IFF RT11 PIP DD'UNIT':='FILE'
	  .IFT RT11 FLX DD'UNIT':/RT='FILE'/RS
	  .RETURN
.XEQD:
	  .IF OPER <> R .AND .IF OPER <> D .GOTO XEQT
	  .IFF RT11 PIP DD'UNIT':'FILE';*/DE/NM
	  .IFT RT11 FLX DD'UNIT':'FILE'/RT/DE
	  .IF OPER = R .GOTO XEQA
	  .RETURN
.XEQT:
	.IF OPER <> T .RETURN
	  .IFF RT11 PIP /NV=DD'UNIT':'FILE'
	  .IFT RT11 FLX /RS=DD'UNIT':'FILE'/RT
	.RETURN
.;
.INIT:	.SETS NAME ""
	.SETS A "A"
	.SETS F "F"
	.SETS R "R"
	.SETS D "D"
	.SETS T "T"
	.SETS N "N"
	.SETS MCR ""
	.IF <CLI> <> "MCR" .SETS MCR "MCR "
	.SETS CLI <CLI>
	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL
	.DISABLE LOWERCASE
	.IF P1 <> "HELP" .AND .IF P1 <> "?" .RETURN
	; This file allows you to add files to a DECtape, delete files from a DECtape,
	; replace DECtape files with their  latest versions, or transfer files from
	; DECtape to disk. You can specify as many operations as you want, and they
	; will then be carried out in the order you enter them.
	.RETURN
