        .TITLE  .MAIN 
	.IDENT	/V2.1A/
	.ENABL	LC
	.NLIST	TOC,SYM
;
; Author: C J Doran, Sira Institute Ltd., South Hill, Chislehurst,
;		Kent, BR7 5EH, England.		Tel: 01 467 2636
;
; This patch file modifies Whitesmith's C startup routine .MAIN to accept
; the task command lines from an indirect command file, or to prompt for
; a command line if none is given, in the normal RSX-11M way.
;
; The method is to replace the GMCR$ system EMT call, which can only get one
; 80-character line, by a call to the more powerful .GCML1, which can handle
; terminal input or command files with multiple lines, in which all lines
; ending with '-' are concatenated. This gives you a chance of getting long
; lists of files into the microprocessor link, lib and lord.
;
; E.g. with this patch applied you can run the linker as:
;	>LIN
;	LIN>-et_text -ed_edata -eb_end lb:[1,1]crts.80 echo.o -
;	LIN>lb:[1,1]libc.80 lb:[1,1]libs.80 lb:[1,1]libm.80
;
; or call it with a command file as:
;	>LIN @ECHOBLD
;
; where file ECHOBLD.CMD would contain all the lower-case text in the first
; example.
;
; For further details see the RSX I/O Operations Manual, Chapter 6.
;        
; The following procedure will create a file MAIN.OBJ;2, which can be
; built into any utility which requires this facility.
;
; Assemble this file:
;	>MAC MAIN.POB,MAIN/SP=MAIN.PAT
;
; Extract the original MAIN.OBJ from the C library:
;	>LBR MAIN.OBJ;1=LB:[1,1]CLIB/EX:.MAIN
;
; Patch it with this file to give the new MAIN.OBJ;2:
;	>PAT MAIN.OBJ;2=MAIN.OBJ;1/CS:113140,MAIN.POB/CS:74040
;
; Build your user task (or edit the first line of BLDLIB.CMD etc) as:
;	>TKB TASK=TASK,LB:[1,1]CHDR.OBJ,MAIN.OBJ;2,CLIB/LB
;
; When all is working, you can delete MAIN.POB AND MAIN.OBJ;1.
;
; WARNING: This patch is for C V2.1 ONLY, and will NOT work with V2.
;
; The following definition sets the maximum total number of characters in
; the (multiple) command line(s). If you alter it the .POB file checksum
; above will be different:
MAXLTH=322.			; 4*80.+2 gives 4 full lines worth

        .PSECT  C$DATA
	.MCALL	GTSK$,DIR$,GCMLB$,GCML$,FSRSZ$,EXIT$S
$=.
.=$+276
GC:	GCMLB$	1,,CMDLIN,5,,MAXLTH ; Get command line block
; ** Order of next four lines must not be changed **
CMDERR:	.ASCIZ	"command line"	; 2nd half of "can't read command line"
	.EVEN
CMDLIN:	GTSK$	TSKNAM		; Command line(s) go here. Use area temporarily
TSKNAM:	.=CMDLIN+MAXLTH		; for getting task name on startup
	.EVEN

	FSRSZ$	1		; File buffer space for GCML$

        .PSECT  C$TEXT
$$=.
.=$$+14				; Overwrite original code here:
	DIR$	#CMDLIN		; Get our task name
	MOV	TSKNAM+G.TSTN,%1 ; Fetch first 3 Radix-50 chars to %1
	JSR	PC,GETCMD	; Do rest in new get command routine

.=$$+164
NOLINE:				; "can't read" error point

; New get line code here, at end of old .MAIN, called by JSR.
.=$$+422
GETCMD: CMP	%1,#^R...	; Is task ...xxx?
	BNE	1$		; No, have right 3 chars already
	MOV	TSKNAM+G.TSTN+2,%1 ; Yes, use the second three
1$:	MOV	#GC+G.DPRM+2,%0	; Point to 1st char in prompt string
	JSR	PC,$C5TA	; and put task name there
	GCML$	#GC		; Get command line(s)
	ROL	-(SP)		; Save success/failure flag (carry)
	MOV	%0,%1		; Copy command file FDB pointer
	ADD	#F.FNB,%1	; Make filename block pointer
	MOV	#"TI,N.DVNM(%1)	; Set device to TI
	CLR	N.UNIT(%1)	;		  0: to
	JSR	PC,.ASLUN	; reset LUN 5 to TI: if GCML changed it
	ROR	(SP)+		; Did command fetch work?
	BCC	5$		; Yes, continue
	CMPB	GC+G.ERR,#GE.EOF ; User typed ctrl/Z?
	BNE	4$		; No, some other error
	EXIT$S			; Yes, exit without complaint
4$:	MOV	#CMDERR,@SP	; No, load error text: "command line"
	BR	NOLINE		; Go print error message and exit
5$:	MOV	GC+G.CMLD+2,%3	; Get command line address
	MOVB	#' ,-(%3)	; Prefix line read with space
	MOV	#GC+G.DPRM+5,%1	; and 3-letter task name
	MOVB	-(%1),-(%3)	; which will become _pname
	MOVB	-(%1),-(%3)
	MOVB	-(%1),-(%3)
	MOV	GC+G.CMLD,%2	; Get command line length
	ADD	#4,%2		; Including task name and space
	RTS	PC		; Back to Whitesmith's original code

        .END
