
/*	VAX string descriptor
 */
typedef struct {
	unsigned short length;
	unsigned short type;
	char *pointer;
	} DESCRIPTOR;

/* Compile time descriptor set up										*/
#define $DESCRIPTOR(label, string) DESCRIPTOR label = {sizeof(string)-1, 0x10e, string}
/* Run time descriptor set up, when type must be initialised							*/
#define $DESCRIPTOR_I(label, string) label.length = sizeof(string)-1, label.type = 0x10e, label.pointer = string
/* Change descriptor to specify fixed string -- assumes type set up already					*/
#define $DESCRIPTOR_F(label, string) label.length = sizeof(string)-1, label.pointer = string
/* Change descriptor to specify string whose length must be determined at runtime				*/
/* e.g. by call as: $DESCRIPTOR_L(strdes, string, strlen(string));						*/
#define $DESCRIPTOR_L(label, string, lth) label.length = lth, label.pointer = string
