2 char *userv = "User Interface 4E(058), 14 Sep 87";   A /*  C K U U S R --  "User Interface" for Unix Kermit (Part 1)  */     /*;  4E, support for Apollo Aegis, Data General added, July 87.  */ /*&  Author: Frank da Cruz (SY.FDC@CU20B),C  Columbia University Center for Computing Activities, January 1985. M  Copyright (C) 1985, Trustees of Columbia University in the City of New York. H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */   /*L  The ckuusr module contains the terminal input and output functions for UnixH  Kermit.  It includes a simple Unix-style command line parser as well asN  an interactive prompting keyword command parser.  It depends on the existenceN  of Unix facilities like fopen, fgets, feof, (f)printf, argv/argc, etc.  OtherM  functions that are likely to vary among Unix implementations -- like setting L  terminal modes or interrupts -- are invoked via calls to functions that are6  defined in the system-dependent modules, ck?[ft]io.c.   K  The command line parser processes any arguments found on the command line, O  as passed to main() via argv/argc.  The interactive parser uses the facilities L  of the cmd package (developed for this program, but usable by any program).   K  Any command parser may be substituted for this one.  The only requirements )  for the Kermit command parser are these:    H  1. Set parameters via global variables like duplex, speed, ttname, etc.J     See ckmain.c for the declarations and descriptions of these variables.   I  2. If a command can be executed without the use of Kermit protocol, then K     execute the command directly and set the variable sstate to 0. Examples L     include 'set' commands, local directory listings, the 'connect' command.   K  3. If a command requires the Kermit protocol, set the following variables:    2     sstate                             string data/       'x' (enter server mode)            (none) 6       'r' (send a 'get' command)         cmarg, cmarg2/       'v' (enter receive mode)           cmarg2 .       'g' (send a generic command)       cmargH       's' (send files)                   nfils, cmarg & cmarg2 OR cmlist.       'c' (send a remote host command)   cmarg   .     cmlist is an array of pointers to strings.*     cmarg, cmarg2 are pointers to strings.     nfils is an integer.       6     cmarg can be a filename string (possibly wild), or>        a pointer to a prefabricated generic command string, or*        a pointer to a host command string.6     cmarg2 is the name to send a single file under, orH        the name under which to store an incoming file; must not be wild.C     cmlist is a list of nonwild filenames, such as passed via argv. 0     nfils is an integer, interpreted as follows:I       -1: argument string is in cmarg, and should be expanded internally.         0: stdin./       >0: number of files to send, from cmlist.    I  The screen() function is used to update the screen during file transfer. 1  The tlog() function maintains a transaction log. 0  The debug() function maintains a debugging log.J  The intmsg() and chkint() functions provide the user i/o for interrupting    file transfers. */   /* Includes */    #include "ckcdeb.h"  #include <stdio.h> #include <ctype.h>
 #ifndef AMIGA  #include <signal.h>  #endif #include "ckcker.h"  #include "ckucmd.h"  #include "ckuusr.h"     #ifdef datageneral; #define fgets(stringbuf,max,fd) dg_fgets(stringbuf,max,fd)   #define fork() vfork()F /* DG version 3.21 of C has bugs in the following routines, since theyF  * depend on /etc/passwd.  In the context where the routines are used,  * we don't need them anyway.   */  #define getgid() -1  #define getuid() -1  #define geteuid() -1 #endif   > /* External Kermit Variables, see ckmain.c for description. */   . extern int size, rpsiz, urpsiz, speed, local, >   server, displa, binary, parity, deblog, escape, xargc, flow,>   turn, duplex, nfils, ckxech, pktlog, seslog, tralog, stdouf,:   turnch, dfloc, keep, maxrps, warn, quiet, cnflg, tlevel;   H extern char *versio, *protv, *ckxv, *ckzv, *fnsv, *connv, *dftty, *cmdv; extern char *dialv, *loginv;A extern char *ckxsys, *ckzsys, *cmarg, *cmarg2, **xargv, **cmlist; ' extern char *DIRCMD, *PWDCMD, cmerrp[];  extern CHAR sstate, ttname[];  char *strcpy(), *getenv(); #ifdef AMIGA char *getcwd();  #endif   # /* Declarations from cmd package */    , extern char cmdbuf[];			/* Command buffer */   ' /* Declarations from ck?fio.c module */    D extern char *SPACMD, *zhome();		/* Space command, home directory. */: extern int backgrd;			/* Kermit executing in background */   L /* The background flag is set by ckutio.c (via conint() ) to note whether */L /* this kermit is executing in background ('&' on shell command line).    */      0 /* Variables and symbols local to this module */   > char line[CMDBL+10], *lp;		/* Character buffer for anything */0 char debfil[50];			/* Debugging log file name */- char pktfil[50];			/* Packet log file name */ . char sesfil[50];			/* Session log file name */2 char trafil[50];			/* Transaction log file name */   $ int n,					/* General purpose int */1     cflg,				/* Command-line connect cmd given */ 3     action,				/* Action selected on command line*/ #     repars,				/* Reparse needed */ (     cwdf = 0;				/* CWD has been done */   8 #define MAXTAKE 20			/* Maximum nesting of TAKE files */< FILE *tfile[MAXTAKE];			/* File pointers for TAKE command */   7 char *homdir;				/* Pointer to home directory string */ 8 char cmdstr[100];			/* Place to build generic command */  8 /*  C M D L I N  --  Get arguments from command line  */ /*K  Simple Unix-style command line parser, conforming with 'A Proposed Command K  Syntax Standard for Unix Systems', Hemenway & Armitage, Unix/World, Vol.1,   No.3, 1984. */
 cmdlin() {.     char x;				/* Local general-purpose int */+     cmarg = "";				/* Initialize globals */      cmarg2 = "";     action = cflg = 0;   >     while (--xargc > 0) {		/* Go through command line words */	 	xargv++; " 	debug(F111,"xargv",*xargv,xargc);B     	if (**xargv == '-') {		/* Got an option (begins with dash) */2 	    x = *(*xargv+1);		/* Get the option letter */. 	    x = doarg(x);		/* Go handle the option */! 	    if (x < 0) doexit(BAD_EXIT); ,     	} else {			/* No dash where expected */
 	    usage();  	    doexit(BAD_EXIT); 	}     } #     debug(F101,"action","",action);      if (!local) { * 	if ((action == 'g') || (action == 'r') ||$ 	    (action == 'c') || (cflg != 0))! 	    fatal("-l and -b required");      }      if (*cmarg2 != 0) { * 	if ((action != 's') && (action != 'r') && 	    (action != 'v')) ' 	    fatal("-a without -s, -r, or -g");      } 2     if ((action == 'v') && (stdouf) && (!local)) {     	if (isatty(1)) = 	    fatal("unredirected -k can only be used in local mode");      } -     if ((action == 's') || (action == 'v') || *     	(action == 'r') || (action == 'x')) { 	if (local) displa = 1; ' 	if (stdouf) { displa = 0; quiet = 1; }      }    ?     if (quiet) displa = 0;		/* No display if quiet requested */         if (cflg) { ' 	conect();			/* Connect if requested */  	if (action == 0) { 6 	    if (cnflg) conect();	/* And again if requested */; 	    doexit(GOOD_EXIT);		/* Then exit indicating success */  	}     } @     if (displa) concb(escape);		/* (for console "interrupts") */:     return(action);			/* Then do any requested protocol */ }   2 /*  D O A R G  --  Do a command-line argument.  */    doarg(x) char x; {     int z; char *xp;   3     xp = *xargv+1;			/* Pointer for bundled args */      while (x) { 
 	switch (x) {     case 'x':				/* server */ -     if (action) fatal("conflicting actions");      action = 'x'; 
     break;   	 case 'f': -     if (action) fatal("conflicting actions"); "     action = setgen('F',"","","");
     break;    case 'r':				/* receive */-     if (action) fatal("conflicting actions");      action = 'v'; 
     break;   $ case 'k':				/* receive to stdout */-     if (action) fatal("conflicting actions");      stdouf = 1;,     action = 'v';*
     break;  - case 's': 				/* send */-     if (action) fatal("conflicting actions");r=     if (*(xp+1)) fatal("invalid argument bundling after -s");F8     z = nfils = 0;			/* Initialize file counter, flag */3     cmlist = xargv+1;			/* Remember this pointer */(3     while (--xargc > 0) {		/* Traverse the list */	o
 	*xargv++;5 	if (**xargv == '-') {		/* Check for sending stdin */o( 	    if (strcmp(*xargv,"-") != 0) break;	 	    z++;n	         }n# 	nfils++;			/* Bump file counter */c     }t/     xargc++, *xargv--;			/* Adjust argv/argc */o4     if (nfils < 1) fatal("missing filename for -s");)     if (z > 1) fatal("-s: too many -'s");i     if (z == 1) {e 	if (nfils == 1) nfils = 0;a: 	else fatal("invalid mixture of filenames and '-' in -s");     }e     if (nfils == 0) {i; 	if (isatty(0)) fatal("sending from terminal not allowed");n     }t      debug(F101,*xargv,"",nfils);     action = 's';l
     break;  t /* cont'd... */i r /* ...doarg(), cont'd */  s case 'g':				/* get */-     if (action) fatal("conflicting actions");t=     if (*(xp+1)) fatal("invalid argument bundling after -g");u     *xargv++, xargc--;)     if ((xargc == 0) || (**xargv == '-'))i&     	fatal("missing filename for -g");     cmarg = *xargv;d     action = 'r';r
     break;  l! case 'c':				/* connect before */d
     cflg = 1;s
     break;  t  case 'n':				/* connect after */     cnflg = 1;
     break;  a case 'h':				/* help */a     usage();     return(-1);i  d case 'a':				/* "as" */.=     if (*(xp+1)) fatal("invalid argument bundling after -a");s     *xargv++, xargc--;(     if ((xargc < 1) || (**xargv == '-'))!     	fatal("missing name in -a");c     cmarg2 = *xargv;
     break;  v case 'l':				/* set line */ =     if (*(xp+1)) fatal("invalid argument bundling after -l");n     *xargv++, xargc--;(     if ((xargc < 1) || (**xargv == '-'))5     	fatal("communication line device name missing");      strcpy(ttname,*xargv);E /*  if (strcmp(ttname,dftty) == 0) local = dfloc; else local = 1;  */ E     local = (strcmp(ttname,CTTNAM) != 0); /* (better than old way) */ !     debug(F101,"local","",local);e     ttopen(ttname,&local,0);
     break;  i" case 'b':   	    			/* set baud */4     if (*(xp+1)) fatal("invalid argument bundling");     *xargv++, xargc--;(     if ((xargc < 1) || (**xargv == '-'))     	fatal("missing baud");s/     z = atoi(*xargv);			/* Convert to number */ 1     if (chkspd(z) > -1) speed = z;	/* Check it */r)     	else fatal("unsupported baud rate");i
     break;  g) case 'e':				/* Extended packet length */r4     if (*(xp+1)) fatal("invalid argument bundling");     *xargv++, xargc--;(     if ((xargc < 1) || (**xargv == '-'))     	fatal("missing length"); /     z = atoi(*xargv);			/* Convert to number */v     if (z > 10 && z < maxrps) {r         rpsiz = urpsiz = z; > 	if (z > 94) rpsiz = 94;		/* Fallback if other Kermit can't */.     } else fatal("Unsupported packet length");
     break;  i( case 'i':				/* Treat files as binary */     binary = 1;e
     break;  r /* cont'd... */o   /* ...doarg(), cont'd */  i  l case 'w':				/* File warning */a
     warn = 1; 
     break;  s case 'q':				/* Quiet */     quiet = 1;
     break;  r case 'd':				/* debug */     debopn("debug.log");
     break;  k case 'p':				/* set parity */i4     if (*(xp+1)) fatal("invalid argument bundling");     *xargv++, xargc--;(     if ((xargc < 1) || (**xargv == '-'))     	fatal("missing parity");l     switch(x = **xargv) {a
 	case 'e':
 	case 'o':
 	case 'm': 	case 's': parity = x; break;e 	case 'n': parity = 0; break; # 	default:  fatal("invalid parity");p	         }/
     break;   	 case 't':r0     turn = 1;				/* Line turnaround handshake */5     turnch = XON;			/* XON is turnaround character */ $     duplex = 1;				/* Half duplex */&     flow = 0;				/* No flow control */
     break;  n default:9     fatal("invalid argument, type 'kermit -h' for help");i	         }y  a2     x = *++xp;				/* See if options are bundled */     }c     return(0); }o t
 /* Misc */   3 fatal(msg) char *msg; {			/* Fatal error message */e*     fprintf(stderr,"\r\nFatal: %s\n",msg);     tlog(F110,"Fatal:",msg,0l);c5     doexit(BAD_EXIT);			/* Exit indicating failure */, }k  s  c3 ermsg(msg) char *msg; {			/* Print error message */M;     if (!quiet) fprintf(stderr,"\r\n%s - %s\n",cmerrp,msg);*      tlog(F110,"Error -",msg,0l); }h *! /* Interactive command parser */ i     m /* Top-Level Keyword Table */a  m struct keytab cmdtab[] = {     "!",	   XXSHE, 0,      "%",    	   XXCOM, CM_INV,     "bye",         XXBYE, 0,!     "c",           XXCON, CM_INV,/     "close",	   XXCLO, 0,K     "connect",     XXCON, 0,     "cwd",	   XXCWD, 0,      "dial",	   XXDIAL, 0,a     "directory",   XXDIR, 0,     "echo",        XXECH, 0,     "exit",	   XXEXI, 0,     "finish",	   XXFIN, 0,     "get",	   XXGET, 0,o     "help",	   XXHLP, 0,     "log",  	   XXLOG, 0,*     "quit",	   XXQUI, 0,!     "r",           XXREC, CM_INV,/     "receive",	   XXREC, 0,      "remote",	   XXREM, 0,!     "s",           XXSEN, CM_INV,;     "script",	   XXLOGI, 0,/     "send",	   XXSEN, 0,     "server",	   XXSER, 0,     "set",	   XXSET, 0,      "show", 	   XXSHO, 0,	     "space",       XXSPA, 0,     "statistics",  XXSTA, 0,     "take",	   XXTAK, 0l };4 int ncmd = (sizeof(cmdtab) / sizeof(struct keytab)); 	 /* Parameter keyword table */d  n struct keytab prmtab[] = {$     "baud",	        XYSPEE,  CM_INV,      "block-check",  	XYCHKT,  0,     "delay",	    	XYDELA,  0,	     "duplex",	    	XYDUPL,  0,G     "end-of-packet",    XYEOL,   CM_INV,    /* moved to send/receive */ #     "escape-character", XYESC,   0,o     "file", 	  	XYFILE,  0,l      "flow-control", 	XYFLOW,  0,      "handshake",    	XYHAND,  0,      "incomplete",   	XYIFD,   0,#     "line",             XYLINE,  0,,     "modem-dialer",	XYMODM,	 0,nG     "packet-length",    XYLEN,   CM_INV,    /* moved to send/receive *//G     "pad-character",    XYPADC,  CM_INV,    /* moved to send/receive */ G     "padding",          XYNPAD,  CM_INV,    /* moved to send/receive */      "parity",	    	XYPARI,  0,     "prompt",	    	XYPROM,  0,#     "receive",          XYRECV,  0,/#     "retry",            XYRETR,  0,p#     "send",             XYSEND,  0,*      "speed",	        XYSPEE,  0,G     "start-of-packet",  XYMARK,  CM_INV,    /* moved to send/receive */ #     "terminal",         XYTERM,  0,;F     "timeout",	        XYTIMO,  CM_INV     /* moved to send/receive */ };N int nprm = (sizeof(prmtab) / sizeof(struct keytab)); /* How many parameters */  f  l /* Remote Command Table */    struct keytab remcmd[] = {     "cwd",       XZCWD, 0,     "delete",    XZDEL, 0,     "directory", XZDIR, 0,     "help",      XZHLP, 0,     "host",      XZHOS, 0,     "space",	 XZSPA, 0,)     "type", 	 XZTYP, 0,      "who",  	 XZWHO, 0 };4 int nrmt = (sizeof(remcmd) / sizeof(struct keytab));  o struct keytab logtab[] = {     "debugging",    LOGD, 0,     "packets",	    LOGP, 0,l     "session",      LOGS, 0,     "transactions", LOGT, 0  };4 int nlog = (sizeof(logtab) / sizeof(struct keytab));  r /* Show command arguments */   # #define SHPAR 0				/* Parameters */d! #define SHVER 1				/* Versions */   f struct keytab shotab[] = {     "parameters", SHPAR, 0,O     "versions",   SHVER, 0 }; sB /*  C M D I N I  --  Initialize the interactive command parser  */   
 cmdini() {  / #ifdef AMIGA     congm();     concb(escape); #endif  (     tlevel = -1;			/* Take file level */2     cmsetp("C-Kermit>");		/* Set default prompt */  ;6 /* Look for init file in home or current directory. */        homdir = zhome();      lp = line;     lp[0] = '\0';	     if (homdir) {  	strcpy(lp,homdir);n" 	if (lp[0] == '/') strcat(lp,"/");     }      strcat(lp,KERMRC); #ifdef AMIGA(     reqoff();			/* disable requestors */ #endif/     if ((tfile[0] = fopen(line,"r")) != NULL) {	 	tlevel = 0;  	debug(F110,"init file",line,0);     }o!     if (homdir && (tlevel < 0)) {a     	strcpy(lp,KERMRC);e, 	if ((tfile[0] = fopen(line,"r")) != NULL) { 	    tlevel = 0;$ 	    debug(F110,"init file",line,0);	 	} else {a% 	    debug(F100,"no init file","",0);f	         }a     }n #ifdef AMIGA)     reqpop();				/* restore requestors */u #elsen+     congm();				/* Get console tty modes */n #endif }l  o/ /* Display version herald and initial prompt */e  h
 herald() {C     if (!backgrd) printf("%s,%s\nType ? for help\n",versio,ckxsys);  }   x  v. /*  T R A P  --  Terminal interrupt handler */    trap() {-     debug(F100,"terminal interrupt...","",0); 6     doexit(GOOD_EXIT);			/* Exit indicating success */ }* g> /*  P A R S E R  --  Top-level interactive command parser.  */  i
 parser() {     int xx, cbn;     char *cbp;  a #ifdef AMIGA1     reqres();			/* restore AmigaDOS requestors */s #endif5     concb(escape);		/* Put console in cbreak mode. */ =     conint(trap);		/* Turn on console terminal interrupts. */m /*I  sstate becomes nonzero when a command has been parsed that requires some'J  action from the protocol module.  Any non-protocol actions, such as localJ  directory listing or terminal emulation, are invoked directly from below. */C     if (local && !backgrd) printf("\n"); /*** Temporary kludge ***/g3     sstate = 0;				/* Start with no start state. */ B     while (sstate == 0) {		/* Parse cmds until action requested */D 	while ((tlevel > -1) && feof(tfile[tlevel])) { /* If end of take */0 		fclose(tfile[tlevel--]); /* file, close it. */1 		cmini(ckxech);		/* and clear the cmd buffer. */	7 		if (tlevel < 0) {	/* Just popped out of cmd files? */'7 		    conint(trap);	/* Check background stuff again. */t5 		    return(0);		/* End of init file or whatever. */( 		}c  	}  debug(F101,"tlevel","",tlevel);"* 	if (tlevel > -1) {		/* If in take file */, 	    cbp = cmdbuf;		/* Get the next line. */ 	    cbn = CMDBL;f  lN /* Loop to get next command line and all continuation lines from take file. */  1? again:	    if (fgets(line,cbn,tfile[tlevel]) == NULL) continue;e) 	    lp = line;			/* Got one, copy it. */* 	    while (*cbp++ = *lp++) C 	    	if (--cbn < 1) fatal("Command too long for internal buffer");T< 	    if (*(cbp - 3) == '\\') {	/* Continued on next line? */* 		cbp -= 3;		/* If so, back up pointer, */, 		goto again;		/* go back, get next line. */ 	    }= 	    stripq(cmdbuf);		/* Strip any quotes from cmd buffer. */v   + 	} else {			/* No take file, get typein. */'  )< 	    if (!backgrd) prompt();	/* Issue interactive prompt. */ 	    cmini(ckxech);      	} 	repars = 1; 	displa = 0; 	while (repars) {e, 	    cmres();			/* Reset buffer pointers. */* 	    xx = cmkey(cmdtab,ncmd,"Command","");) 	    debug(F101,"top-level cmkey","",xx);u 	    switch (docmd(xx)) {v 		case -4:		/* EOF */x3 		    doexit(GOOD_EXIT);	/* ...exit successfully */e' 	        case -1:		/* Reparse needed */e 		    repars = 1;  		    continue; + 	    	case -2:		/* Invalid command given */i5 		    if (backgrd) 	/* if in background, terminate */'9 			fatal("Kermit command error in background execution");r4 		    if (tlevel > -1) {	/* If in take file, quit */8 			ermsg("Kermit command error: take file terminated."); 			fclose(tfile[tlevel]);l 			tlevel--; 		    }w& 		    cmini(ckxech);	/* (fall thru) */4  	    	case -3:		/* Empty command OK at top level */+ 		default:		/* Anything else (fall thru) */"5 		    repars = 0;		/* No reparse, get new command. */y 		    continue;p
             }a	         }t     }nO /* Got an action command; disable terminal interrupts and return start state */l  i>     if (!local) connoi();		/* Interrupts off only if remote */     return(sstate);s }s p/ /*  D O E X I T  --  Exit from the program.  */   d  doexit(exitstat) int exitstat; {     2     ttclos();				/* Close external line, if any */     if (local) {1 	strcpy(ttname,dftty);		/* Restore default tty */r7 	local = dfloc;			/* And default remote/local status */      }w:     if (!quiet) conres();		/* Restore console terminal. */B     if (!quiet) connoi();		/* Turn off console interrupt traps. */  a.     if (deblog) {			/* Close any open logs. */% 	debug(F100,"Debug Log Closed","",0);* 	*debfil = '\0'; 	deblog = 0; 	zclose(ZDFILE);     }s     if (pktlog) {t 	*pktfil = '\0'; 	pktlog = 0; 	zclose(ZPFILE);     }m     if (seslog) {t     	*sesfil = '\0'; 	seslog = 0; 	zclose(ZSFILE);     }s     if (tralog) {	+ 	tlog(F100,"Transaction Log Closed","",0l);  	*trafil = '\0'; 	tralog = 0; 	zclose(ZTFILE);     }1     syscleanup();;3     exit(exitstat);				/* Exit from the program. */  }T L; /*  B L D L E N  --  Make length-encoded copy of string  */!    char *$ bldlen(str,dest) char *str, *dest; {     int len;     len = strlen(str);     *dest = tochar(len);     strcpy(dest+1,str);0     return(dest+len+1);C }       4 /*  S E T G E N  --  Construct a generic command  */  r= setgen(type,arg1,arg2,arg3) char type, *arg1, *arg2, *arg3; {	     char *upstr, *cp;s  	     cp = cmdstr;     *cp++ = type;o     *cp = NUL;     if (*arg1 != NUL) {  	upstr = bldlen(arg1,cp);  	if (*arg2 != NUL) {  	    upstr = bldlen(arg2,upstr);* 	    if (*arg3 != NUL) bldlen(arg3,upstr); 	}     }s     cmarg = cmdstr;M!     debug(F110,"setgen",cmarg,0);/        return('g'); },  # /*  D O C M D  --  Do a command  */   X /*	  Returns:s$    -2: user typed an illegal command    -1: reparse neededi?     0: parse was successful (even tho command may have failed).e */ d  ) docmd(cx) int cx; {a
     int x, y;r     char *s;  b     switch (cx) {k  a case -4:				/* EOF */u+     if (!quiet && !backgrd) printf("\r\n");k     doexit(GOOD_EXIT); case -3:				/* Null command */     return(0); case -2:				/* Error */k  case -1:				/* Reparse needed */     return(cx);e    case XXBYE:				/* bye */%     if ((x = cmcfm()) < 0) return(x);0     if (!local) {o* 	printf("You have to 'set line' first\n"); 	return(0);i     }t"     sstate = setgen('L',"","","");     return(0);  , case XXCOM:				/* comment */A     if ((x = cmtxt("Text of comment line","",&s)) < 0) return(x);r     return(0);  d. case XXCON:                     	/* connect */%     if ((x = cmcfm()) < 0) return(x);      return(doconect());m  d case XXCWD:i #ifdef AMIGAG     if (cmtxt("Name of local directory, or carriage return","",&s) < 0)      	return(-1);/     /* if no name, just print directory name */n
     if (*s) {  	if (chdir(s)) perror(s); 
 	cwdf = 1;     } +     if (getcwd(line, sizeof(line)) == NULL)*3 	printf("Current directory name not available.\n");Y     else$ 	if (!backgrd) printf("%s\n", line); #else/K     if (cmtxt("Name of local directory, or carriage return",homdir,&s) < 0)y     	return(-1);         if (chdir(s)) perror(s);
     cwdf = 1;/     system(PWDCMD);e #endif     return(0);   case XXCLO: 3     x = cmkey(logtab,nlog,"Which log to close","");      if (x == -3) {& 	printf("?You must tell which log\n"); 	return(-2);     }      if (x < 0) return(x); %     if ((y = cmcfm()) < 0) return(y);i     switch (x) {  ( 	case LOGD:) 	    if (deblog == 0) {t) 		printf("?Debugging log wasn't open\n");  		return(0); 	    } 	    *debfil = '\0'; 	    deblog = 0; 	    return(zclose(ZDFILE));  l 	case LOGP:l 	    if (pktlog == 0) {y& 		printf("?Packet log wasn't open\n"); 		return(0); 	    } 	    *pktfil = '\0'; 	    pktlog = 0; 	    return(zclose(ZPFILE));  a 	case LOGS:{ 	    if (seslog == 0) {,' 		printf("?Session log wasn't open\n");  		return(0); 	    } 	    *sesfil = '\0'; 	    seslog = 0; 	    return(zclose(ZSFILE));  A     	case LOGT:; 	    if (tralog == 0) {d+ 		printf("?Transaction log wasn't open\n");/ 		return(0); 	    } 	    *trafil = '\0'; 	    tralog = 0; 	    return(zclose(ZTFILE));  e	 	default:y7 	    printf("\n?Unexpected log designator - %ld\n", x);0 	    return(0);f     }r  ! case XXDIAL:				/* dial number */=@     if ((x = cmtxt("Number to be dialed","",&s)) < 0) return(x);     return(dial(s));  s case XXDIR:				/* directory */ #ifdef AMIGAI     if ((x = cmtxt("Directory/file specification","",&s)) < 0) return(x);0 #else  #ifdef datageneralJ     if ((x = cmtxt("Directory/file specification","+",&s)) < 0) return(x); #elseNJ     if ((x = cmtxt("Directory/file specification",".",&s)) < 0) return(x); #endif #endif     lp = line;!     sprintf(lp,"%s %s",DIRCMD,s);A     system(line);	     return(0);  s  s case XXECH: 				/* echo */B     if ((x = cmtxt("Material to be echoed","",&s)) < 0) return(x);     for ( ; *s; s++) {5 	if ((x = *s) == 0134) {		/* Convert octal escapes */T  	    s++;			/* up to 3 digits */@ 	    for (x = y = 0; *s >= '0' && *s <= '7' && y < 3; s++,y++) {  	    	x = x * 8 + (int) *s - 48; 	    }	 	    s--;)	         }x 	putchar(x);     }x     printf("\n");s     return(0);    case XXQUI:				/* quit, exit */i case XXEXI:r.     if ((x = cmcfm()) > -1) doexit(GOOD_EXIT);     else return(x);f  I case XXFIN:				/* finish */e%     if ((x = cmcfm()) < 0) return(x);o     if (!local) {t* 	printf("You have to 'set line' first\n"); 	return(0);o     }l"     sstate = setgen('F',"","","");     return(0);   case XXGET:				/* get */     if (!local) {s, 	printf("\nYou have to 'set line' first\n"); 	return(0);c     }sF     x = cmtxt("Name of remote file(s), or carriage return","",&cmarg);*     if ((x == -2) || (x == -1)) return(x);  )J /* If foreign file name omitted, get foreign and local names separately */   3     x = 0;				/* For some reason cmtxt returns 1 */      if (*cmarg == NUL) {  /2 	if (tlevel > -1) {		/* Input is from take file */   / 	    if (fgets(line,100,tfile[tlevel]) == NULL)e3 	    	fatal("take file ends prematurely in 'get'");d' debug(F110,"take-get 2nd line",line,0);  	    stripq(line); 	    for (x = strlen(line);	: 	     	 x > 0 && (line[x-1] == '\n' || line[x-1] == '\r'); 		 x--)t 		line[x-1] = '\0';( 	    cmarg = line;3 	    if (fgets(cmdbuf,CMDBL,tfile[tlevel]) == NULL)f3 	    	fatal("take file ends prematurely in 'get'");  	    stripq(cmdbuf); 	    for (x = strlen(cmdbuf); > 	     	 x > 0 && (cmdbuf[x-1] == '\n' || cmdbuf[x-1] == '\r'); 		 x--)  		cmdbuf[x-1] = '\0';l= 	    if (*cmdbuf == NUL) cmarg2 = line; else cmarg2 = cmdbuf;o&             x = 0;			/* Return code */   /         } else {			/* Input is from terminal */t  a+ 	    char psave[40];		/* Save old prompt *// 	    cmsavp(psave,40);? 	    cmsetp(" Remote file specification: "); /* Make new one *// 	    cmini(ckxech);i 	    x = -1; 	    if (!backgrd) prompt();5 	    while (x == -1) {		/* Prompt till they answer */N4 	    	x = cmtxt("Name of remote file(s)","",&cmarg); 		debug(F111," cmtxt",cmarg,x);m 	    } 	    if (x < 0) {  		cmsetp(psave); 		return(x); 	    }9 	    if (*cmarg == NUL) { 	/* If user types a bare CR, */ 3 		printf("(cancelled)\n"); /* Forget about this. */d/ 	    	cmsetp(psave);		/* Restore old prompt, */  		return(0);		/* and return. */F 	    }0 	    strcpy(line,cmarg);		/* Make a safe copy */ 	    cmarg = line;@ 	    cmsetp(" Local name to store it under: ");	/* New prompt */ 	    cmini(ckxech);d 	    x = -1; 	    if (!backgrd) prompt();8 	    while (x == -1) {		/* Again, parse till answered */. 	    	x = cmofi("Local file name","",&cmarg2); 	    }/ 	    if (x == -3) {	    	    	/* If bare CR, */c4 		printf("(cancelled)\n");	/* escape from this... */7 	    	cmsetp(psave);		        /* Restore old prompt, */;$ 		return(0);		    	/* and return. */C 	    } else if (x < 0) return(x);        /* Handle parse errors. */l 	    *& 	    x = -1;			/* Get confirmation. */! 	    while (x == -1) x = cmcfm();p. 	    cmsetp(psave);		/* Restore old prompt. */	         }a     }a:     if (x == 0) {			/* Good return from cmtxt or cmcfm, */' 	sstate = 'r';			/* set start state. */o 	if (local) displa = 1;u     }t     return(x);   case XXHLP:				/* Help */e5     x = cmkey(cmdtab,ncmd,"C-Kermit command","help");      return(dohlp(x));   s case XXLOG:				/* Log */,     x = cmkey(logtab,nlog,"What to log","");     if (x == -3) {4 	printf("?You must specify what is to be logged\n"); 	return(-2);     }      if (x < 0) return(x);e     return(dolog(x));    / case XXLOGI:				/* Send script remote system */tA     if ((x = cmtxt("Text of login script","",&s)) < 0) return(x);/=     return( login(s) );			/* Return 0=completed, -2=failed */b    case XXREC:				/* Receive */     cmarg2 = "";F     x = cmofi("Name under which to store the file, or CR","",&cmarg2);*     if ((x == -1) || (x == -2)) return(x);(     debug(F111,"cmofi cmarg2",cmarg2,x);%     if ((x = cmcfm()) < 0) return(x);d     sstate = 'v';l     if (local) displa = 1;     return(0);  1 case XXREM:				/* Remote */t     if (!local) {x, 	printf("\nYou have to 'set line' first\n"); 	return(-2);     }e=     x = cmkey(remcmd,nrmt,"Remote Kermit server command","");s     if (x == -3) {? 	printf("?You must specify a command for the remote server\n");c 	return(-2);     }      return(dormt(x));    case XXSEN:				/* Send */C     cmarg = cmarg2 = "";6     if ((x = cmifi("File(s) to send","",&s,&y)) < 0) { 	if (x == -3) { 3 	    printf("?A file specification is required\n");+ 	    return(-2); 	} 	return(x);(     }=7     nfils = -1;				/* Files come from internal list. */{<     strcpy(line,s);			/* Save copy of string just parsed. */"     debug(F101,"Send: wild","",y);3     *cmarg2 = '\0';			/* Initialize send-as name */      if (y == 0) { C 	if ((x = cmtxt("Name to send it with","",&cmarg2)) < 0) return(x);-     } else {" 	if ((x = cmcfm()) < 0) return(x);     } &     cmarg = line;			/* File to send */#     debug(F110,"Sending:",cmarg,0);o5     if (*cmarg2 != '\0') debug(F110," as:",cmarg2,0); )     sstate = 's';			/* Set start state */u     if (local) displa = 1;     return(0);    case XXSER:				/* Server */-%     if ((x = cmcfm()) < 0) return(x);;     sstate = 'x';r     if (local) displa = 1; #ifdef AMIGA5     reqoff();				/* no DOS requestors while server */( #endif     return(0);  ) case XXSET:				/* Set */*     x = cmkey(prmtab,nprm,"Parameter","");     if (x == -3) {2 	printf("?You must specify a parameter to set\n"); 	return(-2);     }      if (x < 0) return(x);t     return(doprm(x));e     )J /* XXSHE code by H. Fischer; copyright rights assigned to Columbia Univ */ /*H  Adapted to use getpwuid to find login shell because many systems do notE  have SHELL in environment, and to use direct calling of shell rather /  than intermediate system() call. -- H. Fischer; */( case XXSHE:				/* Local shell command */     {      int pid; #ifdef AMIGA:     if (cmtxt("Command to execute","",&s) < 0) return(-1); #else)E     if (cmtxt("Unix shell command to execute","",&s) < 0) return(-1);l #endif+     conres();				/* Make console normal  */  #ifdef AMIGA     system(s); #elser #ifdef MSDOS
     zxcmd(s);< #else 
 #ifdef vax11c    /     system(s);				/* Best we can do for VMS? */ # #else					/* All Unix systems... */0 #ifdef datageneral7     if (*s == NUL)			/* Interactive shell requested? */  #ifdef mvux) 	system("/bin/sh "); #elseh-         system("x :cli prefix Kermit_Baby:");  #endif     else				/* Otherwise, */,         system(s);			/* Best for aos/vs?? */  D# #else					/* All Unix systems... */f
 #ifdef apollog9     if ((pid = vfork()) == 0) {		/* Make child quickly */0? 	char *shpath, *shname, *shptr;	/* For finding desired shell */P   C         if ((shpath = getenv("SHELL")) == NULL) shpath = "/com/sh";e #else;   0     if ((pid = fork()) == 0) {		/* Make child */? 	char *shpath, *shname, *shptr;	/* For finding desired shell */  	struct passwd *p;# 	extern struct passwd * getpwuid();; 	extern int getuid();=) 	char *defShel = "/bin/sh";	/* Default */e  F/ 	p = getpwuid( getuid() );	/* Get login data */06 	if ( p == (struct passwd *) NULL || !*(p->pw_shell) ) 	    shpath = defShel; 	else= 	    shpath = p->pw_shell; #endif 	shptr = shname = shpath;f 	while (*shptr != '\0')n) 	    if (*shptr++ == '/') shname = shptr;   t6 /* Remove following uid calls if they cause trouble */ #ifdef BSD4=7 	setegid(getgid());		/* Override 4.3BSD csh security */ # 	seteuid(getuid());		/*  checks. *// #endif   4 	if (*s == NUL)			/* Interactive shell requested? */: 	    execl(shpath,shname,"-i",NULL);    /* Yes, do that */ 	else				/* Otherwise, */"C 	    execl(shpath,shname,"-c",s,NULL); /* exec the given command */f5 	exit(BAD_EXIT); }		/* Just punt if it didn't work */0  e     else {				/* Parent */  p2     	int wstat;			/* Kermit must wait for child */ 	SIGTYP (*istat)(), (*qstat)();    C 	istat = signal(SIGINT,SIG_IGN);	/* Let the fork handle keyboard */"< 	qstat = signal(SIGQUIT,SIG_IGN); /* interrupts itself... */  =?     	while (((wstat = wait((int *)0)) != pid) && (wstat != -1))g4 	                                /* Wait for fork */0 	signal(SIGINT,istat);		/* Restore interrupts */ 	signal(SIGQUIT,qstat);      }x #endif #endif #endif #endif6     concb(escape);			/* Console back in cbreak mode */     return(0); }I   case XXSHO:				/* Show */ (     x = cmkey(shotab,2,"","parameters");     if (x < 0) return(x);h%     if ((y = cmcfm()) < 0) return(y);(     switch (x) {    	case SHPAR: 	    shopar(); 	    break;"    	case SHVER:4 	    printf("\nVersions:\n %s\n %s\n",versio,protv); 	    printf(" %s\n",fnsv);% 	    printf(" %s\n %s\n",cmdv,userv);Y' 	    printf(" %s for%s\n",ckxv,ckxsys);(' 	    printf(" %s for%s\n",ckzv,ckzsys);t 	    printf(" %s\n",connv);") 	    printf(" %s\n %s\n\n",dialv,loginv);) 	    break;    	 	default:g& 	    printf("\nNothing to show...\n"); 	    break;r     }/     return(0);  	 case XXSPA:				/* space */ #ifdef datageneral@     /* The DG can take an argument after its "space" command. */M     if ((x = cmtxt("Confirm, or local directory name","",&s)) < 0) return(x); #     if (*s == NULL) system(SPACMD);e
     else {     	char *cp;9     	cp = alloc(strlen(s) + 7);      /* For "space *s" */	'     	strcpy(cp,"space "), strcat(cp,s);l     	system(cp);     	free(cp);     }  #else(%     if ((x = cmcfm()) < 0) return(x);d     system(SPACMD);l #endif     return(0);  t case XXSTA:				/* statistics */'%     if ((x = cmcfm()) < 0) return(x);      return(dostat());    case XXTAK:				/* take */n     if (tlevel > MAXTAKE-1) {x+ 	printf("?Take files nested too deeply\n");f 	return(-2);     }e=     if ((y = cmifi("C-Kermit command file","",&s,&x)) < 0) { / 	if (y == -3) {l3 	    printf("?A file specification is required\n");s 	    return(-2); 	} else return(y);     }(     if (x != 0) {s9 	printf("?Wildcards not allowed in command file name\n");  	return(-2);     } :     strcpy(line,s);			/* Make a safe copy of the string */%     if ((y = cmcfm()) < 0) return(y); 6     if ((tfile[++tlevel] = fopen(line,"r")) == NULL) { 	perror(line);& 	debug(F110,"Failure to open",line,0);
 	tlevel--;     }      return(0);  } default:*     printf("Not available - %s\n",cmdbuf);     return(-2);"     }l }\ ;3 /*  D O C O N E C T  --  Do the connect command  */R  oK /*  Note, we don't call this directly from dial, because we need to give */eE /*  the user a chance to change parameters (e.g. parity) after the */a /*  connection is made. */  * doconect() {
     int x;1     conres();				/* Put console back to normal */(!     x = conect();			/* Connect */n8     concb(escape);			/* Put console into cbreak mode, */1     return(x);				/* for more command parsing. */  }*