0 char *ckxv = "Unix tty I/O, 4E(046), 17 Sep 87";    /*  C K U T I O  */    K /* C-Kermit interrupt, terminal control & i/o functions for Unix systems */     /*&  Author: Frank da Cruz (SY.FDC@CU20B),C  Columbia University Center for Computing Activities, January 1985. M  Copyright (C) 1985, Trustees of Columbia University in the City of New York. H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */? /* Includes for all Unixes (conditional includes come later) */    $ #include <sys/types.h>			/* Types */   & #include <sys/dir.h>			/* Directory */* #include <ctype.h>			/* Character types */ #ifdef NULL  #undef NULL  #endif /* NULL */ , #include <stdio.h>			/* Unix Standard i/o */& #include <signal.h>			/* Interrupts */   
 #ifndef ZILOG % #include <setjmp.h>			/* Longjumps */  #else  #include <setret.h>  #endif   9 #include "ckcdeb.h"			/* Typedefs, formats for debug() */    1 /* Maximum length for the name of a tty device */     #ifndef DEVNAMLEN  #define DEVNAMLEN 25 #endif   9 /* 4.1 BSD support added by Charles E. Brooks, EDN-VAX */ K /* Fortune 32:16 Pro:For 1.8 support mostly like 4.1, added by J-P Dumas */     #ifdef BSD4  #define ANYBSD #ifdef MAXNAMLEN
 #define BSD42  #ifdef aegis+ char *ckxsys = " Apollo DOMAIN/IX 4.2 BSD";  #else  char *ckxsys = " 4.2 BSD"; #endif /* aegis */ #else  #ifdef FT18 
 #define BSD41 & char *ckxsys = " Fortune For:Pro 1.8"; #else 
 #define BSD41  #ifndef C70  char *ckxsys = " 4.1 BSD"; #endif /* not c70 */ #endif /* ft18 */  #endif /* maxnamlen */ #endif /* bsd4 */    7 /* 2.9bsd support contributed by Bradley Smith, UCLA */  #ifdef BSD29 #define ANYBSD char *ckxsys = " 2.9 BSD"; #endif /* bsd29 */    /*6  Version 7 UNIX support contributed by Gregg Wonderly,0  Oklahoma State University:  gregg@okstate.csnet */	 #ifdef	V7 & char *ckxsys = " Version 7 UNIX (tm)"; #endif /* v7 */    8 /* BBN C70 support from Frank Wancho, WANCHO@SIMTEL20 */
 #ifdef C70 char *ckxsys = " BBN C/70";  #endif /* c70 */   I /* IBM 370 IX/370 support from Wayne Van Pelt, GE/CRD, Schenectedy, NY */  #ifdef IX370 char *ckxsys = " IBM IX/370";  #endif /* ix370 */   M /* Amdahl UTS 2.4 (v7 derivative) for IBM 370 series compatible mainframes */ E /* Contributed by Garard Gaye, Jean-Pierre Dumas, DUMAS@SUMEX-AIM. */  #ifdef UTS24! char *ckxsys = " Amdahl UTS 2.4";  #endif /* uts24 */   4 /* Pro/Venix Version 1.x support from Columbia U. */
 #ifdef PROVX1 # char *ckxsys = " Pro-3xx Venix v1";  #endif /* provx1 */    = /* Tower support contributed by John Bray, Auburn, Alabama */ 
 #ifdef TOWER1 * char *ckxsys = " NCR Tower 1632, OS 1.02"; #endif /* tower1 */    A /* Sys III/V, Xenix, PC/IX support by Herm Fischer, Encino, CA */  #ifdef UXIII #ifdef XENIX char *ckxsys = " Xenix/286"; #else  #ifdef PCIX  char *ckxsys = " PC/IX"; #else  #ifdef ISIII6 char *ckxsys = " Interactive Systems Corp System III"; #else  #ifdef hpux 8 /* HP 9000 Series changes contributed by Bill Coalson */' char *ckxsys = " HP 9000 Series HP-UX";  #else  #ifdef aegis7 /* Apollo Aegis support from SAS Institute, Cary, NC */ , char *ckxsys = " Apollo DOMAIN/IX System V"; #else  #ifdef ZILOG) char *ckxsys = " Zilog S8000 Zeus 3.21+";  #else  #ifdef VXVE 7 /* Control Data Corp VX/VE 5.2.1 System V support by */ : /* S.O. Lidie, Lehigh University, LUSOL@LEHICDC1.BITNET */+ char *ckxsys = " CDC VX/VE 5.2.1 System V";  #else + char *ckxsys = " AT&T System III/System V";  #endif /* vxve  */ #endif /* zilog */ #endif /* aegis */ #endif /* hpux  */ #endif /* isiii */ #endif /* pcix  */ #endif /* xenix */ #endif /* uxiii */    /* Features... */    8 /* Do own buffering, using unbuffered read() calls... */ #ifdef UXIII #define MYREAD #endif /* uxiii */    #ifdef BSD42
 #undef MYREAD  #include <errno.h> #endif /* bsd42 */   /*&  Variables available to outside world:   A    dftty  -- Pointer to default tty name string, like "/dev/tty". 7    dfloc  -- 0 if dftty is console, 1 if external line.     dfprty -- Default parity !    dfflow -- Default flow control 0    ckxech -- Flag for who echoes console typein:0      1 - The program (system echo is turned off)0      0 - The system (or front end, or terminal).E    functions that want to do their own echoing should check this flag     before doing so.    9    flfnam -- Name of lock file, including its path, e.g., 3 		"/usr/spool/uucp/LCK..cul0" or "/etc/locks/tty77" >    hasLock -- Flag set if this kermit established a uucp lock.9    inbufc -- number of tty line rawmode unread characters  		(system III/V unixes) D    backgrd -- Flag indicating program executing in background ( & on= 		end of shell command). Used to ignore INT and QUIT signals.    L  Functions for assigned communication line (either external or console tty):   E    sysinit()               -- System dependent program initialization ?    syscleanup()            -- System dependent program shutdown J    ttopen(ttname,local,mdmtyp) -- Open the named tty for exclusive access.O    ttclos()                -- Close & reset the tty, releasing any access lock. K    ttpkt(speed,flow)       -- Put the tty in packet mode and set the speed. C    ttvt(speed,flow)        -- Put the tty in virtual terminal mode. 3 				or in DIALING or CONNECTED modem control state. ;    ttinl(dest,max,timo)    -- Timed read line from the tty. <    ttinc(timo)             -- Timed read character from tty.<    myread()		   -- System 3 raw mode bulk buffer read, gives7 			   --   subsequent chars one at a time and simulates  			   --   FIONREAD!A    myunrd(c)		   -- Places c back in buffer to be read (one only) J    ttchk()                 -- See how many characters in tty input buffer.C    ttxin(n,buf)            -- Read n characters from tty (untimed). 8    ttol(string,length)     -- Write a string to the tty.;    ttoc(c)                 -- Write a character to the tty. 5    ttflui()                -- Flush tty input buffer.    >    ttlock(ttname)	   -- Lock against uucp collisions (Sys III)*    ttunlck()		   -- Unlock "       "     "4    look4lk(ttname)	   -- Check if a lock file exists */   /* Functions for console terminal:    +    congm()   -- Get console terminal modes. N    concb(esc) -- Put the console in single-character wakeup mode with no echo.7    conbin(esc) -- Put the console in binary (raw) mode. @    conres()  -- Restore the console to mode obtained by congm().<    conoc(c)  -- Unbuffered output, one character to console.I    conol(s)  -- Unbuffered output, null-terminated string to the console. C    conola(s) -- Unbuffered output, array of strings to the console. @    conxo(n,s) -- Unbuffered output, n characters to the console.C    conchk()  -- Check if characters available at console (bsd 4.2). < 		Check if escape char (^\) typed at console (System III/V).;    coninc(timo)  -- Timed get a character from the console. L    conint()  -- Enable terminal interrupts on the console if not background.M    connoi()  -- Disable terminal interrupts on the console if not background.     Time functions   !    msleep(m) -- Millisecond sleep 2    ztime(&s) -- Return pointer to date/time string    rtimer() --  Reset timer <    gtimer()  -- Get elapsed time since last call to rtimer() */   /* Conditional Includes */    #ifdef FT18 0 #include <sys/file.h>	  		/* File information */ #endif /* ft18 */    ) /* Whether to #include <sys/file.h>... */  #ifndef PROVX1
 #ifndef aegis 
 #ifndef XENIX 0 #include <sys/file.h>	  		/* File information */ #endif /* xenix */ #endif /* aegis */ #endif /* provx1 */     #ifdef aegis #ifdef BSD4  #include <sys/file.h>  #include <fcntl.h> #endif /* bsd4 */  #endif /* aegis */    /* System III, System V */    #ifdef UXIII #include <termio.h>  #include <sys/ioctl.h>8 #include <fcntl.h>			/* directory reading for locking */; #include <errno.h>			/* error numbers for system returns */  #endif /* uxiii */    #ifdef HPUX  #include <sys/modem.h> #endif    /* Not Sys III/V */    
 #ifndef UXIII*, #include <sgtty.h>			/* Set/Get tty modes */ #ifndef PROVX1
 #ifndef V7
 #ifndef BSD41e? #include <sys/time.h>			/* Clock info (for break generation) */  #endif /* not bsd41 */ #endif /* not v7 */C #endif /* not provx1 */  #endif /* not uxiii */  a #ifdef BSD41. #include <sys/timeb.h>			/* BSD 4.1 ... ceb */ #endif /* bsd41 */    #ifdef BSD29: #include <sys/timeb.h>			/* BSD 2.9 (Vic Abell, Purdue) */ #endif /* bsd29 */  h
 #ifdef TOWER1l7 #include <sys/timeb.h>			/* Clock info for NCR Tower */g #endif /* tower1 */.    #ifdef aegis #include "/sys/ins/base.ins.c" #include "/sys/ins/error.ins.c"u #include "/sys/ins/ios.ins.c"  #include "/sys/ins/sio.ins.c"i #include "/sys/ins/pad.ins.c"	 #include "/sys/ins/time.ins.c" #include "/sys/ins/pfm.ins.c"U #include "/sys/ins/pgm.ins.c"  #include "/sys/ins/ec2.ins.c"<# #include "/sys/ins/type_uids.ins.c"n #include <default_acl.h> #undef TIOCEXCLm #undef FIONREADi #endif  rM /* The following two conditional #defines are catch-alls for those systems */ 3 /* that didn't have or couldn't find <file.h>... */    
 #ifndef FREADM #define FREAD 0x01 #endif  d #ifndef FWRITE #define FWRITE 0x10h #endif o /* Declarations */  r4 long time();				/* All Unixes should have this... */1 extern int errno;			/* System call error code. */   d/ /* Special stuff for V7 input buffer peeking */*  s	 #ifdef	V7l int kmem[2] = { -1, -1};" char *initrawq(), *qaddr[2]={0,0};
 #define CON 0/
 #define TTY 1f #endif /* v7 */S   F /* dftty is the device name of the default device for file transfer */O /* dfloc is 0 if dftty is the user's console terminal, 1 if an external line */d  /
 #ifdef PROVX1 I     char *dftty = "/dev/com1.dout"; /* Only example so far of a system */A@     int dfloc = 1;		    /* that goes in local mode by default */ #else >     char *dftty = CTTNAM;		/* Remote by default, use normal */5     int dfloc = 0;			/* controlling terminal name. */n #endif /* provx1 */h  *5     int dfprty = 0;			/* Default parity (0 = none) */ *     int ttprty = 0;			/* Parity in use. */(     int ttmdm = 0;			/* Modem in use. */1     int dfflow = 1;			/* Xon/Xoff flow control */7;     int backgrd = 0;			/* Assume in foreground (no '&' ) */i  fL int ckxech = 0; /* 0 if system normally echoes console characters, else 1 */   9 /* Declarations of variables global within this module */   *0 static long tcount;			/* Elapsed time counter */  @? static char *brnuls = "\0\0\0\0\0\0\0"; /* A string of nulls */   d3 static jmp_buf sjbuf, jjbuf;		/* Longjump buffer */f* static int lkf = 0,			/* Line lock flag */6     conif = 0,				/* Console interrupts on/off flag */4     cgmf = 0,				/* Flag that console modes saved */5     xlocal = 0,				/* Flag for tty local or remote */3,     ttyfd = -1;				/* TTY file descriptor */4 static char escchr;			/* Escape or attn character */  * #ifdef BSD42F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #endif /* bsd42 */  s #ifdef BSD29?     static long clock;			/* For getting time from sys/time.h */S8     static struct timeb ftp;		/* And from sys/timeb.h */ #endif /* bsd29 */  U #ifdef BSD41?     static long clock;			/* For getting time from sys/time.h */C8     static struct timeb ftp;		/* And from sys/timeb.h */ #endif /* bsd41 */  k
 #ifdef TOWER1S; static long clock;			/* For getting time from sys/time.h */p4 static struct timeb ftp;		/* And from sys/timeb.h */ #endif /* tower1 */O  E	 #ifdef V7E static long clock; #endif /* v7 */1  s! /* sgtty/termio information... */A    #ifdef UXIIID   static struct termio ttold = {0};	/* Init'd for word alignment, */E   static struct termio ttraw = {0};	/* which is important for some */e@   static struct termio tttvt = {0};	/* systems, like Zilog... */#   static struct termio ccold = {0};l#   static struct termio ccraw = {0};D$   static struct termio cccbrk = {0}; #elsef-   static struct sgttyb 			/* sgtty info... *//=     ttold, ttraw, tttvt, ttbuf,		/* for communication line */ 0     ccold, ccraw, cccbrk;		/* and for console */ #endif /* uxiii */  i8 static char flfnam[80];			/* uucp lock file path name */= static int hasLock = 0;			/* =1 if this kermit locked uucp */F@ static int inbufc = 0;			/* stuff for efficient SIII raw line */< static int ungotn = -1;			/* pushback to unread character */> static int conesc = 0;			/* set to 1 if esc char (^\) typed */   > static int ttlock();			/* definition of ttlock subprocedure */5 static int ttunlck();			/* and unlock subprocedure */KB static char ttnmsv[DEVNAMLEN];		/* copy of open path for tthang */ s #ifdef aegis6 static status_$t st;			/* error status return value */; static short concrp = 0; 		/* true if console is CRP pad */d #define CONBUFSIZ 10> static char conbuf[CONBUFSIZ];		/* console readahead buffer */; static int  conbufn = 0;		/* # chars in readahead buffer */c; static char *conbufp;			/* next char in readahead buffer */)* static uid_$t ttyuid;			/* tty type uid */- static uid_$t conuid;			/* stdout type uid */y  m /* APOLLO Aegis main()+  * establish acl usage and cleanup handlingt#  *    this makes sure that CRP pads #  *    get restored to a usable modee  */h( main(argc,argv) int argc; char **argv; { 	status_$t status; 	pfm_$cleanup_rec dirty;  e 	int pid = getpid();  t2 	/* acl usage according to invoking environment */ 	default_acl(USE_DEFENV);L   ' 	/* establish a cleanup continuation */i 	status = pfm_$cleanup(dirty);$ 	if (status.all != pfm_$cleanup_set) 	{3 		/* only handle faults for the original process */(8 		if (pid == getpid() && status.all > pgm_$max_severity)! 		{	/* blew up in main process */  			status_$t quo;  			pfm_$cleanup_rec clean;  	( 			/* restore the console in any case */ 			conres();  c 			/* attempt a clean exit */ 7 			debug(F101, "cleanup fault status", "", status.all);    3 			/* doexit(), then send status to continuation */( 			quo = pfm_$cleanup(clean);t# 			if (quo.all == pfm_$cleanup_set) ! 				doexit(pgm_$program_faulted);t( 			else if (quo.all > pgm_$max_severity)/ 				pfm_$signal(quo); /* blew up in doexit() */o 		}a) 		/* send to the original continuation */) 		pfm_$signal(status); 		/*NOTREACHED*/ 	} 	return(ckcmai(argc, argv)); }x #endif /* aegis */ iC /*  S Y S I N I T  --  System-dependent program initialization.  */m  s sysinit() {e    /* for now, nothing... */e     return(0); }o  wB /*  S Y S C L E A N U P  --  System-dependent program cleanup.  */    syscleanup() {  t /* for now, nothing... */a     return(0); }  n9 /*  T T O P E N  --  Open a tty for exclusive access.  */c  l, /*  Returns 0 on success, -1 on failure.  */ /*7   If called with lcl < 0, sets value of lcl as follows:yD   0: the terminal named by ttname is the job's controlling terminal.H   1: the terminal named by ttname is not the job's controlling terminal.F   But watch out: if a line is already open, or if requested line can't6   be opened, then lcl remains (and is returned as) -1. */9 ttopen(ttname,lcl,modem) char *ttname; int *lcl, modem; {     #ifdef UXIII #ifndef CIE 4     char *ctermid();			/* Wish they all had this! */ #endif /* not cie */ #endif /* uxiii */   * #ifdef CIE				/* CIE Regulus doesn't... */ #define ctermid(x) strcpy(x,"")e #endif  g$     char *x; extern char* ttyname();     char cname[DEVNAMLEN+4];  lG     if (ttyfd > -1) return(0);		/* If already open, ignore this call */ ;     ttmdm = modem;			/* Make this available to other fns */ ;     xlocal = *lcl;			/* Make this available to other fns */n #ifdef NEWUUCPB     acucntrl("disable",ttname);		/* Open getty on line (4.3BSD) */ #endif /* newuucp */ #ifdef UXIII5     /* if modem connection, don't wait for carrier */i:     ttyfd = open(ttname,O_RDWR | (modem ? O_NDELAY : 0) ); #elses=     ttyfd = open(ttname,2);		/* Try to open for read/write */  #endif /* uxiii */  <4     if (ttyfd < 0) {			/* If couldn't open, fail. */ 	perror(ttname); 	return(-1);     }  #ifdef aegisG     /* Apollo C runtime claims that console pads are tty devices, whichiF      * is reasonable, but they aren't any good for packet transfer. */0     ios_$inq_type_uid((short)ttyfd, ttyuid, st);     if (st.all != status_$ok) {n6 	fprintf(stderr, "problem getting tty object type: "); 	error_$print(st);?     } else if (ttyuid != sio_$uid) { /* reject non-SIO lines */f 	close(ttyfd); ttyfd = -1;  	errno = ENOTTY; perror(ttname); 	return(-1);     }> #endif /* aegis */L     strncpy(ttnmsv,ttname,DEVNAMLEN);	/* Open, keep copy of name locally. */  V> /* Caller wants us to figure out if line is controlling tty */  u(     debug(F111,"ttopen ok",ttname,*lcl);     if (*lcl == -1) {eC 	if (strcmp(ttname,CTTNAM) == 0) {   /* "/dev/tty" always remote */s, 	    debug(F110," Same as CTTNAM",ttname,0); 	    xlocal = 0;= 	} else if (isatty(0)) {		/* Else, if stdin not redirected */"8 	    x = ttyname(0);		/* then compare its device name */F 	    strncpy(cname,x,DEVNAMLEN);	/* (copy from internal static buf) */# 	    debug(F110," ttyname(0)",x,0);e< 	    x = ttyname(ttyfd); 	/* ...with real name of ttname. */8 	    xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1;% 	    debug(F111," ttyname",x,xlocal);v. 	} else {			/* Else, if stdin redirected... */ #ifdef UXIIIO /* Sys III/V provides nice ctermid() function to get name of controlling tty */c@     	    ctermid(cname);		/* Get name of controlling terminal */$ 	    debug(F110," ctermid",cname,0);? 	    x = ttyname(ttyfd); 	/* Compare with name of comm line. */i8 	    xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1;% 	    debug(F111," ttyname",x,xlocal);  #elsefF /* Just assume local, so "set speed" and similar commands will work */7 /* If not really local, how could it work anyway?... */i 	    xlocal = 1;/ 	    debug(F101," redirected stdin","",xlocal);f #endif /* uxiii */	         }e	     }    "  *H /* Now check if line is locked -- if so fail, else lock for ourselves */         lkf = 0;				/* Check lock */     if (xlocal > 0) {M 	if (ttlock(ttname) < 0) {> 	    fprintf(stderr,"Exclusive access to %s denied\n",ttname); 	    close(ttyfd); ttyfd = -1;3 	    debug(F110," Access denied by lock",ttname,0); . 	    return(-1);			/* Not if already locked */     	} else lkf = 1;     }u   8 /* Got the line, now set the desired value for local. */  n      if (*lcl < 0) *lcl = xlocal;  u" /* Some special stuff for v7... */  *	 #ifdef	V7m6 	if (kmem[TTY] < 0) {	/*  If open, then skip this.  */5 		qaddr[TTY] = initrawq(ttyfd);	/* Init the queue. */ / 		if ((kmem[TTY] = open("/dev/kmem", 0)) < 0) { 8 			fprintf(stderr, "Can't read /dev/kmem in ttopen.\n"); 			perror("/dev/kmem");c 			exit(1);f 		}u 	} #endif /* v7 */r  f8 /* Request exclusive access on systems that allow it. */  	
 #ifndef XENIXtF /* Xenix exclusive access prevents open(close(...)) from working... */ #ifdef TIOCEXCL=)     	if (ioctl(ttyfd,TIOCEXCL, NULL) < 0) C 	    fprintf(stderr,"Warning, problem getting exclusive access\n");* #endif /* tiocexcl */e #endif /* xenix */    /* Get tty device settings *//  o
 #ifndef UXIII .     gtty(ttyfd,&ttold);			/* Get sgtty info */ #ifdef aegis7     sio_$control((short)ttyfd, sio_$raw_nl, false, st);o5     if (xlocal) {	/* ignore breaks from local line */i8 	sio_$control((short)ttyfd, sio_$int_enable, false, st);9 	sio_$control((short)ttyfd, sio_$quit_enable, false, st);i     }  #endif /* aegis */;     gtty(ttyfd,&ttraw);			/* And a copy of it for packets*//?     gtty(ttyfd,&tttvt);			/* And one for virtual tty service */n #elsefC     ioctl(ttyfd,TCGETA,&ttold);		/* Same deal for Sys III, Sys V */  #ifdef aegis7     sio_$control((short)ttyfd, sio_$raw_nl, false, st); 5     if (xlocal) {	/* ignore breaks from local line */d8 	sio_$control((short)ttyfd, sio_$int_enable, false, st);9 	sio_$control((short)ttyfd, sio_$quit_enable, false, st);*     }i #endif /* aegis */     ioctl(ttyfd,TCGETA,&ttraw);t     ioctl(ttyfd,TCGETA,&tttvt);  #endif /* not uxiii */  c #ifdef VXVE 3     ttraw.c_line = 0;			/* STTY line 0 for VX/VE */      ioctl(ttyfd,TCSETA,&ttraw);t3     tttvt.c_line = 0;			/* STTY line 0 for VX/VE */,     ioctl(ttyfd,TCSETA,&tttvt);m #endif /* vxve */    )     debug(F101,"ttopen, ttyfd","",ttyfd);/     debug(F101," lcl","",*lcl);c(     debug(F111," lock file",flfnam,lkf);     return(0); }h o; /*  T T C L O S  --  Close the TTY, releasing any lock.  */b   
 ttclos() {1     if (ttyfd < 0) return(0);		/* Wasn't open. */t     if (xlocal) {c) 	if (tthang())			/* Hang up phone line */ ? 	    fprintf(stderr,"Warning, problem hanging up the phone\n");c3     	if (ttunlck())			/* Release uucp-style lock */c9 	    fprintf(stderr,"Warning, problem releasing lock\n");a     }v"     ttres();				/* Reset modes. */< /* Relinquish exclusive access if we might have had it... */
 #ifndef XENIX  #ifdef TIOCEXCLs #ifdef TIOCNXCL	)     if (ioctl(ttyfd, TIOCNXCL, NULL) < 0) I     	fprintf(stderr,"Warning, problem relinquishing exclusive access\n");/ #endif /* tiocnxcl */  #endif /* tiocexcl */h #endif /* not xenix */#     close(ttyfd);			/* Close it. */h #ifdef NEWUUCP:     acucntrl("enable",flfnam);		/* Close getty on line. */ #endif /* newuucp */+     ttyfd = -1;				/* Mark it as closed. */b     return(0); }c  n' /*  T T H A N G -- Hangup phone line */C  p
 tthang() { #ifdef UXIII #ifdef HPUXd)     unsigned long dtr_down = 00000000000,a                   modem_rtn; #elsea     unsigned short ttc_save; #endif /* hpux */  #endif /* uxiii */  i.     if (ttyfd < 0) return(0);		/* Not open. */ #ifdef aegisC     sio_$control((short)ttyfd, sio_$dtr, false, st);	/* DTR down */i      msleep(500);					/* pause */A     sio_$control((short)ttyfd, sio_$dtr, true,  st);	/* DTR up */i #elset
 #ifdef ANYBSD.-     ioctl(ttyfd,TIOCCDTR,0);		/* Clear DTR */n*     msleep(500);			/* Let things settle *//     ioctl(ttyfd,TIOCSDTR,0);		/* Restore DTR */n #endif /* anybsd */e #ifdef UXIII9 #ifdef HPUX   /* Hewlett Packard way of modem control  */tG     if (ioctl(ttyfd,MCSETAF,&dtr_down) < 0) return(-1); /* lower DTR */a     msleep(500);M     if (ioctl(ttyfd,MCGETA,&modem_rtn) < 0) return(-1); /* get line status */rM     if ((modem_rtn & MDCD) != 0) return(-1);        /* check if DCD is low */)M     modem_rtn = MRTS | MDTR;                        /* bits for RTS & DTR  */ M     if (ioctl(ttyfd,MCSETAF,&modem_rtn) < 0) return(-1);    /*  set lines  */  #else/     ttc_save = ttraw.c_cflag; E     ttraw.c_cflag &= ~CBAUD;		/* swa: set baud rate to 0 to hangup */ @     if (ioctl(ttyfd,TCSETAF,&ttraw) < 0) return(-1); /* do it */*     msleep(100);			/* let things settle */     ttraw.c_cflag = ttc_save;{  tN /* NOTE - The following #ifndef...#endif can be removed for SCO Xenix 2.1.3 */N /* or later, but must keep for earlier versions, which can't do close/open. */   B #ifndef XENIX		/* xenix cannot do close/open when carrier drops */0 				/* following corrects a PC/IX defficiency */&     ttc_save = fcntl(ttyfd,F_GETFL,0);5     close(ttyfd);		/* close/reopen file descriptor */a9     if ((ttyfd = open(ttnmsv, ttc_save)) < 0) return(-1);n #endif /* not xenix */C     if (ioctl(ttyfd,TCSETAF,&ttraw) < 0) return(-1); /* un-do it */  #endif /* uxiii */ #endif /* hpux  */ #endif /* aegis */     return (0);i };  /  i9 /*  T T R E S  --  Restore terminal to "normal" mode.  */x   - ttres() {				/* Restore the tty to normal. */ 
     int x;  r/     if (ttyfd < 0) return(-1);		/* Not open. */t' #ifndef UXIII				/* except for sIII, */A6     sleep(1);				/* Wait for pending i/o to finish. */7 #endif	/* uxiii */			/*   (sIII does wait in ioctls) */a  t #ifdef UXIIIO     if (ioctl(ttyfd,TCSETAW,&ttold) < 0) return(-1); /* restore termio stuff */iH     if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 )       return(-1);e #else /* not uxiii */  #ifdef FIONBIO
     x = 0;      x = ioctl(ttyfd,FIONBIO,&x);     if (x < 0) { 	perror("ttres ioctl");Y  	debug(F101,"ttres ioctl","",x);     }, #else /* not fionbio */e #ifdef FNDELAYG     x = (fcntl(ttyfd,F_SETFL,fcntl(ttyfd,F_GETFL,0) & ~FNDELAY) == -1);/#     debug(F101,"ttres fcntl","",x);      if (x < 0) perror("fcntl");  #endif /* fndelay */ #endif /* fionbio */6     x = stty(ttyfd,&ttold);		/* Restore sgtty stuff */"     debug(F101,"ttres stty","",x);     if (x < 0) perror("stty"); #endif /* uxiii */     return(x); }k n) /* Exclusive uucp file locking control */e /**  by H. Fischer, creative non-Bell coding !B  copyright rights for lock modules assigned to Columbia University */
 static char *== xxlast(s,c) char *s; char c; {		/* Equivalent to strrchr() */ 
     int i;#     for (i = strlen(s); i > 0; i--),.     	if ( s[i-1] == c ) return( s + (i - 1) );     return(NULL);      }e static look4lk(ttname) char *ttname; {1%     extern char *strcat(), *strcpy();l     char *device, *devname;e;     char lockfil[50];			/* Max length for lock file name */g  1 #ifdef ISIII!     char *lockdir = "/etc/locks";  #else 
 #ifdef ATT3BX{'     char *lockdir = "/usr/spool/locks";  #elset #ifdef NEWUUCP*     char *lockdir = "/usr/spool/uucp/LCK"; #elsex&     char *lockdir = "/usr/spool/uucp"; #endif /* newuucp */ #endif /* att3bx */, #endif /* isiii */  tJ     device = ( (devname=xxlast(ttname,'/')) != NULL ? devname+1 : ttname);  A #ifdef ISIII%     (void) strcpy( lockfil, device );o #else 1     strcat( strcpy( lockfil, "LCK.." ), device );d #endif /* isiii */  pI     if (access( lockdir, 04 ) < 0) {	/* read access denied on lock dir */ C 	fprintf(stderr,"Warning, read access to lock directory denied\n");F3 	return( 1 );			/* cannot check or set lock file */*     }e 	t8     strcat(strcat(strcpy(flfnam,lockdir),"/"), lockfil);#     debug(F110,"look4lk",flfnam,0);F  ,C     if ( ! access( flfnam, 00 ) ) {	/* print out lock file entry */a 	char lckcmd[40] ;, 	strcat( strcpy(lckcmd, "ls -l ") , flfnam); 	system(lckcmd); 	if (access(flfnam,02) == 0)G 	    printf("(You may type \"! rm %s\" to remove this file)\n",flfnam);  	return( -1 );     }NH     if ( access( lockdir, 02 ) < 0 ) {	/* lock file cannot be written */D 	fprintf(stderr,"Warning, write access to lock directory denied\n");
 	return( 1 );      }r2     return( 0 );			/* okay to go ahead and lock */ }    /*  T T L O C K  */=  ; static7 ttlock(ttfd) char *ttfd; {		/* lock uucp if possible */r
 #ifndef aegis 
 #ifdef ATT3BXe     FILE *lck_fild;  #endif /* att3bx */G     int lck_fil, l4l;e;     int pid_buf = getpid();		/* pid to save in lock file */o 	;'     hasLock = 0;			/* not locked yet */      l4l = look4lk(ttfd);3     if (l4l < 0) return (-1);		/* already locked */[D     if (l4l == 1) return (0);		/* can't read/write lock directory */=     lck_fil = creat(flfnam, 0444);	/* create lock file ... *//A     if (lck_fil < 0) return (-1);	/* create of lockfile failed */ 7 		/* creat leaves file handle open for writing -- hf */s
 #ifdef ATT3BXoB     fprintf((lck_fild = fdopen(lck_fil, "w")), "%10d\n", pid_buf);     fflush(lck_fild);i #else/O     write (lck_fil, &pid_buf, sizeof(pid_buf) ); /* uucp expects int in file */r #endif /* att3bx */e     close (lck_fil);&     hasLock = 1;			/* now is locked */ #endif /* not aegis */     return(0); }*    /*  T T U N L O C K  */t  t static/ ttunlck() {				/* kill uucp lock if possible */i,     if (hasLock) return( unlink( flfnam ) );     return(0); }l  	J /* New-style (4.3BSD) UUCP line direction control (Stan Barber, Rice U) */  l #ifdef NEWUUCP, acucntrl(flag,ttname) char *flag, *ttname; {,     char x[DEVNAMLEN+32], *device, *devname;  yF     if (strcmp(ttname,CTTNAM) == 0 || xlocal == 0) /* If not local, */%         return;				/* just return. */iK     device = ((devname = xxlast(ttname,'/')) != NULL ? devname+1 : ttname);s4     if (strncmp(device,"LCK..",4) == 0) device += 5;:     sprintf(x,"/usr/lib/uucp/acucntrl %s %s",flag,device);     debug(F000,"called ",x,0);     system(x); }i #endif /* newuucp */ ;C /*  T T P K T  --  Condition the communication line for packets. */  /*		or for modem dialing */(  f< #define DIALING	4		/* flags (via flow) for modem handling */ #define CONNECT 5   d6 /*  If called with speed > -1, also set the speed.  */  *, /*  Returns 0 on success, -1 on failure.  */  _3 ttpkt(speed,flow,parity) int speed, flow, parity; {t
     int s, x;v  m/     if (ttyfd < 0) return(-1);		/* Not open. */ =     ttprty = parity;			/* Let other tt functions see this. */(1     debug(F101,"ttpkt setting ttprty","",ttprty); .     s = ttsspd(speed);			/* Check the speed */  n
 #ifndef UXIII K     if (flow == 1) ttraw.sg_flags |= TANDEM; /* Use XON/XOFF if selected */c-     if (flow == 0) ttraw.sg_flags &= ~TANDEM;*2     ttraw.sg_flags |= RAW;		/* Go into raw mode */E     ttraw.sg_flags &= ~(ECHO|CRMOD);	/* Use CR for break character */ 
 #ifdef TOWER1d>     ttraw.sg_flags &= ~ANYP; 		/* Must tell Tower no parity */ #endif /* tower1 *//I     if (s > -1) ttraw.sg_ispeed = ttraw.sg_ospeed = s; /* Do the speed */ID     if (stty(ttyfd,&ttraw) < 0) return(-1);	/* Set the new modes. */  L
 #ifdef MYREADf #ifdef BSD4,# /* Try to make reads nonblocking */s #ifdef aegis     return(0); #endif /* aegis */ #ifdef FIONBIO
     x = 1;&     if (ioctl(ttyfd,FIONBIO,&x) < 0) { 	perror("ttpkt ioctl");  	return(-1);     }, #else /* fionbio */t #ifdef FNDELAYF     if (fcntl(ttyfd,F_SETFL,fcntl(ttyfd,F_GETFL,0) | FNDELAY) == -1) { 	return(-1);     }* #endif /* fndelay */ #endif /* bsd4 */p.     ttflui();				/* Flush any pending input */     return(0); #endif /* bsd4 */a #else  /* myread */o.     ttflui();				/* Flush any pending input */     return(0); #endif /* myread *// #endif /* not uxiii */  t #ifdef UXIII1     if (flow == 1) ttraw.c_iflag |= (IXON|IXOFF);t2     if (flow == 0) ttraw.c_iflag &= ~(IXON|IXOFF);  58     if (flow == DIALING)  ttraw.c_cflag |= CLOCAL|HUPCL;3     if (flow == CONNECT)  ttraw.c_cflag &= ~CLOCAL;.   $     ttraw.c_lflag &= ~(ICANON|ECHO);8     ttraw.c_lflag |= ISIG;		/* do check for interrupt */%     ttraw.c_iflag |= (BRKINT|IGNPAR);*J     ttraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|INPCK|ISTRIP|IXANY);     ttraw.c_oflag &= ~OPOST;%     ttraw.c_cflag &= ~(CSIZE|PARENB);e!     ttraw.c_cflag |= (CS8|CREAD);e #ifdef IX370J     ttraw.c_cc[4] = 48;	 /* So Series/1 doesn't interrupt on every char */     ttraw.c_cc[5] = 1; #else) #ifdef VXVE 4     ttraw.c_cc[4] = 1;   /* [VMIN]  for CDC VX/VE */4     ttraw.c_cc[5] = 0;   /* [VTIME] for CDC VX/VE */ #else 
 #ifdef MYREADfA     ttraw.c_cc[4] = 200; /* return max of this many characters *//J     ttraw.c_cc[5] = 1;   /* or when this many secs/10 expire w/no input */ #elsetL     ttraw.c_cc[4] = 1;   /* [VMIN]  Maybe should be bigger for all Sys V? */J     ttraw.c_cc[5] = 0;   /* [VTIME] Should be set high enough to ignore */" 					/* intercharacter spacing? */E     /* But then we have to distinguish between Sys III and Sys V.. */b #endif #endif #endif#     if (s > -1) {			/* set speed */           ttraw.c_cflag &= ~CBAUD; 	ttraw.c_cflag |= s;     }eK     if (ioctl(ttyfd,TCSETAW,&ttraw) < 0) return(-1);  /* set new modes . */f     if (flow == DIALING) {
 #ifndef aegis/E 	if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 )a
 		return(-1);n #endif /* not aegis */= 	close( open(ttnmsv,2) );	/* magic to force mode change!!! */      }t
     ttflui();      return(0); #endif /* uxiii */ }  iK /*  T T V T -- Condition communication line for use as virtual terminal  */o  l# ttvt(speed,flow) int speed, flow; {t
     int s;/     if (ttyfd < 0) return(-1);		/* Not open. */)  t.     s = ttsspd(speed);			/* Check the speed */  e
 #ifndef UXIIIAG     if (flow == 1) tttvt.sg_flags |= TANDEM; /* XON/XOFF if selected */ -     if (flow == 0) tttvt.sg_flags &= ~TANDEM;i*     tttvt.sg_flags |= RAW;		/* Raw mode */
 #ifdef TOWER1(J     tttvt.sg_flags &= ~(ECHO|ANYP);	/* No echo or system III ??? parity */ #else,+     tttvt.sg_flags &= ~ECHO;		/* No echo */e #endifI     if (s > -1) tttvt.sg_ispeed = tttvt.sg_ospeed = s; /* Do the speed */ +     if (stty(ttyfd,&tttvt) < 0) return(-1);d  g
 #ifdef MYREADc #ifdef BSD4  /* Make reads nonblocking */ #ifdef aegis 	return(0);f #endifA 	if (fcntl(ttyfd,F_SETFL,fcntl(ttyfd,F_GETFL,0) | FNDELAY) == -1)1 	    return(-1); 	else return(0); #endif /* bsd4 */) #endif /* myread */     #else /* uxiii *//1     if (flow == 1) tttvt.c_iflag |= (IXON|IXOFF);f2     if (flow == 0) tttvt.c_iflag &= ~(IXON|IXOFF);  )8     if (flow == DIALING)  tttvt.c_cflag |= CLOCAL|HUPCL;3     if (flow == CONNECT)  tttvt.c_cflag &= ~CLOCAL;b  .)     tttvt.c_lflag &= ~(ISIG|ICANON|ECHO);r%     tttvt.c_iflag |= (IGNBRK|IGNPAR);oJ     tttvt.c_iflag &= ~(INLCR|IGNCR|ICRNL|IUCLC|BRKINT|INPCK|ISTRIP|IXANY);     tttvt.c_oflag &= ~OPOST;%     tttvt.c_cflag &= ~(CSIZE|PARENB); !     tttvt.c_cflag |= (CS8|CREAD);e     tttvt.c_cc[4] = 1;     tttvt.c_cc[5] = 0;  t#     if (s > -1) {			/* set speed */1 	tttvt.c_cflag &= ~CBAUD;, 	tttvt.c_cflag |= s;     }eK     if (ioctl(ttyfd,TCSETAW,&tttvt) < 0) return(-1);  /* set new modes . */1  i     if (flow == DIALING) {
 #ifndef aegis"E 	if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 )e
 		return(-1);W #endif= 	close( open(ttnmsv,2) );	/* magic to force mode change!!! */k 	} #endif     return(0); }f  H /*  T T S S P D  --  Return the internal baud rate code for 'speed'.  */  n ttsspd(speed) {,     int s, spdok;n  +     if (speed < 0) return(-1);! 	spdok = 1;			/* Assume arg ok */) 	switch (speed) {c= 	    case 0:    s = B0;    break;	/* Just the common ones. */ @ 	    case 110:  s = B110;  break;	/* The others from ttydev.h */A 	    case 150:  s = B150;  break;	/* could also be included if */r4 	    case 300:  s = B300;  break;	/* necessary... */! 	    case 600:  s = B600;  break;c! 	    case 1200: s = B1200; break;"! 	    case 1800: s = B1800; break;l! 	    case 2400: s = B2400; break;s! 	    case 4800: s = B4800; break;c! 	    case 9600: s = B9600; break;;
 #ifdef PLEXUSp! 	    case 19200: s = EXTA; break;s #endif #ifdef aegis! 	    case 19200: s = EXTA; break;( #endif
 	    default:" 	    	spdok = 0;8 		fprintf(stderr,"Unsupported line speed - %d\n",speed);0 		fprintf(stderr,"Current speed not changed\n"); 		break; 	}    ' 	if (spdok) return(s); else return(-1);c  } n. /*  T T F L U I  --  Flush tty input buffer */  	
 ttflui() {  a
 #ifndef UXIII/     long n;  #endif/     if (ttyfd < 0) return(-1);		/* Not open. */	  l2     ungotn = -1;			/* Initialize myread() stuff */     inbufc = 0;c  i #ifdef aegis8     sio_$control((short)ttyfd, sio_$flush_in, true, st);     if (st.all != status_$ok) =     {  fprintf(stderr, "flush failed: "); error_$print(st); } 1     else {	/* sometimes the flush doesn't work */ 	 	for (;;)k 	{   char buf[256];== 	    /* eat all the characters that shouldn't be available */_@ 	    (void)ios_$get((short)ttyfd, ios_$cond_opt, buf, 256L, st);6 	    if (st.all == ios_$get_conditional_failed) break;< 	    fprintf(stderr, "flush failed(2): "); error_$print(st); 	}     }o #elsep #ifdef UXIII #ifndef VXVE:     if (ioctl(ttyfd,TCFLSH,0) < 0) perror("flush failed"); #endif /* vxve */k #elsep #ifdef TIOCFLUSH
 #ifdef ANYBSDp*     n = FREAD;				/* Specify read queue */>     if (ioctl(ttyfd,TIOCFLUSH,&n) < 0) perror("flush failed"); #elsef=     if (ioctl(ttyfd,TIOCFLUSH,0) < 0) perror("flush failed");* #endif #endif #endif #endif     return(0); }  s /* Interrupt Functions */r  r  u< /* Timeout handler for communication line input functions */   
 timerh() {     longjmp(sjbuf,1);a }r  i  U4 /* Set up terminal interrupts on console terminal */  g #ifdef UXIII- esctrp() {				/* trap console escapes (^\) */y     conesc = 1;t8     signal(SIGQUIT,SIG_IGN);		/* ignore until trapped */ }  #endif  		 #ifdef V7t- esctrp() {				/* trap console escapes (^\) */e     conesc = 1;d8     signal(SIGQUIT,SIG_IGN);		/* ignore until trapped */ }  #endif  ;
 #ifdef C70- esctrp() {				/* trap console escapes (^\) */;     conesc = 1;"8     signal(SIGQUIT,SIG_IGN);		/* ignore until trapped */ }  #endif   1 /*  C O N I N T  --  Console Interrupt setter  */.   6 conint(f) int (*f)(); {			/* Set an interrupt trap. */
     int x, y;o  fN /* Check for background operation, even if not running on real tty, so that */+ /* background flag can be set correctly. */c  s,     x = (signal(SIGINT,SIG_IGN) == SIG_IGN);*     debug(F101,"conint signal test","",x);     y = isatty(0);*     debug(F101,"conint isatty test","",y); #ifdef BSD29E /* For some reason the signal() test doesn't work under 2.9 BSD... */t     backgrd = !y;t #else      backgrd = (x || !y); #endif,     debug(F101,"conint backgrd","",backgrd);  )N /*** It's not really clear to me how to determine if we're running in the ***/N /*** background, or what the definition of background should be.  Anyone  ***/N /*** who has a clearer idea, please pass it along.  - Frank               ***/  R?     signal(SIGHUP,f);			/* Ensure lockfile cleared on hangup *//,     signal(SIGTERM,f);			/* or soft kill. */  iG /* check if invoked in background -- if so signals set to be ignored */a  <8     if (backgrd) {			/* In background, ignore signals */ #ifdef SIGTSTP- 	signal(SIGTSTP,SIG_IGN);	/* Keyboard stop */a #endif- 	signal(SIGQUIT,SIG_IGN);	/* Keyboard quit */O2 	signal(SIGINT,SIG_IGN);		/* Keyboard interrupt */     } else {2 	signal(SIGINT,f);		/* Catch terminal interrupt */ #ifdef SIGTSTP( 	signal(SIGTSTP,f);		/* Keyboard stop */ #endif #ifdef UXIII>         signal(SIGQUIT,esctrp);		/* Quit signal, Sys III/V. */9 	if (conesc) conesc = 0;		/* Clear out pending escapes *// #elsee	 #ifdef V7e8         signal(SIGQUIT,esctrp);		/* V7 like Sys III/V */ 	if (conesc) conesc = 0; #else  #ifdef aegis?         signal(SIGQUIT,f);		/* Apollo, catch it like others. */  #elsewH         signal(SIGQUIT,SIG_IGN);	/* Others, ignore like 4D & earlier. */ #endif #endif #endif/ 	conif = 1;			/* Flag console interrupts on. */U     }      return;  }N  )  t9 /*  C O N N O I  --  Reset console terminal interrupts */|  O) connoi() {				/* Console-no-interrupts */     #ifdef SIGTSTP     signal(SIGTSTP,SIG_DFL); #endif     signal(SIGINT,SIG_DFL);|     signal(SIGHUP,SIG_DFL);|     signal(SIGQUIT,SIG_DFL);     signal(SIGTERM,SIG_DFL);3     conif = 0;				/* Flag interrupt trapping off */R })  K /*  myread() -- For use by systems that can do nonblocking read() calls  */e /*	  Returns: /   -1  if no characters available, timer expireda&   -2  upon error (such as disconnect),-   otherwise value of character (0 or greater)D */
 myread() {     static int inbuf_item;     static CHAR inbuf[257];x     CHAR readit;  e     if (ungotn >= 0) { 	readit = ungotn; 
 	ungotn = -1;1     } else {         if (inbufc > 0) {." 	    readit = inbuf[++inbuf_item];         } else { #ifdef aegisK     /* myread() returns -1 when no input is available.  All the users of */	I     /* myread() explicitly loop until it returns a character or error. */t:     /* The Apollo code waits for input to be available. */        /* read in characters */E 	    inbufc = ios_$get((short)ttyfd, ios_$cond_opt, inbuf, 256L, st);o 	    errno = EIO;tF 	    if (st.all == ios_$get_conditional_failed) /* get at least one */4 		inbufc = ios_$get((short)ttyfd, 0, inbuf, 1L, st);0 	    if (st.all == ios_$end_of_file) inbufc = 0;# 	    else if (st.all != status_$ok)p$ 	    {   inbufc = -1; errno = EIO; } #else!+             inbufc = read(ttyfd,inbuf,256);; 	    if (inbufc > 0) { 		inbuf[inbufc] = '\0';i& 		debug(F101,"myread read","",inbufc); 	    } #endif /* aegis */ 	    if (inbufc == 0) {w 		if (ttmdm) {2 		    debug(F101,"myread read=0, ttmdm","",ttmdm);5 		    errno = 9999;	/* magic number for no carrier */ 1 		    return(-2);		/* end of file has no errno */=; 		} else return(-1);	/* in sys 5 means no data available */t 	    }( 	    if (inbufc < 0) {		/* Real error */ #ifdef EWOULDBLOCK8 		if (errno == EWOULDBLOCK) return(-1); else return(-2); #elsey
 		return(-2);r #endif /* ewouldblock */
     	    }$ 	    readit = inbuf[inbuf_item = 0]; 	}         inbufc--;	     }v!     return(((int) readit) & 255);  }   f; myunrd(ch) CHAR ch; {			/* push back up to one character */i     ungotn = ch; }e  J /*  I N I T R A W Q  --  Set up to read /DEV/KMEM for character count.  */  n	 #ifdef	V7G /*D  Used in Version 7 to simulate Berkeley's FIONREAD ioctl call.  ThisH  eliminates blocking on a read, because we can read /dev/kmem to get theD  number of characters available for raw input.  If your system can'tE  or you won't let it read /dev/kmem (the world that is) then you mustUG  figure out a different way to do the counting of characters available,.@  or else replace this by a dummy function that always returns 0. */ /*&  * Call this routine as: initrawq(tty)B  * where tty is the file descriptor of a terminal.  It will returnE  * (as a char *) the kernel-mode memory address of the rawq charactereE  * count, which may then be read.  It has the side-effect of flushing	  * input on the terminal.c  */g /*B  * John Mackin, Physiology Dept., University of Sydney (Australia)&  * ...!decvax!mulga!physiol.su.oz!john  *A  * Permission is hereby granted to do anything with this code, asy@  * long as this comment is retained unmodified and no commercial  * advantage is gained.p  */n #include <a.out.h> #include <sys/proc.h>*    char *initrawq(tty) int tty; { #ifdef UTS24     return(0); #elsen #ifdef BSD29     return(0); #else/     long lseek();       static struct nlist nl[] = { 	{PROCNAME},
 	{NPROCNAME},d 	{""}	     };     static struct proc *pp;d"     char *malloc(), *qaddr, *p, c;     int m, pid, me;n:     NPTYPE xproc;			/* Its type is defined in makefile. */     int catch();        me = getpid();4     if ((m = open("/dev/kmem", 0)) < 0) err("kmem");     nlist(BOOTNAME, nl);-     if (nl[0].n_type == 0) err("proc array");e  c(     if (nl[1].n_type == 0) err("nproc"); s'     lseek(m, (long)(nl[1].n_value), 0);0$     read (m, &xproc, sizeof(xproc));     signal(SIGALRM, catch);      if ((pid = fork()) == 0) {	 	while(1)  	    read(tty, &c, 1);     }s
     alarm(2);f  g     if(setjmp(jjbuf) == 0) {	 	while(1)e 	    read(tty, &c, 1);     }o     signal(SIGALRM, SIG_DFL);p  e
 #ifdef DIRECT%'     pp = (struct proc *) nl[0].n_value;p #else =     if (lseek(m, (long)(nl[0].n_value), 0) < 0L) err("seek");uL     if (read(m, &pp, sizeof(pp)) != sizeof(pp))  err("no read of proc ptr"); #endif'     lseek(m, (long)(nl[1].n_value), 0); #     read(m, &xproc, sizeof(xproc));e  *>     if (lseek(m, (long)pp, 0) < 0L) err("Can't seek to proc");I     if ((p = malloc(xproc * sizeof(struct proc))) == NULL) err("malloc");nK     if (read(m,p,xproc * sizeof(struct proc)) != xproc*sizeof(struct proc))a     	err("read proc table");;     for (pp = (struct proc *)p; xproc > 0; --xproc, ++pp) {;+ 	if (pp -> p_pid == (short) pid) goto iout;      }e     err("no such proc");  e iout: 
     close(m);e$     qaddr = (char *)(pp -> p_wchan);
     free (p);i     kill(pid, SIGKILL);d/     wait((int *)0);		/* Destroy the ZOMBIEs! */s     return (qaddr);r #endif #endif }  o$ /*  More V7-support functions...  */    static err(s) char *s; {      char buf[200];  "3     sprintf(buf, "fatal error in initrawq: %s", s);d     perror(buf);     doexit(1); }i  r static	 catch() {f     longjmp(jjbuf, -1);n }   p  o0 /*  G E N B R K  --  Simulate a modem break.  */  L #define	BSPEED	B150l    genbrk(fn) int fn; {     struct sgttyb ttbuf;     int ret, sospeed;I  r&     ret = ioctl(fn, TIOCGETP, &ttbuf);     sospeed = ttbuf.sg_ospeed;     ttbuf.sg_ospeed = BSPEED;{&     ret = ioctl(fn, TIOCSETP, &ttbuf);3     ret = write(fn, "\0\0\0\0\0\0\0\0\0\0\0\0", 8);g     ttbuf.sg_ospeed = sospeed;&     ret = ioctl(fn, TIOCSETP, &ttbuf);     ret = write(fn, "@", 1);     return;i }r #endif pO /*  T T C H K  --  Tell how many characters are waiting in tty input buffer  */e   	 ttchk() {1     int x; long n; #ifdef FIONREADiH     x = ioctl(ttyfd, FIONREAD, &n);	/* Berkeley and maybe some others */     debug(F101,"ttchk","",n);o     return((x < 0) ? 0 : n); #elseN	 #ifdef	V7rB     lseek(kmem[TTY], (long) qaddr[TTY], 0); /* 7th Edition Unix */)     x = read(kmem[TTY], &n, sizeof(int));)%     return((x == sizeof(int))? n: 0);  #elsey #ifdef UXIII9     return(inbufc + (ungotn >= 0) );	/* Sys III, Sys V */y #elsea
 #ifdef PROVX1o?     x = ioctl(ttyfd, TIOCQCNT, &ttbuf);	/* Pro/3xx Venix V.1 */G     n = ttbuf.sg_ispeed & 0377;1     return((x < 0) ? 0 : n); #else  #ifdef aegis7     return(inbufc + (ungotn >= 0) );	/* Apollo Aegis */* #elsem
 #ifdef C701     return(inbufc + (ungotn >= 0) );	/* etc... */  #elser     return(0); #endif #endif #endif #endif #endif #endif }"  i  b= /*  T T X I N  --  Get n characters from tty input buffer  */t  eF /*  Returns number of characters actually gotten, or -1 on failure  */  oL /*  Intended for use only when it is known that n characters are actually */& /*  Available in the input buffer.  */     ttxin(n,buf) int n; char *buf; {
     int x;  e
 #ifdef MYREAD*;     for( x = 0; (x > -1) && (x < n); buf[x++] = myread() );k #elseo      debug(F101,"ttxin: n","",n);     x = read(ttyfd,buf,n);     debug(F101," x","",x); #endif     if (x > 0) buf[x] = '\0';G     if (x < 0) x = -1;     return(x); }  p9 /*  T T O L  --  Similar to "ttinl", but for writing.  */O  s ttol(s,n) int n; char *s; {y
     int x;/     if (ttyfd < 0) return(-1);		/* Not open. */h     x = write(ttyfd,s,n);d     debug(F111,"ttol",s,n);).     if (x < 0) debug(F101,"ttol failed","",x);     return(x); }T  c  )A /*  T T O C  --  Output a character to the communication line  */r  t ttoc(c) char c; {//     if (ttyfd < 0) return(-1);		/* Not open. */r     return(write(ttyfd,&c,1)); }c sL /*  T T I N L  --  Read a record (up to break character) from comm line.  */ /*J   If no break character encountered within "max", return "max" characters,L   with disposition of any remaining characters undefined.  Otherwise, returnM   the characters that were read, including the break character, in "dest" andRN   the number of characters read as the value of the function, or 0 upon end ofO   file, or -1 if an error occurred.  Times out & returns error if not completed,   within "timo" seconds. */ #define CTRLC '\03'l9 ttinl(dest,max,timo,eol) int max,timo; CHAR *dest, eol; { <     int x = 0, ccn = 0, c, i, j, m, n;	/* local variables */  -/     if (ttyfd < 0) return(-1);		/* Not open. */(  a=     m = (ttprty) ? 0177 : 0377;		/* Parity stripping mask. */e2     *dest = '\0';			/* Clear destination buffer */B     if (timo) signal(SIGALRM,timerh);	/* Enable timer interrupt */      alarm(timo);			/* Set it. *//     if (setjmp(sjbuf)) {		/* Timer went off? */(         x = -1;r     } else {% 	i = 0;				/* Next char to process */   	j = 0;				/* Buffer position */         while (1) {;J             if ((n = ttchk()) > 0) {	/* See how many chars have arrived *//                 if (n > (max - j)) n = max - j;(K                 if ((n = ttxin(n,dest+i)) < 0) { /* Get them all at once */l
 		    x = -1;r 		    break; 		}b  	    } else {			/* Or else... */% 		n = 1;			/* just wait for a char */t 		if ((c = ttinc(0)) == -1) {,
 		    x = -1;r 		    break; 		} ,                 dest[i] = c;		/* Got one. */ 	    }6 	    j = i + n;			/* Remember next buffer position. */ 	    if (j >= max) {+ 		debug(F101,"ttinl buffer overflow","",j); 	 		x = -1;! 		break; 	    }> 	    for (i; i < j; i++) {	/* Go thru all chars we just got */' 		dest[i] &= m;		/* Strip any parity */ - 	        if (dest[i] == eol) {	/* Got eol? */"0 		  dest[++i] = '\0';	/* Yes, tie off string, */* 		  alarm(0);		/* turn off timers, etc, */? 		  if (timo) signal(SIGALRM,SIG_DFL); /* and return length. */  		  return(i);C 	      } else if ((dest[i] & 0177) == CTRLC) { /* Check for ^C^C */e9 		  if (++ccn > 1) {	/* If we got 2 in a row, clean up */a! 		     alarm(0);		/* and exit. */  		     signal(SIGALRM,SIG_DFL);E 		     fprintf(stderr,"^C...");B 		     ttres();  		     fprintf(stderr,"\n"); 		     return(-2); 		  }d9 	      } else ccn = 0;	/* Not ^C, so reset ^C counter, */  	  } 	}     }c?     debug(F100,"ttinl timout","",0);	/* Get here on timeout. */c     debug(F111," with",dest,i);o%     alarm(0);				/* Turn off timer */e2     signal(SIGALRM,SIG_DFL);		/* and interrupt, */.     return(x);				/* and return error code. */ }U  B /*  T T I N C --  Read a character from the communication line  */  a ttinc(timo) int timo; {e     int m, n = 0;d     CHAR ch = 0;  n=     m = (ttprty) ? 0177 : 0377;		/* Parity stripping mask. */n/     if (ttyfd < 0) return(-1);		/* Not open. */d%     if (timo <= 0) {			/* Untimed. */ 
 #ifdef MYREADoB     	/* comm line failure returns -1 thru myread, so no &= 0377 */A     	while ((n = myread()) == -1) ;	/* Wait for a character... */i 	if (n == -2) n++;  	return( (n < 0) ? -1 : n & m ); #elseaC 	while ((n = read(ttyfd,&ch,1)) == 0) ; /* Wait for a character. */d& 	return( (n < 0) ? -1 : (ch & 0377) ); #endif     }b7     signal(SIGALRM,timerh);		/* Timed, set up timer. */      alarm(timo);     if (setjmp(sjbuf)) { 	n = -1;     } else {
 #ifdef MYREADuC     	while ((n = myread()) == -1) ;	/* If managing own buffer... */s 	if (n == -2) {o	 	    n++;g	 	} else {c 	    ch = n; 	    n = 1;	 	} #elset=     	n = read(ttyfd,&ch,1);		/* Otherwise call the system. */* #endif     }.&     alarm(0);				/* Turn off timer, */2     signal(SIGALRM,SIG_DFL);		/* and interrupt. */@     return( (n < 0) ? -1 : (ch & m) );  /* Return char or -1. */ }   , /*  T T S N D B  --  Send a BREAK signal  */  P
 ttsndb() {     int x; long n; char spd;   /     if (ttyfd < 0) return(-1);		/* Not open. */   n
 #ifdef PROVX1 5     gtty(ttyfd,&ttbuf);			/* Get current tty flags */ ,     spd = ttbuf.sg_ospeed;		/* Save speed */3     ttbuf.sg_ospeed = B50;		/* Change to 50 baud */ $     stty(ttyfd,&ttbuf);			/*  ... */.     write(ttyfd,brnuls,3);		/* Send 3 nulls *//     ttbuf.sg_ospeed = spd;		/* Restore speed */,$     stty(ttyfd,&ttbuf);			/*  ... */     return(0); #elseo #ifdef aegis9     sio_$control((short)ttyfd, sio_$send_break, 250, st);e     return(0); #else, #ifdef UXIII?     if (ioctl(ttyfd,TCSBRK,(char *)0) < 0) {	/* Send a BREAK */       	perror("Can't send BREAK"); 	return(-1);     })     return(0); #else 
 #ifdef ANYBSDt,     n = FWRITE;				/* Flush output queue. */:     ioctl(ttyfd,TIOCFLUSH,&n); 		/* Ignore any errors.. */B     if (ioctl(ttyfd,TIOCSBRK,(char *)0) < 0) {	/* Turn on BREAK */      	perror("Can't send BREAK"); 	return(-1);     } ;     x = msleep(275);			/* Sleep for so many milliseconds */pC     if (ioctl(ttyfd,TIOCCBRK,(char *)0) < 0) {	/* Turn off BREAK */i 	perror("BREAK stuck!!!");. 	doexit(1);			/* Get out, closing the line. */! 					/*   with exit status = 1 */u     })     return(x); #else 	 #ifdef	V7 +     genbrk(ttyfd);			/* Simulate a BREAK */r     return(x); #endif #endif #endif #endif #endif }   8 /*  M S L E E P  --  Millisecond version of sleep().  */    /*D  Intended only for small intervals.  For big ones, just use sleep(). */  a msleep(m) int m; {  o #ifdef aegis     time_$clock_t dur;        dur.c2.high16 = 0;O     dur.c2.low32  = 250 * m; /* one millisecond = 250 four microsecond ticks */f(     time_$wait(time_$relative, dur, st);     return(0); #else 
 #ifdef PROVX1;     if (m <= 0) return(0);$     sleep(-((m * 60 + 500) / 1000));     return(0); #endif   
 #ifdef ANYBSDl     int t1, t3, t4;/     if (m <= 0) return(0);
 #ifndef BSD42i$ /* 2.9 and 4.1 BSD do it this way */<     if (ftime(&ftp) < 0) return(-1);	/* Get current time. */2     t1 = ((ftp.time & 0xff) * 1000) + ftp.millitm;     while (1) {  	ftime(&ftp);			/* new time */6 	t3 = (((ftp.time & 0xff) * 1000) + ftp.millitm) - t1; 	if (t3 > m) return(t3);     }; #elsee, /* 4.2 & above can do it with select()... */G     if (gettimeofday(&tv, &tz) < 0) return(-1); /* Get current time. */o#     t1 = tv.tv_sec;			/* Seconds */i  t'     tv.tv_sec = 0;			/* Use select() */l     tv.tv_usec = m * 1000;;     return(select( 0, (int *)0, (int *)0, (int *)0, &tv) );o #endif #endif  (D /* The clock-tick business is a pain.  Wm. E. Davidsen suggested: */# /*   #include <sys/param.h>      */T# /*   #define CLOCK_TICK 1000/HZ  */ ; /* But I don't see the symbol HZ in this file on my VAX. */( /* Maybe just for XENIX. */f  I #ifdef UXIII #ifdef XENIXA /* Actually, watch out.  It's 50 on the AT, 20 on older PCs... */ 6 #define CLOCK_TICK 50			/* millisecs per clock tick */ #else 
 #ifndef XENIXe& #define CLOCK_TICK 17			/* 1/60 sec */ #endif #endif  g     extern long times();     long t1, t2, tarray[4];s     int t3;   dG /* In SCO Xenix 2.1.3 or later, you can use nap((long)m) to do this. */e  n     if (m <= 0) return(0);-     if ((t1 = times(tarray)) < 0) return(-1);      while (1) {a* 	if ((t2 = times(tarray)) < 0) return(-1);$ 	t3 = ((int)(t2 - t1)) * CLOCK_TICK; 	if (t3 > m) return(t3);     }  #endif  d
 #ifdef TOWER1h     int t1, t3;a     if (m <= 0) return(0);=     if (ftime(&ftp) < 0) return(-1);		/* Get current time. */t2     t1 = ((ftp.time & 0xff) * 1000) + ftp.millitm;     while (1) {> 	ftime(&ftp);				/* new time */d6 	t3 = (((ftp.time & 0xff) * 1000) + ftp.millitm) - t1; 	if (t3 > m) return (t3);e     }1 #endif #endif }f  2 /*  R T I M E R --  Reset elapsed time counter  */   
 rtimer() {      tcount = time( (long *) 0 ); }   i  ,L /*  G T I M E R --  Get current value of elapsed time counter in seconds  */  f
 gtimer() {
     int x;,     x = (int) (time( (long *) 0 ) - tcount);
     rtimer();l     return( (x < 0) ? 0 : x ); },  o  a. /*  Z T I M E  --  Return date/time string  */    ztime(s) char **s; {    #ifdef UXIII6     extern long time();			/* Sys III/V way to do it */     char *ctime();     long clock_storage;n  i'     clock_storage = time( (long *) 0 );-!     *s = ctime( &clock_storage );c #endif  o
 #ifdef PROVX1*#     int utime[2];			/* Venix way */      time(utime);     *s = ctime(utime); #endif  i
 #ifdef ANYBSDa)     char *asctime();			/* Berkeley way */u     struct tm *localtime();e     struct tm *tp; #ifdef BSD42*     gettimeofday(&tv, &tz);		/* BSD 4.2 */     time(&tv.tv_sec);      tp = localtime(&tv.tv_sec);  #elser.     time(&clock);			/* BSD 4.1, 2.9 ... ceb */     tp = localtime(&clock);h #endif     *s = asctime(tp);  #endif  l
 #ifdef TOWER1x&     char *asctime();			/* Tower way */     struct tm *localtime();      struct tm *tp;        time(&clock);      tp = localtime(&clock);	     *s = asctime(tp);  #endif	 #ifdef V77#     char *asctime();			/* V7 way */*     struct tm *localtime();e     struct tm *tp;  /     time(&clock);n     tp = localtime(&clock);      *s = asctime(tp);  #endif }; /2 /*  C O N G M  --  Get console terminal modes.  */  f /*M  Saves current console mode, and establishes variables for switching between =2  current (presumably normal) mode and other modes. */   	 congm() {=8     if (!isatty(0)) return(0);		/* only for real ttys */ #ifdef aegis.     ios_$inq_type_uid(ios_$stdin, conuid, st);     if (st.all != status_$ok))N     {  fprintf(stderr, "problem getting stdin objtype: "); error_$print(st); }"     concrp = (conuid == mbx_$uid);     conbufn = 0; #endif
 #ifndef UXIIIc4      gtty(0,&ccold);			/* Structure for restoring */5      gtty(0,&cccbrk);			/* For setting CBREAK mode */ 1      gtty(0,&ccraw);			/* For setting RAW mode */  #else       ioctl(0,TCGETA,&ccold);      ioctl(0,TCGETA,&cccbrk);	      ioctl(0,TCGETA,&ccraw); #endif #ifdef VXVE)9      cccbrk.c_line = 0;			/* STTY line 0 for CDC VX/VE */       ioctl(0,TCSETA,&cccbrk);i8      ccraw.c_line = 0;			/* STTY line 0 for CDC VX/VE */      ioctl(0,TCSETA,&ccraw); #endif /* vxve */u.      cgmf = 1;				/* Flag that we got them. */      return(0);  }   u  l1 /*  C O N C B --  Put console in cbreak mode.  */[  &" /*  Returns 0 if ok, -1 if not  */  e concb(esc) char esc; {
     int x;8     if (!isatty(0)) return(0);		/* only for real ttys */:     if (cgmf == 0) congm();		/* Get modes if necessary. */:     escchr = esc;			/* Make this available to other fns */4     ckxech = 1;				/* Program can echo characters */ #ifdef aegis     conbufn = 0;0     if (concrp) return(write(1, "\035\002", 2));H     if (conuid == input_pad_$uid) {pad_$raw(ios_$stdin, st); return(0);} #endif
 #ifndef UXIIIf>     cccbrk.sg_flags |= CBREAK;		/* Set to character wakeup, */-     cccbrk.sg_flags &= ~ECHO;		/* no echo. */      x = stty(0,&cccbrk); #elsec%     cccbrk.c_lflag &= ~(ICANON|ECHO);/<     cccbrk.c_cc[0] = 003;		/* interrupt char is control-c */>     cccbrk.c_cc[1] = escchr;		/* escape during packet modes */     cccbrk.c_cc[4] = 1;  #ifdef ZILOG     cccbrk.c_cc[5] = 0;  #elseo     cccbrk.c_cc[5] = 1;  #endif /* zilog */9     x = ioctl(0,TCSETAW,&cccbrk);  	/* set new modes . */7 #endif  w
 #ifndef aegisaC     if (x > -1) setbuf(stdout,NULL);	/* Make console unbuffered. */t #endif	 #ifdef	V7      if (kmem[CON] < 0) { 	qaddr[CON] = initrawq(0);- 	if((kmem[CON] = open("/dev/kmem", 0)) < 0) { 9 	    fprintf(stderr, "Can't read /dev/kmem in concb.\n");M 	    perror("/dev/kmem"); 
 	    exit(1);  	}     }; #endif     return(x); }  =3 /*  C O N B I N  --  Put console in binary mode  */m  a" /*  Returns 0 if ok, -1 if not  */  . conbin(esc) char esc; { 8     if (!isatty(0)) return(0);		/* only for real ttys */:     if (cgmf == 0) congm();		/* Get modes if necessary. */:     escchr = esc;			/* Make this available to other fns */4     ckxech = 1;				/* Program can echo characters */ #ifdef aegis=     conbufn = 0; if (concrp) return(write(1, "\035\002", 2)); H     if (conuid == input_pad_$uid) {pad_$raw(ios_$stdin, st); return(0);} #endif
 #ifndef UXIII B     ccraw.sg_flags |= (RAW|TANDEM);   	/* Set rawmode, XON/XOFF */E     ccraw.sg_flags &= ~(ECHO|CRMOD);  	/* Set char wakeup, no echo */.     return(stty(0,&ccraw));  #elseu)     ccraw.c_lflag &= ~(ISIG|ICANON|ECHO); %     ccraw.c_iflag |= (BRKINT|IGNPAR); F     ccraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|IXON|IXANY|IXOFF 			|INPCK|ISTRIP);     ccraw.c_oflag &= ~OPOST;  *J /*** Kermit used to put the console in 8-bit raw mode, but some users haveH  *** pointed out that this should not be done, since some sites actuallyH  *** use terminals with parity settings on their Unix systems, and if weN  *** override the current settings and stop doing parity, then their terminalsL  *** will display blotches for characters whose parity is wrong.  Therefore,H  *** the following two lines are commented out (Larry Afrin, Clemson U):  ***(  ***   ccraw.c_cflag &= ~(PARENB|CSIZE);$  ***   ccraw.c_cflag |= (CS8|CREAD);  ***I  *** Sys III/V sites that have trouble with this can restore these lines.C  ***/h     ccraw.c_cc[4] = 1;     ccraw.c_cc[5] = 1;=     return(ioctl(0,TCSETAW,&ccraw) );  	/* set new modes . *// #endif }   h  i5 /*  C O N R E S  --  Restore the console terminal  */f   
 conres() {?     if (cgmf == 0) return(0);		/* Don't do anything if modes */f8     if (!isatty(0)) return(0);		/* only for real ttys */' #ifndef UXIII				/* except for sIII, */ "     sleep(1);				/*  not known! */- #endif					/*   (sIII does wait in ioctls) */p1     ckxech = 0;				/* System should echo chars */u #ifdef aegis=     conbufn = 0; if (concrp) return(write(1, "\035\001", 2));nK     if (conuid == input_pad_$uid) {pad_$cooked(ios_$stdin, st); return(0);}  #endif
 #ifndef UXIII :     return(stty(0,&ccold));		/* Restore controlling tty */ #else0$     return(ioctl(0,TCSETAW,&ccold)); #endif }A SA /*  C O N O C  --  Output a character to the console terminal  */i  * conoc(c) char c; {     write(1,&c,1); }(  mA /*  C O N X O  --  Write x characters to the console terminal  */m    conxo(x,s) char *s; int x; {     write(1,s,x);f }e  t; /*  C O N O L  --  Write a line to the console terminal  */.  l conol(s) char *s; {      int len;     len = strlen(s);     write(1,s,len);w }   eG /*  C O N O L A  --  Write an array of lines to the console terminal */t  m conola(s) char *s[]; {
     int i;(     for (i=0 ; *s[i] ; i++) conol(s[i]); }e  )9 /*  C O N O L L  --  Output a string followed by CRLF  */t  0 conoll(s) char *s; {
     conol(s);f     write(1,"\r\n",2); }t  H /*  C O N C H K  --  Return how many characters available at console  */  h
 conchk() {     int x; long n;   
 #ifdef PROVX1*#     x = ioctl(0, TIOCQCNT, &ttbuf);s     n = ttbuf.sg_ispeed & 0377;s     return((x < 0) ? 0 : n); #elsei #ifdef aegisD     if (conbufn > 0) return(conbufn);	/* use old count if nonzero */   !     /* read in more characters */o"     conbufn = ios_$get(ios_$stdin,8 	      ios_$cond_opt, conbuf, (long)sizeof(conbuf), st);*     if (st.all != status_$ok) conbufn = 0;     conbufp = conbuf;3     return(conbufn); #else 	 #ifdef V7o+     lseek(kmem[CON], (long) qaddr[CON], 0); )     x = read(kmem[CON], &n, sizeof(int));e%     return((x == sizeof(int))? n: 0);  #else  #ifdef UXIII&     if (conesc) {			/* Escape typed */ 	conesc = 0;. 	signal(SIGQUIT,esctrp);		/* Restore escape */ 	return(1);i     }W     return(0); #else 
 #ifdef C70&     if (conesc) {			/* Escape typed */ 	conesc = 0;. 	signal(SIGQUIT,esctrp);		/* Restore escape */ 	return(1);      }i     return(0); #else> #ifdef FIONREAD	@     x = ioctl(0, FIONREAD, &n);		/* BSD and maybe some others */     return((x < 0) ? 0 : n); #else (     return(0);				/* Others can't do. */ #endif #endif #endif #endif #endif #endif })  9 /*  C O N I N C  --  Get a character from the console  */   - coninc(timo) int timo; {     int n = 0; char ch;n #ifdef aegis     fflush(stdout);      if (conchk() > 0)o.     {  --conbufn; return(*conbufp++ & 0377); } #endif%     if (timo <= 0 ) {			/* untimed */ . 	n = read(0, &ch, 1);		/* Read a character. */ 	ch &= 0377;7 	if (n > 0) return(ch); 		/* Return the char if read */y 	else  #ifdef UXIII3 #ifndef CIE				/* CIE Regulus has no such symbol */tG 	    if (n < 0 && errno == EINTR) /* if read was interrupted by QUIT */ 7 		return(escchr);		 /* user entered escape character */ 8 	    else		    /* couldnt be ^c, sigint never returns */ #endif #endif. 		return(-1);  		/* Return the char, or -1. */ 	}>     signal(SIGALRM,timerh);		/* Timed read, so set up timer */     alarm(timo);     if (setjmp(sjbuf)) n = -2;
     else { 	n = read(0, &ch, 1);) 	ch &= 0377;     }&8     alarm(0);				/* Stop timing, we got our character */     signal(SIGALRM,SIG_DFL);     if (n > 0) return(ch);     else #ifdef UXIII3 #ifndef CIE				/* CIE Regulus has no such symbol */)J         if (n == -1 && errno == EINTR)  /* If read interrupted by QUIT, */: 	    return(escchr);		/* user entered escape character, */;         else		    		/* can't be ^c, sigint never returns */u #endif #endif 	return(-1); }n