N /* Version 0.8(35) - Jim Noble at Planning Research Corporation, June 1987. */4 /* Ported to Megamax native Macintosh C compiler. */  N /*  C K M T I O  --  interrupt, console, and port functions for Mac Kermit  */   /*M  Copyright (C) 1985, Trustees of Columbia University in the City of New York. H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */   /*  Variables:   A    dftty  -- Pointer to default tty name string, like "/dev/tty". 7    dfloc  -- 0 if dftty is console, 1 if external line.     dfprty -- Default parity !    dfflow -- Default flow control 0    ckxech -- Flag for who echoes console typein:0      1 - The program (system echo is turned off)0      0 - The system (or front end, or terminal).E    functions that want to do their own echoing should check this flag     before doing so.   L  Functions for assigned communication line (either external or console tty):  I    ttopen(ttname,local,modem) -- Open the named tty for exclusive access. O    ttclos()                -- Close & reset the tty, releasing any access lock. K    ttpkt(speed,flow)       -- Put the tty in packet mode and set the speed. C    ttvt(speed,flow)        -- Put the tty in virtual terminal mode. ;    ttinl(dest,max,timo)    -- Timed read line from the tty. <    ttinc(timo)             -- Timed read character from tty.J    ttchk()                 -- See how many characters in tty input buffer.C    ttxin(n,buf)            -- Read n characters from tty (untimed). 8    ttol(string,length)     -- Write a string to the tty.;    ttoc(c)                 -- Write a character to the tty. 5    ttflui()                -- Flush tty input buffer.    Functions for console terminal:   +    congm()   -- Get console terminal modes. M    concb()   -- Put the console in single-character wakeup mode with no echo. 5    conbin()  -- Put the console in binary (raw) mode. @    conres()  -- Restore the console to mode obtained by congm().<    conoc(c)  -- Unbuffered output, one character to console.I    conol(s)  -- Unbuffered output, null-terminated string to the console. @    conxo(n,s) -- Unbuffered output, n characters to the console.9    conchk()  -- Check if characters available at console. 1    coninc()  -- Get a character from the console. :    conint()  -- Enable terminal interrupts on the console.;    connoi()  -- Disable terminal interrupts on the console.       Time functions  !    msleep(m) -- Millisecond sleep 2    ztime(&s) -- Return pointer to date/time string */  ; #include "ckcsym.h"			/* Conditional compilation symbols */ / #include "ckcdeb.h"			/* Formats for debug() */    #if MEGAMAX  overlay "ckmtio"   #include <file.h>  #include <mem.h> #include <te.h>  #endif  
 #ifdef SUMACC  #include "mac/quickdraw.h" #include "mac/osintf.h" 6 #include "mac/toolintf.h"		/* TE types defined here */ #endif  9 #include "ckmsys.h"			/* Compiler specific definitions */ * #include "ckmdef.h"			/* macintosh defs */   char *dftty = "";   O /* dfloc is 0 if dftty is the user's console terminal, 1 if an external line */    int dfloc = 1;   /* Other defaults */  ' int dfprty = 0;				/* Default parity */ & int ttprty = 0;				/* Parity in use */. int dfflow = 1;				/* Xon/Xoff flow control */  - /* buffer and pointer for input processing */   7 #define TTBUFL 200			/* good size (it's RBUFL guys!) */  unsigned char ttbuf[TTBUFL+1]; int ttbufi = 0; . LONGINT ttbufm = 0;			/* input pointer, max */    C /*  S Y S I N I T  --  System-dependent program initialization.  */    sysinit() {    /* for now, nothing... */      return(0); }   9 /*  T T O P E N  --  Open a tty for exclusive access.  */   , /*  Returns 0 on success, -1 on failure.  */  9 ttopen(ttname,lcl,modem) char *ttname; int *lcl, modem; { *   ttbufi = ttbufm = 0;			/* init buffer */5   if (*lcl < 0) *lcl = 1;		/* always in local mode */    return(0); }     ; /*  T T C L O S  --  Close the TTY, releasing any lock.  */    ttclos() { ,   ttbufi = ttbufm = 0;			/* init buffer */  	   return;  }   C /*  T T P K T  --  Condition the communication line for packets. */   6 /*  If called with speed > -1, also set the speed.  */  , /*  Returns 0 on success, -1 on failure.  */   ttpkt(speed,flow)  int speed, flow; {      return(0); }   . /*  T T F L U I  --  Flush tty input buffer */   ttflui() { 
   int err;     err = KillIO(-6); 
   if (err)$     printerr("Bad input clear",err);0   ttbufi = ttbufm = 0;			/* init buffer */         return(0); }      /* Interrupt Functions */   4 /* Set up terminal interrupts on console terminal */  	 conint(f)  int (*f)(); " {					/* Set an interrupt trap. */     return;  }   ' /* Reset console terminal interrupts */    connoi() {      return;  }   9 /*  T T O L  --  Similar to "ttinl", but for writing.  */   	 ttol(s,n)  char *s; int n; {      int err;&     LONGINT wrcnt;			/* pascal long */       wrcnt = n;#     err = FSWrite(outnum,&wrcnt,s); +     if (err) printerr("Bad Writeout:",err);      return(n); }     L /*  T T I N L  --  Read a record (up to break character) from comm line.  */ /*J   If no break character encountered within "max", return "max" characters,L   with disposition of any remaining characters undefined.  Otherwise, returnM   the characters that were read, including the break character, in "dest" and J   the number of characters read as the value of function, or 0 upon end ofO   file, or -1 if an error occurred.  Times out & returns error if not completed    within "timo" seconds. */     ttinl(dest,max,timo,eol) int max, timo; char *dest, eol; {      register int x,c; 
     int m;=     m = (ttprty) ? 0177 : 0377;		/* Parity stripping mask. */   7     for (x = c = 0; (x < max) && ((c & m) != eol); x++)      {        c = ttinc(timo);       if (c < 0)"        return(-1);			/* timeout */       dest[x] = c & m;     } /     return(++x);			/* else return the count. */  }   I /* ttinc(timo) - read a character with timeout.  Return -1 on timeout. */   H /* DELAYTICKS is the dismiss value in 60th of a second when the input */K /* buffer goes empty.  Setting this value too small causes more overhead */ I /* since we'll get very few character on the read.  Setting this value */ C /* too large causes a slowdown if characters are on their way... */   5 #define DELAYTICKS 15			/* 15/60th of second retry */    ttinc(timo) 	 int timo;  {   &     LONGINT avcnt, finaltics, intim=0;     int err;   M     if (ttbufi < ttbufm) return(ttbuf[ttbufi++]);   /* Return char quickly */        G /* Refill buffer with available bytes, if none left retry until timo */        for (;;)     { ; 	SerGetBuf(innum,&avcnt);	/* Get available count */         ' 	if (avcnt > 0)			/* Have something? */  	{. 	    ttbufi = 0;			/* Init input buffer ptr */> 	    ttbufm = (avcnt > TTBUFL) ? TTBUFL : avcnt; /* Set max */= 	    err = FSRead(innum,&ttbufm,ttbuf);	/* Into our buffer */ < 	    if (err != noErr) printerr("Serial input error: ",err);> 	    return(ttbuf[ttbufi++]);	/* And return first character */ 	}4 	if (protocmd != 0)		/* if we're running protocol */ 	{, 	  miniparser(TRUE);		/* keep mac running */+ 	  if (sstate == 'a')		/* abort occured? */ . 	   return(-1);			/* ugh, look like timeout */ 	}A 	Delay((LONGINT) DELAYTICKS,&finaltics);	/* Delay for a little */ * 	if (timo > 0)			/* Want to do timeout? */ 	{				/* Yes... *// 	    if (intim == 0)		/* Do we know time in? */ = 	    	intim = finaltics - DELAYTICKS;	/* no, initialize it */ G 	    if (intim+timo*60 < finaltics) return(-1);	/* Too long, give up */  	}     }  }    ttchk()  { $   LONGINT avcnt;			/* pascal long */  /   SerGetBuf(innum,&avcnt);		/* get available */ @   return(avcnt+(ttbufm-ttbufi));	/* return avail plus our own */ }    ttres()  {      return(1); }   2 /*  R T I M E R --  Reset elapsed time counter  */  
 rtimer() { }     L /*  G T I M E R --  Get current value of elapsed time counter in seconds  */  
 gtimer() {     return(0); }     . /*  Z T I M E  --  Return date/time string  */   ztime(s)	 char **s;  { L /***** Should call GetTime(daterec); and then convert by hand to a string */       *s = "Unknown date/time";  }   M /* Console IO routines.  The console is implemented as a text edit structure.    * These routines are supported:  *E  * conoc(c)   -- output one character to TE record at insertion point ?  * conol(s)   -- output null terminated string to TE record " " -  * conoll(s)  -- same but with CR on the end  -  * conxo(n,s) -- n character to TE record " "   *  */   # #define NILTE ((TEHandle ) NILPTR)   #define LF 012 #define CR 015  = TEHandle consoleTE = NILTE;		/* storage for console TE ptr */    consette(t)  TEHandle t;  {    6  if (consoleTE != NILTE)		/* already have TE record */0   printerr("TE record present at consette! ",0);  consoleTE = t;  }   H /*  C O N O C  --  Output a character to the console text edit record */   conoc(c) char c;  {   static LONGINT len = 1;  !  debug(F101,"conoc here: ","",c);    ,  if (c == LF)				/* we don't support this */	   return; .  if (consoleTE != NILTE)		/* is it present? */  {+ /*  TEKey(c,consoleTE);			/* yes, simple */ 6   TEInsert(&c,len,consoleTE);		/* insert the char */     if (c == CR)				/* if CR */ 0    rcdwscroll();			/* then possibly scroll it */  } }   	 conopen()  {   if (consoleTE == NILTE)4   printerr("Tried to open console before TE set",0);  return(0);  }     C /*  C O N O L  --  Write a line to the console text edit record  */    conol(s) char *s; { .   LONGINT len = strlen(s);		/* fetch length */   "  debug(F101,"conol here: ",s,0);  0  if (consoleTE != NILTE)		/* is it present? */  5   TEInsert(s,len,consoleTE);		/* insert the string */   return(0);  }    conxo(s,len) char *s; { &  debug(F101,"conxo here: ",s,len);    0  if (consoleTE != NILTE)		/* is it present? */  >   TEInsert(s,(LONGINT) len,consoleTE);	/* insert the string */  return(0);  }   9 /*  C O N O L L  --  Output a string followed by CRLF  */   	 conoll(s)  char *s; { %   conol(s);				/* first the string */ $   conoc(CR);				/* now the return */   return(0); }   