N /* Version 0.8(35) - Jim Noble at Planning Research Corporation, June 1987. */4 /* Ported to Megamax native Macintosh C compiler. */' /* Edit by Bill on Thu May 30, 00:18 */ ; /* Do error handling, neaten up comments, and some code. */ ' /* Edit by Bill on Wed May 15, 16:09 */ F /* Make zrtol call common sfprtol, .RSRC overrides default settings */0 /* ckmfio.c, Mon Apr 29 17:48, Edit by Bill*2 */0 /* Put null in translated name to tie it off. */C /* Make author text of new file to ???? instead of random string */ & /* Do flushvol after closing a file */ /* Bill C., Apr 24 */ D /* Change zchin to allow sending of files with high order bits on */ /* Bill C., Apr 22 */ F /* Add error handling (informing) for more cases, e.g. can't delete */ /* Bill C., Apr 22 */ B /* Fix Resource/Data fork stuff.  Uppercase things where needed */. /* ckzmac.c, Thu Apr 21 17:19, Edit by Bill */F /*  Ignore trying to close an not-openend file, driver does it alot */. /* ckzmac.c, Thu Apr 11 21:18, Edit by Bill */A /*  Catch error in ZOPENO when trying to open an existing file */ . /* ckzmac.c, Thu Apr 14 20:07, Edit by Bill */@ /*  Translate calls with ZCTERM to go to the console routines */   /*  @  * File ckmfio  --  Kermit file system support for the Macintosh  *E  * Copyright (C) 1985, Trustees of Columbia University in the City of G  * New York.  Permission is granted to any individual or institution to E  * use, copy, or redistribute this software so long as it is not sold :  * for profit, provided this copyright notice is retained.  *  */   . /* Definitions of some Unix system commands */  0 char *DIRCMD = "";			/* For directory listing */, char *DELCMD = "";			/* For file deletion */, char *TYPCMD = "";			/* For typing a file */; char *SPACMD = "";			/* Space/quota of current directory */ ; char *SPACM2 = "";			/* For space in specified directory */ 5 char *WHOCMD = "";			/* For seeing who's logged in */    /*D   Functions (n is one of the predefined file numbers from ckermi.h):  8    zopeni(n,name)   -- Opens an existing file for input.3    zopeno(n,name)   -- Opens a new file for output. %    zclose(n)        -- Closes a file. B    zchin(n)         -- Gets the next character from an input file.O    zsout(n,s)       -- Write a null-terminated string to output file, buffered. A    zsoutl(n,s)      -- Like zsout, but appends a line terminator. E    zsoutx(n,s,x)    -- Write x characters to output file, unbuffered. E    zchout(n,c)      -- Add a character to an output file, unbuffered. O    zchki(name)      -- Check if named file exists and is readable, return size. :    zchko(name)      -- Check if named file can be created.K    znewn(name,s)    -- Make a new unique file name based on the given name. -    zdelet(name)     -- Delete the named file. N    zxpand(string)   -- Expands the given wildcard string into a list of files.G    znext(string)    -- Returns the next file from the list in "string". ;    zxcmd(cmd)       -- Execute the command in a lower fork. M    zclosf()         -- Close input file associated with zxcmd()'s lower fork. ?    zrtol(n1,n2)     -- Convert remote filename into local form. ?    zltor(n1,n2)     -- Convert local filename into remote form.   */   2 #include <ctype.h>			/* Get islower and toupper */; #include "ckcsym.h"			/* Conditional compilation symbols */ 3 #include "ckcdeb.h"			/* Debug() and tlog() defs */ . #include "ckcker.h"			/* Kermit definitions */   #if MEGAMAX  overlay "ckmfio"   #include <file.h>  #include <mem.h> #include <os.h>  #endif  
 #ifdef SUMACC  #include "mac/quickdraw.h" #include "mac/osintf.h"  #include "mac/toolintf.h"  #endif  9 #include "ckmsys.h"			/* Compiler specific definitions */ 9 #include "ckmdef.h"			/* Common Mac module definitions */ ) #include "ckmres.h"			/* Resource defs */   < /* These should all be settable by the File Settings Menu */  B char  *authortext="????";		/* String to use as "author" of file */  4 #define FS_WIND 1			/* file is a text edit buffer */. #define FS_OPEN 2			/* file has been opened */2 #define FS_RSRC 4			/*  opened in resource fork */ #define FS_DATA 8 2 #define FS_PIPE 16			/* file is a memory buffer */   typedef struct {;     INTEGER frefnum;			/* file reference number (pascal) */ )     int fstatus;			/* file status bits */ (     char *fpipeptr;			/* pipe pointer */
 } MACFILE;  0 MACFILE fp[ZNFILS] = { 			/* File information */     {0,0},{0,0},{0,0},{0,0},     {0,0},{0,0},{0,0}};   4 char pipebuf[128];			/* there's a limit to pipes! */    6 /*  Z O P E N I --  Open an existing file for input.    *@  * The file name has been returned from and the volume reference  * number set by SFGetFile.   *  * Returns:   *  TRUE: file opened ok  *  FALSE: some error.  */    zopeni(n,name) int n; char *name;  { 
   int err;   register MACFILE *fpp;     if (chkfn(n)) { 2     printerr("At zopeni file is already open ",n);     return(FALSE);   }      fpp = &fp[n];   +   if (n == ZCTERM) {			/* Terminal open? */ 3     if (chkfn(ZIFILE))			/* Check current ZOFILE */ -       printerr("ZIFILE already open...: ",n); >     fp[ZIFILE].fstatus = FS_WIND;	/* redirect... here it is */<     fpp->fstatus = FS_WIND;		/* Indicate this is open too */9     return(conopen());			/* Return from low level open */    }      1   if (n == ZSYSFN)			/* trying to open a pipe? */ &     return(zxcmd(name));		/* yes... */       0   if (n == ZIFILE &&			/* opening input file? */B       (filargs.filflg & FIL_RSRC)) 	/*  and they said resource? */4     err = OpenRF(name,filargs.filvol,&fpp->frefnum);0   else					/* else some other channel or data */4     err = FSOpen(name,filargs.filvol,&fpp->frefnum);  0   if (err != noErr)			/* check for open error */)     return(ioutil(err));		/* failed... */   -   fpp->fstatus = FS_OPEN | (		/* set flags */ <       	    (filargs.filflg & FIL_RSRC) ? FS_RSRC : FS_DATA);  B   GetEOF(fpp->frefnum,&filargs.filsiz);  /* set size for screen */'   return(TRUE);				/* Return success */    SYM(ZOPENI); }     0 /*  Z O P E N O  --  Open a new file for output.  *  * Returns:   *  TRUE: File opened ok6  *  FALSE: some error has occured or channel occupied.  *  */    zopeno(n,name) int n; char *name;  { 
   int err;   char *forktext;    FInfo finfo;   register MACFILE *fpp;     if (chkfn(n)) { 2     printerr("zopeno - file is already open: ",n);     return(FALSE);   }      fpp = &fp[n];   8   if (n == ZCTERM || n == ZSTDIO) {	/* Terminal open? */3     if (chkfn(ZOFILE))			/* Check current ZOFILE */ -       printerr("ZOFILE already open...: ",n); C     fp[ZOFILE].fstatus = FS_WIND;	/* yes, redirect... here it is */ <     fpp->fstatus = FS_WIND;		/* Indicate this is open too */9     return(conopen());			/* Return from low level open */    }      1   if (n == ZOFILE && (filargs.filflg & FIL_RSRC))      forktext = "APPL";   else<     forktext = "TEXT";			/* Make fork reflect fork choice */  8   err = Create(name,filargs.filvol,authortext,forktext);/   if (err == dupFNErr) {		/* duplicate file? */ 6     if (!ioutil(FSDelete(name,		/* Try to delete it */A       	      	      filargs.filvol)))	/*  checking for failure */ &       return(FALSE);			/* failed... */4     err = Create(name,filargs.filvol,	/* recreate */&       	      	  authortext,forktext);    }    '   if (err != noErr)			/* some error? */ :    return(ioutil(err));			/* yes, do message and return */     @ /* set file's folder from filargs.filfldr which is either the */5 /* applications folder or the settings file folder */   F   GetFInfo(name,filargs.filvol,&finfo); /* read current finder info */6   finfo.fdFldr = filargs.filfldr;	/* set new folder */F   SetFInfo(name,filargs.filvol,&finfo); /* and tell system about it */  9   if (n == ZOFILE && 			/* is it our transferred file? */ E       (filargs.filflg & FIL_RSRC))	/*  want to use resource fork?  */ 2     err = OpenRF(name,filargs.filvol,	/* yes... */       	      	  &fpp->frefnum); .   else					/* else data, or some other file */%     err = FSOpen(name,filargs.filvol,        	      	  &fpp->frefnum);   )   if (err != noErr)			/* able to open? */ 3    return(ioutil(err));			/* no. fail return now */         fp[n].fstatus = FS_OPEN | 8       ((filargs.filflg & FIL_RSRC) ? FS_RSRC : FS_DATA);           return(TRUE);				/* done ok */   SYM(ZOPENO); }     * /*  Z C L O S E  --  Close the given file.  *  * Returns:   *  TRUE: file closed ok. "  *  FLASE: some error has occured.  *  */   	 zclose(n)  int n; {    int err = noErr;   register MACFILE *fpp;  &   if (!chkfn(n))			/* is it opened? */(     return(FALSE);			/* no return now */     fpp = &fp[n];   7   if (fpp->fstatus == FS_WIND)		/* is this a window? */ 4     fp[ZCTERM].fstatus = 0;		/* yes, clear ZCTERM */   else6     if (fpp->fstatus == FS_PIPE)	/* is this a pipe? */C       fp[ZSYSFN].fstatus = 0;		/* yes, no pipe now, clear ZSYSFN */ 
     else {:       err = FSClose(fpp->frefnum);	/* else use OS close */2       if (err != noErr)			/* and if that worked */A         err = FlushVol(NILPTR,		/* flush buffers in case write */  	      filargs.filvol);	     }      1   fpp->fstatus = 0;			/* clear out status word */ ;   if (n == ZOFILE || n == ZIFILE)	/* turn off both flags */ /       filargs.filflg &= ~(FIL_RSRC | FIL_DATA);   @   return(ioutil(err));			/* return according to io operations */   SYM(ZCLOSE); }     7 /*  Z C H I N  --  Get a character from the input file.   *  * Returns: 	  *  0: Ok   * -1: EOF (or other error).  *  */   
 zchin(n,c) int n; char *c; { 
   int err;%   LONGINT rdcnt;				/* pascal long */    register MACFILE *fpp;     if (!chkfn(n))     return(0);     fpp = &fp[n];   0   if (fpp->fstatus == FS_WIND) {	/* a window? */2     printerr("zchin called for FS_WIND file: ",n);     return(0);   }      -   if (fpp->fstatus == FS_PIPE)		/* a pipe? */ 8     if (*(fpp->fpipeptr) == '\0')	/* is this eo-pipe? */*       return(-1);			/* yes, fail return */
     else {4       *c = *(fpp->fpipeptr)++;		/* read character */        return(0);			/* success */     }           rdcnt = 1;&   err = FSRead(fpp->frefnum,&rdcnt,c);5   if (err == eofErr) return(-1);	/* Failure return */ A   return(ioutil(err) ? 0 : -1);		/* success or unknown failure */ 
   SYM(ZCHIN);  }   > /*  Z S O U T  --  Write a string to the given file, buffered.  *  * Returns: 	  *  0: OK   * -1: Error  *  */   
 zsout(n,s) int n; char *s; { %   LONGINT wrcnt;				/* pascal long */   .   if (n == ZCTERM || fp[n].fstatus == FS_WIND)     return(conol(s));         wrcnt = (long) strlen(s); ;   return(ioutil(FSWrite(fp[n].frefnum,&wrcnt,s)) ? 0 : -1); 
   SYM(ZSOUT);  }   J /*  Z S O U T L  --  Write string to file, with line terminator, buffered.  *  * Returns: 	  *  0: OK   * -1: Error  *  */    zsoutl(n,s)  int n; char *s; { $   LONGINT wrcnt;			/* pascal long */
   int err;  .   if (n == ZCTERM || fp[n].fstatus == FS_WIND)     return(conoll(s));          wrcnt = (long) strlen(s); (   err = FSWrite(fp[n].frefnum,&wrcnt,s);   if (err == noErr) {      wrcnt = 2;/     err = FSWrite(fp[n].frefnum,&wrcnt,"\r\n");    }       return(ioutil(err) ? 0 : -1);    SYM(ZSOUTL); }   < /*  Z S O U T X  --  Write x characters to file, unbuffered.  *  * Returns: 	  *  0: OK   * -1: Error  */   
 zsoutx(n,s,x) 	 int n, x;  char *s; {    LONGINT size;   .   if (n == ZCTERM || fp[n].fstatus == FS_WIND)     return(conxo(s,x));         size = x; :   return(ioutil(FSWrite(fp[n].frefnum,&size,s)) ? 0 : -1);   SYM(ZSOUTX); }     7 /*  Z C H O U T  --  Add a character to the given file.   *  * Returns: 	  *  0: OK   * -1: Error  */    zchout(n,c)  int n; char c;  { %   LONGINT wrcnt;				/* pascal long */ 
   int err;  0   if (n == ZCTERM || fp[n].fstatus == FS_WIND) {3     conoc(c);				/* Then send to console routine */ 5     return (0);				/* Then send to console routine */    }           wrcnt = 1;)   err = FSWrite(fp[n].frefnum,&wrcnt,&c); *   if (err != noErr)			/* error occured? */-     sstate = 'a';			/* yes, abort protocol */ 7   return (ioutil(err) ? 0 : -1);	/* else return code */ 
   SYM(ZCOUT);  }   A /*  C H K F N  --  Internal function to verify file number is ok.   *  * Returns:   *   TRUE  - file is open   *  FALSE  - file is not open   *  >  * Issues an error message if the file number is not in range.  *  */    chkfn(n) int n; {    switch (n) {     case ZCTERM:     case ZSTDIO:     case ZIFILE:     case ZOFILE:     case ZDFILE:     case ZTFILE:     case ZPFILE:     case ZSYSFN:     case ZSFILE: break;      default:9       debug(F101,"chkfn: file number out of range","",n); 7       printerr("chkfn - file number not in range: ",n);         return(FALSE);			/* ugh */   } B   return((fp[n].fstatus != 0));		/* if open, fstatus is nonzero */
   SYM(CHKFN);  }   > /*  Z C H K I  --  Check if input file exists and is readable.  *  * Returns: 4  *  >= 0 if the file can be read (returns the size).4  *    -1 if file doesn't exist or can't be accessed,D  *    -2 if file exists but is not readable (e.g. a directory file).:  *    -3 if file exists but protected against read access.  */    long zchki(name)  char *name;  {    LONGINT size; 
   int err;   FILEPARAM info;   6   if (strcmp(name,"stdin") == 0)	/* stdin is a pipe */8    return(strlen(pipebuf));		/* return size of buffer */  
 #ifdef SUMACC 3   CTOPSTR(name);			/* convert to a pascal string */  #endif2   info.IOFVERSNUM = 0;			/* No version number */  1   info.IOFDIRINDEX = 0;			/* Use the file name */ 6   info.ioNamePtr = name;		/* Point to the file name */6   info.ioVRefNum = filargs.filvol;	/* Volume number */7   err = PBGetFInfo(&info,FALSE);	/* Get info on file */ 
 #ifdef SUMACC *   PTOCSTR(name);			/* put the name back */ #endif   ,   if (err == fnfErr)			/* file not found? */4     return(-1);				/* then that is what they want */     ,   if (err != noErr)			/* any other error? */<     printerr("zchki failed: ",err);  	/* tell me about it */  C   size = (filargs.filflg & FIL_RSRC) ?	/* if thinking about RSRC */ 2       	info.IOFLRPYLEN :		/*  return that size, */)       	info.IOFLPYLEN;			/*  else DATA */    return(size);				/* did ok */ 
   SYM(ZCHKI);  }   7 /*  Z C H K O  --  Check if output file can be created.   *
  * Returns  *  0: Write OK 6  * -1: write permission for the file should be denied.  */     zchko(name)  char *name;  {    char volname[100];   VOLUMEPARAM info;   7   info.IOVOLINDEX = 0;			/* Use the vol ref num only */ =   info.ioNamePtr = volname;		/* Pointer to the volume name */ @   info.ioVRefNum = filargs.filvol;	/* Volume reference number */H   if (!ioutil(PBGetVInfo(&info,0)))	/* Get info on vol, synchronously */"     return(-1);				/* failed... */  7   if ((info.IOVATRB & 0x8000) != 0)	/* Write locked? */      return(-1);				/* yes... */      "   return(0);				/* else success */
   SYM(ZCHKO);  }   / /*  Z D E L E T  --  Delete the named file.  */    zdelet(name) char *name;  { 
   int err;&   err = FSDelete(name,filargs.filvol);J   if (err != fnfErr && err != noErr)	/* file not found... I guess thats */&     return(ioutil(err));		/*  ok... */"   return(TRUE);				/* well done */   SYM(ZDELETE);  }     ; /*  Z R T O L  --  Convert remote filename into local form.   *E  * Check here to see if this should go into the resource fork (.rsrc) !  * or into the data fork (.data).   *  */    zrtol(name,name2)  char *name, *name2;  {    6   strcpy(name2,name);			/* copy name to destination */     ;   if (filargs.filflg & (FIL_DODLG))	/* selected by user? */ +     return;				/* won't be called but... */   6   filargs.filflg &= ~(FIL_RBDT);	/* clear out flags */E   filargs.filflg |= sfprtol(name2);	/* convert name2 and set flags */ E   binary = (filargs.filflg & FIL_BINA); /* selected binary mode? */   	   return; 
   SYM(ZRTOL);  }     H /*  Z L T O R  --  Convert filename from local format to common form. */   zltor(name,name2)  char *name, *name2;  { 
   int dc = 0;      while (*name != '\0') {      if (*name == ' ') "       name++;				/* Skip spaces */     else)       if ((*name == '.') && (++dc > 1)) { # 	*name2++ = 'X'; 		/* Just 1 dot */  	name++;       }        else  @       	*name2++ = (islower(*name)) ? toupper(*name++) : *name++;   } -   *name2++ = '\0';			/* deposit final null */ 	   return; 
   SYM(ZLTOR);  }         J /*  Z C H D I R  --  Change directory  (used on the Mac to switch vols) */   zchdir(dirnam)
 char *dirnam;  { 
   int err;  3   err = SetVol(dirnam,0);		/* set default volume */    if (err == noErr)    {     screen(SCR_TN,0,0l,dirnam);+    filargs.filvol = 0;			/* make default */    }    else*    screen(SCR_TN,0,0l,"Can't set volume");  1   return(err == noErr);			/* return ok or fail */    SYM(ZCHDIR); }     L /*  Z X C M D -- Run a system command so its output can be read like a file.  *H  * Used on the MAC to implement MAC settings commands -- commands from aD  * remote system when in server mode that change internal variables.  *  */    #define CMD_RSRC 1 #define CMD_DATA 2 #define CMD_TEXT 3 #define CMD_BINA 4 #define CMD_UNK 255   
 zxcmd(comand) 
 char *comand;  { 	   int sc;   :   fp[ZIFILE].fstatus = FS_PIPE;		/* set input from pipe */C   fp[ZIFILE].fpipeptr = pipebuf;	/* init pointer to buffer */              switch (sc = getcmd(comand)) {     case CMD_RSRC:     case CMD_DATA:.       strcpy(pipebuf,"Default Fork set OK\n");?       filargs.filflg &= ~(FIL_RSRC | FIL_DATA); /* turn off  */ ?       filargs.filflg |= (sc == CMD_RSRC) ? FIL_RSRC : FIL_DATA; #       return(TRUE);			/* success */        case CMD_TEXT:     case CMD_BINA:.       strcpy(pipebuf,"Default Mode set OK\n");/       filargs.filflg &= ~(FIL_TEXT | FIL_BINA); ?       filargs.filflg |= (sc == CMD_BINA) ? FIL_BINA : FIL_TEXT;        return(TRUE);			/* ok */            default:*       return(FALSE);			/* fail, unknown */   }     
   SYM(ZXCMD);  }    char *cmdtab[] = {   "fork rsrc",   "fork data",   "mode binary",
   "mode text"  };   int toktab[] = {   CMD_RSRC,    CMD_DATA,    CMD_BINA, 
   CMD_TEXT };  + #define NTOKS (sizeof (toktab)/sizeof(int))    getcmd(cmd) 
 char *cmd; {    int k;     for (k=0; k < NTOKS; k++) "    if (strcmp(cmdtab[k],cmd) == 0),     return(toktab[k]);			/* and return ID */'   return(CMD_UNK);			/* else unknown */    SYM(GETCMD); }       N /*  Z C L O S F  - wait for the child fork to terminate and close the pipe. */  	 zclosf()   { 	   return;  }      int znfirst = 0; char *zname;  F /*  Z X P A N D  --  Expand a wildcard string into an array of strings  *J  * Returns the number of files that match fn1, with data structures set upI  * so that first file (if any) will be returned by the next znext() call.   */    
 zxpand(fn)	 char *fn;  { 7   znfirst = 0;				/* Say this is the first time thru */ 2   zname = fn;				/* Save a pointer to that name */*   return(1);				/* Say one file matches */   SYM(ZXPAND); }   G /*  Z N E X T  --  Get name of next file from list created by zxpand().   *E  * Returns >0 if there's another file, with its name copied into the  -  * arg string, or 0 if no more files in list.   */    	 znext(fn) 	 char *fn;  {    if (znfirst++ == 0) { 1     strcpy(fn,zname);			/* Get the file's name */ 6     return(1);				/* No more files in this wildcard */   }    else return(0); 
   SYM(ZNEXT);  }   9 /*  Z N E W N  --  Make a new name for the given file  */    znewn(fn,s)  char *fn, **s; { 
   char *extp; 
   int ver;  )   strcpy(*s,fn);			/* copy in the name */ 5   if (strlen(*s) > 59)			/* don't allow long names */ .    *s[59] = '\0';			/* it breaks the finder */:   extp = *s+strlen(*s);			/* find position of extension */+   *extp++ = '.';			/* add in the dot now */    >   for (ver=0; ver < 99; ver++)		/* I'll try this many names */   { <     NumToString((LONGINT) ver,extp);	/* add in the number */3     if (zchki(*s) == -1)		/* is this file known? */ *      return;				/* no, made a good one! */   } =   fatal("znewn failed to find unique name in 64 attempts",0); 	   return; 
   SYM(ZNEWN);  }   C /* zkself() - Kill self (reboot).  On other machines does a logout. =  *    	      Flush volumes and reboot.  Called by remote BYE.   *  */    zkself() {    DrvQEl *drvqe;   char vname[255];   LONGINT vfreeb;    INTEGER vrefnum;
   int err;  
 #ifdef SUMACC A   for (drvqe = (DrvQEl *) DrvQHdr->qHead; /* handle on drive q */  #else Q   for (drvqe = (DrvQEl *) ((QHdr *) GetDrvQHdr())->qHead; /* handle on drive q */  #endif3        drvqe != NULL;			/* while still something */ 0        drvqe = drvqe->qLink)		/* step to next */   {					/* for each drive */:     err = GetVInfo(drvqe->dQDrive,vname,&vrefnum,&vfreeb);     if (err = noErr)I       err = FlushVol(NILPTR,vrefnum);	/* flush the volume given refnum */      else      if (err != nsvErr) H        screen(SCR_TN,0,0l,"Remote cmd: GetVinfo returned unknown code");   }        #if MEGAMAX    asm { ! 	reset				/* reset the machine */ ! 	jmp	0x40000A		/* boot address */    }  #endif  
 #ifdef SUMACC *   asm("	reset");			/* reset the machine */*   asm("	jmp	/40000A");		/* boot address */ #endif   return(FALSE);   SYM(ZKSELF); }     > /* ioutil - handle the result from an IO call, checking for an;  *    	    error return and displaying an appropriate error <  *    	    message.  Returns TRUE if no error occured, FALSE  *    	    otherwise.   */    struct {
   int errnum;    char *errstr;  } ioerrs[] = {$     {dirFulErr,"Directory is full"},     {dskFulErr,"Disk is full"}, +     {wPrErr,"Diskette is write protected"}, )     {fLckdErr,"File is software locked"}, +     {vLckdErr,"Volume is software locked"},      {fBsyErr,"File is busy"}, ;     {opWrErr,"File is already open with write permission"},      {0,NILPTR}   };   int  ioutil(err)  int err; {    int e;     if (err == noErr)     return(TRUE);  '   for (e = 0; ioerrs[e].errnum != 0 &&  +       	      ioerrs[e].errnum != err; e++);   7   if (ioerrs[e].errstr == NILPTR)	/* anything there? */ &    printerr("Unknown IO error: ",err);   else     printerr(ioerrs[e].errstr,0);        return(FALSE);       SYM(IOUTIL); }    /*J  * OpenRF is not a standard Toolbox routine but acts identically to FSOpenD  * except that it opens the resource fork instead of the data fork.   */   & int OpenRF (fileName, vRefNum, refNum) char *fileName;  int vRefNum; INTEGER *refNum; {      IOPARAM pb;        pb.ioNamePtr = fileName;     pb.ioVRefNum = vRefNum;      pb.IOVERSNUM = 0;      pb.IOPERMSSN = 0;      pb.IOMISC = (Ptr) 0;     PBOpenRF (&pb, 0);     *refNum = pb.IOREFNUM;     return pb.ioResult;  } 