 PROGRAM KERMIT; G (*********************************************************************) G (*                                                                   *) G (*    KERMIT  - File transfer Program for MVS/TSO                    *) G (*              ( and RACF file access control )                     *) G (*    Author  - Fritz Buetikofer (M70B@CBEBDA3T.BITNET)              *) G (*    Version - 2.3                                                  *) G (*    Date    - 1987 August                                          *) G (*                                                                   *) G (*    This program is an adaptation of the original CMS version of   *) G (*    Victor Lee. Due to a big difference between CMS and TSO, most  *) G (*    parts of the program had to be changed.                        *) G (*                                                                   *) G (*********************************************************************) G (*                                                                   *) G (*  1985 Sept 10  Program is totally changed for use with MVS/XA TSO *) G (*                without any Series/1 frontend processor.           *) G (*  1985 Oct  15  Commands DISK, DIR, DELETE, TYPE and WHO added     *) G (*                for those users, not very experienced with TSO.    *) G (*  1985 Oct  24  Correct treatment of the 'repetition' char.        *) G (*  1985 Oct  29  Check of the sequence of data packets from the     *) G (*                micro. Old packets are skipped by an ACK.          *) G (*  1985 Nov  14  Correct handling of the 8th bit quoting for text   *) G (*                files (according to the 2 translation tables).     *) G (*  1985 Nov  22  Warning to user, if using a 327x-alike terminal-   *) G (*                emulator (fullscreen support not available yet).   *) G (*  1986 Jan  03  New command MEMBER added for partitionned files    *) G (*  1986 Jan  13  Wildcard procedure added for sending files.        *) G (*  1986 Feb  03  Setup Option added, using TSO file KERMIT.SETUP    *) G (*                if present.                                        *) G (*            05  Remote help file built in.                         *) G (*  1986 Feb  18  KERMIT may issue FINISH command to micro running   *) G (*                actually in server mode.                           *) G (*  1986 Apr  04  SET REPEATCHAR, SET SOHchar and SET option ?       *) G (*                facility added                                     *) G (*  1986 May  07  TAKE command added, to execute commands from an    *) G (*                external file.                                     *) G (*  1986 May  14  Display in STATUS screen, whether Init-file has    *) G (*                been processed or not.                             *) G (*  1986 May  23  SET ATOE/ETOA added to modify the ASCII<->EBCDIC   *) G (*                translation table on running KERMIT program.       *) G (*  1986 June 16  SET INCOMPLETE added to control the disposition of *) G (*                an incomplete incoming file.                       *) G (*  1986 Aug  28  Command SEND filename updated, so the user can spe-*) G (*                cify the name going to the micro.                  *) G (*********************************************************************) G (*  After a period of other work to be done, I found again some time *) G (*  to implement a brand new feature: long packets !                 *) G (*                                                                   *) G (*  1987 Jan  19  Abort Remote_Help or Remote_Dir if not ACK or NAK  *) G (*                is received (return to server_init state).         *) G (*  1987 Jan  23  Implementation of long packets done. For test use  *) G (*                I restricted the max. length to 1024 = 1K, which   *) G (*                seems to be adequate for use over LANs.            *) G (*                As soon as pack.length exceeds 256 bytes, the      *) G (*                checktype is automatically set to 3=CRC.           *) G (*  1987 Jan  30  Modifications in SendPacket and RecvPacket, be-    *) G (*                cause they handled the checktype wrong.            *) G (*  1987 Mar  25  Modification in Main Program, so that the first    *) G (*                packet received in SERVER-mode is handled correct. *) G (*  1987 Mar  27  Implementation of the ATTRIBUTE packets. Addition  *) G (*                of the command DO, which executes members taken    *) G (*                from the partitioned dataset KERMIT.PROFILE.       *) G (*  1987 Aug  15  Corrections in routine SENDFILE, so that ACKs are  *) G (*                checked with the actual sequence.                  *) G (*                                                                   *) G (*********************************************************************) G (*                                                                   *) G (*  1.   This version of kermit will handle binary files,            *) G (*       i.e. it will handle 8th bit quoting.                        *) G (*                                                                   *) G (*  2.   By default all characters received are converted from       *) G (*       ASCII and stored as EBCDIC. Also all characters send are    *) G (*       converted from EBCDIC to ASCII.  To avoid the translation   *) G (*       for non-text file you must set TEXT OFF.                    *) G (*                                                                   *) G (*  3.   This version contains a slot for all the documented         *) G (*       advanced server functions, however only some are implemented*) G (*                                                                   *) G (*********************************************************************) G (*                                                                   *) G (*  Utility Procedures:                                              *) G (*       SendPacket      RecvPacket    ReSendit     TSOService       *) G (*       SendACK         GetToken      Wait         UPCase           *) G (*       TRead           TWrite        Prompt       InPacket         *) G (*       OutPacket       TermSize      CheckDsn     Extract          *) G (*       CRCheck         SendChar      CheckParms   Micro_Finish     *) G (*       RecvChar        SendError     ParmPacket   FileToPacket     *) G (*       Wildcard_Search Write_State                                 *) G (*                                                                   *) G (*                                                                   *) G (*  Command Procedures                                               *) G (*       SendFile  - Sends a file to another computer.               *) G (*       RecvFile  - Receive a file from another computer.           *) G (*       ShowIT    - Display the options and status of last tranfer. *) G (*       SetIT     - Set the options.                                *) G (*       Help      - Displays the commands available.                *) G (*       RemoteCommand - handle commands initiated by micro.         *) G (*                                                                   *) G (*********************************************************************)  %TITLE Declarations  TYPE     LString   = STRING (256); 0     FString   = PACKED ARRAY (.1..256.) OF CHAR;     LPString  = STRING (1024);1     PString   = PACKED ARRAY (.1..1024.) OF CHAR;      BYTE      = PACKED 0..255;      TWOBYTES  = PACKED 0..65535;?     OVERLAY   = (ONE,TWO,THREE,FOUR,FIVE,SIX,SEVEN,EIGHT,NINE); &     PACKET    = RECORD CASE OVERLAY OFE                  ONE   :( CHARS : PACKED ARRAY (.1..1024.) OF CHAR ); D                  TWO   :( BYTES : PACKED ARRAY (.1..1024.) OF BYTE )                 END;   0     STATETYPE = (S_I,S,SF,SD,SZ,SB,C,A,R,RF,RD);   4     ABORTTYPE = (NOSOH,BADSF,NOT_S,NOT_SFBZ,NOT_DZ);   1     DISPTYPE  = (NEW, NEWMEM, OLD, OLDMEM, SHARE, 7                  MODIFY, ERROR, NOACC, BADNAME, NOMEM);    9     COMMANDS  = ($BAD,  $SEND,   $RECEIVE, $SERVER, $SET, 9                  $SHOW, $STATUS, $HELP,    $QUES,   $DEL,*:                  $DIR,  $DISK,   $MEM,     $TSO,    $TYPE,:                  $WHO,  $FINISH, $QUIT,    $END,    $EXIT,5                  $DO,   $LOG,    $TAKE,    $VERSION);o  V)     WHATFLAGS = ($ZERO,        $TEXTMODE,                   $EXTEND1,+                  $RECFM,       $PACKETSIZE, (                  $EXTEND2,     $EOLCHAR,(                  $CNTRL_QUOTE, $EXTEND3,(                  $BIT8_QUOTE,  $EXTEND4,(                  $CHECKTYPE,   $EXTEND5,&                  $DELAY,       $DEBUG,(                  $REPCHAR,     $EXTEND6,%                  $SOHCHAR,     $ATOE,h+                  $ETOA,        $INCOMPLETE,M'                  $EXTEND7,     $DUMMY);   a  CONST     COMMTABLE = 'BAD     ' ||s                 'SEND    ' ||r                 'RECEIVE ' ||                  'SERVER  ' ||                  'SET     ' ||                  'SHOW    ' ||*                 'STATUS  ' ||*                 'HELP    ' ||*                 '?       ' ||                  'DELETE  ' ||                  'DIR     ' ||0                 'DISK    ' ||r                 'MEMBERS ' ||                  'TSO     ' ||1                 'TYPE    ' ||*                 'WHO     ' ||D                 'FINISH  ' ||a                 'QUIT    ' ||                  'END     ' ||i                 'EXIT    ' ||5                 'DO      ' ||t                 'LOGOUT  ' ||                  'TAKE    ' ||e                 'VERSION ';m  e     WHATTABLE = 'BAD     ' ||r                 'TEXTMODE' ||n                 '        ' ||v                 'RECFM   ' ||t                 'PACKETSI' ||*                 'ZE      ' ||g                 'EOLCHAR ' ||                  'CNTRL_QU' ||n                 'OTE     ' ||e                 'BIT8_QUO' ||                  'TE      ' ||t                 'CHECKTYP' ||                  'E       ' ||R                 'DELAY   ' ||                  'DEBUG   ' ||d                 'REPEATCH' ||l                 'AR      ' ||3                 'SOHCHAR ' ||                  'ATOE    ' ||                  'ETOA    ' ||                  'INCOMPLE' ||*                 'TE      ' ||l                 'DUMMY   ';    6     SPECTABLE = '00'XC || '!"#$%&''()*+,-./:;<=>{|}~';  nF     DCB_Fix   = 'RECFM(F,B) LRECL(80)   BLKSIZE(6160)'; (* Fixed    *)F     DCB_Var   = 'RECFM(V,B) LRECL(255)  BLKSIZE(3024)'; (* Variable *)F     DCB_Bin   = 'RECFM(U)   LRECL(1024) BLKSIZE(6144)'; (* Binary   *)6     DCB_DEBUG = 'RECFM(V,B) LRECL(255) BLKSIZE(6200)';F     DEBUGNAME = 'KERMIT.DEBUG';         (* Name of DEBUG   data set *)F     CMDNAME   = 'KERMIT.SETUP';         (* Name of SETUP   data set *)F     PROFNAME  = 'KERMIT.PROFILE';       (* Name of PROFILE data set *)  n VARe     RUNNING,     EndKermit,     GetFile,     EOLINE,y     Remote,E     CmdMode,     Init_File,     GETREPLY       : BOOLEAN;      COMMAND,     SETTING        : ALFA;      REQUEST        : STRING (9);     CINDEX,E     CHECKBYTES,o     I,J,K,LEN,RC,f     ScreenSize     : INTEGER;m     Handle_Attribute,      Long_Packet,     TEXTMODE, FB   : BOOLEAN;       UserID         : STRING (8);     STATE          : STATETYPE;i     ABORT          : ABORTTYPE;      DsnDisp        : DISPTYPE;B     INPUTSTRING,                              (* Command string *)E     TSOCommand     : LString;                (* TSO command string *)      Line           : LPString;@     (* Packet variables *)                        (* format   *)@     (* Receive       Send     *)                  (* SOH      *)@     INCOUNT,      OUTCOUNT,                       (* COUNT    *)@     INDATACOUNT,  OUTDATACOUNT  : INTEGER;        (* Chr-COUNT*)@     INSEQ,        OUTSEQ        : BYTE;           (* SEQNUM   *)@     INPACKETTYPE, OUTPACKETTYPE : CHAR;           (* TYPE     *)@     REPLYMSG,     SENDMSG       : PACKET;         (* DATA...  *)@     CHECKSUM                    : INTEGER;        (* CHECKSUM *)@     CRC                         : TWOBYTES;       (* CRC-CCITT*)  l     SENDBUFF,RECVBUFF : PACKET;*-     MAXLENGTH,SI,RI,RECVLENGTH,FC : TWOBYTES; >     TSODS,                            (* File with TSO info *)>     DFILE,                            (* DEBUG-Info file    *)>     CmdFile,                          (* SETUP file         *)>     SFILE     : TEXT;                 (* SEND file          *)     FileCount : INTEGER;,     FileList  : ARRAY (.1..100.) OF LString;    STATIC     ASCIITOEBCDIC,>     EBCDICTOASCII           : PACKED ARRAY (.1..255.) OF CHAR;
     CAPAS,&     PSIZE, ECHAR, SCHAR     : INTEGER;     CNTRL_QUOTE, BIT8_QUOTE,     CHECKTYPE, REPEATCHAR,#     SeqChar, LastSeq, SOH   : CHAR;h#     Delay                   : REAL;      Debug, RECEIVING, &     Incomplete_File         : BOOLEAN;)     CRLF                    : STRING (4);*  * VALUE*>     PSIZE       := 94;        (* PACKET size = 94 (maximum) *)>     SOH         := '01'XC ;   (* Start of packet - <Ctrl>-A *):     ECHAR       := 13;        (* End of line char - CR  *)     SCHAR       := 1;8     CAPAS       := 0;      CNTRL_QUOTE := '#';      BIT8_QUOTE  := '&'; 3     CHECKTYPE   := '1';       (* 1 BYTE checksum *) ;     Delay       := 6.0;       (* Wait-factor = 6 seconds *) 9     Debug       := FALSE;     (* No debugging first    *)n0     REPEATCHAR  := '~';       (* Repeat quote *)6     CRLF        := '#M#J';    (* String with CR, LF *)1     SeqChar     := '31'XC;    (* Initial value *)*@     Incomplete_File := TRUE;  (* Keep/Discard incomplete file *)   < (* THIS IS THE EXTENDED-ASCII TO EBCDIC TABLE, TYPE SWISS *)     ASCIITOEBCDIC :=:            '010203372D2E2F1605250B0C0D0E0F'XC ||  (* 0. *):          '100000003C3D322618193F271C1D1E1F'XC ||  (* 1. *):          '404F7F7B5B6C507D4D5D5C4E6B604B61'XC ||  (* 2. *):          'F0F1F2F3F4F5F6F7F8F97A5E4C7E6E6F'XC ||  (* 3. *):          '7CC1C2C3C4C5C6C7C8C9D1D2D3D4D5D6'XC ||  (* 4. *):          'D7D8D9E2E3E4E5E6E7E8E94AE05A5F6D'XC ||  (* 5. *):          '79818283848586878889919293949596'XC ||  (* 6. *):          '979899A2A3A4A5A6A7A8A9C06AD0A107'XC ||  (* 7. *):          '48DC51424344814852535457565863C1'XC ||  (* 8. *):          'C50000CBCCCDDBDDA8ECFC00B1000086'XC ||  (* 9. *):          '455596DE49D58196005F000000000000'XC ||  (* A. *):          '000000FAEDEDEDBCBCEDFABCBBBBBBBC'XC ||  (* B. *):          'ABCECFEBBF8FEBEBABACCECFEBBF8FCE'XC ||  (* C. *):          'CECFCFABABACAC8F8FBBAC0000000000'XC ||  (* D. *):          '00000000000000000000000000000000'XC ||  (* E. *):          '00000000000000000000AF0000009F00'XC;    (* F. *)E (*  THIS IS THE EBCDIC TO EXTENDED-ASCII CONVERSION TABLE (SWISS)  *) E (*   CHARACTERS NOT REPRESENTABLE IN ASCII ARE REPLACED BY A NULL  *)*     EBCDICTOASCII :=:            '0102030009007F0009000B0C0D0E0F'XC ||  (* 0. *):          '10202020000D0800181900001C1D1E1F'XC ||  (* 1. *):          '00000000000A171B0000000000050607'XC ||  (* 2. *):          '0000160000000004000000001415001A'XC ||  (* 3. *):          '2020838485A0000087A45B2E3C282B21'XC ||  (* 4. *):          '268288898AA18C8B8D005D242A293B5E'XC ||  (* 5. *):          '2D2F008E0000000000007C2C255F3E3F'XC ||  (* 6. *):          '000000000000000000603A2340273D22'XC ||  (* 7. *):          '006162636465666768690000002800C5'XC ||  (* 8. *):          '006A6B6C6D6E6F7071720000002900FE'XC ||  (* 9. *):          '007E737475767778797A00C0DA5B00FA'XC ||  (* A. *):          '009C000000000000000000D9BF5D00C4'XC ||  (* B. *):          '7B41424344454647484900939495C1C2'XC ||  (* C. *):          '7D4A4B4C4D4E4F50515200968197A300'XC ||  (* D. *):          '5C00535455565758595A00C399B40000'XC ||  (* E. *):          '30313233343536373839B3009A000000'XC ;   (* F. *)  : LABEL MAINLOOP;A %TITLE Special TSO Routines F (*==================================================================*)F (* TSOService  - This procedure executes all TSO command requests.  *)F (*==================================================================*)D (* The following routine resides in the LPA -> Pgm must be loaded *); PROCEDURE IKJEFTSR (CONST P1 : INTEGER; CONST P2 : FString;S;                     VAR P3, P4, P5, P6 : INTEGER); FORTRAN;A  ,? PROCEDURE TSOService (CONST Cmd : LString; VAR Code : INTEGER);,    VAR,   Command       : FString;   a, b, c, d, e : INTEGER;  , BEGINI%   a := 257; c := 0; d := 0;   e := 0;A$   Command := Cmd; b := LENGTH (Cmd);$   IKJEFTSR (a, Command, b, c, d, e);   Code := cE END (* TSOService *);$  FF (*==================================================================*)F (* Waiting     - This procedure waits 'w' seconds before proceeding *)F (*==================================================================*)F PROCEDURE Wait (CONST i : INTEGER); FORTRAN;     (* Pause i seconds *) PROCEDURE Waiting (w : REAL);  TYPE   Convert = RECORD                CASE BOOLEAN OF+                  TRUE  : ( Int  : INTEGER);AA                  FALSE : ( Chrs : PACKED ARRAY (.1..4.) OF CHAR);              END; VAR    I    : INTEGER;'   Fact : Convert;  BEGIN    I := TRUNC (w * 100);    Fact.Chrs (.1.) := CHR (0);    Fact.Chrs (.2.) := CHR (0); %   Fact.Chrs (.3.) := CHR (I DIV 256); %   Fact.Chrs (.4.) := CHR (I MOD 256);    Wait (Fact.Int)R END (* Waiting *);        PROCEDURE UPCASE (VAR S : ALFA); VAR i  : INTEGER;      ch : CHAR; BEGIN1#   FOR i := 1 TO LENGTH (S) DO BEGIN        ch := S (.i.);@       IF ch IN (.'a'..'z'.) THEN S (.i.) := CHR ( ORD (ch) + 64)   END  END; %PAGEE, PROCEDURE TRead     (CONST Prompt : FString;0                      CONST Prompt_Len : INTEGER;-                      VAR   Message : PString; 9                      VAR   M_Len, RC : INTEGER); FORTRAN;|   F (*==================================================================*)F (* Prompt      - This procedure prompts the user for input          *)F (*==================================================================*)  |0 PROCEDURE Prompt (p : LString; VAR s : LString);  B VARU   m     : FString;   n     : PString;   i,j,k : INTEGER;  Y BEGIN    m := p; i := LENGTH (p);   TRead (m, i, n, j, k);$   s := SUBSTR (STR (n), 1, j) || ' ' END;   F (*==================================================================*)F (* InPacket   - This procedure reads a packet from the terminal     *)F (*==================================================================*)   & PROCEDURE InPacket (VAR s : LPString);  L VAR0   m     : FString;   n     : PString;   i,j,k : INTEGER;  M BEGINR   m := ''; i := 0;   TRead (m, i, n, j, k);$   s := SUBSTR (STR (n), 1, j) || ' ' END;F (*==================================================================*)F (* OutPacket   - This procedure writes a packet to the terminal     *)F (*==================================================================*)* PROCEDURE TWrite    (CONST Line : PString;*                      CONST Len  : INTEGER;4                      VAR   RC   : INTEGER); FORTRAN;  e# PROCEDURE OutPacket (l : LPString);K  i VAR    m   : PString;   i,j : INTEGER;    BEGINM   m := l; i := LENGTH (l);   TWrite (l, i, j) END;   F (*==================================================================*)F (* TermSize    - This procedure reads the screen size of the other  *)F (*               Kermit terminal's emulator.                        *)F (*==================================================================*)/ PROCEDURE TermSize  (VAR a : INTEGER); FORTRAN;s %PAGE ' FUNCTION Upper (S : LString) : LString;  VAR i  : INTEGER;      ch : CHAR; BEGIN 
   Upper := S; #   FOR i := 1 TO LENGTH (S) DO BEGINo       ch := S (.i.);D       IF ch IN (.'a'..'z'.) THEN Upper (.i.) := CHR ( ORD (ch) + 64)   END  END;   F (*==================================================================*)F (* CheckDsn    - This procedure verifies whether a data set exists  *)F (*               and if so, it prompts the user for a new name.     *)F (*==================================================================*)@ PROCEDURE CheckDsn (VAR KFile : LString; VAR Result : DISPTYPE);  D CONST      RelId = '00000001';T  . VAR TSODS : TEXT;      InFile,      Line  : LString;     Name  : STRING (20);     Dot,Num,     Col   : INTEGER;     IsPDS : BOOLEAN;   3   PROCEDURE NewChar (VAR L : LString; N : INTEGER);E   CONSTFD     Charset = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ'; (* 36 items *)   VAR)     Chg : CHAR;      j   : INTEGER;   BEGING     Chg := L (.N.); &     j   := INDEX (Charset, STR (Chg));     j   := j + 1;      IF j > 36 THEN j := 1;     Chg := Charset (.j.);      L (.N.) := Chg   END;  ; BEGINi   InFile := Upper (KFile);   IF InFile (.1.) <> '''' THEN7      InFile := '''' || UserID || '.' || InFile || '''';1>   IF Debug THEN WRITELN (DFILE, 'Checking data set ', InFile);'   TSOService ('PROFILE NOPROMPT',  RC);H7   TSOService ('TSODS LISTDS ' || InFile || ' MEM', RC);h%   TSOService ('PROFILE PROMPT',  RC);    RESET   (TSODS);   READLN  (TSODS, Line);&   IF Debug THEN WRITELN (DFILE, Line);,   (* -------------------------------------*),   (* Maybe filename is invaild            *),   (* -------------------------------------*).   IF INDEX (Line, 'INVALID DATA SET') > 0 THEN)     IF NOT GetFile THEN Result := BADNAMEA     ELSE BEGIN>       (* TSO Kermit got an invalid data set name from micro *)>       (* ... will try now to write data to a temporary file *)>       (* called KERMIT.TEMP                                 *)H       IF Debug THEN WRITELN (DFile, KFile || ' renamed to KERMIT.TEMP');       KFile := 'KERMIT.TEMP';        CheckDsn (KFile, Result)     ENDn   ELSE BEGIN     READLN  (TSODS, Line);(     IF Debug THEN WRITELN (DFILE, Line);.     (* -------------------------------------*).     (* Maybe file is not in catalog         *).     (* -------------------------------------*)<     IF INDEX (Line, 'NOT IN CATALOG') > 0 THEN Result := NEW     ELSE BEGIN       Result := SHARE;       IsPDS  := FALSE;       READLN  (TSODS, Line);C       IF INDEX (Line, 'PO') > 0 THEN BEGIN (* Dsn is partitioned *)           IsPDS  := TRUE;E          IF INDEX (KFile, '(') = 0 THEN BEGIN (* No member for PDS *)7             Result := ERROR;0             IF NOT GetFile THEN Result := NOMEM;D             IF Debug THEN WRITELN (DFILE, 'No member specified !!');             RETURN
          END;76          READLN  (TSODS, Line); READLN  (TSODS, Line);6          READLN  (TSODS, Line); READLN  (TSODS, Line);-          IF Debug THEN WRITELN (DFILE, Line);0?          IF INDEX (Line, 'NOT FOUND') > 0 THEN Result := NEWMEMF!             ELSE Result := OLDMEM 	       END      ENDB   END;   CLOSE (TSODS);   IF NOT GetFile THEN 8      IF (Result = SHARE) OR (Result = OLDMEM) THEN BEGIN?         TSOService ('TSODS LISTCAT ENT(' || InFile || ')', RC);          IF RC <> 0 THEN BEGINNH           IF Debug THEN WRITELN (DFILE, 'No access to file ' || InFile);           Result := NOACC          ENDI	      END;    IF GetFile THENF    CASE Result OF 	      NEW,)+      NEWMEM : (* New data set or member *);X#      ERROR  : (* Do nothing yet *);A      OLDMEM,      SHARE  : BEGIN)'                 IF Remote THEN Num := 30                 ELSE BEGIND                   WRITELN ('Data set or member already exists ...');                    WRITELN (' ');6                   WRITELN ('    (1) Overwrite it ? ');8                   WRITELN ('    (2) Append to file ? ');>                   WRITELN (' or (3) create new file name ? ');                    READLN  (Num);9                   IF (Num < 1) OR (Num > 3) THEN Num := 37                 END;                 CASE Num OF0$                   1 : Result := OLD;'                   2 : Result := MODIFY;4                   3 : BEGIN (                         InFile := KFile;3                         Col := INDEX (InFile, '(');0A                         IF IsPDS THEN Col := INDEX (InFile, ')'); /                         Num := LENGTH (InFile);OA                         IF Col > 0 THEN NewChar (InFile, Col - 1)=>                                    ELSE NewChar (InFile, Num);(                         KFile := InFile;%                         IF Debug THEN=B                            WRITELN (DFILE, 'Trying with ', KFile);0                         CheckDsn (KFile, Result)                       END                    END                  ENDG      END END;     CD (*================================================================*)D (* Extract   - This procedure constructs a KERMIT filename from   *)D (*             a TSO data set name.                               *)D (*================================================================*)? PROCEDURE Extract (Filename : LString; VAR KermName : LString);=  = VAR Name, Typ : String(8);     PDS,Dot,i : INTEGER;    BEGINo   Filename := LTRIM (Filename);=#   Dot := INDEX (Filename, '.') + 1;=   IF Filename (.1.) = '''' THENR@      Filename := SUBSTR (Filename, Dot , LENGTH (Filename)-Dot);   Typ := '';   PDS := INDEX (Filename, '(');    Dot := INDEX (Filename, '.');A   IF PDS > 0 THEN BEGINU"     i    := INDEX (Filename, ')');.     Name := SUBSTR (Filename, PDS+1, i-PDS-1);&     Filename := DELETE (Filename, PDS)
   END ELSE     IF Dot > 0 THEN BEGIN *       Name := SUBSTR (Filename, 1, Dot-1);*       Filename := SUBSTR (Filename, Dot+1)     END ELSE1       BEGIN Name := Filename; Filename := '' END;C   IF Filename <> '' THEN
     REPEAT#       Dot := INDEX (Filename, '.'); :       IF Dot > 0 THEN Filename := SUBSTR (Filename, Dot+1)@                  ELSE BEGIN Typ := Filename; Filename := '' END;     UNTIL Filename = '';#   IF Typ = '' THEN KermName := Name6)      ELSE KermName := Name || '.' || Typ;  END; %PAGEpF (*==================================================================*)F (* Wildcard_Search:  This procedure generates a list of filenames,  *)F (*                   which follow a given mask.                     *)F (*==================================================================*), PROCEDURE Wildcard_Search (VAR S : LString);  = VAR Flag   : BOOLEAN;=	     Line,=     DSname : LString;R     User   : STRING (8);
     Mask1,
     Mask2,	     Name,      FullDsn,     Level  : STRING (40);,     Len1, Len2, >     Star,                   (* Position of '*' in filename  *)>     Dot,                    (* Position of '.' in filename  *)>     ParOp,                  (* Position of '(' in filename  *)>     ParCl  : INTEGER;       (* Position of ')' in filename  *)  = BEGIN=   FileCount := 0;=   S := Upper (S);="   IF INDEX (S, '*') = 0 THEN BEGIN      FileCount := 1;      FileList (.1.) := S;r      RETURN    END;   IF S(.1.) = '''' THEN BEGINI      Dot  := INDEX (S, '.');"      User := SUBSTR (S, 2, Dot-2);1      S    := SUBSTR (S, Dot+1, LENGTH (S)-Dot-1);=   END ELSE User := UserId;   DSname := S;   Star   := INDEX (S, '*');c!   IF Star < LENGTH (S) THEN BEGINa"      Line   := SUBSTR (S, Star+1);)      IF INDEX (Line , '*') > 0 THEN BEGIN)1         WRITELN (' No double wildcard allowed ');          RETURN      END   END;   Dot    := INDEX (S, '.');    ParOp  := INDEX (S, '(');e   IF ParOp > 0 THEN BEGINL      ParCl  := INDEX (S, ')');&      DSname := SUBSTR (S, 1, ParOp-1);E      IF Star > ParOp THEN BEGIN   (* He would like all PDS members *)=#         Mask1 := ' '; Mask2 := ' ';=          IF Star > ParOp + 1 THEN6            Mask1 := SUBSTR (S, ParOp+1, Star-ParOp-1);&         IF Star < Parcl - 1 THEN BEGIN5            Mask2 := SUBSTR (S, Star+1, ParCl-Star-1);="            Len2  := LENGTH (Mask2)         END;9         FullDsn := '''' || User || '.' || DSname || '''';C;         TSOService ('TSODS LISTD ' || FullDsn || ' m', RC);          RESET  (TSODS);e         READLN (TSODS, Line);H:         IF INDEX (Line, 'NOT IN CATALOG') > 0 THEN RETURN;         READLN (TSODS, Line);          READLN (TSODS, Line); ,         IF INDEX (Line, 'PO') = 0 THEN BEGIN&            FileCount := FileCount + 1;A            IF User = UserID THEN FileList (.FileCount.) := DSNAME )            ELSE FileList (.FileCount.) := 6                 '''' || User || '.' || DSNAME || '''';+            RETURN;  (* File is not a PDS *)          END;         READLN (TSODS, Line);I         READLN (TSODS, Line);          READLN (TSODS, Line); &         WHILE NOT EOF (TSODS) DO BEGIN           READLN (TSODS, Line); 7           IF INDEX (Line, 'NOT USEABLE') > 1 THEN BEGIN               CLOSE (TSODS);L              RETURNE           END;           Line := LTRIM (Line);M            Len1 := LENGTH (Line);           Flag := TRUE;            IF Mask1 <> ' ' THEN<              IF INDEX (Line, Mask1) <> 1 THEN Flag := FALSE;           IF Mask2 <> ' ' THEN>              IF SUBSTR (Line, Len1-Len2+1, Len2) <> Mask2 THEN                 Flag := FALSE;           IF Flag THEN BEGIN(              FileCount := FileCount + 1;<              IF User = UserID THEN FileList (.FileCount.) :=,                 DSNAME || '(' || Line || ')'+              ELSE FileList (.FileCount.) :=OC              '''' || User || '.' || DSNAME || '(' || Line || ')''';'           END;         END;         CLOSE  (TSODS)      END
   END ELSE   IF ParOp > 0 THEN RETURN      ELSE BEGIN-$        Name := SUBSTR (S, 1, Dot-1);&        Level := 'LEV(' || User || ')';2        TSOService ('TSODS LISTCAT ' || Level, RC);#        Mask1 := User; Mask2 := ' ';N        IF Star > 1 THEN 9           Mask1 := Mask1 || '.' || SUBSTR (S, 1, Star-1);d&        IF LENGTH (S) > Star THEN BEGIN&           Mask2 := SUBSTR (S, Star+1);!           Len2  := LENGTH (Mask2)T        END;         RESET  (TSODS);
        REPEATb          READLN (TSODS, Line);:          IF INDEX (Line, 'THE NUMBER OF') <> 0 THEN LEAVE;;          IF INDEX (Line, 'SECURITY VERIFICATION') <> 0 THEN               READLN (TSODS, Line)          ELSE BEGINE&             Line := SUBSTR (Line, 17);"             Len1 := LENGTH (Line);             Flag := TRUE;)              IF Mask1 <> ' ' THEN>                IF INDEX (Line, Mask1) <> 1 THEN Flag := FALSE;              IF Mask2 <> ' ' THEN@                IF SUBSTR (Line, Len1-Len2+1, Len2) <> Mask2 THEN                    Flag := FALSE;             IF Flag THEN BEGIN*                FileCount := FileCount + 1;$                IF User = UserID THENG                 FileList (.FileCount.) := SUBSTR (Line, LENGTH(User)+2)NB                ELSE FileList (.FileCount.) := '''' || Line || ''''             ENDr
          END;;          READLN (TSODS, Line)E        UNTIL EOF (TSODS);D        CLOSE (TSODS)      END END; (* Wildcard_Search *)  ) %TITLE KERMIT Utilities F (* ===============================================================  *)F (* CRCheck  -  This procedure generates a CRC (CCITT) .             *)F (*             The generator polynomial is X^16+X^12+X^5+1          *)F (*             which is 1021 hex or the reverse 8408 hex            *)F (* Side Effect - The global variable CRC is updated. The CRC should *)F (*               be zero at the start of each CRC calculation and   *)F (*               should be called once for each byte to checked.    *)F (*               no other call to this procedure is necessary.      *)F (*              The CRC is done on all 8 bits in the byte.          *)F (* ===============================================================  *)! PROCEDURE CRCheck(MYBYTE : BYTE);  VAR   j,c,t : INTEGER;s BEGINe   c := MYBYTE;   FOR j := 0 TO 7 DO BEGIN     t   := CRC && c;     CRC := CRC >> 1;*     IF ODD (t) THEN CRC := CRC && '8408'X;     c   := c >> 12   ENDd END; (* CRCheck *)   D (*================================================================*)D (* SendChar -  This procedure sends a char to the terminal.       *)D (* Side Effect - none                                             *)D (*================================================================*)5 PROCEDURE SendChar (VAR L : LPString; MyChar : CHAR);  BEGIN:   L := L || STR (MyChar); '   IF MyChar = '0D'XC THEN OutPacket (L)  END;  (* Send Char *)P  TD (* ===============================================================*)D (* RecvChar -  This procedure gets a char from string L.          *)D (* Side Effect - EOLINE is set                                    *)D (* ===============================================================*)9 PROCEDURE RecvChar (VAR L : LPString; VAR MyChar : CHAR);, BEGINg   EOLINE := FALSE;+   IF LENGTH (L) > 0 THEN MyChar := L (.1.);)+   IF LENGTH (L) > 1 THEN L := SUBSTR (L, 2)       ELSE EOLINE := TRUE;G END;  (* Recv Char *)C  * %TITLE Procedure Write_StateF (*==================================================================*)F (* WRITE_STATE - write the present state to the debug file          *)F (*==================================================================*) procedure Write_State; var)   mess : string(2);F begin      CASE STATE OFN        S_I : mess := 'I ';        S   : mess := 'S ';        SF  : mess := 'SF';        SD  : mess := 'SD';        SZ  : mess := 'SZ';        SB  : mess := 'SB';        C   : mess := 'C ';        A   : mess := 'A ';        R   : mess := 'R ';        RF  : mess := 'RF';        RD  : mess := 'RD';        OTHERWISE mess := '??'A     END ; (* CASE state *)0     WRITELN (DFILE, '(State = ' || mess || ')' ) end; %TITLE Procedure SendPacket F (* ===============================================================  *)F (* SendPacket -This procedure sends the SENDMSG packet .            *)F (*          1. The COUNT sent includes SEQ,PACKETTYPE,and CHECKSUM  *)F (*             i.e. it is 3 larger than the DATACOUNT.              *)F (*          2. The COUNT and SEQ and CHECKSUM values are offset by  *)F (*             32 decimal (20hex) to make it a printable ASCII char.*)F (*          3. The CHECKSUM are calculated on the ASCII value of    *)F (*             the printable characters.                            *)F (*          4. All character sent must be converted to EBCDIC       *)F (*             which get translated back to ASCII by the hardware.  *)F (*             The DATA and PACKETTYPE are stored in this program   *)F (*             as EBCDIC. The other char are assumed ASCII.         *)F (* Assumptions:                                                     *)F (*       The following Global variables must be correctly set       *)F (*       before calling this procedure .                            *)F (*       1. OUTDATACOUNT - an integer-byte count of data characters.*)F (*       2. OUTSEQ    - an integer-byte count of sequence number.   *)F (*       3. OUTPACKETTYPE - an EBCDIC char  of type .               *)F (*       4. SENDMSG   - an EBCDIC array of data to be sent.         *)F (* ===============================================================  *) PROCEDURE SendPacket;=( VAR I,SUM, Len1, Len2, HCheck : INTEGER; BEGINE   IF Debug THEN BEGINI&      WRITE (DFILE, 'SEND PACKET :  ');      Write_State   END;
   Line := '';,   SUM := 0;o   CRC := 0;    CHECKBYTES := 1;9   IF ( (OUTPACKETTYPE IN (.'X','F','Z','B','D','E'.) ) OR =        (INPACKETTYPE  IN (.'D','C','K','F','Z','B'.) ) ) THEN ,      IF CHECKTYPE = '2' THEN CHECKBYTES := 26         ELSE  IF CHECKTYPE = '3' THEN CHECKBYTES := 3;C   SendChar (Line, SOH);                                 (* SOH   *)E,   OUTCOUNT := OUTDATACOUNT + 2 + CHECKBYTES;/   If (Long_Packet AND (OUTDATACOUNT > 90)) THEN /      IF OUTPACKETTYPE = 'D' THEN OUTCOUNT := 0; C   SendChar (Line, ASCIITOEBCDIC (.OUTCOUNT+32.));       (* COUNT *)=   SUM := SUM + OUTCOUNT + 32;    CRCheck (OUTCOUNT + 32);E   SendChar (Line, ASCIITOEBCDIC (.OUTSEQ+32.));           (* SEQ   *)B=   IF NOT GetFile THEN SeqChar := ASCIITOEBCDIC (.OUTSEQ+32.);    SUM := SUM + OUTSEQ + 32;k   CRCheck (OUTSEQ + 32);D   SendChar (Line, OUTPACKETTYPE);                        (* TYPE  *);   SUM := SUM + ORD (EBCDICTOASCII (.ORD(OUTPACKETTYPE).) );S:   CRCheck ( ORD (EBCDICTOASCII (.ORD (OUTPACKETTYPE).) ));/   IF (Long_Packet AND (OUTDATACOUNT > 90)) THENE&      IF OUTPACKETTYPE = 'D' THEN BEGIN.         OUTCOUNT := OUTDATACOUNT + CHECKBYTES;          Len1 := OUTCOUNT DIV 95;D         SendChar (Line, ASCIITOEBCDIC (.Len1+32.));      (* LENX1 *)         SUM := SUM + Len1 + 32;i         CRCheck (Len1 + 32);             Len2 := OUTCOUNT MOD 95;D         SendChar (Line, ASCIITOEBCDIC (.Len2+32.));      (* LENX2 *)         SUM := SUM + Len2 + 32;I         CRCheck (Len2 + 32);   @         HCheck := (SUM + (SUM AND 'C0'X) DIV '40'X ) AND '3F'X ;D         SendChar (Line, ASCIITOEBCDIC (.HCheck+32.));   (* HCHECK *)!         SUM := SUM + HCheck + 32;          CRCheck (HCheck + 32);	      END;       IF OUTDATACOUNT > 0 THEN"      FOR I := 1 TO OUTDATACOUNT DO        WITH SENDMSG DOE        BEGIN                                          (* Send Data *) %          SendChar (Line, CHARS(.I.)); 9          SUM := SUM + ORD (EBCDICTOASCII (.BYTES(.I.).));e5          CRCheck (ORD (EBCDICTOASCII (.BYTES(.I.).)))g        END;    IF CHECKBYTES = 1 THENF   BEGIN                                        (* One char checksum *)>     CHECKSUM := (SUM + (SUM AND 'C0'X) DIV '40'X ) AND '3F'X ;3     SendChar (Line, ASCIITOEBCDIC (.CHECKSUM+32.));t     SendChar (Line, '0D'XC)U   END'   ELSE IF CHECKBYTES = 2  THENF   BEGIN                                        (* Two char checksum *)>     CHECKSUM := (SUM DIV '40'X)  AND '3F'X ;  (* BIT 11 - 6 *)3     SendChar (Line, ASCIITOEBCDIC (.CHECKSUM+32.));'=     CHECKSUM := (SUM         )  AND '3F'X ;  (* BIT 0 - 5  *) 3     SendChar (Line, ASCIITOEBCDIC (.CHECKSUM+32.));      SendChar (Line, '0D'XC)k   ENDsF   ELSE BEGIN                              (* CRC-CCITT  3 character *)G     SendChar (Line,ASCIITOEBCDIC(.((CRC DIV '1000'X) AND '0F'X) +32.));MG     SendChar (Line,ASCIITOEBCDIC(.((CRC DIV '0040'X) AND '3F'X) +32.));AF     SendChar (Line,ASCIITOEBCDIC(.((CRC           ) AND '3F'X) +32.));     SendChar (Line, '0D'XC)n   END;%   IF Debug THEN WRITELN (DFILE, Line) ! END;  (* SendPacket procedure  *)E %TITLE Function RecvPacketF (*==================================================================*)F (* RecvPacket -This Function returns TRUE if it successfully        *)F (*             recieved a packet and FALSE if it had an error.      *)F (*  Side Effects:                                                   *)F (*       The following global variables will be set.                *)F (*       1. INCOUNT - an integer value of the msg char count .      *)F (*       2. INSEQ - an integer value of the sequence count.         *)F (*       3. TYPE  - an EBCDIC character of message type(Y,N,D,F,etc)*)F (*       4. REPLYMSG - an EBCDIC array of the data sent.            *)F (*                                                                  *)F (*         a)  All characters are received as EBCDIC values and     *)F (*             must be converted back to ASCII before using.        *)F (*==================================================================*) FUNCTION RecvPacket : BOOLEAN; VAR)     I,SUM,RESENDS,     LEN1, LEN2,      HCheck, Chk1,x     Chk2, Chk3,*
     InCh1,     InCh2, InCh3  : INTEGER;     INCHAR,SChar  : CHAR;      Ext_Length    : BOOLEAN; LABEL FINDSOH;    BEGINt   IF Debug THEN BEGIN )      WRITE (DFILE, 'RECEIVE PACKET :  ');t      Write_State   END;   InPacket (Line);   IF LENGTH (Line) > 0 THENs9      IF Line (.1.) <> SOH THEN Line := STR (SOH) || Line; &   IF Debug THEN WRITELN (DFILE, Line); FINDSOH:>   RecvChar (Line, INCHAR);                           (* SOH *)   IF EOLINE THEN   BEGIN (* Null response *)E     RecvPacket := TRUE;O     INPACKETTYPE:='N';
     RETURN   END;  (* Null response *);A   IF INCHAR <> SOH THEN GOTO FINDSOH;                (* no SOH *)    SUM := 0;    CRC := 0;    Ext_Length := FALSE;  =   RecvChar (Line, INCHAR);@   INCOUNT := ORD (EBCDICTOASCII (.ORD (INCHAR).));   (* COUNT *)   SUM := INCOUNT;    CRCheck (INCOUNT);2   INCOUNT := INCOUNT - 32; (* To absolute value *))   IF INCOUNT = 0 THEN Ext_Length := TRUE;=  =   RecvChar (Line, INCHAR);A   INSEQ := ORD (EBCDICTOASCII (.ORD (INCHAR).));      (* SEQ   *)T   SChar   := LastSeq;a   LastSeq := SeqChar;e   SeqChar := INCHAR;   SUM := SUM + INSEQ;=   CRCheck (INSEQ);   INSEQ := INSEQ - 32;>   IF Debug THEN WRITELN (DFILE,'SeqChar = ', SeqChar,LastSeq);  n   RecvChar (Line, INCHAR);;   INPACKETTYPE := INCHAR;                       (* TYPE  *)*4   SUM := SUM + ORD (EBCDICTOASCII (.ORD (INCHAR).));1   CRCheck (ORD (EBCDICTOASCII (.ORD (INCHAR).)));       IF Ext_Length THEN BEGIN;      RecvChar (Line, INCHAR);                   (* LENX1 *))2      LEN1 := ORD (EBCDICTOASCII (.ORD (INCHAR).));      SUM := SUM + LEN1;N      CRCheck (LEN1);      LEN1 := (LEN1 - 32) * 95;  *;      RecvChar (Line, INCHAR);                   (* LENX2 *)=2      LEN2 := ORD (EBCDICTOASCII (.ORD (INCHAR).));      SUM := SUM + LEN2;)      CRCheck (LEN2);      LEN2 := LEN2 - 32;=      INCOUNT := LEN1 + LEN2;  r<      RecvChar (Line, INCHAR);                   (* HCHECK *)4      HCheck := ORD (EBCDICTOASCII (.ORD (INCHAR).));6      CHECKSUM := (SUM + (SUM AND 192) DIV 64 ) AND 63;*      IF HCheck <> CHECKSUM + 32 THEN BEGIN        RecvPacket := FALSE;         SeqChar := LastSeq;        LastSeq := SChar;G        IF Debug THEN WRITELN (DFILE,'HChecksum error : ', CHECKSUM+32);'
        RETURNH	      END;       SUM := SUM + HCheck;       CRCheck (HCheck);   END;  t   CHECKBYTES := 1;@   IF NOT ( (INPACKETTYPE IN (.'S','G','I','C','R','K','N'.) ) OR'            (OUTPACKETTYPE = 'S') ) THEN 2      IF CHECKTYPE = '2' THEN CHECKBYTES := 2  ELSE0         IF CHECKTYPE = '3' THEN CHECKBYTES := 3;*   INDATACOUNT := INCOUNT - 2 - CHECKBYTES;9   IF Ext_Length THEN INDATACOUNT := INCOUNT - CHECKBYTES;    IF INDATACOUNT > 0 THEN.!      FOR I := 1 TO INDATACOUNT DOu        WITH REPLYMSG DO G        BEGIN                                         (* Receive data *) &          RecvChar (Line, CHARS (.I.));:          SUM := SUM + ORD (EBCDICTOASCII (.BYTES (.I.).));7          CRCheck (ORD (EBCDICTOASCII (.BYTES (.I.).)) )c        END;   tF   RecvPacket := TRUE;               (* ASSUME OK UNLESS CHECK FAILS *)  t   IF CHECKBYTES = 1 THENE   BEGIN                                       (* One byte CHECKSUM *) 5     CHECKSUM := (SUM + (SUM AND 192) DIV 64 ) AND 63;d     RecvChar (Line, INCHAR);<     IF ORD (EBCDICTOASCII (.ORD (INCHAR).)) <> CHECKSUM + 32     THEN BEGIN        RecvPacket := FALSE;b        SeqChar := LastSeq;        LastSeq := SChar;F        IF Debug THEN WRITELN (DFILE, 'Checksum error : ', CHECKSUM+32)     END-   ENDu  o   ELSE IF CHECKBYTES = 2  THENF   BEGIN                                       (* TWO BYTE CHECKSUM  *)(     Chk1 := (SUM  DIV '40'X ) AND '3F'X;%     Chk2 := (SUM         ) AND '3F'X;      RecvChar  (Line, INCHAR);b2     InCh1 := ORD (EBCDICTOASCII (.ORD (INCHAR).));     RecvChar (Line, INCHAR);2     InCh2 := ORD (EBCDICTOASCII (.ORD (INCHAR).));  ,@     IF ((InCh1 <> Chk1 + 32) OR (InCh2 <> Chk2 + 32)) THEN BEGIN        RecvPacket := FALSE;         SeqChar := LastSeq;        LastSeq := SChar;E        IF Debug THEN WRITELN (DFILE, 'Checksum-2 error : ', Chk1+32);'D        IF Debug THEN WRITELN (DFILE, '                   ', Chk2+32)     ENDE   END    F   ELSE BEGIN                                   (* CRC-CCITT checksum*)=     (* First char is bits 16-12, second is bits 11-6 and   *)      (* third is bits 5-0 *)      RecvChar (Line, INCHAR);2     InCh1 := ORD (EBCDICTOASCII (.ORD (INCHAR).));     RecvChar (Line, INCHAR);2     InCh2 := ORD (EBCDICTOASCII (.ORD (INCHAR).));     INCHAR := '0D'XC;3     RecvChar (Line, INCHAR);2     InCh3 := ORD (EBCDICTOASCII (.ORD (INCHAR).));   /     Chk1 :=  ((CRC DIV '1000'X) AND '0F'X) +32; -     Chk2 :=  ((CRC DIV '40'X) AND'3F'X)  +32;C"     Chk3 :=   (CRC AND '3F'X) +32;   >     IF ((InCh1 <> Chk1) OR (InCh2 <> Chk2) OR (InCh3 <> Chk3))        THEN BEGINP        RecvPacket := FALSE;         SeqChar := LastSeq;        LastSeq := SChar;        IF Debug THEN BEGIN=           WRITELN (DFILE, 'Checksum-3 (CRC) error : ', Chk1);c=           WRITELN (DFILE, '                         ', Chk2); <           WRITELN (DFILE, '                         ', Chk3)
        END     ENDT   END;! END;  (* RecvPacket procedure  *)C/ %TITLE Procedures ReSendit, SendACK & SendError=F (*==================================================================*)F (* ReSendit -  This procedure RESENDS the packet if it gets a nak   *)F (*             It calls itself recursively upto the number of times *)F (*             specified in the intial parameter list.              *)F (* Side Effects - If it fails then the STATE in the message is set  *)F (*                to 'A' which means ABORT .                        *)F (*==================================================================*)) PROCEDURE ReSendit ( RETRIES : INTEGER );  BEGIN    IF RETRIES > 0 THEN 8   BEGIN                                  (* Try again *)     SendPacket;S     IF RecvPacket THEN'        IF INPACKETTYPE = 'Y' THEN BEGINk/           IF NOT GetFile AND (LastSeq<>SeqChar)D*                  THEN ReSendit (RETRIES-1)
           END =           ELSE IF INPACKETTYPE = 'N' THEN ReSendit(RETRIES-1)+              ELSE STATE := A     ELSE STATE := Ah   ENDe>   ELSE STATE := A                 (* Retries failed - ABORT *) END; (* ReSendit procedure  *)   B (*--------------------------------------------------------------*)B (*  SendACK - Procedure will send an ACK or NAK                 *)B (*            depending on the value of the Boolean parameter   *)B (*            i.e.  ENDACK(TRUE)  sends an ACK packet           *)B (*                 SENDACK(FALSE) sends an NAK packet           *)B (*--------------------------------------------------------------*)  PROCEDURE SendACK (B : BOOLEAN); BEGINO   OUTDATACOUNT := 0;!   IF B THEN OUTSEQ := OUTSEQ + 1;h#   IF OUTSEQ >= 64 THEN OUTSEQ := 0;4    IF B THEN OUTPACKETTYPE := 'Y'!        ELSE OUTPACKETTYPE := 'N';    SendPacket END;  (* Send ACK or NAK *)i   B (*--------------------------------------------------------------*)B (*  SendError - Sends an error packet, with a message passed    *)B (*              from the caller.                                *)B (*--------------------------------------------------------------*)' PROCEDURE SendError (ErrStr : LString);t BEGIN #   OUTDATACOUNT  := LENGTH (ErrStr);    SENDMSG.CHARS := ErrStr;   OUTSEQ := 0;   OUTPACKETTYPE := 'E';i   SendPacket END;  (* SendError *) " %TITLE Some Send_X_Packet routines? (*-----------------------------------------------------------*)E? (* SendBPacket - send break packet to terminate transmission *)3? (*-----------------------------------------------------------*)  PROCEDURE SendBPacket; BEGINr   OUTDATACOUNT  := 0 ;   OUTSEQ        := OUTSEQ + 1 ; $   IF OUTSEQ >= 64 THEN OUTSEQ := 0 ;   OUTPACKETTYPE := 'B' ;
   SendPacket; "   IF RecvPacket THEN (* It's ok *) END; (* SendBPacket *)  e? (*-----------------------------------------------------------*)=? (* SendZPacket - send EOF packet                             *)R? (*-----------------------------------------------------------*)  PROCEDURE SendZPacket; BEGINh   OUTDATACOUNT  :=  0 ;h   OUTSEQ        := OUTSEQ + 1 ;S%   IF OUTSEQ >= 64 THEN OUTSEQ := 0; ;L   OUTPACKETTYPE := 'Z' ;
   SendPacket;b   IF RecvPacket THEN (* Ok *)L END; (* SendZPacket *)   ? (*-----------------------------------------------------------*)>? (* SendXPacket - send data header packet for terminal        *)e? (*-----------------------------------------------------------*)(' PROCEDURE SendXPacket (Head : LString);( BEGIN)!   OUTDATACOUNT  := LENGTH (Head);    OUTSEQ        := OUTSEQ + 1 ;R$   IF OUTSEQ >= 64 THEN OUTSEQ := 0 ;   OUTPACKETTYPE := 'X';n   SENDMSG.CHARS := Head;
   SendPacket;S   IF RecvPacket THEN+      IF INPACKETTYPE='Y' THEN (* It's ok *)_2      ELSE IF INPACKETTYPE = 'N' THEN ReSendit (10) END; (* SendXPacket *)  I? (*-----------------------------------------------------------*) ? (* SendYPacket - send acknoledgement with data to micro      *) ? (*-----------------------------------------------------------*)N' PROCEDURE SendYPacket (Head : LString);R BEGINA!   OUTDATACOUNT  := LENGTH (Head);    OUTPACKETTYPE := 'Y';=   SENDMSG.CHARS := Head;   SendPacket END; (* SendYPacket *)   ? (*-----------------------------------------------------------*)'? (* SendDPacket - send data packet to micro                   *) ? (*-----------------------------------------------------------*) ; PROCEDURE SendDPacket (Head : LString; VAR Flag : BOOLEAN);D BEGINC   OUTSEQ := OUTSEQ + 1;)#   IF OUTSEQ >= 64 THEN OUTSEQ := 0; !   OUTDATACOUNT  := LENGTH (Head);    OUTPACKETTYPE := 'D';    SENDMSG.CHARS := Head;
   SendPacket;A   Flag := TRUE;:   IF RecvPacket THEN,      IF INPACKETTYPE='Y' THEN  (* nothing *)0      ELSE IF INPACKETTYPE='N' THEN ReSendit (10)           ELSE Flag := FALSE END; (* SendDPacket *)' %TITLE Procedures GetToken & ParmPacket F (* ===============================================================  *)F (* GetToken -  This procedure extracts a token from a string and    *)F (*             the function returns a 8 character token value.      *)F (*             the string is update with the portion that is left.  *)F (* ===============================================================  *)7 FUNCTION GetToken ( VAR INSTRING : STRING(256)) : ALFA;,  VAR*     BP,BPM : INTEGER ; (* Blank Pointer *)    BEGIND6   IF LENGTH (INSTRING) < 1 THEN GetToken := '        '   ELSE BEGIN      BP := INDEX (INSTRING, ' ');/     IF BP = 0 THEN BP := LENGTH (INSTRING) + 1;      BPM := MIN(BP,9);P'     GetToken := DELETE (INSTRING, BPM); A     INSTRING := DELETE (INSTRING, 1, MIN (BP, LENGTH (INSTRING)))T   END; END; (* GetToken *)C  TE (*=================================================================*)BE (* ParmPacket - This procedure makes the PARAMETER PACKET.         *) E (*=================================================================*)  PROCEDURE ParmPacket;* VAR i, l1, l2 : BYTE;L BEGINA   OUTDATACOUNT := 13;M   OUTSEQ       := 0;   WITH SENDMSG DO)'   BEGIN         (* Setup PARM packet *)I;     (* The values  are tranformed by adding hex 20 to    *) ;     (* the true value, making the value a printable char *)EF     CHARS (.1.)  := ASCIITOEBCDIC (.94+32.);    (* Buffersize       *)F     CHARS (.2.)  := ASCIITOEBCDIC (.'28'X.);    (* Time out 8 sec   *)F     CHARS (.3.)  := ASCIITOEBCDIC (.'20'X.);    (* Num padchars=0   *)F     CHARS (.4.)  := ASCIITOEBCDIC (.'40'X.);    (* Pad char=blank   *)F     CHARS (.5.)  := ASCIITOEBCDIC (.ECHAR+32.); (* EOL char = CR    *)F     CHARS (.6.)  := CNTRL_QUOTE;                (* Quote character  *)F     CHARS (.7.)  := BIT8_QUOTE;                 (* Quote character  *)3     IF BIT8_QUOTE = '00'XC THEN CHARS (.7.) := 'Y'; F     CHARS (.8.)  := CHECKTYPE;                  (* Check type       *)F     CHARS (.9.)  := REPEATCHAR;                 (* Repeat character *)3     IF REPEATCHAR = '00'XC THEN CHARS (.7.) := ' ';CF     l1 := 2+8;                                  (* 2 = LONGP        *)F                                                 (* 8 = ATTRIBUTE    *)F     CHARS (.10.) := ASCIITOEBCDIC (.l1+32.);    (* CAPAS character  *)F     CHARS (.11.) := ASCIITOEBCDIC (.'20'X.);    (* Window size = 0  *)8     IF Long_Packet THEN l1 := PSIZE DIV 95 ELSE l1 := 0;F     CHARS (.12.) := ASCIITOEBCDIC (.l1+32.);    (* Ext.packet len1  *)9     IF Long_Packet THEN l2 := PSIZE MOD 95 ELSE l2 := 94;*F     CHARS (.13.) := ASCIITOEBCDIC (.l2+32.);    (* Ext.packet len2  *)F                                                 (* DEF:0*95+94= 94  *)   ENDn END;  (*  parameters *)  %TITLE Procedure FileToPacket:F (*==================================================================*)F (* FileToPacket - This procedure files in a DATA packet D or X type *)F (*                with data from the file SFILE.                    *)F (*==================================================================*) PROCEDURE FileToPacket;E BEGIN    OUTDATACOUNT := 0;   OUTSEQ       := OUTSEQ + 1;;#   IF OUTSEQ >= 64 THEN OUTSEQ := 0; =   WHILE (OUTDATACOUNT < PSIZE-3-4-4) AND (NOT EOF (SFILE)) DOr   BEGIN (* Read a record *)R&     OUTDATACOUNT := OUTDATACOUNT + 1 ;1     READ (SFILE, SENDMSG.CHARS (.OUTDATACOUNT.));      WITH SENDMSG DO         IF TEXTMODE THENN"        BEGIN  (* translate file *)<          (* The following double translation is used to   *)<          (* filter out meaningless EBCDIC characters into *)<          (* something more consistent.                    *),          IF BYTES (.OUTDATACOUNT.) <> 0 THEN%             CHARS (.OUTDATACOUNT.) :=*5             EBCDICTOASCII (.BYTES (.OUTDATACOUNT.).); -          IF BYTES (.OUTDATACOUNT.) > 127 THENnF          BEGIN                           (* 8th bit quote this char *)D            BYTES (.OUTDATACOUNT+1.) := BYTES (.OUTDATACOUNT.) - 128;2            CHARS (.OUTDATACOUNT.)   := BIT8_QUOTE;+            OUTDATACOUNT := OUTDATACOUNT + 1R
          END; ,          IF BYTES (.OUTDATACOUNT.) < 32 THENB          BEGIN                               (* control quoting *)'             BYTES (.OUTDATACOUNT+1.) :=F(             BYTES (.OUTDATACOUNT.) + 64;2             CHARS (.OUTDATACOUNT.) := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1
          END;S/          IF BYTES (.OUTDATACOUNT.) = '7F'X THENEB          BEGIN                                 (* <DEL> quoting *)/             CHARS (.OUTDATACOUNT+1.) := '3F'XC;*4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1
          END; /          IF BYTES (.OUTDATACOUNT.) = '7E'X THENvC          BEGIN                                 (* Repeat quoting *) /             CHARS (.OUTDATACOUNT+1.) := '7E'XC; 4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1
          END;-,          IF BYTES (.OUTDATACOUNT.) <> 0 THEN%             CHARS (.OUTDATACOUNT.) :=Q;                   ASCIITOEBCDIC (.BYTES (.OUTDATACOUNT.).);B5          IF (CHARS (.OUTDATACOUNT.) = CNTRL_QUOTE) OR=6             (CHARS (.OUTDATACOUNT.) = BIT8_QUOTE) THENC          BEGIN                                (* Quote the quote *)*?             CHARS (.OUTDATACOUNT+1.) := CHARS (.OUTDATACOUNT.); 4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1          END
        END)        ELSE BEGIN (* Untranslated file *)r=          (* Untranslated file means the file is stored as  *).=          (* 8 bit ASCII. However it must be translated into*)e=          (* EBCDIC so that the comten software will trans- *)t=          (* late it back into ASCII.                       *)-.          IF BYTES (.OUTDATACOUNT.) >= 128 THEND             IF BIT8_QUOTE = '00'XC THEN        (* No bit8 quoting *)F                                           (* Just drop the 8th bit  *)E                BYTES (.OUTDATACOUNT.) := BYTES (.OUTDATACOUNT.) - 128=A             ELSE BEGIN                         (* BIT8 QUOTING *)NF                BYTES (.OUTDATACOUNT+1.) := BYTES (.OUTDATACOUNT.)-128;6                CHARS (.OUTDATACOUNT.)   := BIT8_QUOTE;/                OUTDATACOUNT := OUTDATACOUNT + 1*             END;,          IF BYTES (.OUTDATACOUNT.) < 32 THENF          BEGIN                                   (* CONTROL QUOTING *)D             BYTES (.OUTDATACOUNT+1.) := BYTES (.OUTDATACOUNT.) + 64;4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1
          END;-/          IF BYTES (.OUTDATACOUNT.) = '7F'X THENXF          BEGIN                                     (* <DEL> quoting *)/             CHARS (.OUTDATACOUNT+1.) := '3F'XC;(4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1
          END; /          IF BYTES (.OUTDATACOUNT.) = '7E'X THENPG          BEGIN                                     (* Repeat quoting *)c/             CHARS (.OUTDATACOUNT+1.) := '7E'XC;k4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1
          END;-,          IF BYTES (.OUTDATACOUNT.) <> 0 THEN%             CHARS (.OUTDATACOUNT.) := ;                   ASCIITOEBCDIC (.BYTES (.OUTDATACOUNT.).);-5          IF (CHARS (.OUTDATACOUNT.) = CNTRL_QUOTE) ORn6             (CHARS (.OUTDATACOUNT.) = BIT8_QUOTE) THENE          BEGIN                                  (* Quote the quote *)d?             CHARS (.OUTDATACOUNT+1.) := CHARS (.OUTDATACOUNT.);-4             CHARS (.OUTDATACOUNT.)   := CNTRL_QUOTE;,             OUTDATACOUNT := OUTDATACOUNT + 1          END        END;-?        IF EOLN (SFILE) THEN BEGIN             (* Send CR, LF *)a          READLN (SFILE);>        (*IF TEXTMODE AND (OUTDATACOUNT>1) THEN              *)(             (* Delete trailing blanks *)>        (*WHILE (SENDMSG.CHARS (.OUTDATACOUNT.) = ' ') AND   *)>        (*      (OUTDATACOUNT > 1) DO                        *)>        (*  OUTDATACOUNT := OUTDATACOUNT - 1;                *)F          IF TEXTMODE THEN BEGIN              (* Only for text files *)-             OUTDATACOUNT := OUTDATACOUNT + 1;=:             SENDMSG.CHARS (.OUTDATACOUNT.) := CNTRL_QUOTE;-             OUTDATACOUNT := OUTDATACOUNT + 1;tC             SENDMSG.CHARS (.OUTDATACOUNT.):='M'; (* Carriage Ret *)e-             OUTDATACOUNT := OUTDATACOUNT + 1;u:             SENDMSG.CHARS (.OUTDATACOUNT.) := CNTRL_QUOTE;-             OUTDATACOUNT := OUTDATACOUNT + 1;=B             SENDMSG.CHARS (.OUTDATACOUNT.) := 'J'  (* Line Feed *)          END
        END    END END; (* FILE TO PACKET *)F  N %TITLE Procedure CheckParmskF (********************************************************************)F (* CheckParms- This routine checks the parameters received from     *)F (*             the micro KERMIT.                                    *)F (********************************************************************) PROCEDURE CheckParms;= VAR i : INTEGER; BEGIN=E  IF INDEX (SPECTABLE, STR (CNTRL_QUOTE)) = 0 THEN CNTRL_QUOTE := '#';CE  IF INDEX ('123', STR (CHECKTYPE))       = 0 THEN CHECKTYPE   := '1';=E  IF INDEX (SPECTABLE, STR (BIT8_QUOTE))  = 0 THEN BIT8_QUOTE  := '&';A.  IF BIT8_QUOTE = 'Y'  THEN BIT8_QUOTE  := '&';1  IF BIT8_QUOTE = 'N'  THEN BIT8_QUOTE  := '00'XC;aE  IF INDEX (SPECTABLE, STR (REPEATCHAR))  = 0 THEN REPEATCHAR  := '~';   i := CAPAS DIV 2;?  IF ODD (i) THEN Long_Packet := TRUE ELSE Long_Packet := FALSE;I8  IF (NOT Long_Packet AND (PSIZE > 94)) THEN PSIZE := 94;$  IF PSIZE > 1000 THEN PSIZE := 1000;   IF PSIZE < 26 THEN PSIZE := 94;,  (* IF PSIZE > 256 THEN CHECKTYPE := '3'; *)  i := CAPAS DIV 8;)  IF ODD (i) THEN Handle_Attribute := TRUE *             ELSE Handle_Attribute := FALSE END; (* CheckParms *)2    %TITLE Procedure SendFile F (********************************************************************)F (* SendFile  - This routine handles the sending of a file to        *)F (*             the micro computer.                                  *)F (*             If the parameter string is blank it gets the file-   *)F (*             name from the users.                                 *)F (*             If it is non blank it assumes the file name is in    *)F (*             the parameter string, which was obtained by the      *)F (*             remote RECEIVE file command.                         *)F (********************************************************************)8 PROCEDURE SendFile (FNAME : LString; XHeader : BOOLEAN);    LABEL LOOP1;    VAR    Member      : STRING(8);	   AsName,.   KermName    : LString;	   Closed,    SENDING,EOL : BOOLEAN;   i, j, Ix,5   RETRIES     : INTEGER;   DUMMY,   B8Quote     : CHAR;.    BEGINt*   IF FNAME = ' ' THEN  (* Get file name *)      REPEAT 0        Prompt ('Enter name of sendfile>', FNAME)      UNTIL FNAME <> ' ';   FNAME := LTRIM (FNAME);=   FNAME := TRIM (FNAME);   AsName := ' ';$   IF INDEX(FNAME,' ') > 1 THEN BEGIN      i := INDEX(FNAME,' ');A#      AsName := SUBSTR (FNAME, i+1); &      FNAME  := SUBSTR (FNAME, 1, i-1);'      AsName := LTRIM  (Upper (AsName));=*      IF INDEX(AsName,'AS ') > 0 THEN BEGIN'         i := INDEX  (AsName,'AS ') + 3; #         AsName := SUBSTR(AsName, i) 	      END;;;      IF Debug THEN WRITELN (DFile, 'AsName3 = ' || AsName);    END;   Wildcard_Search (FNAME);/   IF FileCount > 0 THEN FNAME := FileList (.1.)U4   ELSE BEGIN (* No filename meets search criteria *)B     IF Remote THEN SendError ('No filename meets search criteria'):        ELSE WRITELN ('No filename meets search criteria');/        RETURN   (* Return to calling routine *)    END;   FNAME := TRIM (FNAME);   CheckDsn (FNAME, DsnDisp);   CASE DsnDisp OFn8     BADNAME: BEGIN  (* Invalid TSO filename specified *)                IF Remote THEN 6                   SendError ('Bad filename ' || FNAME)7                ELSE WRITELN ('Bad filename ' || FNAME);U7                RETURN   (* Return to calling routine *)               END;h5     NOMEM :  BEGIN  (* No member for PDS specified *)S                IF Remote THEN ;                   SendError ('No member for PDS specified')A<                ELSE WRITELN ('No member for PDS specified');7                RETURN   (* Return to calling routine *)               END; .     NOACC :  BEGIN  (* No access to dataset *)                IF Remote THEN ;                   SendError ('No access to requested file') <                ELSE WRITELN ('No access to requested file');7                RETURN   (* Return to calling routine *)T              END;N     NEW,6     NEWMEM : BEGIN  (* Data set or member not found *)                IF Remote THEN'B                   SendError ('Data set ' || FNAME || ' not found')A                ELSE WRITELN ('Data set ', FNAME, ' not found !');Y7                RETURN   (* Return to calling routine *)               END; '     OTHERWISE (* ok, data set exists *)H   END;0   IF AsName = ' ' THEN Extract (FNAME, KermName)      ELSE KermName := AsName; 9   IF Debug THEN WRITELN (DFILE, ' Sending file ', FNAME);-   IF NOT Remote THEN BEGINC      WRITELN ('ready to SEND file  - Put Micro in receive mode. ');       Waiting (Delay)   END;
   Ix := 1;F   IF XHeader THEN BEGIN                 (* Type file in remote mode *)      STATE := SD;AB      TSOCommand := 'ALLOC F(SFILE) DA(' || FNAME || ') SHR REUSE';!      TSOService (TSOCommand, RC); =      IF Debug THEN WRITELN (DFILE, TSOCommand, ' RC = ', RC);       RESET (SFILE)   END ELSE STATE := S;   GETREPLY := FALSE;   SENDING := TRUE;)   WHILE SENDING DO BEGIN (* Send files *)      IF GETREPLY THEN        IF RecvPacket THEN ?           IF (INPACKETTYPE = 'Y') AND (SeqChar=LastSeq) THEN {} @              ELSE IF (INPACKETTYPE = 'Y') AND (SeqChar<>LastSeq)$                   THEN ReSendit (10)<                 ELSE IF INPACKETTYPE = 'N' THEN ReSendit(10)=                    ELSE IF INPACKETTYPE = 'R' THEN STATE := S %                       ELSE STATE := A ,                          ELSE  ReSendit(10);   GETREPLY := TRUE; 4   IF (INPACKETTYPE = 'Y') AND (INDATACOUNT > 0) THEN3      IF REPLYMSG.CHARS (.1.) = 'X' THEN STATE := SZ <         ELSE IF REPLYMSG.CHARS (.1.) = 'Z' THEN STATE := SZ;      CASE STATE OF(F     S :  BEGIN                                  (* Send INIT packit *)             OUTPACKETTYPE := 'S';            ParmPacket;            SendPacket;            STATE := SF
          END;.  DF     SF:  BEGIN                                  (* Send file header *)"            IF INDATACOUNT > 1 THEN?            BEGIN                      (* Get init parameters *) %              IF INDATACOUNT >= 1 THENT                 PSIZE :=B                 ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.1.).)) - 32;%              IF INDATACOUNT >= 5 THEN                  ECHAR :=B                 ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.5.).)) - 32;%              IF INDATACOUNT >= 6 THENU4                 CNTRL_QUOTE := REPLYMSG.CHARS (.6.);+              IF INDATACOUNT >= 7 THEN BEGINY0                 B8Quote := REPLYMSG.CHARS (.7.);8                 IF B8Quote = 'Y' THEN BIT8_QUOTE := '&';5                 IF NOT (B8Quote IN (.'Y', 'N'.)) THEN (                    BIT8_QUOTE := B8Quote              END; %              IF INDATACOUNT >= 8 THEN 2                 CHECKTYPE  := REPLYMSG.CHARS (.8.)$              ELSE CHECKTYPE  := '1';%              IF INDATACOUNT >= 9 THEN.2                 REPEATCHAR := REPLYMSG.CHARS (.9.)$              ELSE REPEATCHAR := '~';&              IF INDATACOUNT >= 10 THEN                 CAPAS      := E                    ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.10.).)) - 32U                  ELSE CAPAS := 0;,              IF INDATACOUNT >= 13 THEN BEGIN                 PSIZE :=F                    ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.12.).)) - 32;%                 PSIZE := PSIZE * 95 + E                    ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.13.).)) - 32(              END;N              CheckParms             END;i'            OUTSEQ        := OUTSEQ + 1;H,            IF OUTSEQ >= 64 THEN OUTSEQ := 0;             OUTPACKETTYPE := 'F';%            SENDMSG.CHARS := KermName;A.            OUTDATACOUNT  := LENGTH (KermName);            SendPacket;9            TSOCommand := 'ALLOC F(SFILE) DA(' || FNAME ||U'                          ') SHR REUSE'; '            TSOService (TSOCommand, RC);RC            IF Debug THEN WRITELN (DFILE, TSOCommand, ' RC = ', RC);             Closed := FALSE;)            RESET (SFILE); G            IF Handle_Attribute THEN               (* Send attributes *)                 IF RecvPacket THEN1                  IF INPACKETTYPE = 'Y' THEN BEGIN 0                     OUTSEQ        := OUTSEQ + 1;5                     IF OUTSEQ >= 64 THEN OUTSEQ := 0; )                     OUTPACKETTYPE := 'A';eE                     SENDMSG.CHARS := '."I2'; (*IBM/370 with MVS/TSO*)*'                     OUTDATACOUNT  := 4;c                     SendPacket                   END;            STATE := SD
          END;    F     SD:  BEGIN                                         (* Send data *)             OUTPACKETTYPE := 'D';            FileToPacket;            SendPacket;*            IF EOF (SFILE) THEN STATE := SZ
          END;   2     SZ:  BEGIN            OUTDATACOUNT  := 0;'            OUTSEQ        := OUTSEQ + 1;_,            IF OUTSEQ >= 64 THEN OUTSEQ := 0;             OUTPACKETTYPE := 'Z';            SendPacket;.     LOOP1: IF Ix >= FileCount THEN STATE := SB            ELSE BEGINA&               IF NOT Closed THEN BEGIN                  CLOSE (SFILE);L2                  TSOService ('FREE F(SFILE)', RC);                  Closed := TRUE)               END;               Ix := Ix + 1;='               FNAME := FileList (.Ix.); (               CheckDsn (FNAME, DsnDisp);               CASE DsnDisp OF E                  BADNAME: BEGIN  (* Invalid TSO filename specified *)=1                             IF DEBUG THEN WRITELNeA                                (DFILE, 'Bad filename ' || FNAME);*&                             GOTO LOOP1                           END;:                  NOMEM :  BEGIN  (* No member specified *)1                             IF DEBUG THEN WRITELNaE                                (DFILE,'No member for PDS specified');m&                             GOTO LOOP1                           END;;                  NOACC :  BEGIN  (* No access to dataset *) 1                             IF DEBUG THEN WRITELN E                                (DFILE,'No access to requested file'); &                             GOTO LOOP1                           END;                  NEW,eC                  NEWMEM : BEGIN  (* Data set or member not found *) 9                             IF Debug THEN WRITELN (DFILE,nG                                  'Data set ' || FNAME || ' not found');N&                             GOTO LOOP1                           END;4                  OTHERWISE (* ok, data set exists *)               END;(               Extract (FNAME, KermName);               STATE := SF             END;F
          END;e   F     SB:  BEGIN                                    (* Last file sent *)            OUTDATACOUNT  := 0;'            OUTSEQ        := OUTSEQ + 1;i,            IF OUTSEQ >= 64 THEN OUTSEQ := 0;             OUTPACKETTYPE := 'B';            SendPacket;            STATE := C+
          END;s  eF      C:  BEGIN                                 (* Completed Sending *)            CLOSE (SFILE); ,            TSOService ('FREE F(SFILE)', RC);            SENDING := FALSE 
          END;B  NE      A:  BEGIN                                    (* Abort Sending *)(            CLOSE (SFILE);r,            TSOService ('FREE F(SFILE)', RC);            ABORT   := BADSF;            SENDING := FALSE;*            SendError ('Send file aborted')          END      END  (* CASE of STATE *)i    END  (* Send files *) END; (* SendFile procedure *)f %TITLE Procedure RecvFileeF (* **************************************************************** *)F (* RecvFile  - This routine handles the Receiving of a file from    *)F (*             the micro computer.                                  *)F (*                                                                  *)F (* Note : whenever a CR,LF pair is received it assumes it is the    *)F (*        an EOLN indicator and are not stored in the file.         *)F (*        However if we get two CR,LF in a row we can not write     *)F (*        an empty record so we must store the next CR,LF in the    *)F (*        next record .                                             *)F (* **************************************************************** *) PROCEDURE RecvFile;g  u VAR*   BIT8       : BYTE;
   B8Quote,   Dummy      : CHAR;
   IN_Attr,
   FILEWANTED,n   OldFname   : LString;e	   REP, K,    RETRIES,IX : INTEGER;o	   CRFLAG,t   CRLFFLAG   : BOOLEAN;d   TITLE      : STRING (80);LE   RFILE      : TEXT;                               (* RECEIVE file *)t   C   (*-------------------------------------------------------------*) C   (*  SendNAK - Procedure of RECVFILE, will check the number of  *)mC   (*            RETRIES , if it is greater than 0 it will send a *) C   (*            call SENDACK(FALSE) which send a NAK packet and  *)rC   (*            decrements the RETRIES by 1.                     *)eC   (*  Side Effect - RETRIES is decremented by 1.                 *)TC   (*                STATE is set to A if no more retries.        *)LC   (*-------------------------------------------------------------*)m   PROCEDURE SendNAK;   BEGINW     IF RETRIES > 0 THEN,	     BEGINR       SendACK (FALSE);       RETRIES := RETRIES - 1     END      ELSE STATE := AT   END; (* SEND ACK or NAK *)   E   (*---------------------------------------------------------------*) E   (*  AllocFile - Procedure of RECVFILE, will allocate a file for  *) E   (*              receiving function.                              *) E   (*---------------------------------------------------------------*)e*   PROCEDURE AllocFile (OutFile : LSTRING);   VAR      DsnDCB  : STRING(40);    BEGIN *     IF NOT TEXTMODE THEN DsnDCB := DCB_Bin(        ELSE IF FB THEN DsnDCB := DCB_Fix!           ELSE DsnDCB := DCB_Var; :     TSOCommand := 'ALLOC F(RFILE) DA(' || OutFile || ') ';     CASE DsnDisp OF         NEW    : BEGINA                   TSOCommand := ?                      TSOCommand || 'NEW TR SP(5,5) ' || DsnDCB; 2                   IF INDEX (OutFile, '(') > 0 THEN;                      TSOCommand := TSOCommand || ' DIR(5)';                  END;        NEWMEM,8        SHARE  : TSOCommand := TSOCommand || 'SHR REUSE';        OLD,)8        OLDMEM : TSOCommand := TSOCommand || 'OLD REUSE';8        MODIFY : TSOCommand := TSOCommand || 'MOD REUSE';     END;      TSOService (TSOCommand, RC);D     IF Debug THEN WRITELN (DFILE, TSOCommand, ' => RetCode = ', RC);(   END; (* Allocate File for Receiving *)   E   (*---------------------------------------------------------------*)SE   (*  DecodeAttr - Decode incoming attribute fields.               *) E   (*---------------------------------------------------------------*)N+   PROCEDURE DecodeAttr (AttrStr : LSTRING);=   VARS     K,     Len : INTEGER;     Ch1 : CHAR;'     Attribute : STRING(94);    BEGIN '     WHILE LENGTH (AttrStr) > 1 DO BEGIN !       Ch1       := AttrStr (.1.);BB       Len       := ORD (EBCDICTOASCII (. ORD (AttrStr(.2.)).))-32;,       Attribute := SUBSTR (AttrStr, 3, Len);.       AttrStr   := DELETE (AttrStr, 1, Len+2);F       IF DEBUG THEN WRITELN (DFILE, 'Attribute: ', Ch1,' ', Attribute)     END;   END; (* DecodeAttr *)E  T BEGIN    GetFile := TRUE;   IF NOT Remote THEN*     IF LENGTH (INPUTSTRING) > 0 THEN BEGIN!        FILEWANTED := INPUTSTRING;L0        IF INDEX (FILEWANTED, '*') > 0 THEN BEGIN1           WRITELN ('Wildcards not allowed, yet');B           RETURN        END; '        CheckDsn  (FILEWANTED, DsnDisp);E$        IF DsnDisp = ERROR THEN BEGINE           WRITELN ('An error occurred while reading DS information');.G           WRITELN ('Please turn DEBUG option ON, and retry operation');m           RETURN        END;         AllocFile (FILEWANTED);D        WRITELN (' RECEIVE mode - Issue a SEND command from micro. ')     END;0   IF Remote THEN BEGIN OUTSEQ := 0; SendNAK END;
   STATE := R;:   RECEIVING := TRUE;;   RETRIES := 10;            (* Up to 10 retries allowed. *)L  D   WHILE RECEIVING DO   CASE STATE OF F     R : BEGIN                             (* Initial Receive State  *)@           IF (NOT RecvPacket) OR (INPACKETTYPE='N') THEN SendNAK!           ELSE (* Get a packet *)R&             IF INPACKETTYPE = 'S' THEN,             BEGIN  (* Get Init parameters *)&               IF INDATACOUNT >= 1 THENG                  PSIZE := ORD(EBCDICTOASCII(.REPLYMSG.BYTES(.1.).))-32;S&               IF INDATACOUNT >= 5 THENG                  ECHAR := ORD(EBCDICTOASCII(.REPLYMSG.BYTES(.5.).))-32;P&               IF INDATACOUNT >= 6 THEN5                  CNTRL_QUOTE := REPLYMSG.CHARS (.6.); ,               IF INDATACOUNT >= 7 THEN BEGIN1                  B8Quote := REPLYMSG.CHARS (.7.);S9                  IF B8Quote = 'Y' THEN BIT8_QUOTE := '&'; 6                  IF NOT (B8Quote IN (.'Y', 'N'.)) THEN)                     BIT8_QUOTE := B8Quotee               END;&               IF INDATACOUNT >= 8 THEN3                  CHECKTYPE  := REPLYMSG.CHARS (.8.) %               ELSE CHECKTYPE  := '1';T&               IF INDATACOUNT >= 9 THEN2                  REPEATCHAR := REPLYMSG.CHARS(.9.)%               ELSE REPEATCHAR := '~'; '               IF INDATACOUNT >= 10 THEN:                  CAPAS      :=E                    ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.10.).)) - 32 !                  ELSE CAPAS := 0;F-               IF INDATACOUNT >= 13 THEN BEGIN)                  PSIZE := F                    ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.12.).)) - 32;&                  PSIZE := PSIZE * 95 +E                    ORD (EBCDICTOASCII (.REPLYMSG.BYTES (.13.).)) - 32                END;               CheckParms; #               OUTPACKETTYPE := 'Y';                ParmPacket;F               SendPacket;M               STATE := RF              END ,             ELSE BEGIN (* Not init packet *):               STATE := A;   (* ABORT if not INIT packet *)               ABORT := NOT_S             END *         END ; (* Initial Receive State  *)  s>     RF: IF (NOT RecvPacket) OR (INPACKETTYPE='N') THEN SendNAK         ELSE (* Get a packet *) -           IF INPACKETTYPE = 'S' THEN STATE:=R 8           ELSE IF INPACKETTYPE = 'Z' THEN SendACK (TRUE)4             ELSE IF INPACKETTYPE = 'B' THEN STATE:=C.                ELSE IF INPACKETTYPE = 'F' THENF                   BEGIN                          (* Got file header *)!                     FILEWANTED :=oD                       SUBSTR (STR (REPLYMSG.CHARS), 1, INDATACOUNT);=                     IF INDEX (FILEWANTED, '*') > 0 THEN BEGINN?                        SendError ('No wildcards allowed, yet');                         RETURN                      END;.                     IX := LENGTH (FILEWANTED);3                     IF FILEWANTED (.IX.) = '.' THEN B                        FILEWANTED := SUBSTR (FILEWANTED, 1, IX-1);(                     IF Remote THEN BEGIN.                        OldFname := FILEWANTED;6                        CheckDsn (FILEWANTED, DsnDisp);9                        IF DsnDisp = ERROR THEN STATE := AB5                           ELSE AllocFile (FILEWANTED)                      END;2                     IF DsnDisp <> ERROR THEN BEGIN'                        REWRITE (RFILE); '                        CRFLAG := FALSE; )                        CRLFFLAG := FALSE;B#                        STATE := RD; %                        SendACK (TRUE)                      ENDr                   END 5                   ELSE BEGIN (* Not S,F,B,Z packet *) <                     (* ABORT if not a S,F,B,Z type packet *)                     STATE := A; %                     ABORT := NOT_SFBZi                   END;  o>     RD: IF (NOT RecvPacket) OR (INPACKETTYPE='N') THEN SendNAK$         ELSE (* Got a good packet *)%            IF INPACKETTYPE = 'A' THENaF               BEGIN                              (* Got attributes  *)                  IN_Attr := B                     SUBSTR (STR (REPLYMSG.CHARS), 1, INDATACOUNT);&                  DecodeAttr (IN_Attr);                  SendACK (TRUE)                END F            ELSE IF INPACKETTYPE = 'D' THEN          (* Receive data *)F              IF SeqChar = LastSeq THEN BEGIN         (* Drop packet *)%                 OUTSEQ := OUTSEQ - 1;eF                 RETRIES := 10;               (* Reset RETRIES count *)                 SendACK (TRUE)F              END ELSE BEGIN                     (* Correct sequence *)F              RETRIES := 10;                  (* Reset RETRIES count *)              I := 1;              REP := 1;&              WHILE I <= INDATACOUNT DO                  WITH REPLYMSG DOE                   IF TEXTMODE THEN BEGIN       (* SCAN EBCDIC data *) 4                     IF CHARS (.I.) = REPEATCHAR THENF                     BEGIN                       (* Repeat character *)F                       REP := ORD (EBCDICTOASCII (.BYTES (.I+1.).))-32;                        I := I + 2                     END;4                     IF CHARS (.I.) = BIT8_QUOTE THENF                     BEGIN                        (* 8 bit character *)                        I := I+1 ;!                       BIT8 := 128 '                     END ELSE BIT8 := 0;T5                     IF CHARS (.I.) = CNTRL_QUOTE THEN-F                     BEGIN                      (* CONTROL character *)                       I := I+1;IC                       CHARS (.I.) := EBCDICTOASCII (.BYTES (.I.).);TF                       IF CHARS (.I.) = '3F'XC THEN (* Make it a del *)-                          BYTES (.I.) := '7F'X-                       ELSEH                         IF BYTES(.I.) >= 64 THEN (* Make it a control *)8                            IF CHARS (.I.) <> '7E'XC THEN>                               BYTES (.I.) := BYTES (.I.) - 64;.                       IF BYTES (.I.) <> 0 THEN'                          CHARS (.I.) :=ID                                ASCIITOEBCDIC (.BYTES (.I.) + BIT8.);                     END ELSE-                       IF BIT8 <> 0 THEN BEGINSF                          CHARS (.I.) := EBCDICTOASCII (.BYTES (.I.).);'                          CHARS (.I.) := C                                ASCIITOEBCDIC (.BYTES (.I.) + BIT8.))                       END;F                     IF CRFLAG THEN BEGIN  (* previous char was a CR *)'                        CRFLAG := FALSE; C                        IF CHARS (.I.) = '25'XC THEN WRITELN (RFILE) !                        ELSE BEGINO/                          WRITE (RFILE, '0D'XC); -                          FOR K := 1 TO REP DOD9                              WRITE  (RFILE, CHARS (.I.));F!                          REP := 1a                        END                     END ELSEC                        IF  CHARS (.I.) = '0D'XC THEN CRFLAG := TRUE-C                        ELSE BEGIN                    (* not a CR *).*                           CRFLAG := FALSE;.                           FOR K := 1 TO REP DO8                             WRITE  (RFILE, CHARS (.I.));"                           REP := 1                        END;9                     I := I + 1                   END ?                   ELSE BEGIN             (* Text mode is OFF *)D:                     (* Revert back to ASCII data record *)4                     IF CHARS (.I.) = REPEATCHAR THENF                     BEGIN                       (* Repeat character *)F                       REP := ORD (EBCDICTOASCII (.BYTES (.I+1.).))-32;                        I := I + 2                     END;4                     IF CHARS (.I.) = BIT8_QUOTE THENF                     BEGIN                       (* 8TH BIT QUOTING  *)                       I := I+1; !                       BIT8 := 128 '                     END ELSE BIT8 := 0; 5                     IF CHARS (.I.) = CNTRL_QUOTE THENnF                     BEGIN                      (* CONTROL character *)                        I := I+1 ;C                       CHARS (.I.) := EBCDICTOASCII (.BYTES (.I.).);IF                       IF CHARS (.I.) = '3F'XC THEN (* Make it a del *)-                          BYTES (.I.) := '7F'XE                         ELSEH                         IF BYTES(.I.) >= 64 THEN (* Make it a control *)8                            IF CHARS (.I.) <> '7E'XC THEN>                               BYTES (.I.) := BYTES (.I.) - 64;1                     END   (* CONTROL character *)KF                     ELSE CHARS (.I.) := EBCDICTOASCII (.BYTES (.I.).);6                     BYTES (.I.) := BYTES (.I.) + BIT8;(                     FOR K := 1 TO REP DO4                         WRITE  (RFILE, CHARS (.I.));                     REP := 1;-                     I := I + 1                   END ;             SendACK (TRUE)S          ENDC          ELSE IF INPACKETTYPE = 'F' THEN BEGIN       (* Send ACK *)              OUTSEQ := OUTSEQ - 1;            SendACK (TRUE)F          END(          ELSE IF INPACKETTYPE = 'Z' THENE          BEGIN                              (* End of Receive File *)U            CLOSE (RFILE); ,            TSOService ('FREE F(RFILE)', RC);            STATE := RF;E            SendACK (TRUE)           ENDD          ELSE BEGIN                             (* Not D,Z packet *)7            STATE := A;   (* ABORT - Type not D or Z, *)             ABORT := NOT_DZ
          END;    F      C:  BEGIN                               (* COMPLETED Receiving *)            CLOSE (RFILE);I,            TSOService ('FREE F(RFILE)', RC);            SendACK (TRUE);            RECEIVING := FALSE;            GetFile   := FALSE 
          END;A  =E      A:  BEGIN                                  (* Abort Receiving *)P            CLOSE (RFILE); "            IF Incomplete_File THEN.               TSOService ('FREE F(RFILE)', RC)8            ELSE TSOService ('FREE F(RFILE) DELETE', RC);            RECEIVING := FALSE;            GetFile   := FALSE;-            SendError ('Receive file aborted')           END    END (* CASE of STATE *) END;  (* RecvFile *)    %TITLE Procedure ShowIT D (******************************************************************)D (* ShowIT -    This routine handles the SHOW COMMAND.             *)D (******************************************************************)  F PROCEDURE ShowIT;t BEGINN1   WRITELN ('------- Current Status -----------');    WRITELN (' ');   IF ScreenSize = 0 THENA      WRITELN (' KERMIT currently running in line mode (ASCII). ')TB   ELSE WRITELN (' KERMIT currently running in full-screen mode.');+   WRITE   (' Init file KERMIT.SETUP ... '); .   IF Init_File THEN WRITELN ('already loaded')$      ELSE WRITELN ('not specified');7   WRITELN (' Your PROFILE data set is KERMIT.PROFILE');S   WRITELN (' ');   IF TEXTMODE THEN BEGIN4      WRITELN (' TEXT MODE   is ON  - ASCII/EBCDIC');<      IF FB THEN  WRITELN (' RECFM_INPUT is FB, LRECL is 80')=            ELSE  WRITELN (' RECFM_INPUT is VB, LRECL is 255')    END ELSE BEGIN&      WRITELN (' TEXT MODE   is OFF' );3      WRITELN (' RECFM_INPUT is U, BLKSIZE is 1024')    END;   WRITELN ('                '); (   WRITE   (' PACKET SIZE is ', PSIZE:3);6   IF Long_Packet THEN  WRITELN (' (extended packets)')7                  ELSE  WRITELN (' (standard packets)'); :   WRITELN (' EOL CHAR    is ', ECHAR:2,' decimal(ascii)');:   WRITELN (' SOH CHAR    is ', SCHAR:2,' decimal(ascii)');,   WRITELN (' CNTRL_QUOTE is ', CNTRL_QUOTE);=   WRITELN (' BIT8_QUOTE  is ', BIT8_QUOTE, ORD (BIT8_QUOTE));)*   WRITELN (' CHECKTYPE   is ', CHECKTYPE);<   WRITELN (' REPEATCHAR  is ', REPEATCHAR, ORD(REPEATCHAR));6   WRITELN (' DELAY       is ', Delay:3:1, ' seconds');   WRITE   (' DEBUG mode  is '); 4   IF Debug THEN WRITELN ('ON') ELSE WRITELN ('OFF');   WRITE   (' INCOMPLETE  is '); C   IF Incomplete_File THEN WRITELN ('KEEP') ELSE WRITELN ('DELETE');    WRITELN (' ');D   IF STATE = C THEN WRITELN('Last File transferred completed OK. ');5   IF STATE = A THEN BEGIN (* ABORTED file transfer *)N2      WRITE  ('Last File transfer Aborted while ');      CASE ABORT OF?        BADSF   : WRITELN ('attempting to send file to micro.'); 6        NOT_S   : WRITELN ('waiting for Init Packet.');=        NOT_SFBZ: WRITELN ('waiting for File header packet.'); 9        NOT_DZ  : WRITELN ('waiting for a DATA  packet.');(8        OTHERWISE WRITELN ('being completely confused ');      END;   (* CASE ABORT *)      WRITELN(' ') !   END (* ABORTED file transfer *)N END;  (* ShowIT procedure *)    %TITLE Procedure SetITD (******************************************************************)D (* SetIT  -    This routine handles the SET COMMAND.              *)D (******************************************************************)    PROCEDURE SetIT; VAR Answer : ALFA;     Temp   : STRING (1);     N1, N2 : INTEGER;;    BEGIN $   COMMAND := GETTOKEN (INPUTSTRING);   UPCASE (COMMAND); )   REQUEST := ' ' || TRIM (STR (COMMAND));N.   CINDEX := INDEX (WHATTABLE, REQUEST) DIV 8 ;6   IF LENGTH (INPUTSTRING) = 0 THEN INPUTSTRING := '?';  E   CASE WHATFLAGS (CINDEX) OFF     $TEXTMODE :                                   (* TEXT MODE FLAG *)*             IF INPUTSTRING(.1.) = '?' THENG                WRITELN ('Enter ON for Textfiles, OFF for binary files')B             ELSE BEGIN.             SETTING := GETTOKEN (INPUTSTRING);             UPCASE (SETTING); 6                TEXTMODE := NOT (SETTING = 'OFF     ');<                IF TEXTMODE THEN WRITELN ('TEXT MODE is ON ')4                   ELSE WRITELN ('TEXT MODE is OFF');             END;B     $RECFM :                                          (* RECFM  *)0             IF INPUTSTRING(.1.) = '?' THEN BEGIN>                WRITELN ('Enter FB for fixed record length, ');>                WRITELN ('   or VB for variable record length')             END ELSE BEGIN1                SETTING := GETTOKEN (INPUTSTRING);=                 UPCASE (SETTING);8                  IF SETTING = 'FB      ' THEN FB := TRUE%                     ELSE FB := FALSE;.F                  IF FB THEN WRITELN ('INPUT RECFM is FB, LRECL is 80')E                     ELSE WRITELN ('INPUT RECFM is VB, LRECL is 255 ')              END;C     $PACKETSIZE:                              (* SET PACKET SIZE *) *             IF INPUTSTRING(.1.) = '?' THENG               WRITELN ('Enter number (range 26 .. 1000) as packetsize')              ELSE BEGIN.                IF INPUTSTRING (.1.) = '-' THEN9                   INPUTSTRING := SUBSTR (INPUTSTRING, 2); ,                READSTR (INPUTSTRING, PSIZE);+                IF (PSIZE > 1000) THEN BEGINAE                   WRITELN ('ERROR: Number too large. Will use 1000');L                   PSIZE := 1000                 END; )                IF (PSIZE < 26) THEN BEGIN C                   WRITELN ('ERROR: Number too small. Will use 94');                    PSIZE := 94)                END; 5                IF PSIZE > 94 THEN Long_Packet := TRUE 7                              ELSE Long_Packet := FALSE;)7             (* IF PSIZE > 256 THEN CHECKTYPE := '3'; *)S2                WRITELN ('PACKET SIZE is ',PSIZE:4)             END;F    $EOLCHAR :                               (* SET end of line char *)*             IF INPUTSTRING(.1.) = '?' THENE                WRITELN ('Enter number (ascii) used as eol character')9             ELSE BEGIN.                IF INPUTSTRING (.1.) = '-' THEN9                   INPUTSTRING := SUBSTR (INPUTSTRING, 2); ,                READSTR (INPUTSTRING, ECHAR);@                IF (ECHAR < 5) OR (ECHAR > 18) THEN ECHAR := 13 ;D                WRITELN ('EOLCHAR     is ', ECHAR, ' decimal(ascii)')             END;D    $CNTRL_QUOTE:                             (* SET control quote *)*             IF INPUTSTRING(.1.) = '?' THEND                WRITELN ('Enter character to be used as cntrl quote')             ELSE BEGIN+                READSTR (INPUTSTRING, Temp); 2                IF INDEX (SPECTABLE, Temp) > 0 THEND                   CNTRL_QUOTE := Temp (.1.) ELSE CNTRL_QUOTE := '#';7                WRITELN ('CNTRL QUOTE is ', CNTRL_QUOTE)              END;D    $BIT8_QUOTE:                                (* SET bit 8 quote *)*             IF INPUTSTRING(.1.) = '?' THENC                WRITELN ('Enter character to be used as bit8 quote')a             ELSE BEGIN+                READSTR (INPUTSTRING, Temp); 2                IF INDEX (SPECTABLE, Temp) > 0 THENB                   BIT8_QUOTE := Temp (.1.) ELSE BIT8_QUOTE := '&';6                WRITELN ('BIT8_QUOTE  is ', BIT8_QUOTE)             END;F    $CHECKTYPE :                                  (* SET CHECK TYPE  *)*             IF INPUTSTRING(.1.) = '?' THENG                WRITELN ('Enter number (1,2 or 3) to select check type')S             ELSE BEGIN0                READSTR (INPUTSTRING, CHECKTYPE);9                IF INDEX ('123', STR (CHECKTYPE)) = 0 THENE#                   CHECKTYPE := '1';+6                WRITELN ('CHECKTYPE   is ', CHECKTYPE )             END;F    $DELAY :                                     (* SET DELAY FACTOR *)*             IF INPUTSTRING(.1.) = '?' THEND                WRITELN ('Enter send wait-time in seconds (2 .. 30)')             ELSE BEGIN,                READSTR (INPUTSTRING, Delay);>                IF (Delay < 2) OR (Delay > 30) THEN Delay := 6;C                WRITELN ('Delay now set to ', Delay:3:1, ' seconds')              END;F    $DEBUG :                                     (* SET DEBUG option *)0             IF INPUTSTRING(.1.) = '?' THEN BEGIN<                WRITELN ('Enter ON to log transactions, or');6                WRITELN ('      OFF to finish logging')             END ELSE BEGIN-                READSTR (INPUTSTRING, Answer);                 UPCASE (Answer); %                IF Answer = 'ON'  THENi:                 IF Debug THEN (* DEBUG was already ON ! *)                 ELSE BEGIN                  Debug := TRUE;O2                  TSOService ('FREE F(DFILE)', RC);9                  TSOService ('DELETE ' || DEBUGNAME, RC);SC                  TSOCommand := 'ALLOC F(DFILE) DA(' || DEBUGNAME ||AA                                ') NEW SP(1,1) CYL ' || DCB_DEBUG;e-                  TSOService (TSOCommand, RC);o/                  IF RC < 8 THEN REWRITE (DFILE)e                  ELSE BEGIN*#                     Debug := FALSE;*C                     WRITELN ('Debug file could not be allocated, ', 3                              'return code is ', RC)*                  END                 END;%                IF Answer = 'OFF' THEN #                 IF Debug THEN BEGINT!                   Debug := FALSE;N                    CLOSE (DFILE);2                   TSOService ('FREE F(DFILE)', RC)7                 END ELSE (* DEBUG was already OFF ! *);T0                WRITE ('Debug mode now set to ');@                IF Debug THEN WRITELN ('ON') ELSE WRITELN ('OFF')              END; F    $REPCHAR :                                    (* SET repeat char *)*             IF INPUTSTRING(.1.) = '?' THENE                WRITELN ('Enter character to be used as repeat quote')s             ELSE BEGIN+                READSTR (INPUTSTRING, Temp);E2                IF INDEX (SPECTABLE, Temp) > 0 THENB                   REPEATCHAR := Temp (.1.) ELSE REPEATCHAR := '~';6                WRITELN ('REPEAT CHAR is ', REPEATCHAR)             END;F    $SOHCHAR :                                    (* SET repeat char *)*             IF INPUTSTRING(.1.) = '?' THENF          WRITELN ('Enter decimal value (1..18) used as soh character')             ELSE BEGIN.                IF INPUTSTRING (.1.) = '-' THEN9                   INPUTSTRING := SUBSTR (INPUTSTRING, 2); ,                READSTR (INPUTSTRING, SCHAR);?                IF (SCHAR < 1) OR (SCHAR > 18) THEN SCHAR := 1 ; "                SOH := CHR (SCHAR);D                WRITELN ('SOHCHAR     is ', SCHAR, ' decimal(ascii)')             END;F    $ATOE:                              (* SET ASCII -> EBCDIC table *)0             IF INPUTSTRING(.1.) = '?' THEN BEGINH                WRITELN ('Enter two numbers, the first is the entry in');G                WRITELN ('the ASCII table, the second the correspond.');IF                WRITELN ('EBCDIC char. The valid range is (1 .. 255) ')             ENDC             ELSE BEGIN-                READSTR (INPUTSTRING, N1, N2);r5                IF (N1 < 1) OR (N1 > 255) THEN RETURN;k5                IF (N2 < 0) OR (N2 > 255) THEN RETURN;d0                ASCIITOEBCDIC (.N1.) := CHR (N2);B                WRITELN ('ASCII (', N1:3,') has now the value of ',-                         'EBCDIC (', N2:3,')')              END;F    $ETOA:                              (* SET EBCDIC -> ASCII table *)0             IF INPUTSTRING(.1.) = '?' THEN BEGINH                WRITELN ('Enter two numbers, the first is the entry in');G                WRITELN ('the EBCDIC table, the second the correspon.');*E                WRITELN ('ASCII char. The valid range is (1 .. 255) ')F             ENDS             ELSE BEGIN-                READSTR (INPUTSTRING, N1, N2);I5                IF (N1 < 1) OR (N1 > 255) THEN RETURN; 5                IF (N2 < 0) OR (N2 > 255) THEN RETURN;E0                EBCDICTOASCII (.N1.) := CHR (N2);C                WRITELN ('EBCDIC (', N1:3,') has now the value of ', ,                         'ASCII (', N2:3,')')             END;F    $INCOMPLETE:                            (* SET incomplete option *)0             IF INPUTSTRING(.1.) = '?' THEN BEGING                WRITELN ('Enter options KEEP or DELETE to control the'); =                WRITELN ('disposition of an incomplete file.')O             END              ELSE BEGIN1                SETTING := GETTOKEN (INPUTSTRING);L                 UPCASE (SETTING);G                IF (SETTING = 'DELETE  ') OR (SETTING = 'DEL     ') THEN*+                   Incomplete_File := FALSE; +                IF SETTING = 'KEEP    ' THENr)                   Incomplete_File := TRUE              END;,    $DUMMY: WRITELN ('NOT YET implemented ');  NF    OTHERWISE BEGIN                         (*  Invalid SET  OPTION  *)?      WRITELN ('SET ', REQUEST, ' - invalid option specified.'); *      WRITELN ('Valid   OPTIONS are :   ');*      WRITELN ('----------------------- ');      WRITELN (' '); <      WRITELN (' BIT8_QUOTE   c     - Bit8 quote character');8      WRITELN (' CHECK        n     - Block check type');7      WRITELN (' CNTRL_QUOTE  c     - Quote character');*4      WRITELN (' DELAY        nnn   - Delay factor');3      WRITELN (' DEBUG       ON/OFF - Debug mode ');p>      WRITELN (' EOLCHAR      nn    - Endline char (decimal)');G      WRITELN (' INCOMPLETE KEEP/DEL- Disposition of incomplete files');G=      WRITELN (' PACKETSIZE   nn    - Packet size (decimal)'); 9      WRITELN (' RECFM       VB/FB  - Variable or Fixed');L3      WRITELN (' REPEATCHAR   c     - Repeat char'); A      WRITELN (' SOHCHAR      nn    - Start of packet (decimal)'); ?      WRITELN (' TEXTMODE    ON/OFF - for text / binary files');e    END   ENDl END; (* SetIT  procedure *)   S %TITLE Procedure Help D (******************************************************************)D (* Help   -    This routine handles the HELP COMMAND.             *)D (******************************************************************) PROCEDURE Help;Z BEGIN A  WRITELN (' The following are the valid KERMIT-TSO commands : ');e  WRITELN (' ');)<  WRITELN (' SEND filename      - send a file to the micro');A  WRITELN ('      as! filename! (you may select the new name)'); A  WRITELN (' RECEIVE filename! - receive a file from the micro'); 7  WRITELN (' SERVER             - go into server mode'); 7  WRITELN (' SET option value   - set OPTION to VALUE'); E  WRITELN (' STATUS             - displays current options settings');(@  WRITELN (' TAKE filename      - execute commands from a file');F  WRITELN (' DO   membername    - execute commands from your profile');=  WRITELN (' HELP               - displays this information');(C  WRITELN (' EXIT, END or QUIT  - exit KERMIT , terminate program'); D  WRITELN (' LOGOUT             - exit KERMIT and logoff from host');  WRITELN (' '); (  WRITELN ('Additional TSO facilities:');>  WRITELN (' DELETE filename    - deletes cataloged data set');8  WRITELN (' DIR userid!       - shows user directory');7  WRITELN (' DISK               - displays disk usage'); ?  WRITELN (' MEMBERS filename   - shows member list of a file');I8  WRITELN (' TSO command        - issues a TSO command');C  WRITELN (' TYPE filename      - displays data set at the screen'); E  WRITELN (' WHO                - shows users logged in on the host');O END ; (* HELP procedure *)  E %TITLE Procedure Micro_Finish;E (*******************************************************************) E (* Micro_Finish - This routine turns down a micro's KERMIT running *)TE (*                in server mode (used only with setup-files).     *))E (*******************************************************************)R PROCEDURE Micro_Finish;; VAR Ok : BOOLEAN;  BEGIN'   OUTSEQ := 0;   OUTPACKETTYPE := 'I'; 
   ParmPacket;T
   SendPacket; 4   IF RecvPacket AND (INPACKETTYPE='Y') THEN (* Ok *)      ELSE ReSendit(10);A   OUTDATACOUNT  := 1;    OUTSEQ        := 0;D   OUTPACKETTYPE := 'G';    SENDMSG.CHARS := 'F';?
   SendPacket; 5   IF RecvPacket AND (INPACKETTYPE='Y') THEN  (* Ok *)3      ELSE ReSendit(10) END;  (* Micro_Finish *)  ( %TITLE Procedure RemoteCommandE (*******************************************************************)IE (* RemoteCommand -This routine handles the COMMANDS from a remote  *) E (*                kermit.                                          *) E (*******************************************************************)( PROCEDURE RemoteCommand;  , CONST     COMMANDTABLE     = 'CEGIRSYK';*   SUBCOMMANDTABLE  = 'ICLFDUETRKSPWMHQJV';  N TYPE>   SUBCOMMANDTYPE = (ZERO,I,C,L,F,D,U,E,T,R,K,S,P,W,M,H,Q,J,V);  A VAR)   COMMANDTYPE,
   SUBCOMMAND,'   B8Quote     : CHAR ;   Ix          : INTEGER ;w   Ok          : BOOLEAN;   TSOUser     : STRING (10);   TSOFname    : STRING (80);   XLine       : LString; LABEL CHECKCOMMAND ;   ? (*-----------------------------------------------------------*) ? (* Remote_Help - send help information to remote micro       *) ? (*-----------------------------------------------------------*)  PROCEDURE Remote_Help; BEGINm SendDPacket D    ('This is the KERMIT server running under MVS/XA TSO'||CRLF, Ok); IF NOT Ok THEN RETURN; SendDPacket (CRLF, Ok);  IF NOT Ok THEN RETURN; SendDPacketcF   ('The following server commands are actually supported:'||CRLF, Ok); IF NOT Ok THEN RETURN; SendDPacket (CRLF, Ok);N IF NOT Ok THEN RETURN; SendDPacketT@   ('  DELETE filename - erases a specific host file'||CRLF, Ok); IF NOT Ok THEN RETURN; SendDPacket A   ('  DIR             - displays your disk directory'||CRLF, Ok);  IF NOT Ok THEN RETURN; SendDPacketdD   ('  DISK            - displays the current disk usage'||CRLF, Ok); IF NOT Ok THEN RETURN; SendDPacket E   ('  FINISH          - finishes server mode on the host'||CRLF, Ok);  IF NOT Ok THEN RETURN; SendDPacket ?   ('  GET filename    - requests one or more files'||CRLF, Ok);I IF NOT Ok THEN RETURN; SendDPacketrC   ('  HELP            - displays this information page'||CRLF, Ok);S IF NOT Ok THEN RETURN; SendDPacketEA   ('  LOGOUT          - stops host KERMIT and logout'||CRLF, Ok);( IF NOT Ok THEN RETURN; SendDPacket G   ('  SEND filename   - sends one or more files to the host'||CRLF,Ok);C IF NOT Ok THEN RETURN; SendDPacket B   ('  TYPE filename   - displays a specific host file'||CRLF, Ok); IF NOT Ok THEN RETURNt END; (* Remote_Help *)  e %PAGEh$ BEGIN  (* RemoteCommand procedure *)   INPUTSTRING  := Line;R#   COMMANDTYPE  := INPUTSTRING(.4.);    INPACKETTYPE := COMMANDTYPE;   GetFile := FALSE;    CHECKCOMMAND :;   IF INDEX (COMMANDTABLE, STR (COMMANDTYPE)) = 0 THEN BEGIN8>      SendError ('Unknown commandtype, ' || STR (COMMANDTYPE));      RETURNE   END;?   IF COMMANDTYPE = 'C' THEN BEGIN            (* HOST command *)T+     INPUTSTRING := SUBSTR (INPUTSTRING, 5); .     SendYPacket ('Host Command not available')   END;A   IF COMMANDTYPE = 'K' THEN BEGIN            (* KERMIT command *) +     INPUTSTRING := SUBSTR (INPUTSTRING, 5);t/     SendYPacket ('KERMIT command not executed')    END;<   IF COMMANDTYPE = 'E' THEN (* Got an error message back *);=   IF COMMANDTYPE = 'I' THEN BEGIN            (* INITIALIZE *)RG     INDATACOUNT := ORD (EBCDICTOASCII (.ORD (INPUTSTRING(.2.)).))-32-3;E     IF INDATACOUNT >= 1 THENE        PSIZE := ORD (EBCDICTOASCII (.ORD (INPUTSTRING (.4+1.)).))-32;=     IF INDATACOUNT>= 5 THENIE        ECHAR := ORD (EBCDICTOASCII (.ORD (INPUTSTRING (.4+5.)).))-32; @     IF INDATACOUNT>= 6 THEN CNTRL_QUOTE := INPUTSTRING (.4+6.) ;!     IF INDATACOUNT>= 7 THEN BEGINS&        B8Quote := INPUTSTRING (.4+7.);/        IF B8Quote = 'Y' THEN BIT8_QUOTE := '&';E,        IF NOT (B8Quote IN (.'Y', 'N'.)) THEN           BIT8_QUOTE := B8QuoteC     END;=     IF INDATACOUNT>= 8 THEN CHECKTYPE  := INPUTSTRING (.4+8.)c        ELSE CHECKTYPE  := '1';=     IF INDATACOUNT>= 9 THEN REPEATCHAR := INPUTSTRING (.4+9.)         ELSE REPEATCHAR := '~';     IF INDATACOUNT >= 10 THEN E        CAPAS := ORD (EBCDICTOASCII (.ORD (INPUTSTRING (.4+10.)).))-32         ELSE CAPAS := 0;E#     IF INDATACOUNT >= 13 THEN BEGIN C        PSIZE := ORD (EBCDICTOASCII(.ORD(INPUTSTRING(.4+12.)).))-32;         PSIZE := PSIZE * 95 +D                   ORD (EBCDICTOASCII(.ORD(INPUTSTRING(.4+13.)).))-32     END;     OUTPACKETTYPE := 'Y';      CheckParms;I     ParmPacket ;     SendPacket ;     IF RecvPacket THEN	     BEGINr#       COMMANDTYPE := INPACKETTYPE ; 2       INPUTSTRING := 'XXX'||  STR(INPACKETTYPE) ||C                      SUBSTR (STR (REPLYMSG.CHARS), 1, INDATACOUNT);        GOTO CHECKCOMMAND      END    END;=   IF COMMANDTYPE = 'R' THEN BEGIN         (* Send to micro *)T+     INPUTSTRING := SUBSTR (INPUTSTRING, 5);n$     TSOFname := LTRIM (INPUTSTRING);D     IF Debug THEN WRITELN (DFILE, 'REM: Sending file(s)', TSOFname);     SendFile (TSOFname, FALSE)   END;E   IF COMMANDTYPE = 'S' THEN BEGIN            (* Receive from micro *) G     IF Debug THEN WRITELN (DFILE, 'REM: Receiving file(s) from micro');v     RecvFile   END;>   IF COMMANDTYPE = 'Y' THEN (* Got an ACK for break packet *);?   IF COMMANDTYPE = 'G' THEN BEGIN                 (* GENERAL *)($     SUBCOMMAND := INPUTSTRING (.5.);     OUTSEQ := 0;F     CASE SUBCOMMANDTYPE (INDEX (SUBCOMMANDTABLE, STR (SUBCOMMAND))) OF  TC          C:                                    (* CHANGE command *)DB             SendError ('No CHANGE directory available under MVS');   E          D: BEGIN                             (* DIRECTORY command *)E0               TSOService ('TSODS LISTCAT' , RC);               IF RC <> 0 THENA?                  SendYPacket ('No file(s) found for '|| UserID)F,               ELSE BEGIN (* GOT directory *)                 OUTSEQ := 64;R9                 SendXPacket ('DIRECTORY for ' || UserID);o                 RESET  (TSODS);E.                 WHILE NOT EOF (TSODS) DO BEGIN(                   READLN (TSODS, XLine);)                   XLine := XLine || CRLF;**                   SendDPacket (XLine, Ok);&                   IF NOT Ok THEN LEAVE                 END;                 CLOSE (TSODS);5                 IF INPACKETTYPE='Y' THEN SendZPacket;*4                 IF INPACKETTYPE='Y' THEN SendBPacket               ENDa             END;  dF          E: BEGIN                             (* Erase File command *).               IF LENGTH (INPUTSTRING) > 7 THEN                  TSOFname :=C                    SUBSTR (INPUTSTRING, 7, LENGTH (INPUTSTRING)-6);oA               IF Debug THEN WRITELN (DFILE, 'Delete data set ' ||I/                                      TSOFname);)5               TSOService ('DELETE ' || TSOFname, RC);p:               IF RC = 0 THEN TSOCommand := 'File deleted ';                         ELSE TSOCommand := 'Not deleted  ';e&               SendYPacket (TSOCommand)             END;   C          F: BEGIN                              (* FINISH command *)-                RUNNING := FALSE ;               SendACK (TRUE)             END;  dE          H: BEGIN                                 (* HELP  command *)i               OUTSEQ := 64;f               SendXPacket ('');t               Remote_Help;3               IF INPACKETTYPE='Y' THEN SendZPacket;I2               IF INPACKETTYPE='Y' THEN SendBPacket             END;   F          I:                                       (* LOGIN  command *).             SendYPacket ('Already logged on');   A          J:                                         (* Journal *) C             SendYPacket ('No Journal available, use DEBUG option');)  ED          K:                                        (* Copy file   *)<             SendYPacket ('No Copy function available, yet');  eF          L: BEGIN                                 (* LOGOUT command *)                RUNNING := FALSE ;                EndKermit := TRUE;               SendACK (TRUE)             END;  DF          M:                                     (* MESSAGE  command *)?             SendYPacket ('No Message function available, yet');    F          P:                                       (* Print  command *)=             SendYPacket ('No Print function available, yet');   DF          Q:                                 (* QUERY status command *)5             SendYPacket ('No Query state available');c  FD          R:                                        (* Rename file *)>             SendYPacket ('No Rename function available, yet');  hF          S:                                       (* Submit command *);             SendYPacket ('Submit command not implemented');*  *F          T: BEGIN                              (* TYPE File command *).               IF LENGTH (INPUTSTRING) > 7 THEN4                  TSOFname := SUBSTR (INPUTSTRING, 7,D                    ORD (EBCDICTOASCII (.ORD(INPUTSTRING(.6.)).))-32)               ELSE BEGIN1                  SendError ('No file specified');                   RETURN                END;.               IF INDEX (TSOFname,'*') > 0 THEN;                 SendError ('No * allowed for typing files')                ELSE BEGIN                 OUTSEQ := 64;-;                 SendXPacket ('Typing file : ' || TSOFname);c,                 SendFile    (TSOFname, TRUE)               END-             END;  RF          U: BEGIN                             (* Disk Usage command *)3               TSOService ('TSODS SPACE TOTAL', RC);T?               IF RC <> 0 THEN SendError ('Error on Disk Space')e               ELSE BEGIN                 OUTSEQ := 64;t9                 SendXPacket ('Disk usage of ' || UserID);,                 RESET (TSODS);)                 FOR Ix := 1 TO 2 DO BEGINs(                   READLN (TSODS, XLine);-                   IF LENGTH (XLine) > 35 THEN 4                      XLine := SUBSTR (XLine, 1, 35);2                   SendDPacket (XLine || CRLF, Ok);&                   IF NOT Ok THEN LEAVE                 END;                 CLOSE (TSODS);5                 IF INPACKETTYPE='Y' THEN SendZPacket;|4                 IF INPACKETTYPE='Y' THEN SendBPacket               END              END;  eE          W:                                         (* WHO command *) 8             SendYPacket ('Try WHO in interactive mode');  NC          OTHERWISE SendError ('Unknown subcommand')     (* ERROR *)K	       ENDo    END# END ; (* REMOTECOMMAND procedure *)e  P %TITLE KERMIT - Main ProgramD (******************************************************************)D (********         OUTER BLOCK OF KERMIT                    ********)D (******************************************************************)  G BEGINI'   TERMIN   (INPUT);   TERMOUT (OUTPUT);S   TermSize (ScreenSize);(   Remote   := FALSE; EndKermit := FALSE;(   TEXTMODE := TRUE;  Init_File := FALSE;(   RUNNING  := TRUE;  CmdMode   := FALSE;   Handle_Attribute := FALSE;   Long_Packet      := FALSE;7   IF INDEX (PARMS, '@INIT') = 0 THEN UserID    := PARMS    ELSE BEGIN      CmdMode   := TRUE;       Init_File := TRUE;d      Remote    := TRUE;S>      UserID    := SUBSTR (PARMS, 1, (INDEX(PARMS,'@INIT')-1));F      TSOCommand := 'ALLOC F(CMDFILE) DA(' || CMDNAME || ') SHR REUSE';!      TSOService (TSOCommand, RC);B      RESET (CmdFile);    END;"   TSOService ('DELETE TSODS', RC);F   TSOCommand := 'ALLOC F(TSODS) DA(TSODS) NEW TR SP(1,1) ' || DCB_Var;   TSOService (TSOCommand, RC);5   WRITELN('Welcome to KERMIT under MVS/XA-TSO V2.3');O   WRITELN(' ');    IF ScreenSize > 0 THEN BEGINH      WRITELN (' You are running Kermit-TSO from a full-screen device.');C      WRITELN (' There is no filetransfer supported in this mode.');E      WRITELN (' ')   END;+   WHILE RUNNING DO BEGIN (* Command Loop *)D     MAINLOOP: (* NORMAL IO *)=     IF CmdMode THEN BEGIN >        IF NOT EOF (CmdFile) THEN READLN (CmdFile, INPUTSTRING)        ELSE BEGIN8           INPUTSTRING := ' ';'           CmdMode     := FALSE;.           Remote      := TRUE;           CLOSE (CmdFile);
        END2     END ELSE Prompt ('KERMIT-TSO>', INPUTSTRING) ;:     IF (BIT8_QUOTE = '00'XC) AND (NOT TEXTMODE) THEN BEGIN@       WRITELN ('**** WARNING - TEXT MODE is turned off, other');C       WRITELN ('               KERMIT can not handle the 8th bit.')I     END ; (* Warning *)0     GetFile := FALSE; &     INPUTSTRING := LTRIM(INPUTSTRING);-     IF INPUTSTRING = ' '  THEN GOTO MAINLOOP;.=     IF SUBSTR(INPUTSTRING,1,1) = STR (SOH) THEN RemoteCommand %        ELSE BEGIN (* Local Command *)R,          INPUTSTRING := LTRIM (INPUTSTRING);+          COMMAND := GETTOKEN (INPUTSTRING);a          UPCASE (COMMAND);0          REQUEST := ' ' || TRIM (STR (COMMAND));3          CINDEX := INDEX(COMMTABLE,REQUEST) DIV 8 ;|!          CASE COMMANDS(CINDEX) OF A            $BAD    : WRITELN (COMMAND, 'is an invalid command.');O3            $SEND   : SendFile (INPUTSTRING, FALSE);'            $RECEIVE: BEGIN9                        INPUTSTRING := LTRIM(INPUTSTRING);n6                        IF INPUTSTRING = ' ' THEN BEGIN)                           Remote := TRUE;S?                           WRITELN ('ready to RECEIVE file  - ',E9                             'SEND file(s) from Micro. '); )                           Waiting (Delay)n                        END;                          RecvFile;&                        Remote := FALSE                      END;'            $SERVER : BEGIN9                        WRITELN('Entering SERVER mode - ', E                                'Issue FINISH or LOGOUT command from',C8                                ' micro to stop SERVER');$                        IF Debug THENF                           WRITELN (DFILE, 'Entering SERVER mode ...');)                        Remote    := TRUE;R                        REPEAT =                         STATE := S_I; (* Server_Init state *)T0                         IF RecvPacket THEN BEGIN@                           Line := '   ' || STR (INPACKETTYPE) ||E                            SUBSTR(STR(REPLYMSG.CHARS),1,INDATACOUNT);RB                           IF Debug THEN WRITELN (DFILE,'>>',Line);'                           RemoteCommand                          END;)                        UNTIL NOT RUNNING;R$                        IF Debug THEN?                           WRITELN (DFILE, 'SERVER mode ended'); '                        Remote := FALSE; <                        IF NOT EndKermit THEN RUNNING := TRUE                      END;             $SET    : SetIT;             $SHOW,             $STATUS : ShowIT;            $HELP,             $QUES   : HELP ;)            $DEL    : BEGINA                        TSOService ('DELETE ' || INPUTSTRING, RC); =                        IF RC > 0 THEN WRITELN ('Data set ' || @                                  INPUTSTRING || ' not deleted');                      END; )            $DIR    : IF INPUTSTRING = ' 'L8                         THEN TSOService ('LISTCAT ', RC):                         ELSE TSOService ('LISTCAT LEV(' ||C                                           INPUTSTRING  || ')', RC);             $DISK   : BEGIN@                         WRITELN ('Total disk space in tracks:');7                         TSOService ('SPACE TOTAL ', RC)U                      END; 5            $MEM    : IF INPUTSTRING <> ' ' THEN BEGIN :                         INPUTSTRING := TRIM (INPUTSTRING);8                         CheckDsn (INPUTSTRING, DsnDisp);/                         IF DsnDisp = SHARE THEN 9                            WRITELN ('File ', INPUTSTRING,;5                                     ' is sequential') 2                         ELSE IF DsnDisp = NEW THEN9                            WRITELN ('File ', INPUTSTRING, 6                                     ' does not exist')"                         ELSE BEGIN+                            RESET   (TSODS); D                            FOR I := 1 TO 7 DO READLN  (TSODS, Line);B                            IF INDEX (Line, 'NOT USEABLE') > 1 THENG                            WRITELN ('No access to file: ', INPUTSTRING) %                            ELSE BEGIN H                               WRITELN ('Memberlist for: ', INPUTSTRING);%                               I := 1; <                               WHILE NOT EOF (TSODS) DO BEGIN3                                  WRITE  (Line:-12); 6                                  READLN (TSODS, Line);,                                  I := I + 1;4                                  IF I > 5 THEN BEGIN8                                     WRITELN; I := 1 END;5                               END; WRITELN (Line:-12)                             END; *                            CLOSE   (TSODS)                         END                       END8                      ELSE WRITELN ('No file specified');            $TSO    : BEGIN4                        TSOService (INPUTSTRING, RC);&                        IF RC <> 0 THENE                        WRITELN (' TSO command ended with error ', RC)T                      END;             $TYPE   : BEGIN?                        TSOService ('LIST ' || INPUTSTRING, RC); =                        IF RC > 0 THEN WRITELN ('Data set ' ||R>                                  INPUTSTRING || ' not found');                      END; /            $WHO    : TSOService ('USERS ', RC); H            $FINISH : IF NOT CmdMode THEN WRITELN ('Nothing happens ...')'                      ELSE Micro_Finish;             $QUIT,d            $END,&            $EXIT   : RUNNING := FALSE;A            $LOG    : IF (COMMAND = 'LOG') OR (COMMAND = 'LOGOUT')g                      THEN BEGINr+                        RUNNING   := FALSE ; (                        EndKermit := TRUE                      END;L            $DO, -            $TAKE   : IF INPUTSTRING = '' THENc>                           WRITELN ('No commandfile specified'):                      ELSE IF CmdMode THEN (* Do nothing *)"                         ELSE BEGIN8                           IF COMMANDS(CINDEX) = $DO THEN>                              INPUTSTRING := PROFNAME || '(' ||E                                             TRIM(INPUTSTRING) || ')'; A                           TSOCommand := 'ALLOC F(CMDFILE) DA(' ||IE                                         INPUTSTRING || ') SHR REUSE'; 6                           TSOService (TSOCommand, RC);/                           IF RC <= 4 THEN BEGIN -                              CmdMode := TRUE;e-                              Remote  := TRUE; ,                              RESET (CmdFile)D                           END ELSE WRITELN ('Commandfile not found')                        END;P            $VERSION: BEGIND                        WRITELN (' This is the KERMIT filetransfer ',E                         'program for IBM System 370 under MVS/TSO.');*D                        WRITELN (' The actual version number is 2.3',@                         ', featuring long packets ... Fritz B.')                      END;AA            OTHERWISE WRITELN (COMMAND, ' is an INVALID command'); '          END  (* Execute the Command *):       END; (* Local Command *)       INPUTSTRING := '',    END ; (* Command Loop *):    IF Debug THEN CLOSE (DFILE);o#    IF CmdMode THEN CLOSE (CmdFile);E+    TSOService ('FREE F(TSODS) DELETE', RC);:8    IF EndKermit THEN TSOService ('TSOEXEC LOGOFF',  RC);    WRITELN('End of KERMIT  ')  END.