@Part(I370KERMIT,root="KER:KUSER")
@string(-ikvrsn="4.0")
@Chapter<IBM 370 KERMIT>
@Begin<Description,Leftmargin +14,Indent -14,spread 0>
@i(Program:)@\John Chandler (Harvard/Smithsonian Center for
Astrophysics); contributions from
Vace Kundakci and
Daphne Tzoar (Columbia U),
Bob Shields (U. Maryland), Victor Lee (Queens U.), Gary Bjerke (U.
Texas at Austin), Greg Small (UC Berkeley), Clark Frazier (Harvard
Bus. Sch.), Bob Bolch and Steve Blankinship (Triangle), Ron Rusnak
(U. Chicago), Roger Fajman and Dale White (NIH), Andre Pirard (U. Liege)

@i(Language:)@\IBM 370 Assembler

@i(Documentation:)@\John Chandler (CfA)

@i(Version:)@\@value(-ikvrsn)

@i(Date:)@\1987 December
@end<Description>

@Index(IBM)
@index(TTY)@index(Series/1)@Index(SNA)
Kermit-370 is a family of programs
implementing the KERMIT file transfer
protocol for IBM 370-series mainframes (System/370, 303x, 43xx, 308x,
etc.) under a variety of operating systems.
Kermit-370 operates over asynchronous ASCII communication
lines attached to a 3705-style front end (@qq<TTY> devices),
to a Series/1 or 4994 running the
Yale ASCII Terminal Communication System or
the IBM 7171 ASCII Device Control Unit (@qq<SERIES1> devices), or
to any SNA-type front-end that supports graphics pass-through mode
(@qq<GRAPHICS> devices).
For more details on front-ends,
see the section SET CONTROLLER.

The source is coded in IBM 370
assembly language and is divided into sections, some generic and some
specific to an individual operating system.  While the details of
file-system and supervisor interaction vary widely among the systems
available for IBM 370's, the basic features are essentially the same.
This chapter will describe the features common to all variants of
Kermit-370, and a separate chapter will deal with the system-specific
details for each variant.

IBM 370 systems have some peculiarities that users should be aware
of.  First, they are essentially half-duplex
systems; the communication line must "turn
around" before any data can be sent to it.
The @qq<TTY> devices are strictly half-duplex,
and even the @qq<SERIES1> and @qq<GRAPHICS>
devices, although they maintain full-duplex communication with the
terminal, must transmit a block at a time to the mainframe.
The fact that a packet has
been received from the IBM system through a @qq<TTY> device
is no guarantee that it is ready for
a reply; generally, the true indicator of readiness is the
line turnaround character (XON), which the operating system sends
immediately before issuing a read request.  On some systems, however,
it is possible for Kermit to do away with the system-supplied
turnaround and schedule read requests immediately after the
corresponding writes.
It is up to the user to tell the other Kermit that it must conform to
the requirements of the IBM mainframe.

@index(Binary Files)
Second, disk files are encoded using
the EBCDIC character set.  Consequently, there are three layers of
character translation on packets exchanged on a @qq(TTY) device.  For
an incoming packet, the outer layer is provided by the
operating system, which translates all characters
from ASCII to EBCDIC.  Kermit-370 must then translate
the packets back to ASCII (the middle layer)
in order to calculate and verify
the checksum.  Data arriving through
a @qq(SERIES1) or @qq(GRAPHICS) device are still in
ASCII and therefore bypass the two outer layers.
In any case, Kermit-370 translates everything finally into EBCDIC
(the inner layer)
before storing on disk (except BINARY files).
When Kermit-370 sends a file, the opposite translations occur.  In
translation, EBCDIC characters not representable in ASCII
are replaced by nulls.  In some cases, several EBCDIC characters are
mapped into a single ASCII character, but no two 7-bit ASCII characters
are translated into the same EBCDIC character.
The middle-layer tables used by Kermit must be the inverses of the
corresponding outer-layer ones used by the host operating system,
but Kermit offers the option of using different sets of tables for the
inner and middle layers (see the @q<SET TTABLE> subcommand).
The standard ASCII-to-EBCDIC translations can be
found in the Appendix or the IBM System/370 Reference Card.

Another distinction of IBM 370's is that they store and retrieve files
as records rather than byte streams.  Records may be either
fixed-length with some sort of padding (as needed) or varying-length
with some sort of (generally hidden) delimiters.  Thus,
Kermit-370 must assemble incoming
data packets into records by stripping off carriage return-linefeed
pairs (CRLF's) and padding with blanks or truncating as needed
and must strip trailing blanks and append CRLF's
to outgoing records.@Index(Records)@Index(CRLF)@Index(LRECL)@Index(RECFM)
Further, disk files typically have the records combined into blocks
for efficiency.  One consequence of this form of storage is that files
have attributes describing the component records: maximum record
length (LRECL), record format (RECFM), and sometimes block size
(BLKSIZE).@Index(BLKSIZE)

As mentioned before, Kermit-370 is a family of programs.  At present,
only the CMS version is fully operational, but TSO is not far behind.
Versions for DOS/VSE and MTS have at least reached the "drawing board,"
but no others have even been started.  Volunteers are always
welcome to port Kermit-370 to other operating systems or add new
features to the existing family.  Anyone interested should first get
in touch with the Center for Computing Activities at Columbia
University to find out what projects of a similar nature are already
pending (and thereby prevent unnecessary duplication of effort).

@section<Program Operation>

Kermit-370 can be invoked directly or from a command procedure.
In either case, it reads and executes subcommands sequentially until
directed to quit and then returns.
A subcommand consists of one or more fields (words) separated by spaces.

@index(Initialization Files)
Upon initial startup, the program looks for two (optional) initialization
files, one system-wide and a second specific to the user.  Both
@i<filespecs>
are, of course, system-dependent.
The purpose of these files is to allow Kermit to be customized for a
particular system and for a user's specific settings without changing
the source code.
The system-wide file, which is maintained by a systems programmer,
should contain Kermit subcommands
that all users would need to issue in order for
Kermit to run on the system, such as subcommands to modify the
ASCII/EBCDIC tables used by Kermit-370.  The
user-specific file, if any,
should contain subcommands that the user generally
issues every time Kermit is run.  Kermit-370 executes any subcommands
found in these files as though they were typed at the terminal.
Here is a sample @qq(INIT) file:
@begin(example)
* Asterisk in column one is a comment.
set debug on
set warning on
set block 3
@end(example)

During interactive execution,
you may use the built-in help feature while typing
Kermit-370 subcommands.  A question mark ("?") typed at almost any point
in a subcommand, followed by a carriage return, produces a brief
description of what is expected or possible at that point.  Moreover,
mistyping a subcommand will generally produce a helpful error message or
a list of possible options at the point of error.  Keywords in such lists
are displayed with the minimum-length abbreviation in upper case and the
remainder, if any, in lower case.  In entering Kermit subcommands,
any keyword may be shortened to any substring that contains the minimum
abbreviation.

@Section<Kermit-370 Subcommands>

The following is a brief summary of Kermit subcommands.  The starred
subcommands can be issued as
remote Kermit commands to Kermit-370 when it is in
server mode.  System-specific subcommands are omitted from this list.
@Begin(Format,spread 0)
@tabclear()@tabset(1.25inches,1.4inches,1.65inches)
@>BYE@\ @\  logs out other Kermit server.
@>CWD@\*@\  establishes a new working directory.
@>DIRECTORY@\*@\  displays all or part of the disk directory.
@>ECHO@\ @\  a line back to the user.
@>EXIT@\ @\  from Kermit-370.
@>FINISH@\ @\  other Kermit server.
@>GET@\ @\  file(s) from a Kermit server.
@>HELP@\ @\  about Kermit-370.
@>HOST@\*@\  executes a system command.
@>KERMIT@\*@\  executes a Kermit subcommand.
@>QUIT@\ @\  from Kermit-370.
@>RECEIVE@\ @\  file(s) from other Kermit.
@>SEND@\ @\  file(s) to other Kermit.
@>SERVER@\ @\  mode of remote operation.
@>SET@\*@\  various parameters.
@>SHOW@\*@\  various parameters.
@>SPACE@\*@\  displays disk storage allocation.
@>STATUS@\*@\  inquiry.
@>TAKE@\*@\  subcommands from file.
@>TDUMP@\*@\  dumps the contents of a table.
@>TYPE@\*@\  a file.
@>XECHO@\ @\  echoes a line (transparently).
@>XTYPE@\ @\  displays a file (transparently).
@End(format)

@index(Remote)@index(Local)
Although Kermit-370 is generally a remote Kermit, it has
the capability of communicating with another Kermit in server mode.
In that situation, the
subcommand prefixes REMOTE and LOCAL refer to the Kermit server and
Kermit-370, respectively, even when Kermit-370 is, strictly speaking,
the remote Kermit.  Any replies from the Kermit server are
added to a disk file (whose @i<filespec> is,
of course, system-dependent).
Such a transaction can be carried out, for example, under control of
a TAKE file if Kermit-370 is not operating locally.
If the local Kermit has a "magic" character sequence that switches it
from terminal emulation to server mode, then an entire session
could be controlled from the mainframe, possibly in response to a
single command issued by a naive user.  For example,
@Begin(example)
@ux(grab)

     @i(Kermit-370 is invoked and executes the following TAKE file)

ECHO Serve Me!        @i(the local Kermit switches to server mode)
GET file.a            @i(the server uploads file.a)
FINISH                @i(the server switches back to terminal mode)
@End(example)

The remainder of this section concentrates on
the subcommands that have special form or meaning for Kermit-370, but
neglects those with highly system-dependent syntax or use.

@Heading<The SEND Subcommand>

@Index(SEND)@Index(Long packets)
Syntax: @q<SEND> @i(filespec) [@i(foreign-filespec)]

The SEND subcommand tells Kermit-370 to send a file or file group to the
other Kermit.  If no such file exists, Kermit-370 simply displays an
error message and issues another prompt.  If one or more files
are sent, their names are recorded in memory and may be viewed later
via the TDUMP subcommand (but with no
indication of whether any of them were rejected or cancelled by the
other Kermit).

When Kermit-370 sends files using long packets (longer than 96), the
throughput is especially sensitive to the level of noise on the line
because retries are so time-consuming.  Therefore, Kermit-370 adds an
extra, heuristic size limit for packets when retries have been found
necessary.  When that is the case, after every 20 packets, Kermit
computes the packet size for maximum throughput assuming that the
transmission errors were due to sparse, Poisson-distributed noise bursts.
The result of this calculation is then used as another limit on the
size of outgoing packets besides the one specified by the other Kermit.
If no retries are required, then Kermit-370 assumes the line to be
noiseless and sends packets of the maximum length the
other Kermit allows.
For more details on the SEND
subcommand syntax and operation,
see the chapter on the desired system-specific version of Kermit-370.

@Heading<The RECEIVE Subcommand>

@Index(RECEIVE)
Syntax: @q<RECEIVE> [@i(filespec)]

The RECEIVE subcommand tells Kermit-370 to accept a file or file group.
The user must issue the corresponding
SEND subcommand to the other Kermit.  Under
some circumstances, the records of the received file(s) may be
truncated; when this happens, Kermit does not stop, but notes the fact
as an error (unless something more serious happens later).
For more details on the RECEIVE
subcommand syntax and operation,
see the chapter on the desired system-specific version of Kermit-370.

@Heading<The GET Subcommand>

@Index(GET)
@Index(SEND)@index(RECEIVE)
Syntax: @q<GET> @i(foreign-filespec) [@i(filespec)]

The GET subcommand tells Kermit to request a file or file group
from the other system, which must have a Kermit running in server mode.
Provided the other Kermit complies, the effect is the same as if
SEND @i(foreign-filespec) had been issued directly to the other Kermit
and RECEIVE [@i(filespec)] to Kermit-370.  See the respective
SEND and RECEIVE
subcommands for a description of the each @i<filespec>.

@Heading<The TAKE Subcommand>
@Index(TAKE)@Index(Echo mode)@Index(Error exit)

Syntax: @q<TAKE> @i(filespec)

Execute Kermit subcommands from the specified file, usually called a
TAKE file.  The TAKE file may in turn include TAKE
subcommands to a nesting depth of ten.  If a TAKE file includes the
subcommand SERVER, however, the nesting count starts over again in server
mode.
The user has the option of seeing
the subcommands echoed from the TAKE file as they are executed and also
the option of automatically exiting from a TAKE file on error.  See
the subcommand SET TAKE for details.

@Heading<The SERVER Subcommand>
@Index(SERVER)

Kermit-370 is capable of acting as a server.  In server mode,
Kermit-370 can send and receive files, execute host commands,
execute a restricted set of Kermit subcommands, and perform a variety of
generic Kermit functions.  The following list shows the typical local
Kermit commands along with the server functions they elicit.
When Kermit-370 is talking to a Kermit server, these
same subcommands may be used in the other direction.
@begin(format,spread 0)
@tabclear()@tabset(2.0inches)
BYE@\log out the Kermit server.
FINISH@\server mode.
GET@\a file or files from the server.
REMOTE
  COPY@\a file or files.
  CWD@\set new working directory.
  DIRECTORY@\display file attributes.
  ERASE@\a file or files.
  HELP@\display this command summary.
  HOST@\execute a system command.
  KERMIT@\execute a Kermit-370 subcommand.
  RENAME@\a file or files.
  SPACE@\display disk space.
  TYPE@\a file.
SEND@\a file or files to the server.
@end(format)

If your local Kermit does not support the REMOTE KERMIT command,
you may need to issue SET
subcommands to select various options before typing the SERVER
subcommand.  Once in server mode,
Kermit-370 will await all further instructions from the user Kermit
on the other end of the connection until a FINISH or BYE command is
given.

Command execution in server mode is different in some respects
from normal operation.  First of all, some Kermit subcommands
are not allowed (see the list at the beginning of this section).
Moreover, command errors
always terminate any active TAKE file.
Also, all commands will be run in the
special environment that Kermit sets up during protocol transfers.
Among other things, Kermit intercepts all
terminal I/O (if possible) in this environment in order to
transmit the data to the local
Kermit as text packets.

@index(Type)
Note that some operations can be requested by several different
commands.  If for example, the IBM 370 system has a command @qq(PRT) for
displaying a file, a user interacting with a Kermit-370 server
can choose to display a file by issuing any
of the commands: REMOTE TYPE, REMOTE HOST PRT, REMOTE KERMIT TYPE,
REMOTE KERMIT HOST PRT, or (if SYSCMD has been set ON) REMOTE KERMIT
PRT.  The first form simply transfers the
requested file as text, but the others invoke the @qq(PRT) command
with any specified options, intercept the terminal output,
and return the results to the local Kermit.

@Heading<The SET Subcommand>

Syntax: @q<SET> @i(parameter) [@i(value)]

The SET subcommand establishes or modifies various parameters controlling
file transfers.  The values can, in turn, be
examined with the SHOW subcommand.
Some parameters have two levels.  In particular, there are two
matching lists of SEND and RECEIVE sub-parameters corresponding to
the values exchanged by Kermits in the Send-Init/ACK sequence.
For each of these SEND/RECEIVE pairs one element is encoded in
outgoing parameter packets, and the other is decoded from incoming ones.
Setting the latter by hand may be needed to establish contact and also
has the effect of redefining the default value for decoding from
subsequent parameter packets.
Generally, the distinction between SEND and RECEIVE parameters is
unambiguous, the only exception being TIMEOUT (q.v.).
The following SET
subcommands are available in Kermit-370:
@Begin(Format,spread 0)
@tabclear()@tabset(2.0inches)
APPEND@\Append if file name collision.
ATOE@\Modify the Kermit-370 ASCII-to-EBCDIC table.
BLOCK-CHECK@\Level of error checking for file transfer.
CONTROLLER@\Indicate type of terminal connection.
DEBUG@\Log packet traffic during file transfer.
DELAY@\Length of pause before a SEND subcommand.
EOF@\Text file truncation at CTRL-Z.
ETOA@\Modify the Kermit-370 EBCDIC-to-ASCII table.
FILE@\Attributes for incoming or outgoing files...
  TYPE@\... text or binary.
  @i(other)@\... system-specific attributes.
FOREIGN@\Strings added to outgoing filespec...
  PREFIX
  SUFFIX
INCOMPLETE@\Determine the action on an aborted file transfer.
LINE@\Specify alternate communication line.
MARGIN@\for sending files...
  LEFT
  RIGHT
PARITY@\Indicate if 7-bit or 8-bit data.
RETRY@\Maximum retry count...
  INIT@\... for initial packet exchange.
  PACKET@\... per packet for ongoing transfer.
SYSCMD@\Try apparently invalid Kermit subcommands on host system.
TABS-EXPAND@\Determine tab-to-space conversion on reception.
TAKE
  ECHO@\Echo subcommands read from TAKE files.
  ERROR-ACTION@\Exit from TAKE file on command error.
TEST@\Facilitate testing of Kermit.
TATOE@\Modify the Kermit-370 ASCII-to-EBCDIC table.
TETOA@\Modify the Kermit-370 EBCDIC-to-ASCII table.
TTABLE@\Determine which tables undo the terminal translation.
WARNING@\Rename if filename collision.
8-BIT-QUOTE@\Determine state of 8th-bit prefixing.
SEND or RECEIVE
  END-OF-LINE@\Packet terminator.
  PACKET-SIZE@\Maximum packet size.
  PAD-CHAR@\Character to insert before each packet.
  PADDING@\Number of pad characters to insert.
  QUOTE@\Use to quote control characters in packets.
  START-OF-PACKET@\Packet beginning marker.
  TIMEOUT@\Time limit for response.
@End(format)

@Subheading<SET APPEND>
@Index<File warning>

Syntax: @q<SET APPEND ON @i(or) OFF>
@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\If an incoming file has the same name as an existing one, the new
file is appended to the old one.  This option supersedes SET WARNING.

OFF@\Filename collision is handled according to the WARNING parameter.
(Default.)
@End(Description)

@Subheading<SET ATOE etc.>
@Index<ASCII-to-EBCDIC>@Index<EBCDIC-to-ASCII>

Syntax: @q<SET> @i(table) [@i(num1) @i(num2)]

This modifies one of the ASCII/EBCDIC translation tables
used by Kermit-370 (for example,
to conform to your system).  The valid table names are ATOE, ETOA,
TATOE, and TETOA.  The arguments are, respectively,
the offset within the named table and
the new value for that offset.  If the arguments are omitted, the table
is restored to its initial arrangement.
Both @i(num1) and @i(num2) should be in the range 0-255 (decimal).
For example, in ATOE or TATOE, the offset is the
ASCII character code, and the new value is the new EBCDIC result code.
Initially, ATOE and TATOE each
contain two identical copies of the 7-bit ASCII character table.
Note: the meaning of the tables depends on the TTABLE setting -- if
TTABLE is OFF, the TATOE and TETOA tables are not used.

@Subheading<SET BLOCK-CHECK>
@Index<Block check>

Syntax: @q<SET BLOCK-CHECK> @i(number)

This determines the type of block check used during file transfer,
provided the other Kermit agrees.  Valid
options for @i(number) are: 1 (for a one-character checksum), 2 (for
a two-character checksum) and 3 (for a three-character CRC).  This is
one of only two
Send-Init parameters that cannot be SET separately for SEND
and RECEIVE.

@Subheading<SET CONTROLLER>
@Index<Series/1>@Index(TTY)@Index(SNA)

Syntax: @q<SET CONTROLLER> @i(type)

The @i(type) may be TTY, SERIES1, GRAPHICS, or FULLSCREEN.
Kermit-370 automatically determines whether you are connected via a
Series/1 (or similar) emulation controller
or a TTY line.  This subcommand is provided,
though, to allow that choice to be superseded,
and because Kermit may not be
able to distinguish between Series/1-type and other 3270-emulation
controllers.  When CONTROLLER is set to SERIES1 or GRAPHICS,
Kermit disables the 3270 protocol conversion function by putting the
terminal controller into "transparent mode",
which allows Kermit packets to pass through intact.

@Subheading<SET DEBUG>
@Index<Debugging>

Syntax: @q<SET DEBUG ON @i(or) RAW @i(or) OFF>
@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\Keep a journal of all packets sent and received in a log file on
disk.  If the file already exists, it is erased and overwritten.  The
@i<filespec> of the log is, of course, system-dependent.  All packets
are logged in EBCDIC for legibility, even when CONTROLLER is set to
SERIES1 or GRAPHICS.  In addition to the packets themselves, which are
labelled "S" or "R" for packets sent or received, the log includes any
additional status information (labelled "A"), such as the AID returned
by a SERIES1 device.

RAW@\The same as ON, but packets are logged in the form that is passed
to or from
the operating system, i.e., EBCDIC for TTY terminals, and ASCII for
SERIES1 and GRAPHICS terminals.

OFF@\Stop logging packets and close the the log file.
(Default.)
@End(Description)

@Subheading<SET DELAY>
@Index<SEND delay>

Syntax: @q<SET DELAY> @i(number)

Normally, Kermit-370 waits 10 seconds after the SEND subcommand before
starting the transfer, but this delay may be SET to any non-negative
value.  Two DELAY values have special meaning.  When DELAY is 1, the
usual two-line greeting displayed during protocol mode is
abbreviated to a short message (the default
Kermit prompt with three dots...),
and when DELAY is 0, the greeting is suppressed entirely, along with
the extra one-second pause for the RECEIVE and SERVER subcommands.

@Subheading<SET EOF>
@Index<File truncation>

Syntax: @q<SET EOF ON @i(or) OFF>
@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\Scan each incoming TEXT file for the first
occurence of CTRL-Z and ignore the remainder of the file (but
continue decoding up to the actual end of the file).  BINARY files
are not affected.

OFF@\Accept incoming files in their entirety.
(Default.)
@End(Description)

@Subheading(SET FILE TYPE)
@index(Binary Files)@Index<CRLF>

Syntax: @q<SET FILE TYPE TEXT @i(or) BINARY @i(or) V-BINARY @i(or) D-BINARY>

@Begin(Description,leftmargin +10,indent -10,spread 0.5)
TEXT@\Specifies ordinary text.  ASCII-to-EBCDIC
or EBCDIC-to-ASCII translation is performed on the data.  Trailing
blanks are removed, and CRLF's
are appended to outgoing records. CRLF's are used, in turn, to
determine the end of incoming records, which are padded with blanks
if necessary to fill buffers.
(Default.)

@Index(LRECL)
BINARY@\Specifies bit-stream data.  No translation is performed,
no CRLF's are added to outgoing records, and blanks are neither added
nor removed.  Incoming bytes are added successively to
the current record buffer, which is written out when the current
LRECL is reached.  Padding, if necessary, is done with nulls.

V-BINARY@\Specifies varying-length-record binary data.  This type is
like BINARY, except that a
two-byte binary prefix is added to each outgoing record
giving the number of data bytes, and incoming records are set off by
(and stripped of) their prefixes on receipt.

D-BINARY@\Is like V-BINARY except that the length prefixes are five-byte
ASCII-encoded decimal (right-justified with leading zeroes).
@End(Description)

@Subheading(SET FOREIGN)

Syntax: @q<SET FOREIGN PREFIX> @i(string)

This defines a prefix string to be added to the outgoing
@i(filespec) generated by the SEND subcommand.  For example, the string
might be set to @qq(B:) to specify output to the B disk drive on the
other Kermit's system.  The default is a null string.  There is also a
FOREIGN SUFFIX handled in the same manner.

@Subheading(SET HANDSHAKE)
@Index(Handshake)

Syntax: @q<SET HANDSHAKE> @i(number)

This defines the character, if any, that Kermit-370 should
send (or cause to be sent) immediately
before reading each packet.  The character is given as the decimal
of an ASCII control character, or as zero if no handshake is to be
sent.
The default is 17 (XON), and any value in the range
0-31 is valid, but 13 (CR) should not be used because it is generally
the end-of-packet character.  When Kermit-370 is running through a
full-duplex connection (such as a @qq<SERIES1>), the traditional IBM
handshaking is not necessary, and HANDSHAKE should be set to 0
(as long as the other Kermit can be
instructed not to expect a handshake).
Note the distinction between @q(SET
HANDSHAKE) in Kermit-370 (where it defines a character to be sent) and
in many micro Kermits (where it defines a character to be expected).

@Subheading(SET INCOMPLETE)
@index(Incomplete File)

Syntax: @q<SET INCOMPLETE DISCARD @i(or) KEEP>

@Begin(Description,leftmargin +10,indent -10,spread 0.5)
DISCARD@\Specifies that incomplete files are to be erased.  This is
the default.  Note that when APPEND is ON, incomplete files are never
erased, lest pre-existing data be lost.

KEEP@\Specifies that incomplete files are to be kept.
@End(Description)

@Subheading(SET LINE)
@index(Margins)

Syntax: @q<SET LINE> [@i(name)]

This specifies an alternate communication line for file
transfers.  If the @i(name) is omitted, the default line (the user's
terminal) is used.  The format of @i(name) is, of course,
system-dependent, and some versions of Kermit-370 do not support any
alternate lines.  No version currently allows Kermit-370 to CONNECT
over an alternate line.

@Subheading(SET MARGIN)
@index(Margins)

Syntax: @q<SET MARGIN> @i(side column)

When Kermit-370 sends a text file, each line may be truncated on the
left or right (or both) at fixed column numbers.  Only the text from
the left margin to the right margin (inclusive) will be sent, and any
trailing blanks in the truncated lines will be stripped.  A value of
zero for either margin disables truncation on that side.


@Subheading(SET PARITY)
@index(Parity)

Syntax: @q<SET PARITY MARK @i(or) NONE>

Transparent-mode ASCII data received from a
@qq(SERIES1) or @qq(GRAPHICS) device will
typically have either all Mark parity (seven data bits with the eighth
bit set) or no parity (eight data bits).  Kermit-370 must know which
kind of parity to expect in order to calculate checksums properly.
Since Kermit-370 does not actually verify parity, the other possible
variants (ODD, EVEN, and SPACE) are lumped together with MARK parity
for the purpose of this subcommand, which merely chooses between 7-bit
and 8-bit data transfer.

@Subheading(SET PROMPT)
@index(Parity)

Syntax: @q<SET PROMPT> @i(string)

This defines the character string that Kermit-370 displays
when asking for a subcommand.  The prompt may be any string of up to 20
characters.  The default is the name of the system-specific version of
Kermit-370 followed by a ">" sign, e.g., @q(Kermit-CMS>).

@Subheading(SET RETRY)

Syntax: @q<SET RETRY  INITIAL @i(or) PACKETS  @i(number)>

Kermit-370 resends its last packet after receiving a NAK or bad packet,
but it eventually gives up after repeated failures or the same
packet.  The limit on retries
can be set separately for the initial
packet exchange (Send-Init or server-mode command) and for ordinary
packets.  The default for INITIAL
is 16 and for PACKETS, 5.  Either limit can be set to any positive
value.

@Subheading<SET SYSCMD>
@Index<Host commands>

Syntax: @q<SET SYSCMD ON @i(or) OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\If the user enters a command string which is not a valid
Kermit subcommand, Kermit-370 will pass the string along to the host
operating system for execution.  If the string is rejected by the system
as well, Kermit will report it as an invalid @i(Kermit) subcommand.
Otherwise, Kermit will assume the string was intended as a host command
and will simply report the completion code if non-zero.

OFF@\Invalid Kermit subcommands are simply rejected as such.  System
commands may be executed, of course, but only by specifying the
generic prefix @qq(HOST) or the appropriate system-specific prefix,
such as CMS or TSO.
(Default.)
@End(Description)

@Subheading<SET TABS-EXPAND>

Syntax: @q<SET TABS-EXPAND ON> [@i(list)] @i(or) @q<OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\Tab characters in incoming TEXT files are replaced by one or more
blanks to bring the record size up to the next higher multiple of eight
for each tab.  If tab settings other than columns 1, 9, 17, etc. are
desired, they may be specified explicitly in a list following the
keyword @qq(ON).  Items in the list may be separated by spaces or
commas.

OFF@\Incoming tabs are retained.
(Default.)
@End(Description)

@Subheading<SET TAKE ECHO>
@index(Command Echoing)

Syntax: @q<SET TAKE ECHO ON @i(or) OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\Subcommands are echoed to the terminal as they are executed from
a TAKE file.

OFF@\Subcommands from a TAKE file are executed "silently."
(Default.)
@End(Description)

@Subheading<SET TAKE ERROR-ACTION>

Syntax: @q<SET TAKE ERROR-ACTION CONTINUE @i(or) HALT>

@Begin(Description,leftmargin +11,indent -11,spread 0.5)
CONTINUE@\Execution continues in a TAKE file regardless of illegal
commands, except in server mode.  This is the default.

HALT@\A command error in a TAKE file causes immediate exit to Kermit
subcommand level.
@End(Description)

@Subheading<SET TEST>
@Index<TEST>

Syntax: @q<SET TEST ON @i(or) OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\Allow setting the START-OF-PACKET and other special characters
to any value, and suppress checksum testing on received packets.

OFF@\Normal operation.
(Default.)
@End(Description)

@Subheading<SET TTABLE>
@Index<Translation>

Syntax: @q<SET TTABLE ON @i(or) OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\The translation that undoes the terminal controller's
ASCII/EBCDIC conversion comes from the TATOE and TETOA tables, rather
than the ATOE and ETOA tables (which are used only for translating
disk files).  This option has no effect when there is no translation
built into the controller, i.e., with SERIES1 and GRAPHICS connections.

OFF@\The ATOE and ETOA tables are used for all translations by
Kermit-370.  (Default.)
@End(Description)

@Subheading<SET WARNING>
@Index<File warning>@Index(File renaming)@index(Warning)

Syntax: @q<SET WARNING ON @i(or) OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\If an incoming file has the same @i(filespec) as an existing file on
disk, Kermit will attempt to rename the incoming file so
as not to destroy (overwrite) the pre-@|existing one.

OFF@\Upon filename collision, the existing file will be erased
and replaced by the incoming file.  (Default.)
@End(Description)

@Subheading<SET 8-BIT-QUOTE>

Syntax: @q<SET 8-BIT-QUOTE @i(char or) ON @i(or) OFF>

This controls whether eighth-bit prefixing is done and can be
used to specify the character to be used.  This is
one of only two
Send-Init parameters that cannot be SET separately for SEND
and RECEIVE.
@Begin(Description,leftmargin +8,indent -8,spread 0.5)
char@\Eighth-bit prefixing will be done using @i(char), provided the
other Kermit agrees.

ON@\Eighth-bit prefixing will be done, provided the other Kermit
explicitly requests it (and specifies the character).

OFF@\Eighth-bit prefixing will not be done.  (Default.)
@End(Description)

@Subheading(SET SEND/RECEIVE)

The following parameters can be set either as SEND or RECEIVE options.
As a rule, in each pair, one is the operational value, and the other
is used to change the default for Send-Init packets received from the
other Kermit and to set up parameter values as if the other Kermit
had specified them on the previous exchange.
When both values are described, the operational one will be first.
After a transfer, the operational values will be unchanged, but the
others (as displayed by SHOW) will reflect the parameters specified
by the other Kermit.  The underlying defaults established by previous
SET subcommands will still be in effect.
In the syntax descriptions, @i(mode) is SEND or RECEIVE.

@Subheading(END-OF-LINE)

Syntax: @q<SET @i(mode) END-OF-LINE @i(number)>

RECEIVE should not be changed.

SEND may be needed to establish contact.
If the other system needs packets to be terminated
by anything other than carriage return, specify the
decimal value of the desired ASCII character.
@i(number) must be in the range 0-31 (decimal).  The default is 13
(CR).

@Subheading(PACKET-SIZE)

Syntax: @q<SET @i(mode) PACKET-SIZE @i(number)>

RECEIVE defines @i(number) as the maximum length for incoming
packets.  The valid range is 26-9024, but 94 is the limit for normal
short-packet protocol.  The default is 80.@Index(Long packets)
In practice, the size may be limited by hardware and programming
considerations.  See the system-specific chapters for details.

@Subheading(PAD-CHAR)

Syntax: @q<SET @i(mode) PAD-CHAR @i(number)>

RECEIVE defines @i(number) as the character to be used by the other
Kermit for padding
packets.  The character must be an ASCII control
character (in the range 0-31).  The default is 0 (NULL).
This option is seldom useful.

SEND may be needed to establish contact if the other Kermit
(or the transmission line) needs padded packets.

@Subheading(PADDING)

Syntax: @q<SET @i(mode) PADDING @i(number)>

RECEIVE defines the @i(number) of pad characters to be used for padding
packets from the other Kermit.  This number may be anywhere from 0 to
94.  The default is 0.  This option is seldom useful.

SEND may be needed to establish contact if the other Kermit
(or the transmission line) needs padded packets.

@Subheading(QUOTE)

Syntax: @q<SET @i(mode) QUOTE @i(char)>

SEND indicates a printable character for prefixing (quoting) control
characters and other prefix characters.
The only good reason to change this would be for sending a file
that contains many @qq(#) characters (the
normal control prefix) as data.  It must be a single character with
ASCII value 33-62 or 96-126 (decimal).

@Subheading(START-OF-PACKET)

Syntax: @q<SET @i(mode) START-OF-PACKET @i(number)>

RECEIVE defines @i(number) as the character to be expected to mark the
start of packets from the other Kermit.  The character must be an
ASCII control
character (in the range 0-31).  The default is 1 (SOH).  This may be
needed to establish contact.

SEND may also be needed to establish contact.
It defines @i(number) as the character to be used to mark outgoing
packets.

@Subheading(TIMEOUT)

Syntax: @q<SET @i(mode) TIMEOUT @i(time)>

RECEIVE defines the @i(time) in seconds the other Kermit is to wait for
a response from Kermit-370 before resending a packet.  The default is 5.
A value of 0 means the other Kermit should wait indefinitely.

SEND defines the @i(time) in seconds Kermit-370 is to wait for a
response from the other Kermit before resending a packet.  The
default is 0.

@Heading(The SHOW Subcommand)

Syntax: @q<SHOW> [@i(option)]

The SHOW subcommand displays the values of all
parameters that can be changed with
the SET subcommand, except for ATOE, ETOA, TATOE, and TETOA
(for those, see the TDUMP subcommand).  If specified,
@i(option) can be a particular parameter or the keyword @qq<ALL>
(the default).
Groups of parameters, such as SEND, can be displayed by requesting
the group name, or individual sub-parameters can be displayed
by specifying the complete name.  For example,
@example(SHOW RECEIVE EOL)
will display the decimal value of the packet terminator that Kermit-370
currently expects, i.e., 13.  Similarly,
@example(SHOW FOREIGN)
will display the character strings currently in use for prefix and
suffix on each outgoing @i(filespec).

@Heading(The STATUS Subcommand)

Syntax: @q<STATUS>

This subcommand displays information about the previously executed
subcommand.
The response will include either the appropriate error message or
the message @qq<No errors>.
The initial status is @qq(No file transfers yet).
If the status reflects an error condition, the name of the last file
used (excluding TAKE files) will be displayed as well.  If
the error was detected by the other Kermit, the message will be
@qq(Micro aborted) followed by the text from the Error packet.
Conversely, if Kermit-370 detected the error, the text of the status
message will have constituted the error packet sent out.
In any case, if the last file transfer was cancelled (by virtue of an
attribute mismatch or manual intervention), the reason for
cancellation is displayed.  Also, if the error occurred in disk I/O,
any available explanatory information is displayed.
Normally, the error status is altered only when a transfer-initiating
subcommand (SEND or RECEIVE) is executed, but in server mode @i(every)
subcommand is received through a transfer from the other Kermit and
may affect the status (except the STATUS subcommand itself, of course).
When Kermit-370 has been forced to truncate one or more records in a
RECEIVE operation (because of the current maximum record length), the
number of records truncated is reported.
The status display also includes throughput statistics for the last
transfer: number of files sent, duration, number of packets, number of
retries, bytes/second, and bytes/packet.  Finally, if retries were
necessary, Kermit-370 computes the optimum packet size assuming the
retries to have been due to sparse, Poisson-distributed bursts
of noise.  @Index(Long packets)This is the
same heuristic optimum that Kermit-370 computes and uses as
an alternative packet-size limit when sending long packets.

@Heading(The TDUMP Subcommand)

Syntax: @q<TDUMP @i(table-name or) NAMES>

This
displays the contents of @i(table-name).  The same table can be modified
using the SET subcommand.  The ATOE, ETOA, TATOE, and TETOA
tables can presently be displayed and changed.  Alternatively, the
@i<filespec> of each file sent in the last transfer can be displayed.

@Heading(The GIVE Subcommand)

Syntax: @q<GIVE> @i(table-name filespec)

This
compares the named table with its default values and
saves the differences
in the form of a TAKE file consisting of SET subcommands that would
convert the default into the current arrangement.
ATOE, ETOA, TATOE, and TETOA are the available
tables.
The details of the @i<filespec> are system-dependent, but those details
will, in general, be the same as for the TAKE subcommand.

@Heading(The HOST Subcommand)

Syntax: @q<HOST> @i(text of command)

This issues a command to the host operating
system from Kermit-370.
When a command returns a non-zero completion code, the
code will be displayed.
Generally, the name of the system (e.g., CMS)
is treated as a synonym for the
HOST subcommand.

@Heading(The KERMIT Subcommand)

Syntax: @q<KERMIT> @i(text of subcommand)

This is provided for redundancy as the counterpart of the
HOST subcommand.  Kermit-370 executes the specified text as a Kermit
subcommand just as if the LOCAL prefix had been entered.

@Heading(The ECHO and XECHO Subcommands)

Syntax: @q<[X]ECHO @i(line)>

These subcommands type the @i(line) back at the user.
The @i(line) may contain control characters or any desired
text, including upper or lower case.  These
subcommands may be used, for example, to test the ASCII/EBCDIC translate
tables or to issue coded commands to the user's terminal.
XECHO differs from ECHO primarily in that it
uses transparent mode if CONTROLLER is
SERIES1 or GRAPHICS.  It also offers its own
brand of control-character quoting, using the @qq<^> character to
indicate that only the five low-order bits of the ASCII codes are
to be used.
Thus, @qq(^a), @qq(^A), and @qq(^!) are all translated to SOH (CTRL-A),
while @qq(^[) becomes ESC.  However, there must be one exception for
@qq(^) itself: @qq(^>) and @qq(^~) are both translated to RS
(CTRL-@q<^>), but @qq(^^) becomes just @qq(^).

@Heading(The TYPE and XTYPE Subcommands)

Syntax: @q<[X]TYPE> @i(filespec)

These subcommands type the named file.
XTYPE differs from TYPE primarily in that it
uses transparent mode if CONTROLLER is
SERIES1 or GRAPHICS, and sends the data in bursts
no larger than the current SEND PACKET-SIZE.
TYPE is effectively a synonym for (and allows the same options as) the
host system command for listing files, but
XTYPE merely sends the file "raw".

@Section<Before Connecting to the Mainframe>

@index(TTY)@index(LOCAL-ECHO)@index(Flow control)@Index(Handshake)
Several flags must be set on the micro version of Kermit before
connecting to an IBM 370 system as a @qq(TTY) device.
You should set the LOCAL-ECHO flag to ON (to indicate
half-duplex).  This is the norm but not true in absolutely
every case; if each
character appears twice on your terminal screen,
set the LOCAL-ECHO flag OFF.
FLOW-CONTROL should be set to NONE, and on some systems
HANDSHAKE should be set to XON.
The parity should be set according to the system's specifications.  On
some micro versions of Kermit, all of the above is done in one step
using the DO IBM macro (or SET IBM ON).  Set the baud rate to
correspond to the line speed.

@index(SERIES1)@index(PARITY)
Connecting through a
@qq(SERIES1) or @qq(GRAPHICS) device also
requires that certain flags be set
on the micro version of Kermit.  You should set the LOCAL-ECHO flag to
OFF (to indicate full-duplex).  FLOW-CONTROL should be set to XON/XOFF,
and HANDSHAKE should be set to OFF.  For many systems,
the PARITY should be set to EVEN.  Set the baud rate to correspond to
the line speed.

One exception to these rules is the case where
the micro Kermit is attempting automated file transfer, e.g.,
downloading several separate files from Kermit-370 running in server
mode.  In fact, under those circumstances, handshaking is necessary
even with @qq(SERIES1) connections, and the two Kermits must be
instructed to adopt a common handshake character (e.g., by SET HANDSHAKE
10 to Kermit-370 and SET HANDSHAKE LF to the micro).

In any case, you should make sure that either the micro Kermit or
Kermit-370 will provide timeouts during file transfers (if not
both).  Some versions of Kermit-370 (notably CMS) cannot provide
timeouts, and you may need to sset the TIMER to ON in the micro.

@Section<After Returning from Kermit-370>

When Kermit-370 receives a QUIT or EXIT subcommand or finishes the
subcommand or subcommands
specified in the original command string that invoked
Kermit, control is returned to the caller.  Before returning,
Kermit-370 closes any active TAKE files (the EXIT or QUIT subcommand may
be issued from a TAKE file).  On return, the completion code is set
from the current error status according to the codes in Table
@ref<-ikcodes>.

@begin<table,leftmargin +0,use format>
@tabclear()@tabset(0.6in,1.4in)
@bar()
@blankspace(1)
@u(Code)@\@u<Symbol>@\@ux<Error Message>
 0@\NOE@\No errors
 1@\NFT@\No file transfers yet
 2@\TRC@\Transfer cancelled
 3@\USC@\Invalid server command
 4@\TIE@\Terminal I/O error
 5@\BPC@\Bad packet count or chksum
 6@\IPS@\Invalid packet syntax
 7@\IPT@\Invalid packet type
 8@\MIS@\Lost a packet
 9@\NAK@\Micro sent a NAK
10@\ABO@\Micro aborted
11@\FNE@\Invalid file name
12@\FNF@\File not found
13@\FUL@\Disk or file is full
14@\DIE@\Disk I/O error
15@\MOP@\Missing operand
16@\SYS@\Illegal system command
10@\KCE@\Kermit command error
10@\TIM@\No packet received
10@\RTR@\Records truncated
20@\COM@\Bad communication line
@tag<-ikcodes>
@caption<Error messages and codes for Kermit-370>
@blankspace(1)
@bar()
@end<table>

@Section<What's New>
Below is a list of the additions in Version @value(-ikvrsn) of
Kermit-370:

@begin(enumerate,spread 0.5)
Code reorganization into generic 370 and system-specific sections.

Optional separate translation tables for counteracting the system
conversion of terminal I/O.

New @q<GIVE> subcommand for saving a modified translation table.

A new, RAW debug mode for recording the packet traffic as
actually sent and received on @qq(GRAPHICS) and
@qq(SERIES1) devices.

Preservation of the case of subcommands as typed, with uppercase
conversion of only those words that must be uppercase.

New @q<SET MARGIN> subcommand for
limiting the width of a file to be sent.

Settable tab stops for Kermit's conversion of tabs to spaces
(alternative
to the default 1, 9, 17, etc.).

Replace @q<SET SERIES1> subcommand with new @q<SET CONTROLLER>.  Support
for multiple terminal controller types.

New @q<DIRECTORY> and @q<HOST> subcommands following Kermit standard.

Combination of file-attribute @q<SET> subcommands (FILE-TYPE, LRECL, and
RECFM) into a new group @q<SET FILE>.

Separate retry limits for initial and subsequent packet exchanges.

Pad binary records on disk with nulls, rather than blanks.

Automatically tune packet length when sending long packets according
to heuristic optimum based on sparse Poisson statistics, provided
that transmission errors do occur.

Expand STATUS report to include the number of files in the last
transfer, throughput statistics, heuristic optimum packet length
(when long packets are enabled), and the reason for any file rejection
based on A-packets.

New subcommand @q<TDUMP NAMES> to display the list of
files sent in the last transfer.

Add file creation date to A-packet repertoire.

@q<REMOTE COPY> and @q<REMOTE RENAME>
commands to a server at the other end.

Allow long packets through a 7171 with VTAM.

New type @q<D-BINARY> for binary files with undelimited variable-length
records.

@q<SET 8-BIT-QUOTE>.  Allow 8-bit data where possible
via @q<SET PARITY>.

@q<SET SYSCMD>, so that Kermit can be told to try "illegal" subcommands
as host system commands instead of just rejecting them.

@q<SET PROMPT> subcommand.

Do not forget parameters specified by the other Kermit in I-packets.

Keep track of truncated records during a RECEIVE operation and report
the count in STATUS; also call truncation an error after everything is
received.

@q<SET HANDSHAKE> subcommand to alter or suppress handshake character
Kermit-370 sends out after each packet.
@end(enumerate)

@Section(What's Missing)

Work on Kermit-370 will continue.  Features that need to be
improved or added include:
@begin(itemize)
Detect file properties from Attribute packets and allow overriding
current parameter settings.  Also implement file archiving.

Add @q<SET REPEAT> subcommand.

Improve Kermit-370 operation as a local Kermit.

Recover from sudden line degradation by retransmitting partial packets.

System-specific upgrades; see the respective chapters for details.
@end(itemize)
