H /*  C K U U S 2  --  "User Interface" STRINGS module for Unix Kermit  */    /*&  Author: Frank da Cruz (SY.FDC@CU20B),C  Columbia University Center for Computing Activities, January 1985. M  Copyright (C) 1985, Trustees of Columbia University in the City of New York. H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */   O /*  This module separates long strings from the body of the ckuser module. */       #include "ckcdeb.h"  #include <stdio.h> #include <ctype.h> #include "ckcker.h"  #include "ckucmd.h"  #include "ckuusr.h"     extern char cmdbuf[];  extern int nrmt, nprm, dfloc;  extern char *dftty;  extern struct keytab prmtab[]; extern struct keytab remcmd[];    static char *hlp1[] = { "\n", 2 "  Usage: kermit [-x arg [-x arg]...[-yyy]..]]\n",O "   x is an option that requires an argument, y an option with no argument:\n", 7 "     actions (* options also require -l and -b) --\n", = "       -s file(s)   send (use '-s -' to send from stdin)\n",   "       -r           receive\n",* "       -k           receive to stdout\n",I "     * -g file(s)   get remote file(s) from server (quote wildcards)\n", = "       -a name      alternate name, used with -s, -r, -g\n", * "       -x           enter server mode\n",- "     * -f           finish remote server\n", 3 "     * -c           connect before transaction\n", 2 "     * -n           connect after transaction\n",2 "       -h           help - print this message\n", "     settings --\n", 2 "       -l line      communication line device\n",. "       -b baud      line speed, e.g. 1200\n",4 "       -i           binary file or Unix-to-Unix\n",6 "       -p x         parity, x is one of e,o,m,s,n\n",E "       -t           line turnaround handshake = xon, half duplex\n", ; "       -w           don't write over preexisting files\n", 6 "       -q           be quiet during file transfer\n",8 "       -d           log debugging info to debug.log\n",A " If no action command is included, enter interactive dialog.\n",  "" };    /*  U S A G E */   	 usage() {      conola(hlp1);  }       /*  Help string definitions  */     static char *tophlp[] = { "\n\B Type ? for a list of commands, type 'help x' for any command x.\n\A While typing commands, use the following special characters:\n\n\ K  DEL, RUBOUT, BACKSPACE, CTRL-H: Delete the most recent character typed.\n\ /  CTRL-W: Delete the most recent word typed.\n",     "\$  CTRL-U: Delete the current line.\n\'  CTRL-R: Redisplay the current line.\n\ I  ?       (question mark) display help on the current command or field.\n\ G  ESC     (Escape or Altmode) Attempt to complete the current field.\n",     "\E  \\       (backslash) include the following character literally.\n\n\ I From system level, type 'kermit -h' to get help about command line args.\  \n", "" };     static char *hmxxbye = "\ . Shut down and log out a remote Kermit server";    static char *hmxxclo = "\ # Close one of the following logs:\n\ J  session, transaction, packet, debugging -- 'help log' for further info.";    static char *hmxxcon = "\ = Connect to a remote system via the tty device given in the\n\   most recent 'set line' command";    static char *hmxxget = "\ K Format: 'get filespec'.  Tell the remote Kermit server to send the named\n\ K files.  If filespec is omitted, then you are prompted for the remote and\n\  local filenames separately.";     static char *hmxxlg[] = { "\& Record information in a log file:\n\n\C  debugging             Debugging information, to help track down\n\ 9   (default debug.log)  bugs in the C-Kermit program.\n\n\ O  packets               Kermit packets, to help track down protocol problems.\n\    (packet.log)\n\n",   D " session               Terminal session, during CONNECT command.\n\   (session.log)\n\n\G  transactions          Names and statistics about files transferred.\n\    (transact.log)\n", "" } ;      static char *hmxxlogi[] = { "\ Syntax: script text\n\n", H "Login to a remote system using the text provided.  The login script\n",@ "is intended to operate similarly to uucp \"L.sys\" entries.\n",0 "A login script is a sequence of the form:\n\n",' "	expect send [expect send] . . .\n\n", O "where 'expect' is a prompt or message to be issued by the remote site, and\n", L "'send' is the names, numbers, etc, to return.  The send may also be the\n",K "keyword EOT, to send control-d, or BREAK, to send a break.  Letters in\n", F "send may be prefixed by ~ to send special characters.  These are:\n",F "~b backspace, ~s space, ~q '?', ~n linefeed, ~r return, ~c don\'t\n",K "append a return, and ~o[o[o]] for octal of a character.  As with some \n", M "uucp systems, sent strings are followed by ~r unless they end with ~c.\n\n", K "Only the last 7 characters in each expect are matched.  A null expect,\n", I "e.g. ~0 or two adjacent dashes, causes a short delay.  If you expect\n", J "that a sequence might not arrive, as with uucp, conditional sequences\n",$ "may be expressed in the form:\n\n",' "	-send-expect[-send-expect[...]]\n\n", J "where dashed sequences are followed as long as previous expects fail.\n", "" };     static char *hmxxrc[] = { "\J Format: 'receive [filespec]'.  Wait for a file to arrive from the other\n\N Kermit, which must be given a 'send' command.  If the optional filespec is\n",   N "given, the (first) incoming file will be stored under that name, otherwise\n\3 it will be stored under the name it arrives with.",  "" } ;    static char *hmxxsen = "\ N Format: 'send file1 [file2]'.  File1 may contain wildcard characters '*' or\n\M '?'.  If no wildcards, then file2 may be used to specify the name file1 is\n\ D sent under; if file2 is omitted, file1 is sent under its own name.";    static char *hmxxser = "\ J Enter server mode on the currently selected line.  All further commands\n\= will be taken in packet form from the other Kermit program.";     static char *hmhset[] = { "\H The 'set' command is used to establish various communication or file\n",I "parameters.  The 'show' command can be used to display the values of\n", H "'set' parameters.  Help is available for each individual parameter;\n",/ "type 'help set ?' to see what's available.\n",  "" } ;    static char *hmxychkt[] = { "\J Type of packet block check to be used for error detection, 1, 2, or 3.\n",M "Type 1 is standard, and catches most errors.  Types 2 and 3 specify more\n", O "rigorous checking at the cost of higher overhead.  Not all Kermit programs\n",  "support types 2 and 3.\n",  "" } ;     I static char *hmxyf[] = { "\set file: names, type, warning, display.\n\n", K "'names' are normally 'converted', which means file names are converted\n", H "to 'common form' during transmission; 'literal' means use filenames\n",/ "literally (useful between like systems).\n\n", H "'type' is normally 'text', in which conversion is done between Unix\n",K "newlines and CRLF line delimiters; 'binary' means to do no conversion.\n", ; "Use 'binary' for executable programs or binary data.\n\n", M "'warning' is 'on' or 'off', normally off.  When off, incoming files will\n", K "overwrite existing files of the same name.  When on, new names will be\n", H "given to incoming files whose names are the same as existing files.\n", "\n\N 'display' is normally 'on', causing file transfer progress to be displayed\n",H "on your screen when in local mode.  'set display off' is useful for\n",< "allowing file transfers to proceed in the background.\n\n", "" } ;    static char *hmhrmt[] = { "\J The 'remote' command is used to send file management instructions to a\n",N "remote Kermit server.  There should already be a Kermit running in server\n",N "mode on the other end of the currently selected line.  Type 'remote ?' to\n",J "see a list of available remote commands.  Type 'help remote x' to get\n",? "further information about a particular remote command 'x'.\n",  "" } ;     * /*  D O H L P  --  Give a help message  */    dohlp(xx) int xx; {      int x,y;        if (xx < 0) return(xx);      switch (xx) {     case XXBYE:      return(hmsg(hmxxbye));    case XXCLO:      return(hmsg(hmxxclo));    case XXCON:      return(hmsg(hmxxcon));    case XXCWD: 
 #ifdef vms     return(hmsg("\C Change Working Directory, equivalent to VMS SET DEFAULT command"));  #else N     return(hmsg("Change Working Directory, equivalent to Unix 'cd' command")); #endif    case XXDEL: 1     return(hmsg("Delete a local file or files"));     case XXDIAL:9     return(hmsg("Dial a number using modem autodialer"));     case XXDIR: 7     return(hmsg("Display a directory of local files"));     case XXECH: D     return(hmsg("Display the rest of the command on the terminal,\n\ useful in command files."));    case XXEXI:  case XXQUI: I     return(hmsg("Exit from the Kermit program, closing any open logs."));     case XXFIN:      return(hmsg("\C Tell the remote Kermit server to shut down without logging out."));     case XXGET:      return(hmsg(hmxxget));    case XXHLP:      return(hmsga(tophlp));    case XXLOG:      return(hmsga(hmxxlg));    case XXLOGI:     return(hmsga(hmxxlogi));    case XXREC:      return(hmsga(hmxxrc));      case XXREM: F     if ((y = cmkey(remcmd,nrmt,"Remote command","")) == -2) return(y);     if (y == -1) return(y); %     if (x = (cmcfm()) < 0) return(x);      return(dohrmt(y));    case XXSEN:      return(hmsg(hmxxsen));    case XXSER:      return(hmsg(hmxxser));    case XXSET: A     if ((y = cmkey(prmtab,nprm,"Parameter","")) == -2) return(y);      if (y == -2) return(y); %     if (x = (cmcfm()) < 0) return(x);      return(dohset(y));    case XXSHE: 
 #ifdef vms     return(hmsg("\5 Issue a command to VMS (space required after '!')"));  #else  #ifdef AMIGA     return(hmsg("\5 Issue a command to CLI (space required after '!')"));  #else      return(hmsg("\@ Issue a command to the Unix shell (space required after '!')")); #endif #endif    case XXSHO:      return(hmsg("\J Display current values of 'set' parameters; 'show version' will display\n\A program version information for each of the C-Kermit modules."));     case XXSPA: D     return(hmsg("Display disk usage in current device, directory"));    case XXSTA: G     return(hmsg("Display statistics about most recent file transfer"));     case XXTAK:      return(hmsg("\F Take Kermit commands from the named file.  Kermit command files may\n\L themselves contain 'take' commands, up to a reasonable depth of nesting."));    default:%     if (x = (cmcfm()) < 0) return(x); .     printf("Not available yet - %s\n",cmdbuf);
     break;     }      return(0); }      C /*  H M S G  --  Get confirmation, then print the given message  */     hmsg(s) char *s; {
     int x;%     if (x = (cmcfm()) < 0) return(x);      puts(s);     return(0); }    ; hmsga(s) char *s[]; {			/* Same function, but for arrays */ 
     int x, i; &     if ( x = (cmcfm()) < 0) return(x);3     for ( i = 0; *s[i] ; i++ ) fputs(s[i], stdout);      fputc( '\n', stdout);      return(0); }      2 /*  D O H S E T  --  Give help for SET command  */    dohset(xx) int xx; {     (     if (xx == -3) return(hmsga(hmhset));     if (xx < 0) return(xx);      switch (xx) {     case XYCHKT:     return(hmsga(hmxychkt));   
 case XYDELA:       puts("\ N Number of seconds to wait before sending first packet after 'send' command.");     return(0);    case XYDUPL:     puts("\ O During 'connect': 'full' means remote host echoes, 'half' means this program"); "     puts("does its own echoing.");     return(0);    case XYESC:      printf("%s","\I Decimal ASCII value for escape character during 'connect', normally 28\n\  (Control-\\)\n");      return(0);    case XYFILE:     return(hmsga(hmxyf));     case XYFLOW:     puts("\ G Type of flow control to be used.  Choices are 'xon/xoff' and 'none'.");      puts("normally xon/xoff.");      return(0);    case XYHAND:     puts("\ K Decimal ASCII value for character to use for half duplex line turnaround"); ;     puts("handshake.  Normally, handshaking is not done.");      return(0);   case XYLINE:
     printf("\ B Device name of communication line to use.  Normally %s.\n",dftty);     if (!dfloc) { 
 	printf("\< If you set the line to other than %s, then Kermit\n",dftty);
 	printf("\J will be in 'local' mode; 'set line' will reset Kermit to remote mode.\n");     puts("\ J If the line has a modem, and if the modem-dialer is set to direct, this");     puts("\ L command causes waiting for a carrier detect (e.g. on a hayes type modem).");     puts("\ / This can be used to wait for incoming calls.");      puts("\ N To use the modem to dial out, first set modem-dialer (e.g., to hayes), then");H     puts("set line, next issue the dial command, and finally connect.");     }      return(0);    case XYMODM:     puts("\ N Type of modem for dialing remote connections.  Needed to indicate modem can");     puts("\ K be commanded to dial without 'carrier detect' from modem.  Many recently");      puts("\ L manufactured modems use 'hayes' protocol.  Type 'set modem ?' to see what");     puts("\ 1 types of modems are supported by this program.");      return(0);       case XYPARI:H     puts("Parity to use during terminal connection and file transfer:");=     puts("even, odd, mark, space, or none.  Normally none.");      return(0);    case XYPROM:B     puts("Prompt string for this program, normally 'C-Kermit>'.");     return(0);    case XYSPEE:     puts("\ J Communication line speed for external tty line specified in most recent"); #ifdef AMIGA     puts("\ J 'set line' command.  Any baud rate between 110 and 292000, although you");L     puts(" will receive a warning if you do not use a standard baud rate:");     puts("\ I 110, 150, 300, 600, 1200, 1800, 2400, 4800, 9600, 19200, 38400, 57600.");  #else      puts("\ 5 'set line' command.  Any of the common baud rates:"); B     puts(" 0, 110, 150, 300, 600, 1200, 1800, 2400, 4800, 9600."); #endif     return(0);   case XYRECV:     puts("\ * Specify parameters for inbound packets:");     puts("\ ; End-Of-Packet (ASCII value), Packet-Length (94 or less),");      puts("\ = Padding (amount, 94 or less), Pad-Character (ASCII value),");      puts("\ C Start-Of-Packet (ASCII value), and Timeout (94 seconds or less),");      puts("\ $ all specified as decimal numbers.");     return(0);    case XYSEND:     puts("\ + Specify parameters for outbound packets:");      puts("\ ; End-Of-Packet (ASCII value), Packet-Length (94 or less),");      puts("\ = Padding (amount, 94 or less), Pad-Character (ASCII value),");      puts("\ C Start-Of-Packet (ASCII value), and Timeout (94 seconds or less),");      puts("\ $ all specified as decimal numbers.");     return(0);    default:3     printf("%s","Not available yet - %s\n",cmdbuf);      return(0);     }  }      7 /*  D O H R M T  --  Give help about REMOTE command  */     dohrmt(xx) int xx; {
     int x;(     if (xx == -3) return(hmsga(hmhrmt));     if (xx < 0) return(xx);      switch (xx) {     case XZCWD:      return(hmsg("\= Ask remote Kermit server to change its working directory."));     case XZDEL:      return(hmsg("\9 Ask remote Kermit server to delete the named file(s)."));     case XZDIR:      return(hmsg("\O Ask remote Kermit server to provide directory listing of the named file(s)."));     case XZHLP:      return(hmsg("\C Ask remote Kermit server to tell you what services it provides."));     case XZHOS:      return(hmsg("\B Send a command to the remote system in its own command language\n\% through the remote Kermit server."));     case XZSPA:      return(hmsg("\B Ask the remote Kermit server to tell you about its disk space."));    case XZTYP:      return(hmsg("\J Ask the remote Kermit server to type the named file(s) on your screen."));    case XZWHO:      return(hmsg("\O Ask the remote Kermit server to list who's logged in, or to give information\n\  about the specified user."));     default:%     if (x = (cmcfm()) < 0) return(x); 1     printf("%s","not working yet - %s\n",cmdbuf);      return(-2);      }  } 