@Make(text)
@String<VersionDate="December 1987">
@Style<Justification On, Hyphenation On, WidestBlank 1.4, Spacing 1,
        Spread 0.5, Indent 0, HyphenBreak Off, SingleSided, WidowAction Force>
@Modify<Format,Above 1,Below 1>
@Define<QQ,FaceCode R,AfterEntry=["],BeforeExit=["]>
@Case<Device,
 PagedFile="@Style(topmargin 2,bottommargin 0)",
 Diablo="@TypeWheel(Titan 10)",
 Imagen300="@Style(Spacing 1,SingleSided)
	    @Modify(Majorheading,Font TitleFont4,FaceCode R)
	    @Define(QQ,AfterEntry=[@r<``>],BeforeExit=[@r<''>])",
 Imprint10="@Style(FontFamily SmallRoman10,Spacing 1,SingleSided)
    @Define(QQ,AfterEntry=[@r<``>],BeforeExit=[@r<''>])",
 Postscript="
    @Define(QQ,AfterEntry=[@r<``>],BeforeExit=[@r<''>])",
 X9700="@Style(FontFamily Univers10,Singlesided,Spacing 0.7)
	@Modify<itemize,Numbered < @,- >,spacing 0.7,spread 0>
	@Style<TopMargin 0.7inch,BottomMargin 0.7inch>"
 >
@Pageheading(center "@b<Columbia University Center for Computing Activities>",
	immediate)
@MajorHeading(THE KERMIT FILE TRANSFER PROTOCOL)

@center(@i<@value[versiondate]>)
@blankspace(1.5)
@pageheading(center "")
Kermit is an error-correcting protocol for transferring sequential files
between computers of all sizes over ordinary asynchronous telecommunication
lines.  Kermit is non-@|proprietary, thoroughly documented, and in wide use.
The protocol and the original implementations were developed at Columbia
University and have been shared with thousands of other institutions all over
the world, many of which have made significant contributions of their own.
Kermit is presently available for more than 250 different machines and
operating systems, and additional versions are always under development.

@SubHeading(FEATURES:)
All Kermit programs perform file transfer using the Kermit file transfer
protocol.  In addition, Kermit programs for personal computers also provide
terminal emulation, usually of the DEC VT52, VT100, or other terminal, and
some of the mainframe Kermit programs are capable of initiating connections,
acting as dumb terminals to remote systems.  Kermit programs work only over
asynchronous RS-232 direct or dialup connections, or connections that simulate
them.  For file transfer to take place, there must be a Kermit program running
on @i<each> end of the connection, one on each computer.

@SubHeading(VERSIONS:)
There are Kermit programs for most popular @qq<generic> operating systems,
including UNIX, MS-DOS, and CP/M, and for mainframes and minicomputers from
Burroughs, Cray, CDC, Data General, DEC, Gould (SEL), Harris, Honeywell,
Hewlett-Packard, IBM, Perkin-Elmer (Concurrent), Prime, Sperry/Univac, and
Tandem, and for particular microcomputers and workstations from Apple,
Apollo, Atari, Commodore, IBM, Tandy, and many others, written in a wide
variety of languages including many different assemblers, plus high-level
languages like Algol, Basic, Bliss, C, Forth, Fortran, Lisp, Modula-2,
Mumps, Pascal, PL/I, and Ratfor.  A complete list of currently available
Kermit programs accompanies this flyer.

Here are some details about the several most popular Kermit programs.  Most of
them are capable of both local and remote operation,
server and client modes, text and binary file transfer, and support a full
range of communications options -- speed, parity, duplex, flow control,
handshake -- to allow adaptation to a wide variety of hosts (including IBM
mainframes) and communication media.
@begin<itemize>
@b<IBM PC Kermit> Version 2.29C runs under PC-DOS version 2.0 and later on the
entire IBM PC family, as well as on IBM @qq"clones" and compatibles.  It
provides nearly complete DEC VT102 terminal emulation at speeds up to 38.4K
baud fully buffered and interrupt driven -- and includes support for long
packets, color displays, compatibility with various @qq"desktop organizers,"
and selectable emulation of other terminals.  There are also versions of Kermit
specifically tailored for a variety of other MS-DOS systems, including the DEC
Rainbow, Zenith-100, Victor 9000, and many others, and there is a @qq"generic"
MS-DOS Kermit for systems not explicitly covered.

@b<Macintosh Kermit> Version 0.8(34) runs on the Apple Macintosh family,
providing fairly complete VT102 emulation at speeds up to 9600 baud, and file
transfer speeds up to 56Kb.

@b<UNIX Kermit> is distributed only in C-language source form.  It may be
built for nearly any machine running practically any post-V6 variation of UNIX,
including V7, Berkeley 2.x and 4.x, AT&T System III and System V, Xenix, Venix,
and so on.  The same source also serves as a basis for Macintosh, Amiga, and
other Kermit programs.

@b<VAX/VMS Kermit> is written in Bliss, but it is also distributed in Macro-32
and hex form, so that a Bliss compiler is not required.  Other versions exist
in C and Pascal.

@b<IBM mainframe Kermit> programs for VM/CMS and MVS/TSO work with
asynchronous ASCII TTY connections through 3705 or equivalent front ends, or
through Series/1, 7171, or similar protocol converters that support the Yale
ASCII Communications System; beyond this exception, Kermit cannot be used to
transfer files in the IBM 3270-style full-screen terminal environment.  There
are no Kermit programs for DOS/VSE, or IBM minis like the System/34 and
System/38, because these systems do not support asynchronous ASCII
communications.  Currently, IBM mainframe Kermits run only in remote mode.
@end<itemize>

@SubHeading(SOFTWARE:)
The Kermit software -- including source code -- is furnished free and without
license, and without warranty of any kind, and neither Columbia University, nor
the individual authors, nor any institution that has contributed Kermit
material, acknowledge any liability for any claims arising from the use of
Kermit.  Furthermore, it must be stated that the quality of the Kermit programs
varies -- some are polished, well-documented professional products and others
are not.  Kermit programs are contributed by public-spirited volunteers, and
Columbia University does not wish to discourage such contributions by
subjecting them to a rating system.  Since source code is provided for all
implementations, users may make improvements or write documentation where it is
lacking and are encouraged to contribute their work back to Columbia for
further distribution.  Under certain conditions (described in a separate
document) software producers may include Kermit protocol in their products.

@SubHeading(DISTRIBUTION:)
Although the Kermit software is free and unlicensed, Columbia University cannot
afford to distribute it for free because the demand is too great.  To defray
our costs for media, printing, postage, labor, and computing resources, we
require moderate distribution fees from those who request Kermit directly from
us.  The schedule is given on the accompanying Kermit Order Form.  You may also
obtain Kermit programs from many other sources, including user groups,
networks, dialup bulletin boards, and you may copy them from friends,
neighbors, and colleagues.  In fact, you may obtain Kermit programs from anyone
who is willing to share them with you, just as you may share them yourself.

@SubHeading(MEDIA:)
Kermit is distributed by Columbia University primarily on 9-track magnetic
tape, suitable for reading on most mainframe and minicomputers.  It is assumed
that Kermit will be ordered in this form by institutional computer centers,
whose professional staff will take the responsibility for @qq"bootstrapping"
the microcomputer versions from the tape to diskettes for their users.  The
tapes include source code and any available documentation for each Kermit
implementation, and in some cases also binaries (encoded in hex or other
printable format).  Selected microcomputer versions are also available from
Columbia on diskette, and from diskette services, user groups, and individual
volunteers, some of whom are listed on a separate flyer.

@SubHeading(DOCUMENTATION:)
Documentation includes the @i[Kermit User Guide] (about 250pp) and the
@i[Kermit Protocol Manual] (90pp); one printed copy of each is included free
with any tape order.  Other documents may be ordered separately, including
additional copies of the manuals, the manuscript from the Kermit article that
appeared in the June and July 1984 issues of BYTE Magazine (36pp), and the new
book @i<Kermit, A File Transfer Protocol> by Frank @w<da Cruz>, 379pp, Digital
Press (1987).

@SubHeading(KERMIT-THE-BOOK:)
The Kermit book is a comprehensive introduction and guide to Kermit; it
includes an overview of what Kermit is for and how it works, with tutorials in
computer file systems and data communications, a generalized command reference,
a troubleshooting guide, a complete protocol specification with program
examples, a glossary, an index, and numerous tables, figures, and
illustrations.  The @i<User Guide> contains detailed, specific instructions for
the use of the most popular Kermit programs (MS-DOS, VMS, UNIX, Apple, etc).
The @i(Protocol Manual) is an older description of the Kermit protocol, which
lacks the organization and program examples from the book.  If you have the
book, you don't need the @i<Protocol Manual> but you will still need the
@i<User Guide>.

@SubHeading(REDISTRIBUTION:)
Once you receive Kermit, you are encouraged to copy and redistribute it, with
the following stipulations: Kermit should not be sold for profit; credit should
be given where it is due; and new material should be sent back to Columbia
University so that we can maintain a definitive and comprehensive set of Kermit
implementations for further distribution.  And finally, @i<please use Kermit
only for peaceful and humane purposes>.

@SubHeading(DEVELOPMENT:)
Anyone who wishes to develop a version of Kermit which is not on the list, or
to modify an existing Kermit program is invited to contact Kermit
Distribution, where a list of Kermit implementations under development is
maintained.  
@newpage
@begin(center)
@begin(Heading)ORDERING INFORMATION
@end(heading)
@end(center)
All Kermit material is available on magnetic tape as described below.
Selected Kermit programs may also be ordered on diskette; see the order form.
Tapes include program source code, diskettes generally do not have room for
source.

There are 5 separate Kermit tapes: A, B, C, D and E.  There are too many Kermit
files to fit on fewer tapes.  All tapes are half-inch, 2400-foot, 9-track,
1600bpi, odd parity.  They are available ONLY in the following formats:
@begin(description,leftmargin +10,indent -8,spread 0,above 1,below 1)
ANSI:@\ANSI labeled ASCII, format D (variable length records, VMS COPY),
blocksize 8192

TAR:@\UNIX TAR format (written on a VAX with 4.2BSD or Ultrix-32), blocksize 10240

OS:@\IBM OS standard labeled EBCDIC, format VB (variable length records),
blocksize 8192

CMS:@\IBM VM/CMS VMFPLC2 format (unlabeled)

DEC-10:@\DECsystem-10 Backup/Interchange format (unlabeled)

DEC-20:@\DECSYSTEM-20 DUMPER format (unlabeled)
@end(description)
NO OTHER FORMATS ARE AVAILABLE.  We can NOT make 800bpi or 6250bpi tapes,
unlabeled tapes (except as noted above), fixed-block tapes, or custom tapes
of any kind.  If none of the above formats looks familiar to you, then
specify ANSI -- this is an industry standard format that @i<should> be
readable by any computer system (ANSI specifications are provided on paper).
VAX/VMS sites should specify ANSI.

TAPE @qq(A) CONTAINS:
@begin(itemize,spread 0,above 0)
The more popular microcomputer (PC, workstation) Kermit implementations.
@end(itemize)

TAPE @qq(B) CONTAINS:
@begin(itemize,spread 0,above 0)
The more popular mainframe and minicomputer Kermit implementations.
@end(itemize)

TAPE @qq(C) CONTAINS:
@begin(itemize,spread 0,above 0)
Less popular microcomputer Kermit implementations. (Overflow from Tape A)
@end(itemize)

TAPE @qq(D) CONTAINS:
@begin(itemize,spread 0,above 0)
Less popular mainframe and minicomputer Kermit implementations.  (Overflow from Tape B)
@end(itemize)

TAPE @qq(E) CONTAINS:
@begin(itemize,spread 0,above 0)

Machine readable copies of the Kermit User Guide, Protocol Manual, and Byte
Article, including text formatter source.

Archives of old mail, other large documents.
@end(itemize)

EXCEPTIONS:
@begin(itemize,spread 0.6,above 0,spacing 0.8)
C-Kermit is the basis of all Unix Kermit implementations, mainframe and micro,
and also for Commodore Amiga and Apple Macintosh Kermits.  It is on tape B.
@end(itemize)
@case[device,PS="@blankspace(1)"]
@begin(center,below 1,use b,leftmargin +2,rightmargin -2)
TO ORDER KERMIT, @r<fill out the Kermit Order Form and send it to:>
__________________________________________________
@begin(subheading)
Kermit Distribution
Columbia University Center for Computing Activities
612 West 115th Street
New York, NY  10025  (USA)
@end(subheading)
__________________________________________________
@end(center)

Prepayment by check is encouraged; an additional order processing fee is
required if we must issue an invoice.  North American orders are shipped by
delivery service or first class US mail, with shipping costs included.
Overseas orders are shipped first class US (air) mail, with an additional
shipping charge required.  Orders are normally processed within @ux<2-4 weeks>
of receipt, but firm delivery schedules or methods cannot be guaranteed.  USA
rush service is available for an extra fee (see order form *).

Call (212) 280-3703 for additional ordering information (telephone orders
can not be accepted, nor can payment by credit card or bank transfer).

Make checks in US Dollars payable to:@*
@blankspace(1 lines)
@b<@ @ @ @ @ COLUMBIA UNIVERSITY CENTER FOR COMPUTING ACTIVITIES>

@pageheading[left="(V4.05, @value<versiondate>)",
	center="@b(@ux<KERMIT ORDER FORM>)",
	right="#@t<__________>",
	line="@>(CUCCA Use)"
]
@case<Device,File="@blankspace(1)KERMIT ORDER FORM:@blankspace(1)",
	else="@newpage()">

@begin<text,fill>
@i<PLEASE NOTE:> Prices, terms and items are subject to change.  Before you
order, check that the form is not dated more than 6 months prior.  If so,
please write to Kermit Distribution to request a new order form.  Also,
please order carefully since we @b<cannot> refund or exchange items.
@b<Orders are normally processed within @ux<2-4 weeks>.>
@end<text>

@begin(format,spacing 0)
Date Ordered: @t<_____/_____/_____>@>Order Received: @t<_____/_____/_____>
@blankspace(0.05inch)
@>(CUCCA Use)@ @ @ @ @ @ @ @ @ @ 
@end(format)                 
@case<device,x9700="@begin(format,font smallbodyfont,spacing 0.5,spread 0.6)",
	else="@begin(format)">
@tabclear()
@case[device,pagedfile="@tabset(68)",else="@tabset(5.5inch)"]
Check each desired Kermit Distribution Tape, $100 PER TAPE: 
@i<Note:> Kermit User Guide and Kermit Protocol Manual included.

@case<device,x9700="@begin(format,font smallbodyfont,tabexport false)",
	else="@begin(format,tabexport false)">
@case[device,pagedfile="@tabset(34,42,50,58,66,74)",
	file="@tabset(34,42,50,58,66,74)",
	else="@tabset(2.0inch,2.6inch,3.2inch,3.8inch,4.4inch,5.0inch)"]
@u<Format:                       @\ANSI@\TAR@\ OS@ @\CMS @\DEC-10@\DEC-20>
  Tape A (popular micros):       @\@t<[  ]@\[  ]@\[  ]@\[  ]@\[  ]@\[  ]>
  Tape B (popular mainframes):   @\@t<[  ]@\[  ]@\[  ]@\[  ]@\[  ]@\[  ]>
  Tape C (other micros):         @\@t<[  ]@\[  ]@\[  ]@\[  ]@\[  ]@\[  ]>
  Tape D (other mainframes):     @\@t<[  ]@\[  ]@\[  ]@\[  ]@\[  ]@\[  ]>
  Tape E (documentation):        @\@t<[  ]@\[  ]@\[  ]@\[  ]@\[  ]@\[  ]>
@end<format>

@begin<text,fill,rightmargin +1inch,leftmargin +2,indent -2>
@t<[@ @ ] >PRIME Computers: Specify ANSI; Check here for free ANSI-tape-reader program listing.
@end<text>

TAPE SUBTOTAL (number of tapes times $100)@ @). @\$@t<__________>

Kermit programs on diskette (not copy-protected), no source code, $20 each, manual included:
@t<[  ] >@i<Apple Macintosh> (3.5 inch SS diskette)@ @). @\$@t<__________>
@t<[  ] >@i<DEC Rainbow; CP/M-86> (RX50)@ @). @\$@t<__________>
@t<[  ] >@i<DEC Rainbow; MS-DOS> (RX50)@ @). @\$@t<__________>
@t<[  ] >@i<IBM PC, XT, and AT; PC-DOS> (5.25 inch 360KB DS diskette)@ @). @\$@t<__________>
@t<[  ] >@i<IBM PS/2; PC-DOS> (3.5 inch 720KB DS diskette)@ @). @\$@t<__________>

Printed documents, enter quantity:
@t<[  ] >Book: @i<Kermit, A File Transfer Protocol> ($25)@ @). @\$@t<__________>
@t<[  ] >Manual: @i<Kermit User Guide> ($10)@ @). @\$@t<__________>
@t<[  ] >Manual: @i<Kermit Protocol Manual> ($10)@ @). @\$@t<__________>
@t<[  ] >@i<BYTE> Magazine article manuscript ($5)@ @). @\$@t<__________>

@begin<text,fill,rightmargin +1inch>
@i<NOTE:> Source listings are no longer available in paper format but are
still available on tape.
@end<text>

If you can NOT prepay with a check, include @b(@u(BOTH)):
  1.  A $100@t<.>00 Order Processing (Billing) Fee: @). @\$@t<__________>
  2.  @b(@u(AND)) a Purchase Order (terms net 30, FOB origin):

Purchase Order Number: @t<__________________________> @i<(not required if you prepay by check.)>

Outside North America, add $25@t<.>00 for shipping@). @\$@t<__________>
* USA RUSH ORDERS (Sent Federal Express), add $30@t<.>00@). @\$@t<__________>
@i<Note:> Federal Express outside USA requires your Federal Express #: @t<__________________________> 

** Voluntary tax-deductable contribution@). @\$@t<__________>
@ux<GRAND TOTAL>: (@i<Do Not Add Sales Tax>)@). @\$@t<__________>

@b<IMPORTANT>: WRITE SHIPPING ADDRESS HERE, @i<exactly as it should appear on mailing label>:
@i<(* For RUSH ORDERS: Include phone number below, and do not use a Post Office Box.)>

@bar()

@bar()

@bar()

@bar()
@end(format)
