J char *protv = "C-Kermit Protocol Module 4E(031), 31 Jul 87"; /* -*-C-*- */  N /* C K C P R O  -- C-Kermit Protocol Module, in Wart preprocessor notation. */ /*D  Authors: Frank da Cruz (SY.FDC@CU20B), Bill Catchings, Jeff Damens;C  Columbia University Center for Computing Activities, January 1985. M  Copyright (C) 1985, Trustees of Columbia University in the City of New York. H  Permission is granted to any individual or institution to use, copy, orO  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */ #include "ckcdeb.h"  #include "ckcker.h"  /*I  Note -- This file may also be preprocessed by the Unix Lex program, but  I  you must indent the above #include statements before using Lex, and then O  restore them to the left margin in the resulting C program before compilation. K  Also, the invocation of the "wart()" function below must be replaced by an M  invocation  of the "yylex()" function.  It might also be necessary to remove !  comments in the %%...%% section.  */  ) /* State definitions for Wart (or Lex) */ 9 %states ipkt rfile rdata ssinit ssfile ssdata sseof sseot  %states serve generic get rgen  - /* External C-Kermit variable declarations */ A   extern char sstate, *versio, *srvtxt, *cmarg, *cmarg2, *rpar(); <   extern char data[], filnam[], srvcmd[], ttname[], *srvptr;E   extern int pktnum, timint, nfils, hcflg, xflg, speed, flow, mdmtyp; N   extern int prvpkt, cxseen, czseen, server, local, displa, bctu, bctr, quiet;$   extern int tsecs, parity, backgrd;4   extern int putsrv(), puttrm(), putfil(), errpkt();C   extern char *DIRCMD, *DELCMD, *TYPCMD, *SPACMD, *SPACM2, *WHOCMD;    extern char *rdatap;   /* Local variables */ 0   static char vstate = 0;  		/* Saved State   */0   static char vcmd = 0;    		/* Saved Command */)   int x;				/* General-purpose integer */ 2   char *s;				/* General-purpose string pointer */  : /* Macros - Note, BEGIN is predefined by Wart (and Lex) */# #define SERVE  tinit(); BEGIN serve @ #define RESUME if (server) { SERVE; } else { sleep(2); return; }   %%> /* Protocol entry points, one for each start state (sstate) */  1 s { tinit();	    	    	    	/* Do Send command */      if (sinit()) BEGIN ssinit;        else RESUME; }   6 v { tinit(); BEGIN get; } 	     	     	  /* Receive */K r { tinit(); vstate = get;  vcmd = 0;   sipkt('I'); BEGIN ipkt; } /* Get */ L c { tinit(); vstate = rgen; vcmd = 'C'; sipkt('I'); BEGIN ipkt; } /* Host */O g { tinit(); vstate = rgen; vcmd = 'G'; sipkt('I'); BEGIN ipkt; } /* Generic */   2 x { sleep(1); SERVE; }	    	    	/* Be a Server */  K a { errpkt("User cancelled transaction"); /* "Abort" -- Tell other side. */ 7     x = quiet; quiet = 1; 		/* Close files silently. */      clsif(); clsof(1);  8     quiet = x; return(0); }		/* Return from protocol. */  @ /* Dynamic states: <current-states>input-character { action } */  C <rgen,get,serve>S { rinit(rdatap); bctu = bctr; /* Get Send-Init */ $ 	   resetc();			/* Reset counters */%     	   rtimer();			/* Reset timer */  	   BEGIN rfile; }  4 <ipkt>Y  { spar(rdatap);		/* Get ack for I-packet */1     	   if (vcmd) { scmd(vcmd,cmarg); vcmd = 0; } $     	   if (vstate == get) srinit(); 	   BEGIN vstate; }   H <ipkt>E  { if (vcmd) scmd(vcmd,cmarg);	/* Get E for I-packet (ignore) */.     	   vcmd = 0; if (vstate == get) srinit(); 	   BEGIN vstate; }   I <serve>R { srvptr = srvcmd; decode(rdatap,putsrv); /* Get Receive-Init */   	   cmarg = srvcmd;  nfils = -1;4     	   if (sinit()) BEGIN ssinit; else { SERVE; } }  K <serve>I { spar(rdatap); ack1(rpar());	           /* Get Init Parameters */  	   pktnum = 0; prvpkt = -1; }  N <serve>G { srvptr = srvcmd; decode(rdatap,putsrv); /* Get & decode command. */ 	   putsrv('\0'); putsrv('\0'); ( 	   sstate = srvcmd[0]; BEGIN generic; }  > <serve>C { srvptr = srvcmd;		    	 /* Get command for shell */( 	   decode(rdatap,putsrv); putsrv('\0');( 	   if (syscmd(srvcmd,"")) BEGIN ssinit;8 	   else { errpkt("Can't do system command"); SERVE; } }  H <serve>. { errpkt("Unimplemented server function"); SERVE; } /* Other */  L <generic>C { if (!cwd(srvcmd+1)) errpkt("Can't change directory"); /* CWD */     	     SERVE; }  G <generic>D { if (syscmd(DIRCMD,srvcmd+2)) BEGIN ssinit;	/* Directory */ ;     	     else { errpkt("Can't list directory"); SERVE; } }   C <generic>E { if (syscmd(DELCMD,srvcmd+2)) BEGIN ssinit;	/* Erase */ 8     	     else { errpkt("Can't remove file"); SERVE; } }  M <generic>F { ack(); screen(SCR_TC,0,0l,""); return(0); } /* Finish and Bye */ H <generic>L { ack(); ttres(); screen(SCR_TC,0,0l,""); return(zkself()); }  ( <generic>H { if (sndhlp()) BEGIN ssinit;6     	     else { errpkt("Can't send help"); SERVE; } }  7 <generic>T { if (syscmd(TYPCMD,srvcmd+2)) BEGIN ssinit; 6     	     else { errpkt("Can't type file"); SERVE; } }  6 <generic>U { x = *(srvcmd+1);			/* Disk Usage query */)     	     x = ((x == '\0') || (x == SP)); < 	     x = (x ? syscmd(SPACMD,"") : syscmd(SPACM2,srvcmd+2));L     	     if (x) BEGIN ssinit; else { errpkt("Can't check space"); SERVE; }}  7 <generic>W { if (syscmd(WHOCMD,srvcmd+2)) BEGIN ssinit; ;     	     else { errpkt("Can't do who command"); SERVE; } }   F <generic>. { errpkt("Unimplemented generic server function"); SERVE; }   /* Dynamic states, cont'd */    I <rgen>Y { decode(rdatap,puttrm); RESUME; }    /* Got reply in ACK data */   N <rgen,rfile>F { if (rcvfil()) { ack1(filnam); BEGIN rdata; } /* File header *// 		else { errpkt("Can't open file"); RESUME; } }   J <rgen,rfile>X { opent(); ack(); BEGIN rdata; }	/* Screen data is coming */  C <rfile>B { ack(); tsecs = gtimer(); reot(); RESUME; } /* Got EOT */   1 <rdata>D { if (cxseen) ack1("X");	/* Got data. */ '     	       else if (czseen) ack1("Z");  	       else ack();  	   decode(rdatap,putfil); }  8 <rdata>Z  { if (reof() < 0) {	    	/* Got End Of File */.     	      errpkt("Can't close file"); RESUME;)     	    } else { ack(); BEGIN rfile; } }   A <ssinit>Y { spar(rdatap); bctu = bctr;	/* Got ACK to Send-Init */ :     	    x = sfile(xflg);		/* Send X or F header packet */1 	    if (x) { resetc(); rtimer(); BEGIN ssfile; } C 	   	else { s = xflg ? "Can't execute command" : "Can't open file";  		    errpkt(s); RESUME; }           }   6 <ssfile>Y { srvptr = srvcmd;		    	 /* Got ACK to F */) 	    decode(rdatap,putsrv); putsrv('\0'); 3 	    if (*srvcmd) tlog(F110," stored as",srvcmd,0); 9 	    if (sdata() < 0) { clsif(); seof(""); BEGIN sseof; }      	    	else BEGIN ssdata; }  D <ssdata>Y { if (canned(rdatap)) { clsif(); seof("D"); BEGIN sseof; }A 	    	else if (sdata() < 0) { clsif(); seof(""); BEGIN sseof; } }   D <sseof>Y  { if (gnfile() > 0) {		/* Got ACK to EOF, get next file */  		if (sfile(xflg)) BEGIN ssdata;. 		else { errpkt("Can't open file") ; RESUME; }* 	    } else {			/* If no next file, EOT */ 		tsecs = gtimer(); 	 		seot();  		BEGIN sseot; } 	  }  + <sseot>Y { RESUME; }			/* Got ACK to EOT */   7 E { ermsg(rdatap);			/* Error packet, issue message. */ 6     x = quiet; quiet = 1;		/* Close files silently, */:     clsif(); clsof(1);			/* discarding any output file. */     tsecs = gtimer();      quiet = x;4     if (backgrd && !server) fatal("Protocol error");
     RESUME; }   L . { errpkt("Unknown packet type"); RESUME; } /* Anything else, send error */ %%  . /*  P R O T O  --  Protocol entry function  */  	 proto() {        extern int sigint();
     int x;  5     conint(sigint);			/* Enable console interrupts */   6 /* Set up the communication line for file transfer. */       if (local && (speed < 0)) { 9 	screen(SCR_EM,0,0l,"Sorry, you must 'set speed' first");  	return;     }        x = -1; '     if (ttopen(ttname,&x,mdmtyp) < 0) { 7 	debug(F111,"failed: proto ttopen local",ttname,local); ' 	screen(SCR_EM,0,0l,"Can't open line");  	return;     }      if (x > -1) local = x;2     debug(F111,"proto ttopen local",ttname,local);       x = (local) ? speed : -1; B     if (ttpkt(x,flow,parity) < 0) {	/* Put line in packet mode, */, 	screen(SCR_EM,0,0l,"Can't condition line"); 	return;     } 8     if (sstate == 'x') {		/* If entering server mode, */ 	server = 1;			/* set flag, */ 	if (!quiet) {7 	    if (!local)			/* and issue appropriate message. */  	    	conol(srvtxt); 	    else { ( 	    	conol("Entering server mode on "); 		conoll(ttname);  	    } 	}     } else server = 0;*     if (sstate == 'v' && !local && !quiet)L       conoll("Escape back to your local system and give a SEND command...");*     if (sstate == 's' && !local && !quiet)O       conoll("Escape back to your local system and give a RECEIVE command..."); 
     sleep(1);  /*C  The 'wart()' function is generated by the wart program.  It gets a H  character from the input() routine and then based on that character andJ  the current state, selects the appropriate action, according to the stateF  table above, which is transformed by the wart program into a big case8  statement.  The function is active for one transaction. */4     wart();				/* Enter the state table switcher. */     4     if (server) {			/* Back from packet protocol. */ 	server = 0;3     	if (!quiet)  			/* Give appropriate message */ $ 	    conoll("C-Kermit server done");     }      ttres();7     screen(SCR_TC,0,0l,"");		/* Transaction complete */  } 